/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.ActionWithReturn;
import com.aol.cyclops.matcher.Extractor;
import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.builders.Matching;
import com.aol.cyclops.matcher.builders.PatternMatcher;
import java.io.Serializable;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HamcrestTest {
    @Test
    public void hamcrest1() {
        Matching.whenValues(c -> c.isMatch(Matchers.hasItem((Object)"hello2")).thenConsume(System.out::println)).match(Arrays.asList("hello", "world"));
    }

    @Test
    public void hamcrestViaNew() {
        Matching.when().isMatch(Matchers.hasItem((Object)"hello2")).thenConsume(System.out::println).match(Arrays.asList("hello", "world"));
    }

    @Test
    public void hasAnyOrderTest() {
        Assert.assertTrue((boolean)((Boolean)Matching.whenValues(c -> c.isMatch(Matchers.containsInAnyOrder((Object[])new String[]{"world", "hello"})).thenApply((ActionWithReturn & Serializable)list -> true)).apply(Arrays.asList("hello", "world")).get()));
    }

    @Test
    public void hamcrestWithExtractor() {
        Assert.assertTrue((boolean)((Boolean)Matching.when().extract(Extractors.at((int)1)).isMatch(Matchers.is((Object)"world")).thenApply((ActionWithReturn & Serializable)list -> true).match(Arrays.asList("hello", "world")).get()));
    }

    @Test
    public void postExtractorDoc() {
        Matching.when().isMatch(Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty()))).thenExtract(Extractors.get((int)1)).thenConsume(System.out::println).match(Arrays.asList(20303, "20303 is passing", true));
    }

    @Test
    public void hamcrestWithPostExtractor() {
        Assert.assertEquals((Object)"world", Matching.whenValues(c -> c.isMatch(Matchers.containsInAnyOrder((Object[])new String[]{"world", "hello"})).thenExtract(Extractors.at((int)1)).thenApply((ActionWithReturn & Serializable)value -> value)).apply(Arrays.asList("hello", "world")).get());
    }

    @Test
    public void hamcrestWithPostExtractor2() {
        Assert.assertEquals((Object)"world", new PatternMatcher().inMatchOfThenExtract(Matchers.containsInAnyOrder((Object[])new String[]{"world", "hello"}), (ActionWithReturn & Serializable)value -> value, (Extractor & Serializable)list -> (String)list.get(1)).apply(Arrays.asList("hello", "world")).get());
    }
}

