/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads.transformers;

import com.aol.cyclops.monad.AnyM;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class StreamT<T> {
    final AnyM<Stream<T>> run;

    private StreamT(AnyM<Stream<T>> run) {
        this.run = run;
    }

    public AnyM<Stream<T>> unwrap() {
        return this.run;
    }

    public StreamT<T> peek(Consumer<T> peek) {
        return this.map(a -> {
            peek.accept(a);
            return a;
        });
    }

    public StreamT<T> filter(Predicate<T> test) {
        return StreamT.of(this.run.map(stream -> stream.filter(test)));
    }

    public <B> StreamT<B> map(Function<T, B> f) {
        return new StreamT<T>(this.run.map(o -> o.map(f)));
    }

    public <B> StreamT<B> flatMap(Function<T, StreamT<B>> f) {
        return StreamT.of(this.run.map(stream -> stream.flatMap((? super T a) -> ((StreamT)function.apply(a)).run.asSequence()).flatMap((? super T a) -> a)));
    }

    public static <U, R> Function<StreamT<U>, StreamT<R>> lift(Function<U, R> fn) {
        return optTu -> optTu.map(input -> fn.apply(input));
    }

    public static <A> StreamT<A> fromAnyM(AnyM<A> anyM) {
        return StreamT.of(anyM.map(Stream::of));
    }

    public static <A> StreamT<A> of(AnyM<Stream<A>> monads) {
        return new StreamT<A>(monads);
    }

    public String toString() {
        return this.run.toString();
    }
}

