/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Functor<T> {
    default public <T> Functor<T> withFunctor(T functor) {
        if (this.getFunctor() == this) {
            return (Functor)functor;
        }
        try {
            Constructor<?> cons = this.getClass().getConstructor(Object.class);
            cons.setAccessible(true);
            return (Functor)cons.newInstance(functor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ExceptionSoftener.throwSoftenedException((Throwable)e);
            return null;
        }
    }

    default public Object getFunctor() {
        return this;
    }

    default public <R> Functor<R> map(Function<? super T, ? extends R> fn) {
        Object value = new ComprehenderSelector().selectComprehender(this.getFunctor()).map(this.getFunctor(), fn);
        return this.withFunctor(value);
    }

    default public Functor<T> peek(Consumer<? super T> c) {
        return this.map(input -> {
            c.accept(input);
            return input;
        });
    }

    default public <X> X unwrap() {
        if (this.getFunctor() != this && this.getFunctor() instanceof Functor) {
            return ((Functor)this.getFunctor()).unwrap();
        }
        return (X)this.getFunctor();
    }
}

