/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.comprehenders;

import com.aol.cyclops.types.extensability.Comprehender;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import javaslang.collection.HashSet;

public class HashSetComprehender
implements Comprehender<HashSet> {
    public Object map(HashSet t, Function fn) {
        return t.map(s -> fn.apply(s));
    }

    public Object executeflatMap(HashSet t, Function fn) {
        return this.flatMap(t, (T input) -> HashSetComprehender.unwrapOtherMonadTypes(this, fn.apply(input)));
    }

    public Object flatMap(HashSet t, Function fn) {
        return t.flatMap(s -> fn.apply(s));
    }

    public HashSet of(Object o) {
        return HashSet.of((Object)o);
    }

    public HashSet empty() {
        return HashSet.empty();
    }

    public Class getTargetClass() {
        return HashSet.class;
    }

    static HashSet unwrapOtherMonadTypes(Comprehender<HashSet> comp, Object apply) {
        if (comp.instanceOfT(apply)) {
            return (HashSet)apply;
        }
        if (apply instanceof Stream) {
            return HashSet.of(((Stream)apply).iterator());
        }
        if (apply instanceof Iterable) {
            return HashSet.of(((Iterable)apply).iterator());
        }
        if (apply instanceof Collection) {
            return HashSet.ofAll((Iterable)((Collection)apply));
        }
        Object finalApply = apply;
        if (apply instanceof BaseStream) {
            return HashSet.ofAll(() -> ((BaseStream)finalApply).iterator());
        }
        return (HashSet)Comprehender.unwrapOtherMonadTypes(comp, (Object)apply);
    }

    public Object resolveForCrossTypeFlatMap(Comprehender comp, HashSet apply) {
        return comp.fromIterator((Iterator)apply.iterator());
    }

    public HashSet fromIterator(Iterator o) {
        return HashSet.ofAll(() -> o);
    }
}

