/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.comprehenders;

import com.aol.cyclops.types.extensability.Comprehender;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import javaslang.collection.Array;

public class ArrayComprehender
implements Comprehender<Array> {
    public Object map(Array t, Function fn) {
        return t.map(s -> fn.apply(s));
    }

    public Object executeflatMap(Array t, Function fn) {
        return this.flatMap(t, (T input) -> ArrayComprehender.unwrapOtherMonadTypes(this, fn.apply(input)));
    }

    public Object flatMap(Array t, Function fn) {
        return t.flatMap(s -> fn.apply(s));
    }

    public Array of(Object o) {
        return Array.of((Object)o);
    }

    public Array empty() {
        return Array.empty();
    }

    public Class getTargetClass() {
        return Array.class;
    }

    static Array unwrapOtherMonadTypes(Comprehender<Array> comp, Object apply) {
        if (comp.instanceOfT(apply)) {
            return (Array)apply;
        }
        if (apply instanceof Stream) {
            return Array.of((Object)((Stream)apply));
        }
        if (apply instanceof Iterable) {
            return Array.of((Object)((Iterable)apply));
        }
        if (apply instanceof Collection) {
            return Array.ofAll((Iterable)((Collection)apply));
        }
        Object finalApply = apply;
        if (apply instanceof BaseStream) {
            return Array.ofAll(() -> ((BaseStream)finalApply).iterator());
        }
        return (Array)Comprehender.unwrapOtherMonadTypes(comp, (Object)apply);
    }

    public Object resolveForCrossTypeFlatMap(Comprehender comp, Array apply) {
        return comp.fromIterator((Iterator)apply.iterator());
    }

    public Array fromIterator(Iterator o) {
        return Array.ofAll(() -> o);
    }
}

