/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang;

import com.aol.cyclops.control.For;
import com.aol.cyclops.javaslang.Javaslang;
import com.aol.cyclops.javaslang.Water;
import java.util.concurrent.CompletableFuture;
import javaslang.Value;
import javaslang.collection.List;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.control.Option;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jooq.lambda.tuple.Tuple;
import org.junit.Assert;
import org.junit.Test;

public class ComprehensionTest {
    @Test
    public void optionalTest() {
        Assert.assertTrue((boolean)Javaslang.ForValue.each2((Value)Option.of((Object)10), a -> Option.none(), (a, b) -> "failed").isEmpty());
    }

    @Test
    public void option2Test() {
        Assert.assertThat((Object)Javaslang.ForValue.each2((Value)Option.of((Object)10), a -> Option.of((Object)(a + 20)), (a, b) -> a + b).get(), (Matcher)Matchers.equalTo((Object)40));
    }

    @Test
    public void generate() {
        String s = Javaslang.ForTraversable.each2((Traversable)List.of((Object[])new Integer[]{1, 2, 3}), a -> List.of((Object)(a + 10)), Tuple::tuple).toString();
        Assert.assertThat((Object)s, (Matcher)Matchers.equalTo((Object)"List((1, 11), (2, 12), (3, 13))"));
    }

    @Test
    public void generateStream() {
        String s = Javaslang.ForTraversable.each2((Traversable)Stream.of((Object[])new Integer[]{1, 2, 3}), a -> Stream.of((Object)(a + 10)), Tuple::tuple).toString();
        Assert.assertThat((Object)s, (Matcher)Matchers.equalTo((Object)"Stream((1, 11), ?)"));
    }

    @Test
    public void generateListStream() {
        String s = Javaslang.ForTraversable.each2((Traversable)List.of((Object[])new Integer[]{1, 2, 3}), a -> Stream.of((Object)(a + 10)), Tuple::tuple).toString();
        Assert.assertThat((Object)s, (Matcher)Matchers.equalTo((Object)"List((1, 11), (2, 12), (3, 13))"));
    }

    @Test
    public void cfList() {
        CompletableFuture<String> future = CompletableFuture.supplyAsync(this::loadData);
        CompletableFuture results1 = (CompletableFuture)For.future(future).iterable(a -> List.of((Object[])new String[]{"first", "second"})).yield(loadedData -> localData -> loadedData + ":" + localData).unwrap();
        System.out.println(results1.join());
    }

    private String loadData() {
        return "loaded";
    }

    @Test
    public void futureTest() {
        CompletableFuture result = (CompletableFuture)For.future(this.grind("arabica beans")).future(ground -> this.heatWater(new Water(25))).future(ground -> water -> this.brew((String)ground, (Water)water)).future(a -> b -> c -> this.frothMilk("milk")).yield(ground -> water -> espresso -> foam -> this.combine((String)espresso, (String)foam)).unwrap();
        System.out.println((String)result.join());
    }

    CompletableFuture<String> grind(String beans) {
        return CompletableFuture.completedFuture("ground coffee of " + beans);
    }

    CompletableFuture<Water> heatWater(Water water) {
        return CompletableFuture.supplyAsync(() -> water.withTemperature(85));
    }

    CompletableFuture<String> frothMilk(String milk) {
        return CompletableFuture.completedFuture("frothed " + milk);
    }

    CompletableFuture<String> brew(String coffee, Water heatedWater) {
        return CompletableFuture.completedFuture("espresso");
    }

    String combine(String espresso, String frothedMilk) {
        return "cappuccino";
    }
}

