/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.SortedSetX;
import com.aol.cyclops.javaslang.Javaslang;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.stream.reactive.SeqSubscriber;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import javaslang.Lazy;
import javaslang.Value;
import javaslang.collection.Array;
import javaslang.collection.CharSeq;
import javaslang.collection.HashSet;
import javaslang.collection.List;
import javaslang.collection.Queue;
import javaslang.collection.Traversable;
import javaslang.collection.Vector;
import javaslang.concurrent.Future;
import javaslang.control.Either;
import javaslang.control.Option;
import javaslang.control.Try;
import lombok.Data;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.reactivestreams.Subscriber;

public class AnyJavaslangMTest {
    volatile int count = 0;

    private ReactiveSeq<Data> loadById(int id) {
        return null;
    }

    private Integer add(Integer a, Integer b) {
        return a + b;
    }

    @Test
    public void emissionTest() throws InterruptedException {
        SortedSetX functor = SortedSetX.of((Object[])new Integer[]{1, 2});
        Functor doubled = functor.map(i -> i * 2);
        Thread.sleep(5000L);
        Javaslang.traversable((Traversable)List.of((Object[])new String[]{"emit", "one", "word", "per", "second"})).schedule("* * * * * ?", Executors.newScheduledThreadPool(1)).connect().map(s -> System.currentTimeMillis() / 1000L + " : " + s).printOut();
    }

    @Test
    public void arrayFlatMap() {
        Array.of((Object[])new Integer[]{1, 2}).flatMap(i -> new LazyReact().range(i.intValue(), 4)).forEach(System.out::println);
    }

    @Test
    public void listFlatMap() {
        ListX.of((Object[])new Integer[]{1, 2}).flatMap(i -> Array.range((int)i, (int)4)).forEach(System.out::println);
    }

    @Test
    public void javaslangCyclops() {
        Javaslang.ForTraversable.each2((Traversable)List.of((Object[])new Integer[]{1, 2, 3}), a -> List.range((int)0, (int)a), this::add);
        Javaslang.ForValue.each2((Value)Option.none(), a -> Option.some((Object)(a + 1)), this::add);
        Option.some((Object)1).flatMap(a -> Option.some((Object)(a + 1)).map(b -> this.add((Integer)a, (Integer)b)));
        Array.of((Object[])new Integer[]{1, 2, 3, 4}).flatMap(i -> new LazyReact().range(i.intValue(), 10)).forEach(System.out::println);
        ReactiveSeq.of((Object[])new Integer[]{1, 2, 3, 4}).flatMapIterable(i -> javaslang.collection.Stream.iterate((Object)1, a -> a + 1).take((long)i.intValue())).map(i -> i + 2);
    }

    @Test
    public void testToList() {
        SeqSubscriber sub = SeqSubscriber.subscriber();
        Javaslang.traversable((Traversable)List.of((Object[])new Integer[]{1, 2, 3})).subscribe((Subscriber)sub);
        sub.stream().forEachWithError(System.out::println, System.err::println);
        Assert.assertThat((Object)Javaslang.traversable((Traversable)List.of((Object[])new Integer[]{1, 2, 3})).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void monadTest() {
        Assert.assertThat((Object)Javaslang.value((Value)Try.of(this::success)).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void tryTest() {
        Assert.assertThat((Object)Javaslang.tryM((Try)Try.of(this::success)).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void tryTestFailure() {
        Javaslang.tryM((Try)Try.failure((Throwable)new RuntimeException())).stream().forEach(System.out::println);
    }

    @Test
    public void tryTestFailureProcess() {
        RuntimeException e = new RuntimeException();
        Javaslang.tryM((Try)Try.failure((Throwable)e));
        System.out.println("hello!");
        Assert.assertThat((Object)Javaslang.tryM((Try)Try.failure((Throwable)e)).stream().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void whenSuccessFailureProcessDoesNothing() {
        Assert.assertThat((Object)Javaslang.tryM((Try)Try.success((Object)"hello world")).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("hello world")));
    }

    @Test
    public void tryFlatMapTest() {
        Assert.assertThat((Object)Javaslang.tryM((Try)Try.of(this::success)).map(String::toUpperCase).flatMap(AnyM::ofNullable).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    private String success() {
        return "hello world";
    }

    private String exceptional() {
        throw new RuntimeException();
    }

    @Test
    public void eitherTest() {
        Assert.assertThat((Object)Javaslang.either((Either)Either.right((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void eitherLeftTest() {
        Assert.assertThat((Object)Javaslang.either((Either)Either.left((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void eitherFlatMapTest() {
        Assert.assertThat((Object)Javaslang.either((Either)Either.right((Object)"hello world")).map(String::toUpperCase).flatMap(AnyM::ofNullable).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionTest() {
        Assert.assertThat((Object)Javaslang.right((Either.RightProjection)Either.right((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionLeftTest() {
        Assert.assertThat((Object)Javaslang.right((Either.RightProjection)Either.left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void rightProjectionFlatMapTest() {
        Assert.assertThat((Object)Javaslang.right((Either.RightProjection)Either.right((Object)"hello world").right()).map(String::toUpperCase).flatMap(AnyM::ofNullable).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionTest() {
        Assert.assertThat((Object)Javaslang.right((Either.RightProjection)Either.left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void leftProjectionLeftTest() {
        Assert.assertThat((Object)Javaslang.left((Either.LeftProjection)Either.left((Object)"hello world").left()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionLeftFlatMapTest() {
        Assert.assertThat((Object)Javaslang.left((Either.LeftProjection)Either.left((Object)"hello world").left()).map(String::toUpperCase).flatMap(AnyM::ofNullable).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionTest() {
        Assert.assertThat((Object)Javaslang.option((Option)Option.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionFlatMapTest() {
        Assert.assertThat((Object)Javaslang.option((Option)Option.of((Object)"hello world")).map(String::toUpperCase).flatMap(AnyM::ofNullable).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionEmptyTest() {
        Assert.assertThat((Object)Javaslang.option((Option)Option.none()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void futureTest() {
        Assert.assertThat((Object)Javaslang.value((Value)Future.of(() -> "hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void futureFlatMapTest() {
        Assert.assertThat((Object)Javaslang.value((Value)Future.of(() -> "hello world")).map(String::toUpperCase).flatMap(AnyM::ofNullable).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void lazyTest() {
        Assert.assertThat((Object)Javaslang.value((Value)Lazy.of(() -> "hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)javaslang.collection.Stream.of((Object)"hello world")).map(String::toUpperCase).stream().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void listTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)List.of((Object)"hello world")).map(String::toUpperCase).stream().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)javaslang.collection.Stream.of((Object)"hello world")).map(String::toUpperCase).flatMap(i -> Javaslang.traversable((Traversable)List.of((Object)i))).toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTestJDK() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)javaslang.collection.Stream.of((Object)"hello world")).map(String::toUpperCase).flatMap(i -> AnyM.fromStream(Stream.of(i))).toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void arrayTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)Array.of((Object)"hello world")).map(String::toUpperCase).toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void charSeqTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)CharSeq.of((CharSequence)"hello world")).map(c -> Character.valueOf(c.toString().toUpperCase().charAt(0))).join(), (Matcher)Matchers.equalTo((Object)"HELLO WORLD"));
    }

    @Test
    public void hashsetTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)HashSet.of((Object)"hello world")).map(String::toUpperCase).toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void queueTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)Queue.of((Object)"hello world")).map(String::toUpperCase).toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void vectorTest() {
        Assert.assertThat((Object)Javaslang.traversable((Traversable)Vector.of((Object)"hello world")).map(String::toUpperCase).toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }
}

