/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import com.aol.cyclops.functions.caching.Memoize;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.collection.AbstractIterator;
import javaslang.collection.LazyStream;
import javaslang.collection.List;
import javaslang.collection.Stream;

interface LazyStreamModule {

    public static final class StreamIterator<T>
    extends AbstractIterator<T> {
        private Supplier<LazyStream<T>> current = () -> stream;

        StreamIterator(LazyStream.LazyCons<T> stream) {
        }

        public boolean hasNext() {
            return !this.current.get().isEmpty();
        }

        public T getNext() {
            LazyStream<T> stream = this.current.get();
            this.current = stream::tail;
            return (T)stream.head();
        }
    }

    public static interface StreamFactory {
        public static <T> LazyStream<T> create(Iterator<? extends T> iterator) {
            Supplier head = Memoize.memoizeSupplier(() -> iterator.next());
            return iterator.hasNext() ? LazyStream.cons(head, () -> StreamFactory.lambda$create$19(iterator, (Supplier)head)) : LazyStream.Empty.instance();
        }

        private static /* synthetic */ LazyStream lambda$create$19(Iterator iterator, Supplier supplier) {
            if (iterator.hasNext()) {
                supplier.get();
                return StreamFactory.create(iterator);
            }
            return LazyStream.Empty.instance();
        }
    }

    public static interface DropRight {
        public static <T> LazyStream<T> apply(List<T> front, List<T> rear, LazyStream<T> remaining) {
            if (remaining.isEmpty()) {
                return remaining;
            }
            if (front.isEmpty()) {
                return DropRight.apply(rear.reverse(), List.empty(), remaining);
            }
            return LazyStream.cons(() -> front.head(), () -> DropRight.apply(front.tail(), rear.prepend(remaining.head()), remaining.tail()));
        }
    }

    public static interface Combinations {
        public static <T> LazyStream<LazyStream<T>> apply(LazyStream<T> elements, int k) {
            if (k == 0) {
                return LazyStream.of(LazyStream.empty());
            }
            return elements.zipWithIndex().flatMap(t -> Combinations.apply(elements.drop((Long)t._2 + 1L), k - 1).map(c -> c.prepend(tuple2._1)));
        }
    }

    public static final class AppendSelf<T> {
        private final LazyStream.LazyCons<T> self;

        AppendSelf(LazyStream.LazyCons<T> self, Function<? super Stream<T>, ? extends Stream<T>> mapper) {
            this.self = this.appendAll(self, mapper);
        }

        private LazyStream.LazyCons<T> appendAll(LazyStream.LazyCons<T> stream, Function<? super Stream<T>, ? extends Stream<T>> mapper) {
            return (LazyStream.LazyCons)LazyStream.cons(() -> stream.head(), () -> {
                Stream tail = stream.tail();
                return tail.isEmpty() ? this.convertToLazyStream((Stream)mapper.apply(this.self)) : this.appendAll((LazyStream.LazyCons)tail, mapper);
            });
        }

        LazyStream<T> convertToLazyStream(Stream<T> stream) {
            return stream instanceof LazyStream ? (LazyStream)stream : LazyStream.ofAll(() -> stream.iterator());
        }

        LazyStream.LazyCons<T> stream() {
            return this.self;
        }
    }
}

