/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.javaslang.Javaslang;
import com.aol.cyclops.javaslang.streams.StreamUtils;
import com.aol.cyclops.lambda.monads.Functor;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.simple.react.async.Queue;
import com.aol.simple.react.async.factories.QueueFactories;
import com.aol.simple.react.stream.lazy.LazyReact;
import com.aol.simple.react.stream.simple.SimpleReact;
import com.aol.simple.react.stream.traits.LazyFutureStream;
import com.aol.simple.react.stream.traits.SimpleReactStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Function1;
import javaslang.Lazy;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Value;
import javaslang.collection.Collections;
import javaslang.collection.Iterator;
import javaslang.collection.LazyStreamModule;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Seq;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.control.Match;
import javaslang.control.Option;
import org.jooq.lambda.Collectable;

public interface LazyStream<T>
extends Stream<T>,
Functor<T> {
    public static final long serialVersionUID = 1L;

    default public SequenceM<T> stream() {
        return SequenceM.fromIterator(this.iterator());
    }

    public static <T> Collector<T, ArrayList<T>, LazyStream<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, LazyStream> finisher = LazyStream::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> LazyStream<T> fromStream(Stream<T> stream) {
        return stream instanceof LazyStream ? (LazyStream)stream : LazyStream.ofAll(() -> stream.iterator());
    }

    public static LazyStream<Integer> from(int value) {
        return LazyStream.ofAll(Iterator.from((int)value));
    }

    public static LazyStream<Long> from(long value) {
        return LazyStream.ofAll(Iterator.from((long)value));
    }

    public static <T> LazyStream<T> gen(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return LazyStream.ofAll(Iterator.gen(supplier));
    }

    public static <T> LazyStream<T> gen(T seed, Function<? super T, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return LazyStream.ofAll(Iterator.gen(seed, f));
    }

    public static <T> LazyStream<T> cons(Supplier<T> head, Supplier<? extends LazyStream<? extends T>> tailSupplier) {
        Objects.requireNonNull(tailSupplier, "tailSupplier is null");
        return new LazyCons<T>(head, tailSupplier);
    }

    public static <T> LazyStream<T> empty() {
        return LazyStream.fromStream(Stream.empty());
    }

    public static <T> LazyStream<T> of(T element) {
        return new LazyCons<Object>(() -> element, Empty::instance);
    }

    @SafeVarargs
    public static <T> LazyStream<T> of(final T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LazyStream.ofAll(new Iterator<T>(){
            int i = 0;

            public boolean hasNext() {
                return this.i < elements.length;
            }

            public T next() {
                return elements[this.i++];
            }
        });
    }

    default public Iterator<T> iterator() {
        LazyStream that = this;
        return new Iterator<T>((Traversable)that){
            Traversable<T> traversable;
            final /* synthetic */ Traversable val$that;
            {
                this.val$that = traversable;
                this.traversable = this.val$that;
            }

            public boolean hasNext() {
                return !this.traversable.isEmpty();
            }

            public T next() {
                if (this.traversable.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object result = null;
                try {
                    result = this.traversable.head();
                }
                catch (Throwable t) {
                    throw ExceptionSoftener.throwSoftenedException((Throwable)t);
                }
                finally {
                    this.traversable = this.traversable.tail();
                }
                return result;
            }
        };
    }

    public static <T> LazyStream<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return LazyStream.ofAll(Collections.tabulate((int)n, f));
    }

    public static <T> LazyStream<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return LazyStream.ofAll(Collections.fill((int)n, s));
    }

    public static <T> LazyStream<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof LazyStream) {
            return (LazyStream)((Object)elements);
        }
        return LazyStreamModule.StreamFactory.create(elements.iterator());
    }

    public static LazyStream<Boolean> ofAll(boolean[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((boolean[])array));
    }

    public static LazyStream<Byte> ofAll(byte[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((byte[])array));
    }

    public static LazyStream<Character> ofAll(char[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((char[])array));
    }

    public static LazyStream<Double> ofAll(double[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((double[])array));
    }

    public static LazyStream<Float> ofAll(float[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((float[])array));
    }

    public static LazyStream<Integer> ofAll(int[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((int[])array));
    }

    public static LazyStream<Long> ofAll(long[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((long[])array));
    }

    public static LazyStream<Short> ofAll(short[] array) {
        Objects.requireNonNull(array, "array is null");
        return LazyStream.ofAll(Iterator.ofAll((short[])array));
    }

    public static LazyStream<Character> range(char from, char toExclusive) {
        return LazyStream.ofAll(Iterator.range((char)from, (char)toExclusive));
    }

    public static LazyStream<Character> rangeBy(char from, char toExclusive, int step) {
        return LazyStream.ofAll(Iterator.rangeBy((char)from, (char)toExclusive, (int)step));
    }

    public static LazyStream<Double> rangeBy(double from, double toExclusive, double step) {
        return LazyStream.ofAll(Iterator.rangeBy((double)from, (double)toExclusive, (double)step));
    }

    public static LazyStream<Integer> range(int from, int toExclusive) {
        return LazyStream.ofAll(Iterator.range((int)from, (int)toExclusive));
    }

    public static LazyStream<Integer> rangeBy(int from, int toExclusive, int step) {
        return LazyStream.ofAll(Iterator.rangeBy((int)from, (int)toExclusive, (int)step));
    }

    public static LazyStream<Long> range(long from, long toExclusive) {
        return LazyStream.ofAll(Iterator.range((long)from, (long)toExclusive));
    }

    public static LazyStream<Long> rangeBy(long from, long toExclusive, long step) {
        return LazyStream.ofAll(Iterator.rangeBy((long)from, (long)toExclusive, (long)step));
    }

    public static LazyStream<Character> rangeClosed(char from, char toInclusive) {
        return LazyStream.ofAll(Iterator.rangeClosed((char)from, (char)toInclusive));
    }

    public static LazyStream<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return LazyStream.ofAll(Iterator.rangeClosedBy((char)from, (char)toInclusive, (int)step));
    }

    public static LazyStream<Double> rangeClosedBy(double from, double toInclusive, double step) {
        return LazyStream.ofAll(Iterator.rangeClosedBy((double)from, (double)toInclusive, (double)step));
    }

    public static LazyStream<Integer> rangeClosed(int from, int toInclusive) {
        return LazyStream.ofAll(Iterator.rangeClosed((int)from, (int)toInclusive));
    }

    public static LazyStream<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return LazyStream.ofAll(Iterator.rangeClosedBy((int)from, (int)toInclusive, (int)step));
    }

    public static LazyStream<Long> rangeClosed(long from, long toInclusive) {
        return LazyStream.ofAll(Iterator.rangeClosed((long)from, (long)toInclusive));
    }

    public static LazyStream<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return LazyStream.ofAll(Iterator.rangeClosedBy((long)from, (long)toInclusive, (long)step));
    }

    public static <T> LazyStream<T> repeat(T t) {
        return LazyStream.ofAll(Iterator.repeat(t));
    }

    default public LazyStream<T> toStream() {
        return LazyStream.toTraversable(this, LazyStream.empty(), LazyStream::of, LazyStream::ofAll);
    }

    public static <T extends Traversable<V>, V> T toTraversable(Value<V> value, T empty, Function<V, T> ofElement, Function<Iterable<V>, T> ofAll) {
        if (value.isEmpty()) {
            return empty;
        }
        if (value.isSingleValued()) {
            return (T)((Traversable)ofElement.apply(value.get()));
        }
        return (T)((Traversable)ofAll.apply((Iterable<V>)value));
    }

    public Supplier<T> lazyHead();

    default public LazyStream<T> append(T element) {
        if (this.isEmpty()) {
            return LazyStream.of(element);
        }
        Lazy tail = ((LazyCons)this).tail;
        return new LazyCons<T>(this.lazyHead(), () -> ((LazyStream)tail.get()).append(element));
    }

    default public LazyStream<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.isEmpty() ? LazyStream.ofAll(elements) : new LazyCons<T>(this.lazyHead(), () -> this.tail().appendAll((Iterable)elements));
    }

    default public LazyStream<T> appendSelf(Function<? super Stream<T>, ? extends Stream<T>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? this : new LazyStreamModule.AppendSelf(this, mapper).stream();
    }

    default public Queue<T> toAsyncBlockingQueue(int boundSize) {
        return new Queue(new LinkedBlockingQueue(boundSize));
    }

    default public Queue<T> toAsyncQueue() {
        return QueueFactories.unboundedNonBlockingQueue().build();
    }

    default public Queue<T> toAsyncQueue(int boundSize) {
        return QueueFactories.boundedNonBlockingQueue((int)boundSize).build();
    }

    default public Collectable<T> collectable() {
        return SequenceM.fromIterable((Iterable)((Object)this));
    }

    default public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.toJavaStream().collect(supplier, accumulator, combiner);
    }

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.toJavaStream().collect(collector);
    }

    default public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)this.sequenceM().toCollection(collectionFactory);
    }

    default public AnyM<T> anyM() {
        return Javaslang.anyM(this);
    }

    default public SequenceM<T> sequenceM() {
        return SequenceM.fromIterable((Iterable)((Object)this));
    }

    default public org.jooq.lambda.Seq<T> seq() {
        return org.jooq.lambda.Seq.seq((Iterable)((Object)this));
    }

    default public Streamable<T> streamable() {
        return Streamable.fromIterable((Iterable)((Object)this));
    }

    default public LazyFutureStream<T> futureStream() {
        return LazyFutureStream.lazyFutureStreamFromIterable((Iterable)((Object)this));
    }

    default public LazyFutureStream<T> futureStream(LazyReact react) {
        return react.fromIterable((Iterable)((Object)this));
    }

    default public SimpleReactStream<T> futures() {
        return new SimpleReact().fromIterable((Iterable)((Object)this));
    }

    default public SimpleReactStream<T> futures(SimpleReact react) {
        return react.fromIterable((Iterable)((Object)this));
    }

    default public LazyStream<T> clear() {
        return Empty.instance();
    }

    default public LazyStream<Stream<T>> combinations() {
        return LazyStream.rangeClosed(0, this.length()).map((T n) -> this.combinations((int)n)).flatMap((T i) -> i);
    }

    default public LazyStream<Stream<T>> combinations(int k) {
        return LazyStreamModule.Combinations.apply(this, Math.max(k, 0));
    }

    default public LazyStream<Tuple2<T, T>> crossProduct() {
        return this.crossProduct((Iterable)((Object)this));
    }

    default public LazyStream<Stream<T>> crossProduct(int power) {
        return LazyStream.ofAll(() -> Collections.crossProduct((Seq)this, (int)power).map(LazyStream::ofAll).toStream().iterator());
    }

    default public <U> LazyStream<Tuple2<T, U>> crossProduct(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        LazyStream other = LazyStream.ofAll(that);
        return this.flatMap((T a) -> other.map((T b) -> Tuple.of((Object)a, (Object)b)));
    }

    default public LazyStream<T> cycle() {
        return this.appendSelf(Function.identity());
    }

    default public LazyStream<T> distinct() {
        return this.distinctBy((T i) -> i);
    }

    default public LazyStream<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        TreeSet<? super T> seen = new TreeSet<T>(comparator);
        return this.filter(seen::add);
    }

    default public <U> LazyStream<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(keyExtractor.apply(t)));
    }

    default public LazyStream<T> drop(long n) {
        LazyStream stream = this;
        while (n-- > 0L && !stream.isEmpty()) {
            stream = stream.tail();
        }
        return stream;
    }

    default public LazyStream<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        return LazyStreamModule.DropRight.apply(this.take(n).toList(), List.empty(), this.drop(n));
    }

    default public LazyStream<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return LazyStream.fromStream(StreamUtils.skipUntil(this, predicate));
    }

    default public LazyStream<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LazyStream stream = this;
        while (!stream.isEmpty() && predicate.test(stream.head())) {
            stream = stream.tail();
        }
        return stream;
    }

    default public LazyStream<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LazyStream<Object> stream = this;
        while (!stream.isEmpty() && !predicate.test(stream.head())) {
            stream = stream.tail();
        }
        LazyStream<Object> finalStream = stream;
        return stream.isEmpty() ? stream : new LazyCons<Object>(() -> finalStream.head(), () -> finalStream.tail().filter(predicate));
    }

    default public <U> LazyStream<U> flatMap(final Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Empty.instance() : LazyStream.ofAll(new Iterator<U>(){
            final Iterator<? extends T> inputs;
            java.util.Iterator<? extends U> current;
            {
                this.inputs = LazyStream.this.iterator();
                this.current = java.util.Collections.emptyIterator();
            }

            public boolean hasNext() {
                boolean currentHasNext;
                while (!(currentHasNext = this.current.hasNext()) && this.inputs.hasNext()) {
                    this.current = ((Iterable)mapper.apply(this.inputs.next())).iterator();
                }
                return currentHasNext;
            }

            public U next() {
                return this.current.next();
            }
        });
    }

    default public T get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index + ") on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("get(" + index + ")");
        }
        LazyStream stream = this;
        for (int i = index - 1; i >= 0; --i) {
            if (!(stream = stream.tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException(String.format("get(%s) on Stream of size %s", index, index - i));
        }
        return (T)stream.head();
    }

    default public <C> Map<C, Stream<T>> groupBy(Function<? super T, ? extends C> classifier) {
        Objects.requireNonNull(classifier, "classifier is null");
        return this.iterator().groupBy(classifier).map((c, it) -> Tuple.of((Object)c, LazyStream.ofAll(it)));
    }

    default public Iterator<Stream<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    default public boolean hasDefiniteSize() {
        return false;
    }

    default public Option<T> headOption() {
        return this.isEmpty() ? Option.none() : Option.some((Object)this.head());
    }

    default public int indexOf(T element, int from) {
        int index = 0;
        LazyStream stream = this;
        while (!stream.isEmpty()) {
            if (index >= from && Objects.equals(stream.head(), element)) {
                return index;
            }
            stream = stream.tail();
            ++index;
        }
        return -1;
    }

    default public LazyStream<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty stream");
        }
        Stream tail = this.tail();
        if (tail.isEmpty()) {
            return Empty.instance();
        }
        return new LazyCons<T>(this.lazyHead(), () -> this.init());
    }

    default public Option<Stream<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some((Object)this.init());
    }

    default public LazyStream<T> insert(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e)");
        }
        if (index == 0) {
            return new LazyCons<Object>(() -> element, () -> this);
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e) on Nil");
        }
        return new LazyCons<T>(this.lazyHead(), () -> this.tail().insert(index - 1, (Object)element));
    }

    default public LazyStream<T> insertAll(int index, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements)");
        }
        if (index == 0) {
            return this.isEmpty() ? LazyStream.ofAll(elements) : LazyStream.ofAll(elements).appendAll((Iterable)((Object)this));
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements) on Nil");
        }
        return new LazyCons<T>(this.lazyHead(), () -> this.tail().insertAll(index - 1, (Iterable)elements));
    }

    default public LazyStream<T> intersperse(T element) {
        if (this.isEmpty()) {
            return this;
        }
        return new LazyCons<T>(this.lazyHead(), () -> {
            Stream tail = this.tail();
            return tail.isEmpty() ? tail : new LazyCons<Object>(() -> element, () -> LazyStream.lambda$null$40((LazyStream)tail, element));
        });
    }

    default public boolean isTraversableAgain() {
        return true;
    }

    default public int lastIndexOf(T element, int end) {
        int result = -1;
        LazyStream stream = this;
        for (int index = 0; index <= end && !stream.isEmpty(); ++index) {
            if (Objects.equals(stream.head(), element)) {
                result = index;
            }
            stream = stream.tail();
        }
        return result;
    }

    default public int length() {
        return (Integer)this.foldLeft(0, (n, ignored) -> n + 1);
    }

    default public <U> LazyStream<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return new LazyCons<Object>(() -> mapper.apply(this.head()), () -> this.tail().map(mapper));
    }

    default public Match.MatchValue.Of<Stream<T>> match() {
        return Match.of((Object)this);
    }

    default public LazyStream<T> padTo(int length, T element) {
        if (length <= 0) {
            return this;
        }
        if (this.isEmpty()) {
            return LazyStream.ofAll(Iterator.gen(() -> element).take((long)length));
        }
        return new LazyCons<T>(this.lazyHead(), () -> this.tail().padTo(length - 1, (Object)element));
    }

    default public LazyStream<T> patch(int from, Iterable<? extends T> that, int replaced) {
        from = from < 0 ? 0 : from;
        replaced = replaced < 0 ? 0 : replaced;
        Stream result = this.take(from).appendAll((Iterable)that);
        result = result.appendAll((Iterable)this.drop(from += replaced));
        return result;
    }

    default public Tuple2<Stream<T>, Stream<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of((Object)this.filter(predicate), (Object)this.filter((Predicate)predicate.negate()));
    }

    default public LazyStream<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        action.accept(head);
        return new LazyCons<Object>(() -> head, () -> this.tail().peek(action));
    }

    default public LazyStream<Stream<T>> permutations() {
        if (this.isEmpty()) {
            return Empty.instance();
        }
        Stream tail = this.tail();
        if (tail.isEmpty()) {
            return LazyStream.of(this);
        }
        Empty zero = Empty.instance();
        return (LazyStream)this.distinct().foldLeft(zero, (xs, x) -> {
            Function<LazyStream, LazyStream> prepend = l -> l.prepend(x);
            return xs.appendAll((Iterable)this.remove(x).permutations().map(prepend));
        });
    }

    default public LazyStream<T> prepend(T element) {
        return new LazyCons<Object>(() -> element, () -> this);
    }

    default public LazyStream<T> prependAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return LazyStream.ofAll(elements).appendAll((Iterable)((Object)this));
    }

    default public LazyStream<T> remove(T element) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        return Objects.equals(head, element) ? this.tail() : new LazyCons<Object>(() -> head, () -> this.tail().remove((Object)element));
    }

    default public LazyStream<T> removeFirst(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        return predicate.test(head) ? this.tail() : new LazyCons<Object>(() -> head, () -> this.tail().removeFirst((Predicate)predicate));
    }

    default public LazyStream<T> removeLast(Predicate<T> predicate) {
        return this.isEmpty() ? this : this.reverse().removeFirst((Predicate)predicate).reverse();
    }

    default public LazyStream<T> removeAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ")");
        }
        if (index == 0) {
            return this.tail();
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("removeAt() on Nil");
        }
        return new LazyCons<T>(this.lazyHead(), () -> this.tail().removeAt(index - 1));
    }

    default public LazyStream<T> removeAll(T removed) {
        return this.filter((T e) -> !Objects.equals(e, removed));
    }

    default public LazyStream<T> removeAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        Stream distinct = LazyStream.ofAll(elements).distinct();
        return this.filter(arg_0 -> LazyStream.lambda$removeAll$59((LazyStream)distinct, arg_0));
    }

    default public LazyStream<T> replace(T currentElement, T newElement) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        if (Objects.equals(head, currentElement)) {
            return new LazyCons<Object>(() -> newElement, () -> this.tail());
        }
        return new LazyCons<Object>(() -> head, () -> this.tail().replace((Object)currentElement, (Object)newElement));
    }

    default public LazyStream<T> replaceAll(T currentElement, T newElement) {
        if (this.isEmpty()) {
            return this;
        }
        Object head = this.head();
        Object newHead = Objects.equals(head, currentElement) ? newElement : head;
        return new LazyCons<Object>(() -> newHead, () -> this.tail().replaceAll((Object)currentElement, (Object)newElement));
    }

    default public LazyStream<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            return this;
        }
        Stream retained = LazyStream.ofAll(elements).distinct();
        return this.filter(arg_0 -> ((LazyStream)retained).contains(arg_0));
    }

    /*
     * Exception decompiling
     */
    default public LazyStream<T> reverse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public LazyStream<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    default public <U> LazyStream<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return LazyStream.ofAll(this.iterator().scanLeft(zero, operation));
    }

    /*
     * Exception decompiling
     */
    default public <U> LazyStream<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public LazyStream<T> slice(long beginIndex, long endIndex) {
        if (beginIndex >= endIndex || this.isEmpty()) {
            return LazyStream.empty();
        }
        long lowerBound = Math.max(beginIndex, 0L);
        if (lowerBound == 0L) {
            return new LazyCons<T>(this.lazyHead(), () -> this.tail().slice(0L, endIndex - 1L));
        }
        return this.tail().slice(lowerBound - 1L, endIndex - 1L);
    }

    default public Iterator<Stream<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    default public Iterator<Stream<T>> sliding(long size, long step) {
        return this.iterator().sliding(size, step).map(LazyStream::ofAll);
    }

    default public LazyStream<T> sort() {
        return this.isEmpty() ? this : this.toJavaStream().sorted().collect(LazyStream.collector());
    }

    default public LazyStream<T> sort(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator).collect(LazyStream.collector());
    }

    default public <U extends Comparable<? super U>> LazyStream<T> sortBy(Function<? super T, ? extends U> mapper) {
        return this.sortBy(Comparable::compareTo, (Function)mapper);
    }

    default public <U> LazyStream<T> sortBy(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Function1 domain = Function1.of(mapper::apply).memoized();
        return this.toJavaStream().sorted((arg_0, arg_1) -> LazyStream.lambda$sortBy$66(comparator, (Function)domain, arg_0, arg_1)).collect(LazyStream.collector());
    }

    default public Tuple2<Stream<T>, Stream<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of((Object)this.takeWhile((Predicate)predicate), (Object)this.dropWhile((Predicate)predicate));
    }

    default public Tuple2<Stream<T>, Stream<T>> splitAt(long n) {
        return Tuple.of((Object)this.take(n), (Object)this.drop(n));
    }

    default public Tuple2<Stream<T>, Stream<T>> splitAt(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of((Object)this.takeWhile((Predicate)predicate.negate()), (Object)this.dropWhile((Predicate)predicate.negate()));
    }

    default public Tuple2<Stream<T>, Stream<T>> splitAtInclusive(Predicate<? super T> predicate) {
        Tuple2<Stream<? super T>, Stream<? super T>> split = this.splitAt(predicate);
        if (((Stream)split._2).isEmpty()) {
            return split;
        }
        return Tuple.of((Object)((Stream)split._1).append(((Stream)split._2).head()), (Object)((Stream)split._2).tail());
    }

    default public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    default public String stringPrefix() {
        return "Stream";
    }

    default public LazyStream<T> subSequence(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ")");
        }
        LazyStream result = this;
        int i = 0;
        while (i < beginIndex) {
            if (result.isEmpty()) {
                throw new IndexOutOfBoundsException(String.format("subSequence(%s) on Stream of size %s", beginIndex, i));
            }
            ++i;
            result = result.tail();
        }
        return result;
    }

    default public LazyStream<T> subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.format("subSequence(%s, %s)", beginIndex, endIndex));
        }
        if (beginIndex == endIndex) {
            return Empty.instance();
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("subSequence of Nil");
        }
        if (beginIndex == 0) {
            return new LazyCons<T>(this.lazyHead(), () -> this.tail().subSequence(0, endIndex - 1));
        }
        return this.tail().subSequence(beginIndex - 1, endIndex - 1);
    }

    public LazyStream<T> tail();

    default public Option<Stream<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some((Object)this.tail());
    }

    default public LazyStream<T> take(long n) {
        if (n < 1L || this.isEmpty()) {
            return Empty.instance();
        }
        return new LazyCons<T>(this.lazyHead(), () -> this.tail().take(n - 1L));
    }

    default public LazyStream<T> takeRight(long n) {
        return LazyStream.fromStream(StreamUtils.limitLast(this, (int)n));
    }

    default public LazyStream<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    default public LazyStream<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        Object head = this.head();
        if (predicate.test(head)) {
            return new LazyCons<Object>(() -> head, () -> this.tail().takeWhile(predicate));
        }
        return Empty.instance();
    }

    default public <U> LazyStream<U> unit(Iterable<? extends U> iterable) {
        return LazyStream.ofAll(iterable);
    }

    default public <T1, T2> Tuple2<Stream<T1>, Stream<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        Stream stream = this.map(unzipper);
        Stream stream1 = stream.map((T t) -> t._1);
        Stream stream2 = stream.map((T t) -> t._2);
        return Tuple.of((Object)stream1, (Object)stream2);
    }

    default public <T1, T2, T3> Tuple3<Stream<T1>, Stream<T2>, Stream<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        Stream stream = this.map(unzipper);
        Stream stream1 = stream.map((T t) -> t._1);
        Stream stream2 = stream.map((T t) -> t._2);
        Stream stream3 = stream.map((T t) -> t._3);
        return Tuple.of((Object)stream1, (Object)stream2, (Object)stream3);
    }

    default public LazyStream<T> update(int index, T element) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index + ", e) on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("update(" + index + ", e)");
        }
        Stream preceding = Empty.instance();
        LazyStream tail = this;
        int i = index;
        while (i > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("update at " + index);
            }
            preceding = preceding.prepend(tail.head());
            --i;
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            throw new IndexOutOfBoundsException("update at " + index);
        }
        return preceding.reverse().appendAll((Iterable)tail.tail().prepend((Object)element));
    }

    default public <U> LazyStream<Tuple2<T, U>> zip(Iterable<U> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        return LazyStream.ofAll(this.iterator().zip(iterable));
    }

    default public <U> LazyStream<Tuple2<T, U>> zipAll(Iterable<U> iterable, T thisElem, U thatElem) {
        Objects.requireNonNull(iterable, "iterable is null");
        return LazyStream.ofAll(this.iterator().zipAll(iterable, thisElem, thatElem));
    }

    default public LazyStream<Tuple2<T, Long>> zipWithIndex() {
        return LazyStream.ofAll(this.iterator().zipWithIndex());
    }

    private static /* synthetic */ int lambda$sortBy$66(Comparator comparator, Function function, Object e1, Object e2) {
        return comparator.compare(function.apply(e1), function.apply(e2));
    }

    private static /* synthetic */ boolean lambda$removeAll$59(LazyStream lazyStream, Object e) {
        return !lazyStream.contains(e);
    }

    private static /* synthetic */ LazyStream lambda$null$40(LazyStream lazyStream, Object object) {
        return lazyStream.intersperse(object);
    }

    public static final class LazyCons<T>
    implements LazyStream<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Supplier<T> head;
        private final Lazy<LazyStream<T>> tail;

        LazyCons(Supplier<T> head, Supplier<LazyStream<T>> tail) {
            Objects.requireNonNull(tail, "tail is null");
            this.head = head;
            this.tail = Lazy.of(tail);
        }

        @Override
        public Supplier<T> lazyHead() {
            return this.head;
        }

        public T head() {
            return this.head.get();
        }

        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return new LazyStreamModule.StreamIterator(this);
        }

        @Override
        public LazyStream<T> tail() {
            return (LazyStream)this.tail.get();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Stream) {
                LazyCons stream1 = this;
                Stream stream2 = (Stream)o;
                while (!stream1.isEmpty() && !stream2.isEmpty()) {
                    boolean isEqual = Objects.equals(stream1.head(), stream2.head());
                    if (!isEqual) {
                        return false;
                    }
                    stream1 = stream1.tail();
                    stream2 = stream2.tail();
                }
                return stream1.isEmpty() && stream2.isEmpty();
            }
            return false;
        }

        public int hashCode() {
            return Traversable.hash((Iterable)((Object)this));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.stringPrefix()).append("(");
            LazyStream<T> stream = this;
            while (stream != null && !stream.isEmpty()) {
                LazyCons cons = stream;
                builder.append(cons.head());
                if (cons.tail.isEvaluated()) {
                    stream = (LazyStream)cons.tail.get();
                    if (stream.isEmpty()) continue;
                    builder.append(", ");
                    continue;
                }
                builder.append(", ?");
                stream = null;
            }
            return builder.append(")").toString();
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static final class SerializationProxy<T>
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient LazyCons<T> stream;

            SerializationProxy(LazyCons<T> stream) {
                this.stream = stream;
            }

            private void writeObject(ObjectOutputStream s) throws IOException {
                s.defaultWriteObject();
                s.writeInt(this.stream.length());
                Stream l = this.stream;
                while (!l.isEmpty()) {
                    s.writeObject(l.head());
                    l = l.tail();
                }
            }

            private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
                s.defaultReadObject();
                int size = s.readInt();
                if (size <= 0) {
                    throw new InvalidObjectException("No elements");
                }
                Stream temp = Empty.instance();
                for (int i = 0; i < size; ++i) {
                    Object element = s.readObject();
                    temp = temp.append(element);
                }
                this.stream = (LazyCons)temp;
            }

            private Object readResolve() {
                return this.stream;
            }
        }
    }

    public static final class Empty<T>
    implements LazyStream<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public Supplier<T> lazyHead() {
            return () -> null;
        }

        public static <T> Empty<T> instance() {
            return INSTANCE;
        }

        public T head() {
            throw new NoSuchElementException("head of empty stream");
        }

        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterator.empty();
        }

        @Override
        public LazyStream<T> tail() {
            throw new UnsupportedOperationException("tail of empty stream");
        }

        public boolean equals(Object o) {
            return o instanceof Empty || o instanceof Stream.Empty;
        }

        public int hashCode() {
            return Traversable.hash((Iterable)((Object)this));
        }

        public String toString() {
            return this.stringPrefix() + "()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

