/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.streams;

import com.aol.cyclops.javaslang.FromJDK;
import com.aol.cyclops.javaslang.streams.JavaslangHotStream;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.streams.IteratorHotStream;
import com.aol.cyclops.streams.spliterators.ClosingSpliterator;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javaslang.collection.Stream;
import uk.co.real_logic.agrona.concurrent.OneToOneConcurrentArrayQueue;

public abstract class BaseHotStreamImpl<T>
extends IteratorHotStream<T>
implements JavaslangHotStream<T> {
    protected final Stream<T> stream;

    public BaseHotStreamImpl(Stream<T> stream) {
        this.stream = stream;
    }

    public JavaslangHotStream<T> paused(Executor exec) {
        this.pause();
        return this.init(exec);
    }

    public abstract JavaslangHotStream<T> init(Executor var1);

    public JavaslangHotStream<T> schedule(String cron, ScheduledExecutorService ex) {
        javaslang.collection.Iterator it = this.stream.iterator();
        this.scheduleInternal((Iterator)it, cron, ex);
        return this;
    }

    public JavaslangHotStream<T> scheduleFixedDelay(long delay, ScheduledExecutorService ex) {
        javaslang.collection.Iterator it = this.stream.iterator();
        this.scheduleFixedDelayInternal((Iterator)it, delay, ex);
        return this;
    }

    public JavaslangHotStream<T> scheduleFixedRate(long rate, ScheduledExecutorService ex) {
        javaslang.collection.Iterator it = this.stream.iterator();
        this.scheduleFixedRate((Iterator)it, rate, ex);
        return this;
    }

    @Override
    public Stream<T> connect() {
        this.unpause();
        return this.connect((Queue<T>)new OneToOneConcurrentArrayQueue(256));
    }

    @Override
    public Stream<T> connect(Queue<T> queue) {
        this.unpause();
        this.connections.getAndSet(this.connected, queue);
        ++this.connected;
        return FromJDK.stream(SequenceM.fromStream(StreamSupport.stream(new ClosingSpliterator(Long.MAX_VALUE, queue, this.open), false)));
    }

    @Override
    public <R extends Stream<T>> R connectTo(Queue<T> queue, Function<Stream<T>, R> to) {
        return (R)((Stream)to.apply(this.connect(queue)));
    }
}

