/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams;

import com.aol.cyclops.comprehensions.donotation.typed.Do;
import com.aol.cyclops.javaslang.ToStream;
import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.javaslang.streams.StreamUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javaslang.collection.LazyStream;
import javaslang.control.Try;
import org.reactivestreams.Subscription;

public class ReactiveStreamImpl<T>
implements ReactiveStream<T> {
    private final LazyStream<T> stream;

    ReactiveStreamImpl(LazyStream<T> stream) {
        this.stream = stream;
    }

    private <U> LazyStream<Try<U>> enforceTry(LazyStream<T> stream) {
        if (stream.isEmpty()) {
            return LazyStream.Empty.instance();
        }
        return stream.map((T t) -> {
            if (t instanceof Try) {
                return (Try)t;
            }
            return Try.success((Object)t);
        });
    }

    public String toString() {
        return this.stream.toString();
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReactiveStreamImpl) {
            return this.stream.equals(((ReactiveStreamImpl)obj).stream);
        }
        return this.stream.equals(obj);
    }

    @Override
    public ReactiveStream<T> appendSelf(Function<? super javaslang.collection.Stream<T>, ? extends javaslang.collection.Stream<T>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return ReactiveStream.fromStream(this.stream.appendSelf(mapper));
    }

    public Stream<T> parallel() {
        return (Stream)ToStream.toStream(this.stream).parallel();
    }

    @Override
    public LazyStream<T> toStream() {
        return this.stream;
    }

    public <X extends Throwable> Subscription forEachX(long numberOfElements, Consumer<? super T> consumer) {
        return StreamUtils.forEachX(this, numberOfElements, consumer);
    }

    public <X extends Throwable> Subscription forEachXWithError(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError) {
        return StreamUtils.forEachXWithError(this, numberOfElements, consumer, consumerError);
    }

    public <X extends Throwable> Subscription forEachXEvents(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return StreamUtils.forEachXEvents(this, numberOfElements, consumer, consumerError, onComplete);
    }

    public <X extends Throwable> void forEachWithError(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError) {
        StreamUtils.forEachWithError(this, consumerElement, consumerError);
    }

    public <X extends Throwable> void forEachEvent(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        StreamUtils.forEachEvent(this, consumerElement, consumerError, onComplete);
    }

    @Override
    public <R1, R2, R> ReactiveStream<R> forEach3(Function<? super T, ? extends Iterable<R1>> stream1, Function<? super T, Function<? super R1, ? extends Iterable<R2>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)Do.add((Iterable)((Object)this)).withIterable(u -> (Iterable)stream1.apply(u)).withIterable(u -> r1 -> (Iterable)((Function)stream2.apply(u)).apply(r1)).yield(yieldingFunction).unwrap());
    }

    @Override
    public <R1, R2, R> ReactiveStream<R> forEach3(Function<? super T, ? extends Iterable<R1>> stream1, Function<? super T, Function<? super R1, ? extends Iterable<R2>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> filterFunction, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)Do.add((Iterable)((Object)this)).withIterable(u -> (Iterable)stream1.apply(u)).withIterable(u -> r1 -> (Iterable)((Function)stream2.apply(u)).apply(r1)).filter(filterFunction).yield(yieldingFunction).unwrap());
    }

    @Override
    public <R1, R> ReactiveStream<R> forEach2(Function<? super T, ? extends Iterable<R1>> stream1, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)Do.add((Iterable)((Object)this)).withIterable(u -> (Iterable)stream1.apply(u)).yield(yieldingFunction).unwrap());
    }

    @Override
    public <R1, R> ReactiveStream<R> forEach2(Function<? super T, ? extends Iterable<R1>> stream1, Function<? super T, Function<? super R1, Boolean>> filterFunction, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)Do.add((Iterable)((Object)this)).withIterable(u -> (Iterable)stream1.apply(u)).filter(filterFunction).yield(yieldingFunction).unwrap());
    }

    public T head() {
        return (T)this.stream.head();
    }

    public boolean isEmpty() {
        return this.stream.isEmpty();
    }

    @Override
    public Supplier<T> lazyHead() {
        return this.stream.lazyHead();
    }
}

