/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.streams;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.javaslang.streams.StreamUtils;
import java.util.ArrayList;
import java.util.function.Supplier;
import javaslang.collection.LazyStream;
import javaslang.collection.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.reactivestreams.Subscription;

public class ForEachTest {
    boolean complete = false;
    Throwable error;

    @Before
    public void setup() {
        this.error = null;
        this.complete = false;
    }

    @Test
    public void forEachX() {
        Subscription s = StreamUtils.forEachX((LazyStream)LazyStream.of((Object[])new Integer[]{1, 2, 3}), (long)2L, System.out::println);
        System.out.println("first batch");
        s.request(1L);
    }

    @Test
    public void forEachXTest() {
        ArrayList list = new ArrayList();
        Subscription s = StreamUtils.forEachX((LazyStream)LazyStream.of((Object[])new Integer[]{1, 2, 3}), (long)2L, i -> list.add(i));
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)2));
        s.request(1L);
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void forEachXWithErrors() {
        ArrayList list = new ArrayList();
        LazyStream stream = LazyStream.of((Object[])new Supplier[]{() -> 1, () -> 2, () -> 3, () -> {
            throw new RuntimeException();
        }}).map(Supplier::get);
        Subscription s = StreamUtils.forEachXWithError((LazyStream)stream, (long)2L, i -> list.add(i), e -> {
            this.error = e;
        });
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)2));
        System.out.println("first batch");
        s.request(1L);
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.error, (Matcher)Matchers.nullValue());
        s.request(2L);
        Assert.assertThat((Object)this.error, (Matcher)Matchers.instanceOf(RuntimeException.class));
    }

    @Test
    public void forEachXWithEvents() {
        ArrayList list = new ArrayList();
        LazyStream stream = LazyStream.of((Object[])new Supplier[]{() -> 1, () -> 2, () -> 3, () -> {
            throw new RuntimeException();
        }}).map(Supplier::get);
        Subscription s = StreamUtils.forEachXEvents((LazyStream)stream, (long)2L, i -> list.add(i), e -> {
            this.error = e;
        }, () -> {
            this.complete = true;
        });
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)2));
        System.out.println("first batch");
        s.request(1L);
        Assert.assertFalse((boolean)this.complete);
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.error, (Matcher)Matchers.nullValue());
        s.request(2L);
        Assert.assertThat((Object)this.error, (Matcher)Matchers.instanceOf(RuntimeException.class));
        Assert.assertTrue((boolean)this.complete);
    }

    @Test
    public void forEachWithErrors() {
        ArrayList list = new ArrayList();
        Assert.assertThat((Object)this.error, (Matcher)Matchers.nullValue());
        LazyStream stream = LazyStream.of((Object[])new Supplier[]{() -> 1, () -> 2, () -> 3, () -> {
            throw new RuntimeException();
        }}).map(Supplier::get);
        StreamUtils.forEachWithError((Stream)stream, i -> list.add(i), e -> {
            this.error = e;
        });
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.error, (Matcher)Matchers.instanceOf(RuntimeException.class));
    }

    @Test
    public void forEachWithEvents() {
        ArrayList list = new ArrayList();
        Assert.assertFalse((boolean)this.complete);
        Assert.assertThat((Object)this.error, (Matcher)Matchers.nullValue());
        LazyStream stream = LazyStream.of((Object[])new Supplier[]{() -> 1, () -> 2, () -> 3, () -> {
            throw new RuntimeException();
        }}).map(Supplier::get);
        StreamUtils.forEachEvent((LazyStream)stream, i -> list.add(i), e -> {
            this.error = e;
        }, () -> {
            this.complete = true;
        });
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)this.error, (Matcher)Matchers.instanceOf(RuntimeException.class));
        Assert.assertTrue((boolean)this.complete);
    }

    @Test
    public void forEachWithEvents2() {
        ArrayList list = new ArrayList();
        Assert.assertFalse((boolean)this.complete);
        Assert.assertThat((Object)this.error, (Matcher)Matchers.nullValue());
        ReactiveStream stream = ReactiveStream.of((Object[])new Supplier[]{() -> 1, () -> 2, () -> 3, () -> {
            throw new RuntimeException();
        }, () -> 5}).map(Supplier::get);
        stream.forEachWithError(System.out::println, Throwable::printStackTrace);
        StreamUtils.forEachEvent((LazyStream)stream, i -> list.add(i), e -> {
            this.error = e;
        }, () -> {
            this.complete = true;
        });
        Assert.assertThat(list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3, 5}));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat((Object)this.error, (Matcher)Matchers.instanceOf(RuntimeException.class));
        Assert.assertTrue((boolean)this.complete);
    }
}

