/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.sequence.SequenceM;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WindowingTest {
    ReactiveStream<Integer> empty;
    ReactiveStream<Integer> nonEmpty;

    @Before
    public void setup() {
        this.empty = ReactiveStream.of((Object[])new Integer[0]);
        this.nonEmpty = ReactiveStream.of((Object[])new Integer[]{1});
    }

    @Test
    public void windowWhile() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowWhile(i -> i % 3 != 0).toList().length(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)((ReactiveStream)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowWhile(i -> i % 3 != 0).toList().get(0)).sequenceM().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void windowUntil() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowUntil(i -> i % 3 == 0).toJavaList().size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)((ReactiveStream)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowUntil(i -> i % 3 == 0).toList().get(0)).sequenceM().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void windowUntilEmpty() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[0]).windowUntil(i -> i % 3 == 0).toList().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void windowStatefullyWhile() {
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowStatefullyWhile((s, i) -> s.sequenceM().toList().contains(4)).toList());
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowStatefullyWhile((s, i) -> s.sequenceM().toList().contains(4)).toList().length(), (Matcher)Matchers.equalTo((Object)5));
    }

    @Test
    public void windowStatefullyWhileEmpty() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).windowStatefullyWhile((s, i) -> s.sequenceM().toList().contains(4)).toList().length(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void sliding() {
        List list = (List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).slidingWindow(2).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{2, 3}));
    }

    @Test
    public void slidingIncrement() {
        List list = (List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).slidingWindow(3, 2).collect(Collectors.toList());
        System.out.println(list);
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{3, 4, 5}));
    }

    @Test
    public void grouped() {
        List list = (List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowBySize(3).map(s -> s.toJavaList()).collect(Collectors.toList());
        System.out.println(list);
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void sliding2() {
        List sliding = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).slidingWindow(2).toJavaList();
        Assert.assertThat((Object)sliding, (Matcher)Matchers.contains((Object[])new ReactiveStream[]{ReactiveStream.of((Object[])new Integer[]{1, 2}), ReactiveStream.of((Object[])new Integer[]{2, 3}), ReactiveStream.of((Object[])new Integer[]{3, 4}), ReactiveStream.of((Object[])new Integer[]{4, 5})}));
    }

    @Test
    public void slidingOverlap() {
        List sliding = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).slidingWindow(3, 2).map(s -> s.toJavaList()).toJavaList();
        Assert.assertThat((Object)sliding, (Matcher)Matchers.contains((Object[])new List[]{Arrays.asList(1, 2, 3), Arrays.asList(3, 4, 5)}));
    }

    @Test
    public void slidingEmpty() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).sliding(1L).toList().length(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void slidingWithSmallWindowAtEnd() {
        List sliding = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).slidingWindow(2, 2).toJavaList();
        Assert.assertThat((Object)sliding, (Matcher)Matchers.contains((Object[])new ReactiveStream[]{ReactiveStream.of((Object[])new Integer[]{1, 2}), ReactiveStream.of((Object[])new Integer[]{3, 4}), ReactiveStream.of((Object[])new Integer[]{5})}));
    }

    @Test
    public void groupedOnEmpty() throws Exception {
        Assert.assertThat((Object)this.empty.windowBySize(10).length(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void groupedEmpty0() throws Exception {
        this.empty.grouped(0L).toList();
    }

    @Test(expected=IllegalArgumentException.class)
    public void grouped0() throws Exception {
        this.nonEmpty.grouped(0L).toList();
    }

    @Test
    public void groupedEmpty() throws Exception {
        Assert.assertThat((Object)this.empty.grouped(1L).length(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void groupedInfinite() {
        ReactiveStream infinite = ReactiveStream.iterate((Object)1, i -> i + 1);
        ReactiveStream grouped = infinite.windowBySize(3);
        Assert.assertThat((Object)grouped.get(), (Matcher)Matchers.equalTo((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3})));
    }
}

