/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests.SimpleTimer;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javaslang.collection.List;
import javaslang.collection.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class BatchingTest {
    AtomicInteger count2 = new AtomicInteger(0);
    int count3 = 0;
    volatile int otherCount;
    volatile int peek = 0;

    @Test
    public void batchUntil() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowUntil(i -> i % 3 == 0).toList().length(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowUntil(i -> i % 3 == 0).toList().get(0), (Matcher)Matchers.equalTo((Object)Stream.of((Object[])new Integer[]{1, 2, 3})));
    }

    @Test
    public void batchWhile() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowWhile(i -> i % 3 != 0).toList().length(), (Matcher)Matchers.equalTo((Object)2));
        ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowWhile(i -> i % 3 != 0).toList().forEach(a -> System.out.println(a.getClass()));
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowWhile(i -> i % 3 != 0).toList(), (Matcher)Matchers.equalTo((Object)List.of((Object[])new Stream[]{Stream.of((Object[])new Integer[]{1, 2, 3}), Stream.of((Object[])new Integer[]{4, 5, 6})})));
    }

    private Integer sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return i;
    }

    @Test
    public void windowwByTime2() {
        for (int i = 0; i < 5; ++i) {
            System.out.println(i);
            Assert.assertThat((Object)((ReactiveStream)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).map(n -> n == 6 ? this.sleep(1) : n).windowByTime(10L, TimeUnit.MICROSECONDS).toList().get(0)).sequenceM().toList(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)6)));
        }
    }

    @Test
    public void jitter() {
        ReactiveStream.range((int)0, (int)1000).map(it -> it * 100).jitter(100L).peek(System.out::println).forEach(a -> {});
    }

    @Test
    public void fixedDelay2() {
        ReactiveStream.range((int)0, (int)1000).fixedDelay(1L, TimeUnit.MICROSECONDS).peek(System.out::println).forEach(a -> {});
    }

    @Test
    public void onePerSecond() {
        ReactiveStream.iterate((Object)0, it -> it + 1).take(100L).onePer(1L, TimeUnit.MICROSECONDS).map(seconds -> "hello!").peek(System.out::println).toList();
    }

    private String saveStatus(Status s) {
        return "Status saved:" + s.getId();
    }

    private Object nextFile() {
        return "hello";
    }

    @Test
    public void windowByTimeFiltered() {
        for (int x = 0; x < 10; ++x) {
            this.count2 = new AtomicInteger(0);
            ArrayList result = new ArrayList();
            ReactiveStream.iterate((Object)"", last -> "hello").take(1000L).peek(i -> System.out.println(++this.otherCount)).windowByTime(1L, TimeUnit.MICROSECONDS).peek(batch -> System.out.println("batched : " + batch + ":" + ++this.peek)).peek(batch -> this.count3 += (int)batch.seq().count()).forEach(next -> this.count2.getAndAdd((int)next.seq().count()));
            System.out.println("In flight count " + this.count3 + " :" + this.otherCount);
            System.out.println(result.size());
            System.out.println(result);
            System.out.println("x" + x);
            Assert.assertThat((Object)this.count2.get(), (Matcher)Matchers.equalTo((Object)1000));
        }
    }

    @Test
    public void windowByTimex() {
        ReactiveStream.iterate((Object)"", last -> "next").take(100L).peek(next -> System.out.println("Counter " + this.count2.incrementAndGet())).windowByTime(10L, TimeUnit.MICROSECONDS).peek(batch -> System.out.println("batched : " + batch)).filter(c -> c.length() != 0).forEach(System.out::println);
    }

    @Test
    public void batchBySize3() {
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowBySize(3).collect(Collectors.toList()));
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowBySize(3).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void windowBySizeAndTimeSize() {
        Assert.assertThat((Object)((ReactiveStream)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowBySizeAndTime(3, 10L, TimeUnit.SECONDS).toList().get(0)).seq().count(), (Matcher)Matchers.is((Object)3L));
    }

    @Test
    public void windowBySizeAndTimeSizeEmpty() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).windowBySizeAndTime(3, 10L, TimeUnit.SECONDS).toList().length(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void windowBySizeAndTimeTime() {
        for (int i = 0; i < 10; ++i) {
            System.out.println(i);
            java.util.List list = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).map(n -> n == 6 ? this.sleep(1) : n).windowBySizeAndTime(10, 1L, TimeUnit.MICROSECONDS).toJavaList();
            Assert.assertThat((Object)((ReactiveStream)list.get(0)).sequenceM().toList(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)6)));
        }
    }

    @Test
    public void fixedDelay() {
        SimpleTimer timer = new SimpleTimer();
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).fixedDelay(10000L, TimeUnit.NANOSECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)timer.getElapsedNanoseconds(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(60000L)));
    }

    @Test
    public void judder() {
        SimpleTimer timer = new SimpleTimer();
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).jitter(10000L).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)timer.getElapsedNanoseconds(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(20000L)));
    }

    @Test
    public void debounce() {
        SimpleTimer timer = new SimpleTimer();
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).debounce(1000L, TimeUnit.SECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void debounceOk() {
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).debounce(1L, TimeUnit.NANOSECONDS).toList());
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).debounce(1L, TimeUnit.NANOSECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void onePer() {
        SimpleTimer timer = new SimpleTimer();
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).onePer(1000L, TimeUnit.NANOSECONDS).collect(Collectors.toList()));
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).onePer(1000L, TimeUnit.NANOSECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)timer.getElapsedNanoseconds(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(600L)));
    }

    @Test
    public void xPer() {
        SimpleTimer timer = new SimpleTimer();
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).xPer(6, 1000L, TimeUnit.NANOSECONDS).collect(Collectors.toList()));
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).xPer(6, 100000000L, TimeUnit.NANOSECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)timer.getElapsedNanoseconds(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(60000000L)));
    }

    @Test
    public void batchByTime() {
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowByTime(1L, TimeUnit.SECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void batchByTimeInternalSize() {
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowByTime(1L, TimeUnit.NANOSECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5)));
    }

    @Test
    public void windowByTimeInternalSize() {
        Assert.assertThat((Object)((java.util.List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowByTime(1L, TimeUnit.NANOSECONDS).collect(Collectors.toList())).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5)));
    }

    static final class Status {
        private final long id;

        @ConstructorProperties(value={"id"})
        public Status(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Status)) {
                return false;
            }
            Status other = (Status)o;
            return this.getId() == other.getId();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            return result;
        }

        public String toString() {
            return "BatchingTest.Status(id=" + this.getId() + ")";
        }
    }
}

