/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang;

import com.aol.cyclops.javaslang.Javaslang;
import com.aol.cyclops.monad.AnyM;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javaslang.Lazy;
import javaslang.Value;
import javaslang.collection.Array;
import javaslang.collection.CharSeq;
import javaslang.collection.HashSet;
import javaslang.collection.LazyStream;
import javaslang.collection.List;
import javaslang.collection.Queue;
import javaslang.collection.Stack;
import javaslang.collection.Vector;
import javaslang.concurrent.Future;
import javaslang.control.Either;
import javaslang.control.Option;
import javaslang.control.Try;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AnyJavaslangMTest {
    @Test
    public void testToList() {
        Assert.assertThat((Object)Javaslang.anyM((List)List.of((Object[])new Integer[]{1, 2, 3})).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void monadTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Try.of(this::success)).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void tryTest() {
        Assert.assertThat((Object)Javaslang.anyM((Try)Try.of(this::success)).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void tryTestFailure() {
        Javaslang.anyM((Try)Try.failure((Throwable)new RuntimeException())).toSequence().forEach(System.out::println);
    }

    @Test
    public void tryTestFailureProcess() {
        RuntimeException e = new RuntimeException();
        Assert.assertThat((Object)Javaslang.anyMFailure((Try)Try.failure((Throwable)e)).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(e)));
    }

    @Test
    public void whenSuccessFailureProcessDoesNothing() {
        Assert.assertThat((Object)Javaslang.anyMFailure((Try)Try.success((Object)"hello world")).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void tryFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Try)Try.of(this::success)).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    private String success() {
        return "hello world";
    }

    private String exceptional() {
        throw new RuntimeException();
    }

    @Test
    public void eitherTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either)Either.right((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void eitherLeftTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either)Either.left((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void eitherFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either)Either.right((Object)"hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)Either.right((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionLeftTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)Either.left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void rightProjectionFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)Either.right((Object)"hello world").right()).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)Either.left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void leftProjectionLeftTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.LeftProjection)Either.left((Object)"hello world").left()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionLeftFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.LeftProjection)Either.left((Object)"hello world").left()).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionTest() {
        Assert.assertThat((Object)Javaslang.anyM((Option)Option.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Option)Option.of((Object)"hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionEmptyTest() {
        Assert.assertThat((Object)Javaslang.anyM((Option)Option.none()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void futureTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Future.of(() -> "hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void futureFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Future.of(() -> "hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void lazyTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Lazy.of(() -> "hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamTest() {
        Assert.assertThat((Object)Javaslang.anyM((LazyStream)LazyStream.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void listTest() {
        Assert.assertThat((Object)Javaslang.anyM((List)List.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((LazyStream)LazyStream.of((Object)"hello world")).map(String::toUpperCase).flatMap(i -> Javaslang.anyM((List)List.of((Object)i))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTestJDK() {
        Assert.assertThat((Object)Javaslang.anyM((LazyStream)LazyStream.of((Object)"hello world")).map(String::toUpperCase).flatMap(i -> AnyM.fromStream(Stream.of(i))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void arrayTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Array.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void charSeqTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)CharSeq.of((CharSequence)"hello world")).map(c -> Character.valueOf(c.toString().toUpperCase().charAt(0))).toSequence().join(), (Matcher)Matchers.equalTo((Object)"HELLO WORLD"));
    }

    @Test
    public void hashsetTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)HashSet.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void queueTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Queue.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void stackTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Stack.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void vectorTest() {
        Assert.assertThat((Object)Javaslang.anyMonad((Value)Vector.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }
}

