/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.javaslang.reactivestreams.JavaslangReactiveStreamsPublisher;
import com.aol.cyclops.javaslang.reactivestreams.JavaslangReactiveStreamsSubscriber;
import com.aol.cyclops.javaslang.reactivestreams.ReactiveStreamImpl;
import com.aol.cyclops.javaslang.streams.JavaslangHotStream;
import com.aol.cyclops.javaslang.streams.StreamUtils;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.reactivestreams.ReactiveStreamsTerminalOperations;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.trampoline.Trampoline;
import com.aol.simple.react.async.Queue;
import com.aol.simple.react.async.subscription.Continueable;
import com.aol.simple.react.async.subscription.Subscription;
import com.aol.simple.react.stream.lazy.LazyReact;
import com.aol.simple.react.stream.traits.LazyFutureStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import javaslang.Lazy;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.LazyStream;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.control.Option;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface ReactiveStream<T>
extends LazyStream<T>,
Publisher<T>,
ReactiveStreamsTerminalOperations<T> {
    default public <U> U foldRight2(U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return (U)this.reverse().foldLeft(zero, (xs, x) -> f.apply(xs, x));
    }

    public static <T> ReactiveStream<T> cons(Supplier<T> head, Supplier<? extends LazyStream<? extends T>> tailSupplier) {
        return ReactiveStream.fromStream(LazyStream.cons(head, tailSupplier));
    }

    public static ReactiveStream<Integer> from(int value) {
        return ReactiveStream.fromStream(LazyStream.from(value));
    }

    public static ReactiveStream<Long> from(long value) {
        return ReactiveStream.fromStream(LazyStream.from(value));
    }

    public static <T> ReactiveStream<T> of(T ... values) {
        return ReactiveStream.fromStream(LazyStream.of(values));
    }

    public static <T> ReactiveStream<T> empty() {
        return ReactiveStream.fromStream(LazyStream.empty());
    }

    public static <T> ReactiveStream<T> iterate(T seed, Function<? super T, ? extends T> gen) {
        return ReactiveStream.fromStream(LazyStream.gen(seed, gen));
    }

    public static ReactiveStream<Integer> range(int start, int end) {
        return ReactiveStream.fromStream(LazyStream.range(start, end));
    }

    public static ReactiveStream<Long> range(long start, long end) {
        return ReactiveStream.fromStream(LazyStream.range(start, end));
    }

    public static <T> ReactiveStream<T> generate(Supplier<T> gen) {
        return ReactiveStream.fromStream((LazyStream)Lazy.val(() -> LazyStream.gen(gen), LazyStream.class));
    }

    public static <T> ReactiveStream<T> fromStream(Stream<T> stream) {
        if (stream instanceof ReactiveStream) {
            return (ReactiveStream)stream;
        }
        return new ReactiveStreamImpl<T>(LazyStream.fromStream(stream));
    }

    public static <T> ReactiveStream<T> fromStreamable(Streamable<T> stream) {
        return ReactiveStream.fromIterable(stream);
    }

    public static <T> ReactiveStream<T> fromJDK(BaseStream<T, ? extends BaseStream<T, ?>> stream) {
        return ReactiveStream.fromIterable(() -> stream.iterator());
    }

    public static <T> ReactiveStream<T> fromAnyM(AnyM<T> stream) {
        return ReactiveStream.fromJDK(stream.stream());
    }

    public static <T> ReactiveStream<T> fromIterable(Iterable<T> stream) {
        return ReactiveStream.fromStream(LazyStream.ofAll(stream));
    }

    public static <T> ReactiveStream<T> fromIterator(Iterator<T> it) {
        return ReactiveStream.fromStream(LazyStream.ofAll(() -> it));
    }

    public static <T> ReactiveStream<T> fromAsyncQueue(Queue<T> q) {
        return ReactiveStream.fromJDK(q.stream((Continueable)new Subscription()));
    }

    public static <T> JavaslangReactiveStreamsSubscriber<T> subscriber() {
        return new JavaslangReactiveStreamsSubscriber();
    }

    default public <U> ReactiveStream<U> cast(Class<U> type) {
        return ReactiveStream.fromStream(StreamUtils.cast(this, type));
    }

    default public <U> ReactiveStream<U> ofType(Class<U> type) {
        return ReactiveStream.fromStream(StreamUtils.ofType(this, type));
    }

    default public <R> ReactiveStream<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return this.map((T in) -> ((Trampoline)mapper.apply(in)).result());
    }

    default public void subscribe(Subscriber<? super T> s) {
        JavaslangReactiveStreamsPublisher.ofSync(this).subscribe(s);
    }

    default public void subscribeAsync(Executor ex, Subscriber<? super T> s) {
        JavaslangReactiveStreamsPublisher.ofAsync(this, ex).subscribe(s);
    }

    default public FutureOperations<T> futureOperations(Executor ex) {
        return StreamUtils.futureOperations(this, ex);
    }

    default public JavaslangHotStream<T> pausedHotStream(Executor ex) {
        return StreamUtils.pausedHotStream(this, ex);
    }

    default public JavaslangHotStream<T> hotStream(Executor ex) {
        return StreamUtils.hotStream(this, ex);
    }

    default public <R> LazyFutureStream<R> asyncMap(LazyReact react, Function<? super T, ? extends R> fn) {
        return this.futureStream(react).map(fn);
    }

    default public <R> LazyFutureStream<R> asyncRetry(LazyReact react, Function<? super T, ? extends R> fn) {
        return this.futureStream(react).retry(fn);
    }

    @Override
    default public javaslang.collection.Iterator<T> iterator() {
        ReactiveStream that = this;
        return new javaslang.collection.Iterator<T>((Traversable)that){
            Traversable<T> traversable;
            final /* synthetic */ Traversable val$that;
            {
                this.val$that = traversable;
                this.traversable = this.val$that;
            }

            public boolean hasNext() {
                return !this.traversable.isEmpty();
            }

            public T next() {
                if (this.traversable.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object result = null;
                try {
                    result = this.traversable.head();
                }
                catch (Throwable t) {
                    throw ExceptionSoftener.throwSoftenedException((Throwable)t);
                }
                finally {
                    this.traversable = this.traversable.tail();
                }
                return result;
            }
        };
    }

    default public ReactiveStream<T> recover(Function<Throwable, ? extends T> fn) {
        javaslang.collection.Iterator<T> it = this.iterator();
        Class<Throwable> type = Throwable.class;
        return ReactiveStream.fromIterator(new Iterator<T>((Iterator)it, type, fn){
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ Class val$type;
            final /* synthetic */ Function val$fn;
            {
                this.val$it = iterator;
                this.val$type = clazz;
                this.val$fn = function;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public T next() {
                try {
                    return this.val$it.next();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (this.val$type.isAssignableFrom(t.getClass())) {
                        return this.val$fn.apply(t);
                    }
                    throw ExceptionSoftener.throwSoftenedException((Throwable)t);
                }
            }
        });
    }

    default public <EX extends Throwable> ReactiveStream<T> recover(Class<EX> type, Function<EX, ? extends T> fn) {
        return ReactiveStream.fromStream(StreamUtils.recover(this, type, fn));
    }

    default public <R> ReactiveStream<R> retry(Function<? super T, ? extends R> fn) {
        return ReactiveStream.fromJDK(this.sequenceM().retry(fn));
    }

    default public ReactiveStream<T> debounce(long time, TimeUnit t) {
        return ReactiveStream.fromStream(StreamUtils.debounce(this, time, t));
    }

    default public ReactiveStream<T> onePer(long time, TimeUnit t) {
        return ReactiveStream.fromStream(StreamUtils.onePer(this, time, t));
    }

    default public ReactiveStream<T> jitter(long jitterInNanos) {
        return ReactiveStream.fromStream(StreamUtils.jitter(this, jitterInNanos));
    }

    default public ReactiveStream<T> fixedDelay(long time, TimeUnit unit) {
        return ReactiveStream.fromStream(StreamUtils.fixedDelay(this, time, unit));
    }

    default public ReactiveStream<T> xPer(int x, long time, TimeUnit t) {
        return ReactiveStream.fromStream(StreamUtils.xPer(this, x, time, t));
    }

    default public ReactiveStream<Tuple2<T, Long>> elapsed() {
        AtomicLong last = new AtomicLong(System.currentTimeMillis());
        return this.zip((Iterable)((Object)ReactiveStream.generate(() -> {
            long now = System.currentTimeMillis();
            long result = now - last.get();
            last.set(now);
            return result;
        })));
    }

    default public ReactiveStream<Tuple2<T, Long>> timestamp() {
        return this.zip((Iterable)((Object)ReactiveStream.generate(() -> System.currentTimeMillis())));
    }

    default public ReactiveStream<ReactiveStream<T>> slidingWindow(int windowSize, int increment) {
        return ReactiveStream.fromStream(StreamUtils.sliding(this, windowSize, increment).map(s -> ReactiveStream.fromIterable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> slidingWindow(int windowSize) {
        return ReactiveStream.fromStream(StreamUtils.sliding(this, windowSize, 1).map(s -> ReactiveStream.fromIterable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> windowByTime(long time, TimeUnit t) {
        return ReactiveStream.fromStream(StreamUtils.windowByTime(this, time, t).map(s -> ReactiveStream.fromStreamable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> windowStatefullyWhile(BiPredicate<Streamable<? super T>, ? super T> predicate) {
        return ReactiveStream.fromStream(StreamUtils.windowStatefullyWhile(this, predicate).map(s -> ReactiveStream.fromStreamable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> windowWhile(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(StreamUtils.windowWhile(this, predicate).map(s -> ReactiveStream.fromStreamable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> windowUntil(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(StreamUtils.windowWhile(this, predicate.negate()).map(s -> ReactiveStream.fromStreamable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> windowBySizeAndTime(int size, long time, TimeUnit t) {
        return ReactiveStream.fromStream(StreamUtils.windowBySizeAndTime(this, size, time, t).map(s -> ReactiveStream.fromStreamable(s)));
    }

    default public ReactiveStream<ReactiveStream<T>> windowBySize(int size) {
        return ReactiveStream.fromStream(StreamUtils.batchBySize(this, size).map(s -> ReactiveStream.fromIterable(s)));
    }

    default public ReactiveStream<T> subStream(int start, int end) {
        return this.take(end).removeBetween(0, start);
    }

    @Override
    default public ReactiveStream<T> cycle() {
        return ReactiveStream.fromStream(StreamUtils.cycle(this));
    }

    default public ReactiveStream<T> cycle(int times) {
        return ReactiveStream.fromStream(StreamUtils.cycle(times, this.streamable()));
    }

    default public ReactiveStream<T> cycleWhile(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(StreamUtils.cycleWhile(this, predicate));
    }

    default public ReactiveStream<T> cycleUntil(LazyStream<T> stream, Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(StreamUtils.cycleUntil(this, predicate));
    }

    @Override
    default public <U> LazyStream<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return this.reverse().scanLeft((Object)identity, (T u, U t) -> combiner.apply(t, u));
    }

    default public ReactiveStream<T> scanRight(Monoid<T> monoid) {
        return this.reverse().scanLeft(monoid.zero(), (T u, U t) -> monoid.combiner().apply(t, u));
    }

    @Override
    default public <U> ReactiveStream<U> scanLeft(U identity, BiFunction<? super U, ? super T, ? extends U> combiner) {
        return ReactiveStream.fromStream(LazyStream.super.scanLeft((Object)identity, (BiFunction)combiner));
    }

    default public ReactiveStream<T> scanLeft(Monoid<T> monoid) {
        return ReactiveStream.fromStream(StreamUtils.scanLeft(this, monoid));
    }

    default public boolean xMatch(int num, Predicate<? super T> c) {
        return StreamUtils.xMatch(this, num, c);
    }

    default public ReactiveStream<T> take(long time, TimeUnit unit) {
        return ReactiveStream.fromStream(StreamUtils.limit(this, time, unit));
    }

    default public ReactiveStream<T> drop(long time, TimeUnit unit) {
        return ReactiveStream.fromStream(StreamUtils.skip(this, time, unit));
    }

    default public ReactiveStream<T> onEmptySwitch(Supplier<LazyStream<T>> switchTo) {
        AtomicBoolean called = new AtomicBoolean(false);
        return ReactiveStream.fromStream(this.onEmptyGet(() -> {
            called.set(true);
            return switchTo.get();
        }).flatMap((T s) -> {
            if (called.get()) {
                return (LazyStream)s;
            }
            return LazyStream.of(s);
        }));
    }

    default public ReactiveStream<T> onEmpty(T value) {
        return ReactiveStream.fromJDK(this.sequenceM().onEmpty(value));
    }

    default public ReactiveStream<T> onEmptyGet(Supplier<T> supplier) {
        return ReactiveStream.fromJDK(this.sequenceM().onEmptyGet(supplier));
    }

    default public <X extends Throwable> ReactiveStream<T> onEmptyThrow(Supplier<X> supplier) {
        return ReactiveStream.fromJDK(this.sequenceM().onEmptyThrow(supplier));
    }

    public <R1, R2, R> ReactiveStream<R> forEach3(Function<? super T, ? extends Iterable<R1>> var1, Function<? super T, Function<? super R1, ? extends Iterable<R2>>> var2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> var3);

    public <R1, R2, R> ReactiveStream<R> forEach3(Function<? super T, ? extends Iterable<R1>> var1, Function<? super T, Function<? super R1, ? extends Iterable<R2>>> var2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> var3, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> var4);

    public <R1, R> ReactiveStream<R> forEach2(Function<? super T, ? extends Iterable<R1>> var1, Function<? super T, Function<? super R1, ? extends R>> var2);

    public <R1, R> ReactiveStream<R> forEach2(Function<? super T, ? extends Iterable<R1>> var1, Function<? super T, Function<? super R1, Boolean>> var2, Function<? super T, Function<? super R1, ? extends R>> var3);

    default public List<T> reduce(LazyStream<Monoid<T>> reducers) {
        return StreamUtils.reduce(this, reducers);
    }

    default public <R> R mapReduce(Monoid<R> reducer) {
        return StreamUtils.mapReduce(this, reducer);
    }

    default public <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return StreamUtils.mapReduce(this, mapper, reducer);
    }

    default public T reduce(Monoid<T> reducer) {
        return StreamUtils.foldLeft(this, reducer);
    }

    default public T foldRight(Monoid<T> reducer) {
        return StreamUtils.foldRight(this, reducer);
    }

    default public <S, R> LazyStream<R> zipAnyM(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return ReactiveStream.fromStream(StreamUtils.zipAnyM(this, second, zipper));
    }

    default public T single() {
        javaslang.collection.Iterator<T> it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return (T)result;
            }
        }
        throw new UnsupportedOperationException("single only works for Streams with a single value");
    }

    default public T single(Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate).single();
    }

    default public Option<T> singleOption() {
        javaslang.collection.Iterator<T> it = this.iterator();
        if (it.hasNext()) {
            Object result = it.next();
            if (!it.hasNext()) {
                return Option.of(result);
            }
        }
        return Option.none();
    }

    @Override
    default public ReactiveStream<T> append(T element) {
        return ReactiveStream.fromStream(this.toStream().append((Object)element));
    }

    @Override
    default public ReactiveStream<T> append(T ... elements) {
        return ReactiveStream.fromStream(this.toStream().appendAll(Arrays.asList(elements)));
    }

    @Override
    default public ReactiveStream<T> appendAll(Iterable<? extends T> elements) {
        return ReactiveStream.fromStream(this.toStream().appendAll((Iterable)elements));
    }

    @Override
    default public ReactiveStream<T> clear() {
        return ReactiveStream.fromStream(this.toStream().clear());
    }

    @Override
    default public ReactiveStream<Tuple2<T, T>> crossProduct() {
        return ReactiveStream.fromStream(this.toStream().crossProduct());
    }

    @Override
    default public ReactiveStream<Stream<T>> crossProduct(int power) {
        return ReactiveStream.fromStream(this.toStream().crossProduct(power));
    }

    @Override
    default public <U> ReactiveStream<Tuple2<T, U>> crossProduct(Iterable<? extends U> that) {
        return ReactiveStream.fromStream(this.toStream().crossProduct((Iterable)that));
    }

    @Override
    default public ReactiveStream<Stream<T>> combinations() {
        return ReactiveStream.fromStream(this.toStream().combinations());
    }

    @Override
    default public ReactiveStream<Stream<T>> combinations(int k) {
        return ReactiveStream.fromStream(this.toStream().combinations(k));
    }

    @Override
    default public ReactiveStream<T> distinct() {
        return ReactiveStream.fromStream(this.toStream().distinct());
    }

    @Override
    default public ReactiveStream<T> distinctBy(Comparator<? super T> comparator) {
        return ReactiveStream.fromStream(this.toStream().distinctBy((Comparator)comparator));
    }

    @Override
    default public <U> ReactiveStream<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        return ReactiveStream.fromStream(this.toStream().distinctBy((Function)keyExtractor));
    }

    @Override
    default public ReactiveStream<T> drop(long n) {
        return ReactiveStream.fromStream(this.toStream().drop(n));
    }

    @Override
    default public ReactiveStream<T> dropRight(long n) {
        return ReactiveStream.fromStream(this.toStream().dropRight(n));
    }

    @Override
    default public ReactiveStream<T> dropWhile(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(this.toStream().dropWhile((Predicate)predicate));
    }

    @Override
    default public ReactiveStream<T> filter(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(this.toStream().filter((Predicate)predicate));
    }

    @Override
    default public <U> ReactiveStream<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return ReactiveStream.fromStream(this.toStream().flatMap((Function)mapper));
    }

    default public <U> ReactiveStream<U> flatten() {
        return ReactiveStream.fromJDK(this.sequenceM().flatten());
    }

    default public <C> Map<C, ? extends ReactiveStream<T>> groupByReactive(Function<? super T, ? extends C> classifier) {
        return this.toStream().groupBy(classifier).map((i, s) -> Tuple.of((Object)i, ReactiveStream.fromStream(s)));
    }

    @Override
    default public ReactiveStream<T> init() {
        return ReactiveStream.fromStream(this.toStream().init());
    }

    default public Option<? extends ReactiveStream<T>> initOptionReactive() {
        return this.toStream().initOption().map(s -> ReactiveStream.fromStream(s));
    }

    @Override
    default public ReactiveStream<T> insert(int index, T element) {
        return ReactiveStream.fromStream(this.toStream().insert(index, (Object)element));
    }

    @Override
    default public ReactiveStream<T> insertAll(int index, Iterable<? extends T> elements) {
        return ReactiveStream.fromStream(this.toStream().insertAll(index, (Iterable)elements));
    }

    @Override
    default public ReactiveStream<T> intersperse(T element) {
        return ReactiveStream.fromStream(this.toStream().intersperse((Object)element));
    }

    @Override
    default public <U> ReactiveStream<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return ReactiveStream.fromStream(LazyStream.Empty.instance());
        }
        return ReactiveStream.fromStream(LazyStream.super.map((Function)mapper));
    }

    @Override
    default public ReactiveStream<T> padTo(int length, T element) {
        return ReactiveStream.fromStream(this.toStream().padTo(length, (Object)element));
    }

    @Override
    default public ReactiveStream<T> patch(int from, Iterable<? extends T> that, int replaced) {
        return ReactiveStream.fromStream(this.toStream().patch(from, (Iterable)that, replaced));
    }

    default public Tuple2<? extends ReactiveStream<T>, ? extends ReactiveStream<T>> partitionReactive(Predicate<? super T> predicate) {
        return this.toStream().partition(predicate).map(i -> ReactiveStream.fromStream(i), s -> ReactiveStream.fromStream(s));
    }

    @Override
    default public ReactiveStream<T> peek(Consumer<? super T> action) {
        return ReactiveStream.fromStream(this.toStream().peek((Consumer)action));
    }

    @Override
    default public ReactiveStream<Stream<T>> permutations() {
        return ReactiveStream.fromStream(this.toStream().permutations());
    }

    @Override
    default public ReactiveStream<T> prepend(T element) {
        return ReactiveStream.fromStream(this.toStream().prepend((Object)element));
    }

    @Override
    default public ReactiveStream<T> prepend(T ... elements) {
        return ReactiveStream.fromStream(this.toStream().prependAll(Arrays.asList(elements)));
    }

    @Override
    default public ReactiveStream<T> prependAll(Iterable<? extends T> elements) {
        return ReactiveStream.fromStream(this.toStream().prependAll((Iterable)elements));
    }

    @Override
    default public ReactiveStream<T> remove(T element) {
        return ReactiveStream.fromStream(this.toStream().remove((Object)element));
    }

    @Override
    default public ReactiveStream<T> removeFirst(Predicate<T> predicate) {
        return ReactiveStream.fromStream(this.toStream().removeFirst((Predicate)predicate));
    }

    @Override
    default public ReactiveStream<T> removeLast(Predicate<T> predicate) {
        return ReactiveStream.fromStream(this.toStream().removeLast((Predicate)predicate));
    }

    @Override
    default public ReactiveStream<T> removeAt(int index) {
        return ReactiveStream.fromStream(this.toStream().removeAt(index));
    }

    default public ReactiveStream<T> removeBetween(int start, int end) {
        return ReactiveStream.fromStream(StreamUtils.deleteBetween(this, start, end));
    }

    @Override
    default public ReactiveStream<T> removeAll(T element) {
        return ReactiveStream.fromStream(this.toStream().removeAll((Object)element));
    }

    @Override
    default public ReactiveStream<T> removeAll(Iterable<? extends T> elements) {
        return ReactiveStream.fromStream(this.toStream().removeAll((Iterable)elements));
    }

    @Override
    default public ReactiveStream<T> replace(T currentElement, T newElement) {
        return ReactiveStream.fromStream(this.toStream().replace((Object)currentElement, (Object)newElement));
    }

    @Override
    default public ReactiveStream<T> replaceAll(T currentElement, T newElement) {
        return ReactiveStream.fromStream(this.toStream().replaceAll((Object)currentElement, (Object)newElement));
    }

    @Override
    default public ReactiveStream<T> retainAll(Iterable<? extends T> elements) {
        return ReactiveStream.fromStream(this.toStream().retainAll((Iterable)elements));
    }

    @Override
    default public ReactiveStream<T> reverse() {
        return ReactiveStream.fromStream(this.toStream().reverse());
    }

    @Override
    default public ReactiveStream<T> slice(long beginIndex, long endIndex) {
        return ReactiveStream.fromStream(this.toStream().slice(beginIndex, endIndex));
    }

    @Override
    default public ReactiveStream<T> sort() {
        return ReactiveStream.fromStream(this.toStream().sort());
    }

    @Override
    default public ReactiveStream<T> sort(Comparator<? super T> comparator) {
        return ReactiveStream.fromStream(this.toStream().sort((Comparator)comparator));
    }

    @Override
    default public <U extends Comparable<? super U>> ReactiveStream<T> sortBy(Function<? super T, ? extends U> mapper) {
        return ReactiveStream.fromStream(this.toStream().sortBy((Function)mapper));
    }

    @Override
    default public <U> ReactiveStream<T> sortBy(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        return ReactiveStream.fromStream(this.toStream().sortBy((Comparator)comparator, (Function)mapper));
    }

    default public Tuple2<? extends ReactiveStream<T>, ? extends ReactiveStream<T>> spanReactive(Predicate<? super T> predicate) {
        return this.toStream().span(predicate).map(s1 -> ReactiveStream.fromStream(s1), s2 -> ReactiveStream.fromStream(s2));
    }

    @Override
    default public ReactiveStream<T> subSequence(int beginIndex) {
        return ReactiveStream.fromStream(this.toStream().subSequence(beginIndex));
    }

    @Override
    default public ReactiveStream<T> subSequence(int beginIndex, int endIndex) {
        return ReactiveStream.fromStream(this.toStream().subSequence(beginIndex, endIndex));
    }

    default public Option<? extends ReactiveStream<T>> tailOptionReactive() {
        return this.toStream().tailOption().map(s -> ReactiveStream.fromStream(s));
    }

    @Override
    default public ReactiveStream<T> take(long n) {
        return ReactiveStream.fromStream(this.toStream().take(n));
    }

    @Override
    default public ReactiveStream<T> takeRight(long n) {
        return ReactiveStream.fromStream(this.toStream().takeRight(n));
    }

    @Override
    default public ReactiveStream<T> takeUntil(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(this.toStream().takeUntil((Predicate)predicate));
    }

    @Override
    default public ReactiveStream<T> takeWhile(Predicate<? super T> predicate) {
        return ReactiveStream.fromStream(this.toStream().takeWhile((Predicate)predicate));
    }

    @Override
    default public <U> ReactiveStream<U> unit(Iterable<? extends U> iterable) {
        return ReactiveStream.fromStream(this.toStream().unit((Iterable)iterable));
    }

    default public <T1, T2> Tuple2<? extends ReactiveStream<T1>, ? extends ReactiveStream<T2>> unzipReactive(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        return this.toStream().unzip(unzipper).map(s1 -> ReactiveStream.fromStream(s1), s2 -> ReactiveStream.fromStream(s2));
    }

    @Override
    default public ReactiveStream<T> update(int index, T element) {
        return ReactiveStream.fromStream(this.toStream().update(index, (Object)element));
    }

    @Override
    default public <U> ReactiveStream<Tuple2<T, U>> zip(Iterable<U> that) {
        return ReactiveStream.fromStream(this.toStream().zip((Iterable)that));
    }

    @Override
    default public <U> ReactiveStream<Tuple2<T, U>> zipAll(Iterable<U> that, T thisElem, U thatElem) {
        return ReactiveStream.fromStream(this.toStream().zipAll((Iterable)that, (Object)thisElem, (Object)thatElem));
    }

    @Override
    default public ReactiveStream<Tuple2<T, Long>> zipWithIndex() {
        return ReactiveStream.fromStream(this.toStream().zipWithIndex());
    }

    default public Tuple2<? extends ReactiveStream<T>, ? extends ReactiveStream<T>> splitAtReactive(int n) {
        return this.toStream().splitAt(n).map(s1 -> ReactiveStream.fromStream(s1), s2 -> ReactiveStream.fromStream(s2));
    }

    default public Tuple2<? extends ReactiveStream<T>, ? extends ReactiveStream<T>> splitAtReactive(Predicate<? super T> predicate) {
        return this.toStream().splitAt(predicate).map(s1 -> ReactiveStream.fromStream(s1), s2 -> ReactiveStream.fromStream(s2));
    }

    default public Tuple2<? extends ReactiveStream<T>, ? extends ReactiveStream<T>> splitAtInclusiveReactive(Predicate<? super T> predicate) {
        return this.toStream().splitAtInclusive(predicate).map(s1 -> ReactiveStream.fromStream(s1), s2 -> ReactiveStream.fromStream(s2));
    }

    default public <T1, T2, T3> Tuple3<? extends ReactiveStream<T1>, ? extends ReactiveStream<T2>, ? extends ReactiveStream<T3>> unzip3Reactive(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        return this.toStream().unzip3(unzipper).map(s1 -> ReactiveStream.fromStream(s1), s2 -> ReactiveStream.fromStream(s2), s3 -> ReactiveStream.fromStream(s3));
    }

    @Override
    default public ReactiveStream<T> tail() {
        return ReactiveStream.fromStream(this.toStream().tail());
    }

    default public JavaslangHotStream<T> schedule(String cron, ScheduledExecutorService ex) {
        return StreamUtils.schedule(this, cron, ex);
    }

    default public JavaslangHotStream<T> scheduleFixedDelay(long delay, ScheduledExecutorService ex) {
        return StreamUtils.scheduleFixedDelay(this, delay, ex);
    }

    default public JavaslangHotStream<T> scheduleFixedRate(long rate, ScheduledExecutorService ex) {
        return StreamUtils.scheduleFixedRate(this, rate, ex);
    }
}

