/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.streamable.Streamable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javaslang.collection.Seq;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SequenceMTest {
    int peek = 0;

    @Test
    public void subStream() {
        List list = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).subStream(1, 3).toJavaList();
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(Arrays.asList(2, 3)));
    }

    @Test
    public void emptyPermutations() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).permutations().map(s -> s.toJavaList()).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void permuations3() {
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).permutations().map(s -> s.toList()).toList());
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).permutations().map(s -> s.toList()).toList(), (Matcher)Matchers.equalTo((Object)ReactiveStream.of((Object[])new ReactiveStream[]{ReactiveStream.of((Object[])new Integer[]{1, 2, 3}), ReactiveStream.of((Object[])new Integer[]{1, 3, 2}), ReactiveStream.of((Object[])new Integer[]{2, 1, 3}), ReactiveStream.of((Object[])new Integer[]{2, 3, 1}), ReactiveStream.of((Object[])new Integer[]{3, 1, 2}), ReactiveStream.of((Object[])new Integer[]{3, 2, 1})}).map(s -> s.toList()).toList()));
    }

    @Test
    public void emptyAllCombinations() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).combinations().map(s -> s.toJavaList()).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(Arrays.asList(new Object[0]))));
    }

    @Test
    public void allCombinations3() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).combinations().map(s -> s.toJavaList()).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(Arrays.asList(new Object[0]), Arrays.asList(1), Arrays.asList(2), Arrays.asList(3), Arrays.asList(1, 2), Arrays.asList(1, 3), Arrays.asList(2, 3), Arrays.asList(1, 2, 3))));
    }

    @Test
    public void emptyCombinations() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).combinations(2).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void combinations2() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).combinations(2).map(s -> s.toJavaList()).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(1, 3), Arrays.asList(2, 3))));
    }

    @Test
    public void onEmptySwitchEmpty() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).onEmptySwitch(() -> ReactiveStream.of((Object[])new Object[]{1, 2, 3})).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void onEmptySwitch() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{4, 5, 6}).onEmptySwitch(() -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3})).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 5, 6)));
    }

    @Test
    public void elapsedIsPositive() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).elapsed().seq().noneMatch(t -> (Long)t._2 < 0L));
    }

    @Test
    public void timeStamp() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).timestamp().seq().allMatch(t -> (Long)t._2 <= System.currentTimeMillis()));
    }

    @Test
    public void singleTest() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1}).single(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void singleEmpty() {
        ReactiveStream.of((Object[])new Object[0]).single();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void single2() {
        ReactiveStream.of((Object[])new Integer[]{1, 2}).single();
    }

    @Test
    public void singleOptionalTest() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1}).singleOption().get(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void singleOptionalEmpty() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Object[0]).singleOption().isDefined());
    }

    @Test
    public void singleOptonal2() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2}).singleOption().isDefined());
    }

    @Test
    public void limitTime() {
        List result = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).peek(i -> this.sleep(i * 100)).take(1000L, TimeUnit.MILLISECONDS).toJavaList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    public void limitTimeEmpty() {
        List result = SequenceM.of((Object[])new Integer[0]).peek(i -> this.sleep(i * 100)).limit(1000L, TimeUnit.MILLISECONDS).toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void skipTime() {
        List result = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).peek(i -> this.sleep(i * 100)).drop(1000L, TimeUnit.MILLISECONDS).toJavaList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(4, 5, 6)));
    }

    @Test
    public void skipTimeEmpty() {
        List result = ReactiveStream.of((Object[])new Integer[0]).peek(i -> this.sleep(i * 100)).drop(1000L, TimeUnit.MILLISECONDS).toJavaList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    private int sleep(Integer i) {
        try {
            Thread.currentThread();
            Thread.sleep(i.intValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return i;
    }

    @Test
    public void testSkipLast() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).dropRight(2L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testSkipLastEmpty() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).dropRight(2L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testLimitLast() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).takeRight(2L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(4, 5)));
    }

    @Test
    public void testLimitLastEmpty() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Object[0]).takeRight(2L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void endsWith() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{5, 6})));
    }

    @Test
    public void endsWithFalse() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)javaslang.collection.List.of((Object[])new Integer[]{5, 6, 7})));
    }

    @Test
    public void endsWithToLong() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6})));
    }

    @Test
    public void endsWithEmpty() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.empty()));
    }

    @Test
    public void endsWithWhenEmpty() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Object[0]).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6})));
    }

    @Test
    public void endsWithBothEmpty() {
        Assert.assertTrue((boolean)SequenceM.of((Object[])new Integer[0]).endsWith((Iterable)ReactiveStream.empty()));
    }

    @Test
    public void endsWithStream() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{5, 6})));
    }

    @Test
    public void endsWithFalseStream() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{5, 6, 7})));
    }

    @Test
    public void endsWithToLongStream() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6})));
    }

    @Test
    public void endsWithEmptyStream() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).endsWith((Seq)ReactiveStream.of((Object[])new Integer[0])));
    }

    @Test
    public void endsWithWhenEmptyStream() {
        Assert.assertFalse((boolean)ReactiveStream.of((Object[])new Object[0]).endsWith((Seq)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6})));
    }

    @Test
    public void endsWithBothEmptyStream() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[0]).endsWith((Seq)ReactiveStream.of((Object[])new Integer[0])));
    }

    @Test
    public void anyMTest() {
        List list = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).anyM().filter(i -> i > 3).asSequence().toList();
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(Arrays.asList(4, 5, 6)));
    }

    @Test
    public void streamable() {
        Streamable repeat = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).map(i -> i * 2).streamable();
        Assert.assertThat((Object)repeat.sequenceM().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 4, 6, 8, 10, 12)));
        Assert.assertThat((Object)repeat.sequenceM().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 4, 6, 8, 10, 12)));
    }

    @Test
    public void testPeek() {
        this.peek = 0;
        AnyM.fromStream(Stream.of(Arrays.asList(1, 3))).flatMap(c -> AnyM.fromStream(c.stream())).asSequence().map(i -> i * 2).peek(i -> {
            this.peek = i;
        }).collect(Collectors.toList());
        Assert.assertThat((Object)this.peek, (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testMap() {
        List list = (List)AnyM.fromStream(Stream.of(Arrays.asList(1, 3))).flatMap(c -> AnyM.fromStream(c.stream())).asSequence().map(i -> i * 2).peek(System.out::println).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(2, 6), (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void testOfType() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Integer.class).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Integer.class).toList(), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{"a", "b", null})));
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Serializable.class).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3)}));
    }

    @Test(expected=ClassCastException.class)
    public void testCastPast() {
        ReactiveStream.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).cast(Date.class).map(d -> d.getTime()).forEach(System.out::println);
    }

    @Test
    public void testIntersperse() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).intersperse((Object)0).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 0, 2, 0, 3)));
    }

    @Test(expected=ClassCastException.class)
    public void cast() {
        ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).cast(String.class).collect(Collectors.toList());
    }

    @Test
    public void xMatch() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 5, 6, 7}).xMatch(3, i -> i > 4));
    }
}

