/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.sequence.SequenceM;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class RetryTest {
    @Mock
    Function<Integer, String> serviceMock;
    Throwable error;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.error = null;
    }

    @Test
    public void recover() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(u -> {
            throw new RuntimeException();
        }).recover(e -> "hello").get(), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    public void recover2() {
        ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(i -> i + 2).map(u -> {
            if (u == 3) {
                return "i";
            }
            throw new RuntimeException();
        }).recover(e -> "hello").forEach(System.out::println);
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(i -> i + 2).map(u -> {
            if (u == 3) {
                return "i";
            }
            throw new RuntimeException();
        }).recover(e -> "hello").toList().get(1), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    @Ignore
    public void recover3() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(i -> i + 2).map(u -> {
            if (u == 3) {
                return "i";
            }
            throw new RuntimeException();
        }).map(i -> "x!" + i).recover(e -> "hello").get(), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    @Ignore
    public void recoverIO() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(u -> {
            ExceptionSoftener.throwSoftenedException((Throwable)new IOException());
            return null;
        }).recover(e -> "hello").get(), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    public void recover2IO() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(i -> i + 2).map(u -> {
            ExceptionSoftener.throwSoftenedException((Throwable)new IOException());
            return null;
        }).recover(IOException.class, e -> "hello").get(), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test(expected=IOException.class)
    public void recoverIOUnhandledThrown() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).map(i -> i + 2).map(u -> {
            ExceptionSoftener.throwSoftenedException((Throwable)new IOException());
            return null;
        }).map(i -> "x!" + i).recover(IllegalStateException.class, e -> "hello").get(), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    public void shouldSucceedAfterFewAsynchronousRetries() throws Exception {
        BDDMockito.given((Object)this.serviceMock.apply(org.mockito.Matchers.anyInt())).willThrow(new Throwable[]{new RuntimeException(new SocketException("First")), new RuntimeException(new IOException("Second"))}).willReturn((Object)"42");
        String result = (String)SequenceM.of((Object[])new Integer[]{1, 2, 3}).retry(this.serviceMock).firstValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)"42"));
    }

    private CompletableFuture<String> failedAsync(Throwable throwable) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.completeExceptionally(throwable);
        return future;
    }
}

