/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javaslang.collection.Map;
import javaslang.collection.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BaseSequentialTest {
    ReactiveStream<Integer> empty;
    ReactiveStream<Integer> nonEmpty;

    <U> ReactiveStream<U> of(U ... array) {
        return ReactiveStream.of((Object[])array);
    }

    @Before
    public void setup() {
        this.empty = this.of(new Integer[0]);
        this.nonEmpty = this.of(1);
    }

    Integer value2() {
        return 5;
    }

    @Test
    public void batchBySize() {
        System.out.println(this.of(1, 2, 3, 4, 5, 6).windowBySize(3).collect(Collectors.toList()));
        Assert.assertThat((Object)((List)this.of(1, 2, 3, 4, 5, 6).windowBySize(3).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void prepend() {
        List result = (List)this.of(1, 2, 3).prepend((Object[])new Integer[]{100, 200, 300}).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("100!!", "200!!", "300!!", "1!!", "2!!", "3!!")));
    }

    @Test
    public void append() {
        List result = (List)this.of(1, 2, 3).append((Object[])new Integer[]{100, 200, 300}).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "2!!", "3!!", "100!!", "200!!", "300!!")));
    }

    @Test
    public void concatStreams() {
        List result = (List)this.of(1, 2, 3).appendAll(this.of(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "2!!", "3!!", "100!!", "200!!", "300!!")));
    }

    @Test
    public void prependStreams() {
        List result = (List)this.of(1, 2, 3).prependAll(this.of(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("100!!", "200!!", "300!!", "1!!", "2!!", "3!!")));
    }

    @Test
    public void insertAt() {
        List result = (List)this.of(1, 2, 3).insertAll(1, Arrays.asList(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "100!!", "200!!", "300!!", "2!!", "3!!")));
    }

    @Test
    public void insertAtStream() {
        List result = (List)this.of(1, 2, 3).insertAll(1, this.of(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "100!!", "200!!", "300!!", "2!!", "3!!")));
    }

    @Test
    public void deleteBetween() {
        List result = (List)this.of(1, 2, 3, 4, 5, 6).removeBetween(2, 4).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "2!!", "5!!", "6!!")));
    }

    @Test
    public void limitWhileTest() {
        List list = (List)this.of(1, 2, 3, 4, 5, 6).takeWhile(it -> it < 4).peek(it -> System.out.println(it)).collect(Collectors.toList());
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)2));
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)3));
    }

    @Test
    public void testReverse() {
        Assert.assertThat((Object)this.of(1, 2, 3).reverse().toJavaList(), (Matcher)Matchers.is(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testCycle() {
        Assert.assertEquals(Arrays.asList(1, 2, 1, 2, 1, 2), (Object)this.of(1, 2).cycle().take(6L).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 1, 2, 3), (Object)this.of(1, 2, 3).cycle().take(6L).toJavaList());
    }

    @Test
    public void testIterable() {
        List list = (List)this.of(1, 2, 3).toCollection(LinkedList::new);
        for (Integer i : this.of(1, 2, 3)) {
            Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)i));
        }
    }

    @Test
    public void testGroupByEager() {
        Map map1 = this.of(1, 2, 3, 4).groupBy(i -> i % 2);
        Assert.assertEquals((Object)ReactiveStream.of((Object[])new Integer[]{2, 4}), (Object)map1.get((Object)0).get());
        Assert.assertEquals((Object)ReactiveStream.of((Object[])new Integer[]{1, 3}), (Object)map1.get((Object)1).get());
        Assert.assertEquals((long)2L, (long)map1.size());
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"123", (Object)this.of(1, 2, 3).mkString());
        Assert.assertEquals((Object)"1, 2, 3", (Object)this.of(1, 2, 3).mkString((CharSequence)", "));
        Assert.assertEquals((Object)"|1^2^3$", (Object)this.of(1, 2, 3).mkString((CharSequence)"|", (CharSequence)"^", (CharSequence)"$"));
    }

    @Test
    public void testSkipWhile() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)s.get().dropWhile(i -> false).toJavaList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().dropWhile(i -> i % 3 != 0).toJavaList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().dropWhile(i -> i < 3).toJavaList());
        Assert.assertEquals(Arrays.asList(4, 5), (Object)s.get().dropWhile(i -> i < 4).toJavaList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().dropWhile(i -> true).toJavaList());
    }

    @Test
    public void testSkipUntil() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().dropUntil(i -> false).toJavaList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().dropUntil(i -> i % 3 == 0).toJavaList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().dropUntil(i -> i == 3).toJavaList());
        Assert.assertEquals(Arrays.asList(4, 5), (Object)s.get().dropUntil(i -> i == 4).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)s.get().dropUntil(i -> true).toJavaList());
    }

    @Test
    @Ignore
    public void testSkipUntilWithNulls() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, null, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(1, 2, null, 3, 4, 5), (Object)s.get().dropUntil(i -> true).toJavaList());
    }

    @Test
    public void testLimitWhile() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().takeWhile(i -> false).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)s.get().takeWhile(i -> i % 3 != 0).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)s.get().takeWhile(i -> i < 3).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)s.get().takeWhile(i -> i < 4).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)s.get().takeWhile(i -> true).toJavaList());
    }

    @Test
    public void testLimitUntil() {
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)this.of(1, 2, 3, 4, 5).takeUntil(i -> false).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)this.of(1, 2, 3, 4, 5).takeUntil(i -> i % 3 == 0).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)this.of(1, 2, 3, 4, 5).takeUntil(i -> i == 3).toJavaList());
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)this.of(1, 2, 3, 4, 5).takeUntil(i -> i == 4).toJavaList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.of(1, 2, 3, 4, 5).takeUntil(i -> true).toJavaList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.of(1, 2, 3, 4, 5).takeUntil(i -> true).toJavaList());
    }

    @Test
    @Ignore
    public void testLimitUntilWithNulls() {
        Assert.assertThat((Object)this.of(1, 2, null, 3, 4, 5).takeUntil(i -> false).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, null, 3, 4, 5)));
    }

    @Test
    public void testSplitAt() {
        Supplier<ReactiveStream> s;
        int i;
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(4, 5, 6), (Object)((Stream)s.get().splitAt(3L)._2()).toJavaList());
        }
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)((Stream)s.get().splitAt((long)3L)._1).toJavaList());
        }
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)((Stream)s.get().splitAt((long)6L)._1).toJavaList());
        }
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)((Stream)s.get().splitAt((long)7L)._1).toJavaList());
        }
    }

    @Test
    public void testMinByMaxBy() {
        Supplier<ReactiveStream> s = () -> this.of(1, 2, 3, 4, 5, 6);
        Assert.assertEquals((long)1L, (long)((Integer)s.get().maxBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)s.get().minBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)s.get().maxBy(t -> "" + t).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)s.get().minBy(t -> "" + t).get()).intValue());
    }

    @Test
    public void testFoldLeft() {
        Supplier<ReactiveStream> s = () -> this.of("a", "b", "c");
        Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("a"));
        Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("b"));
        Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("c"));
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldLeft((Object)0, (u, t) -> u + t)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
        Assert.assertEquals((Object)"-a-b-c", (Object)((StringBuilder)s.get().map(str -> new StringBuilder((String)str)).foldLeft((Object)new StringBuilder(), (u, t) -> u.append("-").append((CharSequence)t))).toString());
    }

    @Test
    public void testFoldRight() {
        Supplier<ReactiveStream> s = () -> this.of("a", "b", "c");
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", (a, b) -> b + a)).equals("cba"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", (a, b) -> b + a)).contains("b"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", (a, b) -> b + a)).contains("c"));
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
    }

    @Test
    public void flattenEmpty() throws Exception {
        Assert.assertTrue((boolean)this.of(new Integer[0]).flatMap(i -> ReactiveStream.of((Object[])new Integer[]{i, -i.intValue()})).toList().isEmpty());
    }

    @Test
    public void flatten() throws Exception {
        Assert.assertThat((Object)this.of(1, 2).flatMap(i -> ReactiveStream.of((Object[])new Integer[]{i, -i.intValue()})).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, -1, 2, -2)));
    }

    @Test
    public void flattenEmptyStream() throws Exception {
        Assert.assertThat((Object)this.of(1, 2, 3, 4, 5, 5, 6, 8, 9, 10).flatMap(this::flatMapFun).take(10L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(2, 3, 4, 5, 6, 7, 0, 0, 0, 0)));
    }

    private ReactiveStream<Integer> flatMapFun(int i) {
        if (i <= 0) {
            return ReactiveStream.empty();
        }
        switch (i) {
            case 1: {
                return ReactiveStream.fromIterable(Arrays.asList(2));
            }
            case 2: {
                return ReactiveStream.fromIterable(Arrays.asList(3, 4));
            }
            case 3: {
                return ReactiveStream.fromIterable(Arrays.asList(5, 6, 7));
            }
        }
        return ReactiveStream.fromIterable(Arrays.asList(0, 0));
    }
}

