/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream.tests;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.sequence.Monoid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javaslang.collection.Map;
import javaslang.collection.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BaseSequenceMTest {
    ReactiveStream<Integer> empty;
    ReactiveStream<Integer> nonEmpty;

    @Before
    public void setup() {
        this.empty = ReactiveStream.of((Object[])new Integer[0]);
        this.nonEmpty = ReactiveStream.of((Object[])new Integer[]{1});
    }

    protected Object value() {
        return "jello";
    }

    private int value2() {
        return 200;
    }

    @Test
    public void batchBySize() {
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowBySize(3).collect(Collectors.toList()));
        Assert.assertThat((Object)((List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).windowBySize(3).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void takeWhileTest() {
        List list = new ArrayList();
        while (list.size() == 0) {
            list = (List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6}).takeWhile(it -> it < 4).peek(it -> System.out.println(it)).collect(Collectors.toList());
        }
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(list.get(0)));
    }

    @Test
    public void testScanLeftStringConcat() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new String[]{"a", "b", "c"}).scanLeft((Object)"", String::concat).toList().length(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testScanLeftSum() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new String[]{"a", "ab", "abc"}).map(str -> str.length()).scanLeft((Object)0, (u, t) -> u + t).toList().length(), (Matcher)Matchers.is((Object)Arrays.asList(0, 1, 3, 6).size()));
    }

    @Test
    public void testScanRightStringConcatMonoid() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new String[]{"a", "b", "c"}).scanRight(Monoid.of((Object)"", String::concat)).toList().length(), (Matcher)Matchers.is((Object)Arrays.asList("", "c", "bc", "abc").size()));
    }

    @Test
    public void testScanRightStringConcat() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new String[]{"a", "b", "c"}).scanRight((Object)"", String::concat).toList().length(), (Matcher)Matchers.is((Object)Arrays.asList("", "c", "bc", "abc").size()));
    }

    @Test
    public void testScanRightSum() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new String[]{"a", "ab", "abc"}).map(str -> str.length()).scanRight((Object)0, (t, u) -> u + t).toList().length(), (Matcher)Matchers.is((Object)Arrays.asList(0, 3, 5, 6).size()));
    }

    @Test
    public void testReverse() {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).reverse().toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testReverseList() {
        Assert.assertThat((Object)ReactiveStream.fromIterable(Arrays.asList(10, 400, 2, -1)).reverse().toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(-1, 2, 400, 10)));
    }

    @Test
    public void testReverseListtake() {
        Assert.assertThat((Object)ReactiveStream.fromIterable(Arrays.asList(10, 400, 2, -1)).reverse().take(2L).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(-1, 2)));
    }

    @Test
    public void testReverseRange() {
        Assert.assertThat((Object)ReactiveStream.range((int)0, (int)10).reverse().toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(9, 8, 7, 6, 5, 4, 3, 2, 1, 0)));
    }

    @Test
    public void testCycle() {
        Assert.assertEquals(Arrays.asList(1, 1, 1, 1, 1, 1), (Object)ReactiveStream.of((Object[])new Integer[]{1}).cycle().take(6L).toJavaList());
    }

    @Test
    public void testIterable() {
        List list = (List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).toCollection(LinkedList::new);
        for (Integer i : ReactiveStream.of((Object[])new Integer[]{1, 2, 3})) {
            Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)i));
        }
    }

    @Test(expected=ClassCastException.class)
    public void testCastException() {
        ReactiveStream.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).peek(it -> System.out.println(it)).cast(Integer.class).peek(it -> System.out.println(it)).toList();
    }

    @Test
    public void testGroupByEager() {
        Map map1 = ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}).groupBy(i -> i % 2);
        Assert.assertThat((Object)((Stream)map1.get((Object)0).get()).toJavaList(), (Matcher)Matchers.hasItem((Object)2));
        Assert.assertThat((Object)((Stream)map1.get((Object)0).get()).toJavaList(), (Matcher)Matchers.hasItem((Object)4));
        Assert.assertThat((Object)((Stream)map1.get((Object)1).get()).toJavaList(), (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat((Object)((Stream)map1.get((Object)1).get()).toJavaList(), (Matcher)Matchers.hasItem((Object)3));
        Assert.assertEquals((long)2L, (long)map1.size());
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((long)"123".length(), (long)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).mkString().length());
        Assert.assertEquals((long)"1, 2, 3".length(), (long)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).mkString((CharSequence)", ").length());
        Assert.assertEquals((long)"^1|2|3$".length(), (long)ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).mkString((CharSequence)"|", (CharSequence)"^", (CharSequence)"$").length());
    }

    @Test
    public void testSkipWhile() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertTrue((boolean)s.get().dropWhile(i -> false).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().dropWhile(i -> true).toJavaList());
    }

    @Test
    public void testSkipUntil() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().dropUntil(i -> false).toJavaList());
        Assert.assertTrue((boolean)s.get().dropUntil(i -> true).toJavaList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    @Ignore
    public void testSkipUntilWithNulls() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, null, 3, 4, 5});
        Assert.assertTrue((boolean)s.get().dropUntil(i -> true).toJavaList().containsAll(Arrays.asList(1, 2, null, 3, 4, 5)));
    }

    @Test
    public void testtakeWhile() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().takeWhile(i -> false).toJavaList());
        Assert.assertTrue((s.get().takeWhile(i -> i < 3).toList().length() != 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.get().takeWhile(i -> true).toJavaList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void testtakeUntil() {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).takeUntil(i -> false).toList().containsAll(Arrays.asList(1, 2, 3, 4, 5)));
        Assert.assertFalse((ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).takeUntil(i -> i % 3 == 0).toList().length() == 5 ? 1 : 0) != 0);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5}).takeUntil(i -> true).toJavaList());
    }

    @Test
    @Ignore
    public void testtakeUntilWithNulls() {
        System.out.println(ReactiveStream.of((Object[])new Integer[]{1, 2, null, 3, 4, 5}).takeUntil(i -> false).toList());
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[]{1, 2, null, 3, 4, 5}).takeUntil(i -> false).toList().containsAll(Arrays.asList(1, 2, null, 3, 4, 5)));
    }

    @Test
    public void testMinByMaxBy() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
        Assert.assertEquals((long)1L, (long)((Integer)s.get().maxBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)s.get().minBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)s.get().maxBy(t -> "" + t).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)s.get().minBy(t -> "" + t).get()).intValue());
    }

    @Test
    public void testFoldLeft() {
        for (int i = 0; i < 100; ++i) {
            Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new String[]{"a", "b", "c"});
            Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("a"));
            Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("b"));
            Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("c"));
            Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldLeft((Object)0, (u, t) -> u + t)).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
        }
    }

    @Test
    public void testFoldRight() {
        Supplier<ReactiveStream> s = () -> ReactiveStream.of((Object[])new String[]{"a", "b", "c"});
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("a"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("b"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("c"));
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
    }

    @Test
    public void flattenEmpty() throws Exception {
        Assert.assertTrue((boolean)ReactiveStream.of((Object[])new Integer[0]).flatten().toList().isEmpty());
    }

    @Test
    public void flatten() throws Exception {
        Assert.assertThat((Object)ReactiveStream.of((Object[])new List[]{Arrays.asList(1, 2)}).flatten().toList().length(), (Matcher)Matchers.equalTo((Object)Arrays.asList(1, 2).size()));
    }

    @Test
    public void flattenEmptyStream() throws Exception {
        Assert.assertThat((Object)((List)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4, 5, 5, 6, 8, 9, 10}).flatten().take(10L).collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)Arrays.asList(2, 3, 4, 5, 6, 7, 0, 0, 0, 0).size()));
    }
}

