/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream;

import com.aol.cyclops.javaslang.reactivestreams.ReactiveStream;
import com.aol.cyclops.javaslang.reactivestreams.reactivestream.AbstractSeqTest;
import java.util.ArrayList;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javaslang.collection.LazyStream;
import javaslang.collection.List;
import javaslang.control.Try;
import org.junit.Test;

public class JavaslangStreamTest
extends AbstractSeqTest {
    protected <T> Collector<T, ArrayList<T>, LazyStream<T>> collector() {
        return LazyStream.collector();
    }

    protected <T> LazyStream<T> empty() {
        return ReactiveStream.empty();
    }

    protected <T> LazyStream<T> of(T element) {
        return ReactiveStream.of((Object[])new Object[]{element});
    }

    @SafeVarargs
    protected final <T> LazyStream<T> of(T ... elements) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.of((Object[])elements));
    }

    protected <T> LazyStream<T> ofAll(Iterable<? extends T> elements) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll(elements));
    }

    protected LazyStream<Boolean> ofAll(boolean[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((boolean[])array));
    }

    protected LazyStream<Byte> ofAll(byte[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((byte[])array));
    }

    protected LazyStream<Character> ofAll(char[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((char[])array));
    }

    protected LazyStream<Double> ofAll(double[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((double[])array));
    }

    protected LazyStream<Float> ofAll(float[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((float[])array));
    }

    protected LazyStream<Integer> ofAll(int[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((int[])array));
    }

    protected LazyStream<Long> ofAll(long[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((long[])array));
    }

    protected LazyStream<Short> ofAll(short[] array) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.ofAll((short[])array));
    }

    protected LazyStream<Character> range(char from, char toExclusive) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.range((char)from, (char)toExclusive));
    }

    protected LazyStream<Character> rangeBy(char from, char toExclusive, int step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeBy((char)from, (char)toExclusive, (int)step));
    }

    protected LazyStream<Double> rangeBy(double from, double toExclusive, double step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeBy((double)from, (double)toExclusive, (double)step));
    }

    protected LazyStream<Integer> range(int from, int toExclusive) {
        return ReactiveStream.range((int)from, (int)toExclusive);
    }

    protected LazyStream<Integer> rangeBy(int from, int toExclusive, int step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeBy((int)from, (int)toExclusive, (int)step));
    }

    protected LazyStream<Long> range(long from, long toExclusive) {
        return ReactiveStream.range((long)from, (long)toExclusive);
    }

    protected LazyStream<Long> rangeBy(long from, long toExclusive, long step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeBy((long)from, (long)toExclusive, (long)step));
    }

    protected LazyStream<Character> rangeClosed(char from, char toInclusive) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosed((char)from, (char)toInclusive));
    }

    protected LazyStream<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosedBy((char)from, (char)toInclusive, (int)step));
    }

    protected LazyStream<Double> rangeClosedBy(double from, double toInclusive, double step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosedBy((double)from, (double)toInclusive, (double)step));
    }

    protected LazyStream<Integer> rangeClosed(int from, int toInclusive) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosed((int)from, (int)toInclusive));
    }

    protected LazyStream<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosedBy((int)from, (int)toInclusive, (int)step));
    }

    protected LazyStream<Long> rangeClosed(long from, long toInclusive) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosed((long)from, (long)toInclusive));
    }

    protected LazyStream<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return ReactiveStream.fromStream((javaslang.collection.Stream)LazyStream.rangeClosedBy((long)from, (long)toInclusive, (long)step));
    }

    @Test
    public void shouldGenerateIntStream() {
        this.assertThat(ReactiveStream.from((int)-1).take(3L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{-1, 0, 1}));
    }

    @Test
    public void shouldGenerateTerminatingIntStream() {
        this.assertThat(ReactiveStream.from((int)Integer.MAX_VALUE).take(2L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{Integer.MAX_VALUE, Integer.MIN_VALUE}));
    }

    @Test
    public void shouldGenerateLongStream() {
        this.assertThat(ReactiveStream.from((long)-1L).take(3L)).isEqualTo((Object)ReactiveStream.of((Object[])new Long[]{-1L, 0L, 1L}));
    }

    @Test
    public void shouldGenerateTerminatingLongStream() {
        this.assertThat(ReactiveStream.from((long)Long.MAX_VALUE).take(2L)).isEqualTo((Object)ReactiveStream.of((Object[])new Long[]{Long.MAX_VALUE, Long.MIN_VALUE}));
    }

    @Test
    public void shouldGenerateInfiniteStreamBasedOnSupplier() {
        this.assertThat((Integer)ReactiveStream.generate(() -> 1).take(13L).reduce((i, j) -> i + j)).isEqualTo(13);
    }

    @Test
    public void shouldGenerateInfiniteStreamBasedOnSupplierWithAccessToPreviousValue() {
        this.assertThat((Integer)ReactiveStream.iterate((Object)2, i -> i + 2).take(3L).reduce((i, j) -> i + j)).isEqualTo(12);
    }

    @Test
    public void shouldBuildStreamBasedOnHeadAndTailSupplierWithAccessToHead() {
        this.assertThat(ReactiveStream.cons(() -> 1, () -> ReactiveStream.cons(() -> 2, LazyStream::empty))).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldComputeCombinationsOfEmptyStream() {
        this.assertThat((Iterable)ReactiveStream.of((Object[])new ReactiveStream[]{ReactiveStream.empty()}).single()).isEqualTo(ReactiveStream.empty().combinations().single());
    }

    @Test
    public void shouldComputeCombinationsOfNonEmptyStream() {
        this.assertThat(ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).combinations().map(r -> r.toList())).isEqualTo((Object)ReactiveStream.of((Object[])new List[]{List.empty(), List.of((Object)1), List.of((Object)2), List.of((Object)3), List.of((Object[])new Integer[]{1, 2}), List.of((Object[])new Integer[]{1, 3}), List.of((Object[])new Integer[]{2, 3}), List.of((Object[])new Integer[]{1, 2, 3})}));
    }

    @Test
    public void shouldComputeKCombinationsOfEmptyStream() {
        this.assertThat(ReactiveStream.empty().combinations(1)).isEqualTo((Object)ReactiveStream.empty());
    }

    @Test
    public void shouldComputeKCombinationsOfNonEmptyStream() {
        this.assertThat(ReactiveStream.of((Object[])new Integer[]{1, 2, 3}).combinations(2)).isEqualTo((Object)ReactiveStream.of((Object[])new ReactiveStream[]{ReactiveStream.of((Object[])new Integer[]{1, 2}), ReactiveStream.of((Object[])new Integer[]{1, 3}), ReactiveStream.of((Object[])new Integer[]{2, 3})}));
    }

    @Test
    public void shouldFlatMapInfiniteTraversable() {
        this.assertThat(ReactiveStream.iterate((Object)1, i -> i + 1).flatMap(i -> List.of((Object[])new Integer[]{i, 2 * i})).take(7L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 2, 4, 3, 6, 4}));
    }

    @Override
    protected int getPeekNonNilPerformingAnAction() {
        return 3;
    }

    @Test
    public void shouldComputePermutationsOfEmptyStream() {
        this.assertThat(ReactiveStream.empty().permutations()).isEqualTo((Object)ReactiveStream.empty());
    }

    @Test
    public void shouldComputePermutationsOfNonEmptyStream() {
        System.out.println(javaslang.collection.Stream.of((Object[])new Integer[]{1, 2, 3}).permutations());
        this.assertThat(javaslang.collection.Stream.of((Object[])new Integer[]{1, 2, 3}).permutations().map(r -> r.toList())).isEqualTo((Object)ReactiveStream.of((Object[])new List[]{List.of((Object[])new Integer[]{1, 2, 3}), List.of((Object[])new Integer[]{1, 3, 2}), List.of((Object[])new Integer[]{2, 1, 3}), List.of((Object[])new Integer[]{2, 3, 1}), List.of((Object[])new Integer[]{3, 1, 2}), List.of((Object[])new Integer[]{3, 2, 1})}));
    }

    @Test
    public void shouldRecurrentlyCalculateFibonacci() {
        this.assertThat(ReactiveStream.of((Object[])new Integer[]{1, 1}).appendSelf(self -> self.zip((Iterable)self.tail()).map(t -> (Integer)t._1 + (Integer)t._2)).take(10L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{1, 1, 2, 3, 5, 8, 13, 21, 34, 55}));
    }

    @Test
    public void shouldRecurrentlyCalculatePrimes() {
        this.assertThat(LazyStream.of((Object)2).appendSelf(self -> LazyStream.gen((Object)3, i -> i + 2).filter(i -> self.takeWhile(j -> j * j <= i).forAll(k -> i % k > 0))).take(10L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29}));
    }

    @Test
    public void shouldDoNothingOnNil() {
        this.assertThat(ReactiveStream.empty().appendSelf(self -> self)).isEqualTo((Object)ReactiveStream.empty());
    }

    @Test
    public void shouldRecurrentlyCalculateArithmeticProgression() {
        this.assertThat(ReactiveStream.of((Object[])new Integer[]{1}).appendSelf(self -> self.map(t -> t + 1)).take(4L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 3, 4}));
    }

    @Test
    public void shouldRecurrentlyCalculateGeometricProgression() {
        this.assertThat(ReactiveStream.of((Object[])new Integer[]{1}).appendSelf(self -> self.map(t -> t * 2)).take(4L)).isEqualTo((Object)ReactiveStream.of((Object[])new Integer[]{1, 2, 4, 8}));
    }

    @Test
    public void shouldRecognizeInfiniteDoesContainSlice() {
        boolean actual = ReactiveStream.iterate((Object)1, i -> i + 1).containsSlice(this.of((T[])new Integer[]{12, 13, 14}));
        this.assertThat(actual).isTrue();
    }

    @Test
    public void shouldStringifyNil() {
        this.assertThat(this.empty().toString()).isEqualTo((Object)"Stream()");
    }

    @Test
    public void shouldStringifyNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).toString()).isEqualTo((Object)"Stream(1, ?)");
    }

    @Test
    public void shouldStringifyNonNilEvaluatingFirstTail() {
        ReactiveStream stream = ReactiveStream.of((Object[])new Integer[]{1, 2, 3});
        stream.tail();
        this.assertThat(stream.toString()).isEqualTo((Object)"Stream(1, 2, ?)");
    }

    @Override
    protected boolean useIsEqualToInsteadOfIsSameAs() {
        return true;
    }

    @Test
    public void shouldEvaluateTailAtMostOnce() {
        int[] counter = new int[]{0};
        ReactiveStream stream = ReactiveStream.generate(() -> {
            int n = counter[0];
            nArray[0] = n + 1;
            return n;
        });
        LazyStream tail = stream.tail().append((Object)100);
        String expected = stream.drop(1L).take(3L).mkString((CharSequence)",");
        String actual = tail.take(3L).mkString((CharSequence)",");
        this.assertThat(expected).isEqualTo((Object)"1,2,3");
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotEvaluateHeadOfTailWhenCallingIteratorHasNext() {
        Integer[] vals = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        StringBuilder actual = new StringBuilder();
        this.flatTryWithJavaslangStream(vals, (Try.CheckedConsumer<Integer>)((Try.CheckedConsumer)i -> this.doStuff((int)i, actual)));
        StringBuilder expected = new StringBuilder();
        this.flatTryWithJavaStream(vals, (Try.CheckedConsumer<Integer>)((Try.CheckedConsumer)i -> this.doStuff((int)i, expected)));
        this.assertThat(actual.toString()).isEqualTo((Object)expected.toString());
    }

    private Try<Void> flatTryWithJavaslangStream(Integer[] vals, Try.CheckedConsumer<Integer> func) {
        return (Try)LazyStream.of((Object[])vals).map(v -> Try.run(() -> func.accept(v))).find(Try::isFailure).getOrElse(() -> Try.success(null));
    }

    private Try<Void> flatTryWithJavaStream(Integer[] vals, Try.CheckedConsumer<Integer> func) {
        return Stream.of(vals).map(v -> Try.run(() -> func.accept(v))).filter(Try::isFailure).findFirst().orElseGet(() -> Try.success(null));
    }

    private String doStuff(int i, StringBuilder builder) throws Exception {
        builder.append(i);
        if (i == 5) {
            throw new Exception("Some error !!!");
        }
        return i + " Value";
    }
}

