/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream;

import com.aol.cyclops.javaslang.reactivestreams.reactivestream.JavaCollections;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import javaslang.Tuple;
import javaslang.Value;
import javaslang.collection.Array;
import javaslang.collection.HashMap;
import javaslang.collection.HashSet;
import javaslang.collection.Iterator;
import javaslang.collection.LazyStream;
import javaslang.collection.Map;
import javaslang.collection.Queue;
import javaslang.collection.Set;
import javaslang.collection.Stack;
import javaslang.collection.Vector;
import javaslang.control.Either;
import javaslang.control.Match;
import javaslang.control.Option;
import javaslang.control.Try;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.StringAssert;
import org.junit.Test;

public abstract class AbstractValueTest {
    protected <T> IterableAssert<T> assertThat(Iterable<T> actual) {
        return new IterableAssert<T>(actual){};
    }

    protected <T> ObjectAssert<T> assertThat(T actual) {
        return new ObjectAssert<T>(actual){};
    }

    protected BooleanAssert assertThat(Boolean actual) {
        return new BooleanAssert(actual){};
    }

    protected DoubleAssert assertThat(Double actual) {
        return new DoubleAssert(actual){};
    }

    protected IntegerAssert assertThat(Integer actual) {
        return new IntegerAssert(actual){};
    }

    protected LongAssert assertThat(Long actual) {
        return new LongAssert(actual){};
    }

    protected StringAssert assertThat(String actual) {
        return new StringAssert(actual){};
    }

    protected abstract <T> Value<T> empty();

    protected abstract <T> Value<T> of(T var1);

    protected abstract <T> Value<T> of(T ... var1);

    protected abstract boolean useIsEqualToInsteadOfIsSameAs();

    protected abstract int getPeekNonNilPerformingAnAction();

    @Test(expected=NoSuchElementException.class)
    public void shouldGetEmpty() {
        this.empty().get();
    }

    @Test
    public void shouldGetNonEmpty() {
        this.assertThat((Integer)this.of((T)1).get()).isEqualTo(1);
    }

    @Test
    public void shouldGetOptionEmpty() {
        this.assertThat((Iterable)this.empty().getOption()).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldGetOptionNonEmpty() {
        this.assertThat((Iterable)this.of((T)1).getOption()).isEqualTo((Object)Option.of((Object)1));
    }

    @Test
    public void shouldCalculateGetOrElse() {
        this.assertThat(this.empty().getOrElse((Object)1)).isEqualTo((Object)1);
        this.assertThat((Integer)this.of((T)1).getOrElse((Object)2)).isEqualTo(1);
    }

    @Test
    public void shouldCalculateGetOrElseSupplier() {
        this.assertThat(this.empty().getOrElse(() -> 1)).isEqualTo((Object)1);
        this.assertThat((Integer)this.of((T)1).getOrElse(() -> 2)).isEqualTo(1);
    }

    @Test(expected=ArithmeticException.class)
    public void shouldThrowOnGetOrElseThrowIfEmpty() {
        this.empty().getOrElseThrow(ArithmeticException::new);
    }

    @Test
    public void shouldNotThrowOnGetOrElseThrowIfNonEmpty() {
        this.assertThat((Integer)this.of((T)1).getOrElseThrow(ArithmeticException::new)).isEqualTo(1);
    }

    @Test
    public void shouldReturnUnderlyingValueWhenCallingGetOrElseTryOnNonEmptyValue() {
        this.assertThat((Integer)this.of((T)1).getOrElseTry(() -> 2)).isEqualTo(1);
    }

    @Test
    public void shouldReturnAlternateValueWhenCallingGetOrElseTryOnEmptyValue() {
        this.assertThat(this.empty().getOrElseTry(() -> 2)).isEqualTo((Object)2);
    }

    @Test(expected=Try.NonFatalException.class)
    public void shouldThrowWhenCallingGetOrElseTryOnEmptyValueAndTryIsAFailure() {
        this.empty().getOrElseTry(() -> {
            throw new Error();
        });
    }

    @Test
    public void shouldCalculateIsEmpty() {
        this.assertThat(this.empty().isEmpty()).isTrue();
        this.assertThat(this.of((T)1).isEmpty()).isFalse();
    }

    @Test
    public void shouldCalculateIsDefined() {
        this.assertThat(this.empty().isDefined()).isFalse();
        this.assertThat(this.of((T)1).isDefined()).isTrue();
    }

    @Test
    public void shouldPeekNil() {
        this.assertThat((Iterable)this.empty().peek(t -> {})).isEqualTo(this.empty());
    }

    @Test
    public void shouldPeekNonNilPerformingNoAction() {
        this.assertThat((Iterable)this.of((T)1).peek(t -> {})).isEqualTo(this.of((T)1));
    }

    @Test
    public void shouldPeekSingleValuePerformingAnAction() {
        int[] effect = new int[]{0};
        Value actual = this.of((T)1).peek(i -> {
            nArray[0] = i;
        });
        this.assertThat((Iterable)actual).isEqualTo(this.of((T)1));
        this.assertThat(effect[0]).isEqualTo(1);
    }

    @Test
    public void shouldPeekNonNilPerformingAnAction() {
        int[] effect = new int[]{0};
        Value actual = this.of((T[])new Integer[]{1, 2, 3}).peek(i -> {
            nArray[0] = i;
        });
        this.assertThat((Iterable)actual).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(effect[0]).isEqualTo(this.getPeekNonNilPerformingAnAction());
    }

    @Test
    public void shouldConvertNonEmptyValueToMatchValue() {
        Value<Integer> value = this.of((T)1);
        String actual = (String)value.match().when((Match.SerializablePredicate & Serializable)v -> (Integer)v.getOrElse((Object)-1) == 1).then((Object)"ok").getOrElse((Object)"nok");
        this.assertThat(actual).isEqualTo((Object)"ok");
    }

    @Test
    public void shouldConvertEmptyValueToMatchValue() {
        Value value = this.empty();
        String actual = (String)value.match().when(Value::isEmpty).then((Object)"ok").getOrElse((Object)"nok");
        this.assertThat(actual).isEqualTo((Object)"ok");
    }

    @Test
    public void shouldConvertToCharSeq() {
        Value<Character> v = this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')});
        this.assertThat((String)Match.of(v).whenTypeIn(new Class[]{Iterator.class}).then((Object)Iterator.of((Object)"ignore").toString()).getOrElse((Object)v.toString())).isEqualTo((Object)v.toCharSeq().toString());
    }

    @Test
    public void shouldConvertToArray() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Array array = value.toArray();
        if (value.isSingleValued()) {
            this.assertThat((Iterable)array).isEqualTo((Object)Array.of((Object)1));
        } else {
            this.assertThat((Iterable)array).isEqualTo((Object)Array.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertToList() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        javaslang.collection.List list = value.toList();
        if (value.isSingleValued()) {
            this.assertThat((Iterable)list).isEqualTo((Object)javaslang.collection.List.of((Object)1));
        } else {
            this.assertThat((Iterable)list).isEqualTo((Object)javaslang.collection.List.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertToMap() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Map map = value.toMap(v -> Tuple.of((Object)v, (Object)v));
        if (value.isSingleValued()) {
            this.assertThat((Iterable)map).isEqualTo((Object)HashMap.of((Object)1, (Object)1));
        } else {
            this.assertThat((Iterable)map).isEqualTo((Object)HashMap.empty().put((Object)1, (Object)1).put((Object)2, (Object)2).put((Object)3, (Object)3));
        }
    }

    @Test
    public void shouldConvertToOption() {
        this.assertThat((Iterable)this.empty().toOption()).isSameAs((Object)Option.none());
        this.assertThat((Iterable)this.of((T)1).toOption()).isEqualTo((Object)Option.of((Object)1));
    }

    @Test
    public void shouldConvertToQueue() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Queue queue = value.toQueue();
        if (value.isSingleValued()) {
            this.assertThat((Iterable)queue).isEqualTo((Object)Queue.of((Object)1));
        } else {
            this.assertThat((Iterable)queue).isEqualTo((Object)Queue.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertToSet() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Set set = value.toSet();
        if (value.isSingleValued()) {
            this.assertThat((Iterable)set).isEqualTo((Object)HashSet.of((Object)1));
        } else {
            this.assertThat((Iterable)set).isEqualTo((Object)HashSet.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertToStack() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Stack stack = value.toStack();
        if (value.isSingleValued()) {
            this.assertThat((Iterable)stack).isEqualTo((Object)Stack.of((Object)1));
        } else {
            this.assertThat((Iterable)stack).isEqualTo((Object)Stack.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertToStream() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        LazyStream stream = LazyStream.ofAll(() -> value.toStream().iterator());
        if (value.isSingleValued()) {
            this.assertThat((Iterable)stream).isEqualTo((Object)LazyStream.of((Object)1));
        } else {
            this.assertThat((Iterable)stream).isEqualTo((Object)LazyStream.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertNonEmptyToTry() {
        this.assertThat((Iterable)this.of((T[])new Integer[]{1, 2, 3}).toTry()).isEqualTo((Object)Try.of(() -> 1));
    }

    @Test
    public void shouldConvertEmptyToTry() {
        Try actual = this.empty().toTry();
        this.assertThat(actual.isFailure()).isTrue();
        this.assertThat(actual.getCause()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    public void shouldConvertNonEmptyToTryUsingExceptionSupplier() {
        Exception x = new Exception("test");
        this.assertThat((Iterable)this.of((T[])new Integer[]{1, 2, 3}).toTry(() -> x)).isEqualTo((Object)Try.of(() -> 1));
    }

    @Test
    public void shouldConvertEmptyToTryUsingExceptionSupplier() {
        Exception x = new Exception("test");
        this.assertThat((Iterable)this.empty().toTry(() -> x)).isEqualTo((Object)Try.failure((Throwable)x));
    }

    @Test
    public void shouldConvertToVector() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Vector vector = value.toVector();
        if (value.isSingleValued()) {
            this.assertThat((Iterable)vector).isEqualTo((Object)Vector.of((Object)1));
        } else {
            this.assertThat((Iterable)vector).isEqualTo((Object)Vector.of((Object[])new Integer[]{1, 2, 3}));
        }
    }

    @Test
    public void shouldConvertToJavaArray() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Integer[] ints = (Integer[])value.toJavaArray(Integer.class);
        if (value.isSingleValued()) {
            this.assertThat(ints).isEqualTo((Object)new int[]{1});
        } else {
            this.assertThat(ints).isEqualTo((Object)new int[]{1, 2, 3});
        }
    }

    @Test
    public void shouldConvertToJavaList() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        List list = value.toJavaList();
        if (value.isSingleValued()) {
            this.assertThat(list).isEqualTo(Arrays.asList(1));
        } else {
            this.assertThat(list).isEqualTo(Arrays.asList(1, 2, 3));
        }
    }

    @Test
    public void shouldConvertToJavaMap() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        java.util.Map map = value.toJavaMap(v -> Tuple.of((Object)v, (Object)v));
        if (value.isSingleValued()) {
            this.assertThat(map).isEqualTo(JavaCollections.javaMap(1, 1));
        } else {
            this.assertThat(map).isEqualTo(JavaCollections.javaMap(1, 1, 2, 2, 3, 3));
        }
    }

    @Test
    public void shouldConvertToJavaOptional() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).toJavaOptional()).isEqualTo(Optional.of(1));
    }

    @Test
    public void shouldConvertToJavaSet() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        java.util.Set set = value.toJavaSet();
        if (value.isSingleValued()) {
            this.assertThat(set).isEqualTo(JavaCollections.javaSet(1));
        } else {
            this.assertThat(set).isEqualTo(JavaCollections.javaSet(1, 2, 3));
        }
    }

    @Test
    public void shouldConvertToJavaStream() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2, 3});
        Stream s1 = value.toJavaStream();
        if (value.isSingleValued()) {
            Stream<Integer> s2 = Stream.of(Integer.valueOf(1));
            this.assertThat((Iterable)javaslang.collection.List.ofAll(s1::iterator)).isEqualTo((Object)javaslang.collection.List.ofAll(s2::iterator));
        } else {
            Stream<Integer> s2 = Stream.of(1, 2, 3);
            this.assertThat((Iterable)javaslang.collection.List.ofAll(s1::iterator)).isEqualTo((Object)javaslang.collection.List.ofAll(s2::iterator));
        }
    }

    @Test
    public void shouldConvertToEitherLeftFromValueSupplier() {
        Either either = this.of((T)0).toLeft(() -> "fallback");
        this.assertThat(either.isLeft()).isTrue();
        this.assertThat((Integer)either.getLeft()).isEqualTo(0);
        Either either2 = this.empty().toLeft(() -> "fallback");
        this.assertThat(either2.isRight()).isTrue();
        this.assertThat((String)either2.get()).isEqualTo((Object)"fallback");
    }

    @Test
    public void shouldConvertToEitherLeftFromValue() {
        Either either = this.of((T)0).toLeft((Object)"fallback");
        this.assertThat(either.isLeft()).isTrue();
        this.assertThat((Integer)either.getLeft()).isEqualTo(0);
        Either either2 = this.empty().toLeft((Object)"fallback");
        this.assertThat(either2.isRight()).isTrue();
        this.assertThat((String)either2.get()).isEqualTo((Object)"fallback");
    }

    @Test
    public void shouldConvertToEitherRightFromValueSupplier() {
        Either either = this.of((T)0).toRight(() -> "fallback");
        this.assertThat(either.isRight()).isTrue();
        this.assertThat((Integer)either.get()).isEqualTo(0);
        Either either2 = this.empty().toRight(() -> "fallback");
        this.assertThat(either2.isLeft()).isTrue();
        this.assertThat((String)either2.getLeft()).isEqualTo((Object)"fallback");
    }

    @Test
    public void shouldConvertToEitherRightFromValue() {
        Either either = this.of((T)0).toRight((Object)"fallback");
        this.assertThat(either.isRight()).isTrue();
        this.assertThat((Integer)either.get()).isEqualTo(0);
        Either either2 = this.empty().toRight((Object)"fallback");
        this.assertThat(either2.isLeft()).isTrue();
        this.assertThat((String)either2.getLeft()).isEqualTo((Object)"fallback");
    }

    @Test
    public void shouldBeAwareOfExistingElement() {
        Value<Integer> value = this.of((T[])new Integer[]{1, 2});
        if (value.isSingleValued()) {
            this.assertThat(value.exists(i -> i == 1)).isTrue();
        } else {
            this.assertThat(value.exists(i -> i == 2)).isTrue();
        }
    }

    @Test
    public void shouldBeAwareOfNonExistingElement() {
        this.assertThat(this.empty().exists(i -> i == 1)).isFalse();
    }

    @Test
    public void shouldBeAwareOfPropertyThatHoldsForAll() {
        this.assertThat(this.of((T[])new Integer[]{2, 4}).forAll(i -> i % 2 == 0)).isTrue();
    }

    @Test
    public void shouldBeAwareOfPropertyThatNotHoldsForAll() {
        this.assertThat(this.of((T[])new Integer[]{1, 2}).forAll(i -> i % 2 == 0)).isFalse();
    }

    @Test
    public void shouldntCorrespondsNilNil() {
        this.assertThat(this.empty().corresponds(this.empty(), (o1, o2) -> true)).isTrue();
    }

    @Test
    public void shouldntCorrespondsNilNonNil() {
        this.assertThat(this.empty().corresponds(this.of((T)1), (o1, i2) -> true)).isFalse();
    }

    @Test
    public void shouldntCorrespondsNonNilNil() {
        this.assertThat(this.of((T)1).corresponds(this.empty(), (i1, o2) -> true)).isFalse();
    }

    @Test
    public void shouldntCorrespondsDifferentLengths() {
        if (!this.empty().isSingleValued()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).corresponds(this.of((T[])new Integer[]{1, 2}), (i1, i2) -> true)).isFalse();
            this.assertThat(this.of((T[])new Integer[]{1, 2}).corresponds(this.of((T[])new Integer[]{1, 2, 3}), (i1, i2) -> true)).isFalse();
        }
    }

    @Test
    public void shouldCorresponds() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).corresponds(this.of((T[])new Integer[]{3, 4, 5}), (i1, i2) -> i1 == i2 - 2)).isTrue();
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).corresponds(this.of((T[])new Integer[]{1, 2, 3}), (i1, i2) -> i1 == i2 + 1)).isFalse();
    }
}

