/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream;

import com.aol.cyclops.javaslang.reactivestreams.reactivestream.AbstractValueTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javaslang.Tuple;
import javaslang.collection.Iterator;
import javaslang.collection.Map;
import javaslang.collection.Traversable;
import javaslang.collection.Vector;
import javaslang.control.Option;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractTraversableTest
extends AbstractValueTest {
    protected boolean isTraversableAgain() {
        return true;
    }

    protected abstract <T> Collector<T, ArrayList<T>, ? extends Traversable<T>> collector();

    protected abstract <T> Traversable<T> empty();

    protected abstract <T> Traversable<T> of(T var1);

    protected abstract <T> Traversable<T> of(T ... var1);

    protected abstract <T> Traversable<T> ofAll(Iterable<? extends T> var1);

    protected abstract Traversable<Boolean> ofAll(boolean[] var1);

    protected abstract Traversable<Byte> ofAll(byte[] var1);

    protected abstract Traversable<Character> ofAll(char[] var1);

    protected abstract Traversable<Double> ofAll(double[] var1);

    protected abstract Traversable<Float> ofAll(float[] var1);

    protected abstract Traversable<Integer> ofAll(int[] var1);

    protected abstract Traversable<Long> ofAll(long[] var1);

    protected abstract Traversable<Short> ofAll(short[] var1);

    @Test
    public void shouldCreateNil() {
        Traversable actual = this.empty();
        this.assertThat(actual.length()).isEqualTo(0);
    }

    @Test
    public void shouldCreateSeqOfSeqUsingCons() {
        javaslang.collection.List actual = this.of((T)javaslang.collection.List.empty()).toList();
        this.assertThat(actual).isEqualTo((Object)javaslang.collection.List.of((Object)javaslang.collection.List.empty()));
    }

    @Test
    public void shouldCreateInstanceOfElements() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2}).toList();
        this.assertThat(actual).isEqualTo((Object)javaslang.collection.List.of((Object[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldCreateListOfIterable() {
        List<Integer> arrayList = Arrays.asList(1, 2);
        javaslang.collection.List actual = this.ofAll(arrayList).toList();
        this.assertThat(actual).isEqualTo((Object)javaslang.collection.List.of((Object[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldCreateListOfPrimitiveBooleanArray() {
        Traversable<Boolean> actual = this.ofAll(new boolean[]{true, false});
        Traversable<Boolean> expected = this.of((T[])new Boolean[]{true, false});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveByteArray() {
        Traversable<Byte> actual = this.ofAll(new byte[]{1, 2, 3});
        Traversable<Byte> expected = this.of((T[])new Byte[]{(byte)1, (byte)2, (byte)3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveCharArray() {
        Traversable<Character> actual = this.ofAll(new char[]{'a', 'b', 'c'});
        Traversable<Character> expected = this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveDoubleArray() {
        Traversable<Double> actual = this.ofAll(new double[]{1.0, 2.0, 3.0});
        Traversable<Double> expected = this.of((T[])new Double[]{1.0, 2.0, 3.0});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveFloatArray() {
        Traversable<Float> actual = this.ofAll(new float[]{1.0f, 2.0f, 3.0f});
        Traversable<Float> expected = this.of((T[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveIntArray() {
        Traversable<Integer> actual = this.ofAll(new int[]{1, 2, 3});
        Traversable<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveLongArray() {
        Traversable<Long> actual = this.ofAll(new long[]{1L, 2L, 3L});
        Traversable<Long> expected = this.of((T[])new Long[]{1L, 2L, 3L});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCreateListOfPrimitiveShortArray() {
        Traversable<Short> actual = this.ofAll(new short[]{1, 2, 3});
        Traversable<Short> expected = this.of((T[])new Short[]{(short)1, (short)2, (short)3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldReturnNoneWhenComputingAverageOfNil() {
        this.assertThat(this.empty().average()).isEqualTo((Object)Option.none());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowWhenComputingAverageOfStrings() {
        this.of((T[])new String[]{"1", "2", "3"}).average();
    }

    @Test
    public void shouldComputeAverageOfByte() {
        this.assertThat((Double)this.of((T[])new Byte[]{(byte)1, (byte)2}).average().get()).isEqualTo(1.5);
    }

    @Test
    public void shouldComputeAverageOfDouble() {
        this.assertThat((Double)this.of((T[])new Double[]{0.1, 0.2, 0.3}).average().get()).isEqualTo(0.2, Assertions.within((Double)1.0E-16));
    }

    @Test
    public void shouldComputeAverageOfFloat() {
        this.assertThat((Double)this.of((T[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f)}).average().get()).isEqualTo(0.2, Assertions.within((Double)1.0E-8));
    }

    @Test
    public void shouldComputeAverageOfInt() {
        this.assertThat((Double)this.of((T[])new Integer[]{1, 2, 3}).average().get()).isEqualTo(2.0);
    }

    @Test
    public void shouldComputeAverageOfLong() {
        this.assertThat((Double)this.of((T[])new Long[]{1L, 2L, 3L}).average().get()).isEqualTo(2.0);
    }

    @Test
    public void shouldComputeAverageOfShort() {
        this.assertThat((Double)this.of((T[])new Short[]{(short)1, (short)2, (short)3}).average().get()).isEqualTo(2.0);
    }

    @Test
    public void shouldComputeAverageOfBigInteger() {
        this.assertThat((Double)this.of((T[])new BigInteger[]{BigInteger.ZERO, BigInteger.ONE}).average().get()).isEqualTo(0.5);
    }

    @Test
    public void shouldComputeAverageOfBigDecimal() {
        this.assertThat((Double)this.of((T[])new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE}).average().get()).isEqualTo(0.5);
    }

    @Test
    public void shouldClearNil() {
        this.assertThat(this.empty().clear()).isEqualTo(this.empty());
    }

    @Test
    public void shouldClearNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).clear()).isEmpty();
    }

    @Test
    public void shouldRecognizeNilContainsNoElement() {
        boolean actual = this.empty().contains(null);
        this.assertThat(actual).isFalse();
    }

    @Test
    public void shouldRecognizeNonNilDoesNotContainElement() {
        boolean actual = this.of((T[])new Integer[]{1, 2, 3}).contains((Object)0);
        this.assertThat(actual).isFalse();
    }

    @Test
    public void shouldRecognizeNonNilDoesContainElement() {
        boolean actual = this.of((T[])new Integer[]{1, 2, 3}).contains((Object)2);
        this.assertThat(actual).isTrue();
    }

    @Test
    public void shouldRecognizeNilNotContainsAllElements() {
        boolean actual = this.empty().containsAll(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(actual).isFalse();
    }

    @Test
    public void shouldRecognizeNonNilNotContainsAllOverlappingElements() {
        boolean actual = this.of((T[])new Integer[]{1, 2, 3}).containsAll(this.of((T[])new Integer[]{2, 3, 4}));
        this.assertThat(actual).isFalse();
    }

    @Test
    public void shouldRecognizeNonNilContainsAllOnSelf() {
        boolean actual = this.of((T[])new Integer[]{1, 2, 3}).containsAll(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(actual).isTrue();
    }

    @Test
    public void shouldComputeDistinctOfEmptyTraversable() {
        this.assertThat(this.empty().distinct()).isEqualTo(this.empty());
    }

    @Test
    public void shouldComputeDistinctOfNonEmptyTraversable() {
        this.assertThat(this.of((T[])new Integer[]{1, 1, 2, 2, 3, 3}).distinct()).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void shouldComputeDistinctByOfEmptyTraversableUsingComparator() {
        Comparator comparator = (i1, i2) -> i1 - i2;
        this.assertThat(this.empty().distinctBy(comparator)).isEqualTo(this.empty());
    }

    @Test
    public void shouldComputeDistinctByOfNonEmptyTraversableUsingComparator() {
        Comparator comparator = (s1, s2) -> s1.charAt(1) - s2.charAt(1);
        this.assertThat(this.of((T[])new String[]{"1a", "2a", "3a", "3b", "4b", "5c"}).distinctBy(comparator)).isEqualTo(this.of((T[])new String[]{"1a", "3b", "5c"}));
    }

    @Test
    public void shouldComputeDistinctByOfEmptyTraversableUsingKeyExtractor() {
        this.assertThat(this.empty().distinctBy(Function.identity())).isEqualTo(this.empty());
    }

    @Test
    public void shouldComputeDistinctByOfNonEmptyTraversableUsingKeyExtractor() {
        this.assertThat(this.of((T[])new String[]{"1a", "2a", "3a", "3b", "4b", "5c"}).distinctBy(c -> Character.valueOf(c.charAt(1)))).isEqualTo(this.of((T[])new String[]{"1a", "3b", "5c"}));
    }

    @Test
    public void shouldDropNoneOnNil() {
        this.assertThat(this.empty().drop(1L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldDropNoneIfCountIsNegative() {
        Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(t.drop(-1L)).isEqualTo(t);
    }

    @Test
    public void shouldDropAsExpectedIfCountIsLessThanSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).drop(2L)).isEqualTo(this.of((T)3));
    }

    @Test
    public void shouldDropAllIfCountExceedsSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).drop(4L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldDropRightNoneOnNil() {
        this.assertThat(this.empty().dropRight(1L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldDropRightNoneIfCountIsNegative() {
        Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(t.dropRight(-1L)).isEqualTo(t);
    }

    @Test
    public void shouldDropRightAsExpectedIfCountIsLessThanSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropRight(2L)).isEqualTo(this.of((T)1));
    }

    @Test
    public void shouldDropRightAllIfCountExceedsSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropRight(4L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldDropUntilNoneOnNil() {
        Assert.assertTrue((boolean)this.empty().dropUntil(ignored -> true).isEmpty());
    }

    @Test
    public void shouldDropUntilNoneIfPredicateIsTrue() {
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropUntil(ignored -> true)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        } else {
            Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
            this.assertThat(t.dropUntil(ignored -> true)).isSameAs(t);
        }
    }

    @Test
    public void shouldDropUntilAllIfPredicateIsFalse() {
        Assert.assertTrue((boolean)this.of((T[])new Integer[]{1, 2, 3}).dropUntil(ignored -> false).isEmpty());
    }

    @Test
    public void shouldDropUntilCorrect() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropUntil(i -> i >= 2)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldDropWhileNoneOnNil() {
        this.assertThat(this.empty().dropWhile(ignored -> true)).isEqualTo(this.empty());
    }

    @Test
    public void shouldDropWhileNoneIfPredicateIsFalse() {
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropWhile(ignored -> false)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        } else {
            Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
            this.assertThat(t.dropWhile(ignored -> false)).isSameAs(t);
        }
    }

    @Test
    public void shouldDropWhileAllIfPredicateIsTrue() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropWhile(ignored -> true)).isEqualTo(this.empty());
    }

    @Test
    public void shouldDropWhileCorrect() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).dropWhile(i -> i < 2)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldBeAwareOfExistingUniqueElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2}).existsUnique(i -> i == 1)).isTrue();
    }

    @Test
    public void shouldBeAwareOfNonExistingUniqueElement() {
        this.assertThat(this.empty().existsUnique(i -> i == 1)).isFalse();
    }

    @Test
    public void shouldBeAwareOfExistingNonUniqueElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 1, 2}).existsUnique(i -> i == 1)).isFalse();
    }

    @Test
    public void shouldFindFirstOfNil() {
        this.assertThat(this.empty().find(ignored -> true)).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldFindFirstOfNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).find(i -> i % 2 == 0)).isEqualTo((Object)Option.of((Object)2));
    }

    @Test
    public void shouldFindLastOfNil() {
        this.assertThat(this.empty().findLast(ignored -> true)).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldFindLastOfNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).findLast(i -> i % 2 == 0)).isEqualTo((Object)Option.of((Object)4));
    }

    @Test
    public void shouldFoldMultipleElements() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).fold((Object)0, (a, b) -> a + b)).isEqualTo(6);
    }

    @Test
    public void shouldFoldLeftNil() {
        this.assertThat((String)this.empty().foldLeft((Object)"", (xs, x) -> xs + x)).isEqualTo((Object)"");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenFoldLeftNullOperator() {
        this.empty().foldLeft(null, null);
    }

    @Test
    public void shouldFoldLeftNonNil() {
        this.assertThat((String)this.of((T[])new String[]{"a", "b", "c"}).foldLeft((Object)"", (xs, x) -> xs + x)).isEqualTo((Object)"abc");
    }

    @Test
    public void shouldFoldRightNil() {
        this.assertThat((String)this.empty().foldRight((Object)"", (x, xs) -> x + xs)).isEqualTo((Object)"");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenFoldRightNullOperator() {
        this.empty().foldRight(null, null);
    }

    @Test
    public void shouldFoldRightNonNil() {
        this.assertThat((String)this.of((T[])new String[]{"a", "b", "c"}).foldRight((Object)"", (x, xs) -> x + xs)).isEqualTo((Object)"abc");
    }

    @Test
    public void shouldReturnSomethingOnHasDefiniteSize() {
        this.empty().hasDefiniteSize();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowWhenHeadOnNil() {
        this.empty().head();
    }

    @Test
    public void shouldReturnHeadOfNonNil() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).head()).isEqualTo(1);
    }

    @Test
    public void shouldReturnNoneWhenCallingHeadOptionOnNil() {
        this.assertThat(this.empty().headOption().isEmpty()).isTrue();
    }

    @Test
    public void shouldReturnSomeHeadWhenCallingHeadOptionOnNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).headOption()).isEqualTo((Object)Option.some((Object)1));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowWhenInitOfNil() {
        this.empty().init().get();
    }

    @Test
    public void shouldGetInitOfNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).init()).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldNilGroupBy() {
        this.assertThat(this.empty().groupBy(Function.identity())).isEqualTo((Object)javaslang.collection.HashMap.empty());
    }

    @Test
    public void shouldNonNilGroupByIdentity() {
        Map actual = this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).groupBy(Function.identity());
        javaslang.collection.HashMap expected = javaslang.collection.HashMap.empty().put((Object)Character.valueOf('a'), this.of((T)Character.valueOf('a'))).put((Object)Character.valueOf('b'), this.of((T)Character.valueOf('b'))).put((Object)Character.valueOf('c'), this.of((T)Character.valueOf('c')));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNonNilGroupByEqual() {
        Map actual = this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).groupBy(c -> 1);
        javaslang.collection.HashMap expected = javaslang.collection.HashMap.empty().put((Object)1, this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldGroupedNil() {
        this.assertThat(this.empty().grouped(1L).isEmpty()).isTrue();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenGroupedWithSizeZero() {
        this.empty().grouped(0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenGroupedWithNegativeSize() {
        this.empty().grouped(-1L);
    }

    @Test
    public void shouldGroupedTraversableWithEqualSizedBlocks() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4}).grouped(2L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new Traversable[]{Vector.of((Object[])new Integer[]{1, 2}), Vector.of((Object[])new Integer[]{3, 4})});
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldGroupedTraversableWithRemainder() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).grouped(2L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new Traversable[]{Vector.of((Object[])new Integer[]{1, 2}), Vector.of((Object[])new Integer[]{3, 4}), Vector.of((Object)5)});
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldGroupedWhenTraversableLengthIsSmallerThanBlockSize() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4}).grouped(5L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object)Vector.of((Object[])new Integer[]{1, 2, 3, 4}));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldReturnNoneWhenCallingInitOptionOnNil() {
        this.assertThat(this.empty().initOption().isEmpty()).isTrue();
    }

    @Test
    public void shouldReturnSomeInitWhenCallingInitOptionOnNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).initOption()).isEqualTo((Object)Option.some(this.of((T[])new Integer[]{1, 2})));
    }

    @Test
    public void shouldRecognizeNil() {
        this.assertThat(this.empty().isEmpty()).isTrue();
    }

    @Test
    public void shouldRecognizeNonNil() {
        this.assertThat(this.of((T)1).isEmpty()).isFalse();
    }

    @Test
    public void shouldReturnSomethingOnIsTraversableAgain() {
        this.empty().isTraversableAgain();
    }

    @Test
    public void shouldNotHasNextWhenNilIterator() {
        this.assertThat(this.empty().iterator().hasNext()).isFalse();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowOnNextWhenNilIterator() {
        this.empty().iterator().next();
    }

    @Test
    public void shouldIterateFirstElementOfNonNil() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).iterator().next()).isEqualTo(1);
    }

    @Test
    public void shouldFullyIterateNonNil() {
        Iterator iterator = this.of((T[])new Integer[]{1, 2, 3}).iterator();
        for (int i = 1; i <= 3; ++i) {
            int actual = (Integer)iterator.next();
            this.assertThat(actual).isEqualTo(i);
        }
        this.assertThat(iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldMkStringNil() {
        this.assertThat(this.empty().mkString()).isEqualTo((Object)"");
    }

    @Test
    public void shouldMkStringNonNil() {
        this.assertThat(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).mkString()).isEqualTo((Object)"abc");
    }

    @Test
    public void shouldMkStringWithDelimiterNil() {
        this.assertThat(this.empty().mkString((CharSequence)",")).isEqualTo((Object)"");
    }

    @Test
    public void shouldMkStringWithDelimiterNonNil() {
        this.assertThat(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).mkString((CharSequence)",")).isEqualTo((Object)"a,b,c");
    }

    @Test
    public void shouldMkStringWithDelimiterAndPrefixAndSuffixNil() {
        this.assertThat(this.empty().mkString((CharSequence)"[", (CharSequence)",", (CharSequence)"]")).isEqualTo((Object)"[]");
    }

    @Test
    public void shouldMkStringWithDelimiterAndPrefixAndSuffixNonNil() {
        this.assertThat(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).mkString((CharSequence)"[", (CharSequence)",", (CharSequence)"]")).isEqualTo((Object)"[a,b,c]");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowWhenLastOnNil() {
        this.empty().last();
    }

    @Test
    public void shouldReturnLastOfNonNil() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).last()).isEqualTo(3);
    }

    @Test
    public void shouldReturnNoneWhenCallingLastOptionOnNil() {
        this.assertThat(this.empty().lastOption().isEmpty()).isTrue();
    }

    @Test
    public void shouldReturnSomeLastWhenCallingLastOptionOnNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).lastOption()).isEqualTo((Object)Option.some((Object)3));
    }

    @Test
    public void shouldComputeLengthOfNil() {
        this.assertThat(this.empty().length()).isEqualTo(0);
    }

    @Test
    public void shouldComputeLengthOfNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).length()).isEqualTo(3);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenPartitionNilAndPredicateIsNull() {
        this.empty().partition(null);
    }

    @Test
    public void shouldPartitionNil() {
        this.assertThat(this.empty().partition(e -> true)).isEqualTo((Object)Tuple.of(this.empty(), this.empty()));
    }

    @Test
    public void shouldPartitionIntsInOddAndEvenHavingOddAndEvenNumbers() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).partition(i -> i % 2 != 0)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 3}), this.of((T[])new Integer[]{2, 4})));
    }

    @Test
    public void shouldPartitionIntsInOddAndEvenHavingOnlyOddNumbers() {
        this.assertThat(this.of((T[])new Integer[]{1, 3}).partition(i -> i % 2 != 0)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 3}), this.empty()));
    }

    @Test
    public void shouldPartitionIntsInOddAndEvenHavingOnlyEvenNumbers() {
        this.assertThat(this.of((T[])new Integer[]{2, 4}).partition(i -> i % 2 != 0)).isEqualTo((Object)Tuple.of(this.empty(), this.of((T[])new Integer[]{2, 4})));
    }

    @Test
    public void shouldReturnNoneWhenComputingMaxOfNil() {
        this.assertThat(this.empty().max()).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldComputeMaxOfStrings() {
        this.assertThat(this.of((T[])new String[]{"1", "2", "3"}).max()).isEqualTo((Object)Option.some((Object)"3"));
    }

    @Test
    public void shouldComputeMaxOfBoolean() {
        this.assertThat(this.of((T[])new Boolean[]{true, false}).max()).isEqualTo((Object)Option.some((Object)true));
    }

    @Test
    public void shouldComputeMaxOfByte() {
        this.assertThat(this.of((T[])new Byte[]{(byte)1, (byte)2}).max()).isEqualTo((Object)Option.some((Object)2));
    }

    @Test
    public void shouldComputeMaxOfChar() {
        this.assertThat(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).max()).isEqualTo((Object)Option.some((Object)Character.valueOf('c')));
    }

    @Test
    public void shouldComputeMaxOfDouble() {
        this.assertThat(this.of((T[])new Double[]{0.1, 0.2, 0.3}).max()).isEqualTo((Object)Option.some((Object)0.3));
    }

    @Test
    public void shouldComputeMaxOfFloat() {
        this.assertThat(this.of((T[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f)}).max()).isEqualTo((Object)Option.some((Object)Float.valueOf(0.3f)));
    }

    @Test
    public void shouldComputeMaxOfInt() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).max()).isEqualTo((Object)Option.some((Object)3));
    }

    @Test
    public void shouldComputeMaxOfLong() {
        this.assertThat(this.of((T[])new Long[]{1L, 2L, 3L}).max()).isEqualTo((Object)Option.some((Object)3L));
    }

    @Test
    public void shouldComputeMaxOfShort() {
        this.assertThat(this.of((T[])new Short[]{(short)1, (short)2, (short)3}).max()).isEqualTo((Object)Option.some((Object)3));
    }

    @Test
    public void shouldComputeMaxOfBigInteger() {
        this.assertThat(this.of((T[])new BigInteger[]{BigInteger.ZERO, BigInteger.ONE}).max()).isEqualTo((Object)Option.some((Object)BigInteger.ONE));
    }

    @Test
    public void shouldComputeMaxOfBigDecimal() {
        this.assertThat(this.of((T[])new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE}).max()).isEqualTo((Object)Option.some((Object)BigDecimal.ONE));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenMaxByWithNullComparator() {
        this.of((T)1).maxBy((Comparator)null);
    }

    @Test
    public void shouldThrowWhenMaxByOfNil() {
        this.assertThat(this.empty().maxBy((o1, o2) -> 0)).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldCalculateMaxByOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).maxBy((i1, i2) -> i1 - i2)).isEqualTo((Object)Option.some((Object)3));
    }

    @Test
    public void shouldCalculateInverseMaxByOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).maxBy((i1, i2) -> i2 - i1)).isEqualTo((Object)Option.some((Object)1));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenMaxByWithNullFunction() {
        this.of((T)1).maxBy((Function)null);
    }

    @Test
    public void shouldThrowWhenMaxByFunctionOfNil() {
        this.assertThat(this.empty().maxBy(i -> i)).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldCalculateMaxByFunctionOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).maxBy(i -> i)).isEqualTo((Object)Option.some((Object)3));
    }

    @Test
    public void shouldCalculateInverseMaxByFunctionOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).maxBy(i -> -i.intValue())).isEqualTo((Object)Option.some((Object)1));
    }

    @Test
    public void shouldCallMaxFunctionOncePerElement() {
        int[] cnt = new int[]{0};
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).maxBy(i -> {
            nArray[0] = cnt[0] + 1;
            return i;
        })).isEqualTo((Object)Option.some((Object)3));
        this.assertThat(cnt[0]).isEqualTo(3);
    }

    @Test
    public void shouldReturnNoneWhenComputingMinOfNil() {
        this.assertThat(this.empty().min()).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldComputeMinOfStrings() {
        this.assertThat(this.of((T[])new String[]{"1", "2", "3"}).min()).isEqualTo((Object)Option.some((Object)"1"));
    }

    @Test
    public void shouldComputeMinOfBoolean() {
        this.assertThat(this.of((T[])new Boolean[]{true, false}).min()).isEqualTo((Object)Option.some((Object)false));
    }

    @Test
    public void shouldComputeMinOfByte() {
        this.assertThat(this.of((T[])new Byte[]{(byte)1, (byte)2}).min()).isEqualTo((Object)Option.some((Object)1));
    }

    @Test
    public void shouldComputeMinOfChar() {
        this.assertThat(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).min()).isEqualTo((Object)Option.some((Object)Character.valueOf('a')));
    }

    @Test
    public void shouldComputeMinOfDouble() {
        this.assertThat(this.of((T[])new Double[]{0.1, 0.2, 0.3}).min()).isEqualTo((Object)Option.some((Object)0.1));
    }

    @Test
    public void shouldComputeMinOfFloat() {
        this.assertThat(this.of((T[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f)}).min()).isEqualTo((Object)Option.some((Object)Float.valueOf(0.1f)));
    }

    @Test
    public void shouldComputeMinOfInt() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).min()).isEqualTo((Object)Option.some((Object)1));
    }

    @Test
    public void shouldComputeMinOfLong() {
        this.assertThat(this.of((T[])new Long[]{1L, 2L, 3L}).min()).isEqualTo((Object)Option.some((Object)1L));
    }

    @Test
    public void shouldComputeMinOfShort() {
        this.assertThat(this.of((T[])new Short[]{(short)1, (short)2, (short)3}).min()).isEqualTo((Object)Option.some((Object)1));
    }

    @Test
    public void shouldComputeMinOfBigInteger() {
        this.assertThat(this.of((T[])new BigInteger[]{BigInteger.ZERO, BigInteger.ONE}).min()).isEqualTo((Object)Option.some((Object)BigInteger.ZERO));
    }

    @Test
    public void shouldComputeMinOfBigDecimal() {
        this.assertThat(this.of((T[])new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE}).min()).isEqualTo((Object)Option.some((Object)BigDecimal.ZERO));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenMinByWithNullComparator() {
        this.of((T)1).minBy((Comparator)null);
    }

    @Test
    public void shouldThrowWhenMinByOfNil() {
        this.assertThat(this.empty().minBy((o1, o2) -> 0)).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldCalculateMinByOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).minBy((i1, i2) -> i1 - i2)).isEqualTo((Object)Option.some((Object)1));
    }

    @Test
    public void shouldCalculateInverseMinByOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).minBy((i1, i2) -> i2 - i1)).isEqualTo((Object)Option.some((Object)3));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenMinByWithNullFunction() {
        this.of((T)1).minBy((Function)null);
    }

    @Test
    public void shouldThrowWhenMinByFunctionOfNil() {
        this.assertThat(this.empty().minBy(i -> i)).isEqualTo((Object)Option.none());
    }

    @Test
    public void shouldCalculateMinByFunctionOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).minBy(i -> i)).isEqualTo((Object)Option.some((Object)1));
    }

    @Test
    public void shouldCalculateInverseMinByFunctionOfInts() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).minBy(i -> -i.intValue())).isEqualTo((Object)Option.some((Object)3));
    }

    @Test
    public void shouldCallMinFunctionOncePerElement() {
        int[] cnt = new int[]{0};
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).minBy(i -> {
            nArray[0] = cnt[0] + 1;
            return i;
        })).isEqualTo((Object)Option.some((Object)1));
        this.assertThat(cnt[0]).isEqualTo(3);
    }

    @Test
    public void shouldComputeProductOfNil() {
        this.assertThat(this.empty().product()).isEqualTo((Object)1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowWhenComputingProductOfStrings() {
        this.of((T[])new String[]{"1", "2", "3"}).product();
    }

    @Test
    public void shouldComputeProductOfByte() {
        this.assertThat(this.of((T[])new Byte[]{(byte)1, (byte)2}).product()).isEqualTo((Object)2);
    }

    @Test
    public void shouldComputeProductOfDouble() {
        this.assertThat(this.of((T[])new Double[]{0.1, 0.2, 0.3}).product().doubleValue()).isEqualTo(0.006, Assertions.within((Double)1.0E-17));
    }

    @Test
    public void shouldComputeProductOfFloat() {
        this.assertThat(this.of((T[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f)}).product().doubleValue()).isEqualTo(0.006, Assertions.within((Double)1.0E-9));
    }

    @Test
    public void shouldComputeProductOfInt() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).product()).isEqualTo((Object)6);
    }

    @Test
    public void shouldComputeProductOfLong() {
        this.assertThat(this.of((T[])new Long[]{1L, 2L, 3L}).product()).isEqualTo((Object)6L);
    }

    @Test
    public void shouldComputeProductOfShort() {
        this.assertThat(this.of((T[])new Short[]{(short)1, (short)2, (short)3}).product()).isEqualTo((Object)6);
    }

    @Test
    public void shouldComputeProductOfBigInteger() {
        this.assertThat(this.of((T[])new BigInteger[]{BigInteger.ZERO, BigInteger.ONE}).product()).isEqualTo((Object)0L);
    }

    @Test
    public void shouldComputeProductOfBigDecimal() {
        this.assertThat(this.of((T[])new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE}).product()).isEqualTo((Object)0.0);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowWhenReduceNil() {
        this.empty().reduce((a, b) -> a + b);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenReduceNullOperator() {
        this.empty().reduce(null);
    }

    @Test
    public void shouldReduceNonNil() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).reduce((a, b) -> a + b)).isEqualTo(6);
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowWhenReduceLeftNil() {
        this.empty().reduceLeft((a, b) -> a + b);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenReduceLeftNullOperator() {
        this.empty().reduceLeft(null);
    }

    @Test
    public void shouldReduceLeftNonNil() {
        this.assertThat((String)this.of((T[])new String[]{"a", "b", "c"}).reduceLeft((xs, x) -> xs + x)).isEqualTo((Object)"abc");
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowWhenReduceRightNil() {
        this.empty().reduceRight((a, b) -> a + b);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenReduceRightNullOperator() {
        this.empty().reduceRight(null);
    }

    @Test
    public void shouldReduceRightNonNil() {
        this.assertThat((String)this.of((T[])new String[]{"a", "b", "c"}).reduceRight((x, xs) -> x + xs)).isEqualTo((Object)"abc");
    }

    @Test
    public void shouldReplaceElementOfNilUsingCurrNew() {
        this.assertThat(this.empty().replace((Object)1, (Object)2)).isEqualTo(this.empty());
    }

    @Test
    public void shouldReplaceFirstOccurrenceOfNonNilUsingCurrNewWhenMultipleOccurrencesExist() {
        Traversable<Integer> testee = this.of((T[])new Integer[]{0, 1, 2, 1});
        Traversable actual = testee.replace((Object)1, (Object)3);
        Traversable<Integer> expected = this.of((T[])new Integer[]{0, 3, 2, 1});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldReplaceElementOfNonNilUsingCurrNewWhenOneOccurrenceExists() {
        this.assertThat(this.of((T[])new Integer[]{0, 1, 2}).replace((Object)1, (Object)3)).isEqualTo(this.of((T[])new Integer[]{0, 3, 2}));
    }

    @Test
    public void shouldReplaceAllElementsOfNilUsingCurrNew() {
        this.assertThat(this.empty().replaceAll((Object)1, (Object)2)).isEqualTo(this.empty());
    }

    @Test
    public void shouldReplaceAllElementsOfNonNilUsingCurrNew() {
        this.assertThat(this.of((T[])new Integer[]{0, 1, 2, 1}).replaceAll((Object)1, (Object)3)).isEqualTo(this.of((T[])new Integer[]{0, 3, 2, 3}));
    }

    @Test
    public void shouldRetainAllElementsFromNil() {
        this.assertThat(this.empty().retainAll(this.of((T[])new Integer[]{1, 2, 3}))).isEqualTo(this.empty());
    }

    @Test
    public void shouldRetainAllExistingElementsFromNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).retainAll(this.of((T[])new Integer[]{1, 2}))).isEqualTo(this.of((T[])new Integer[]{1, 2, 1, 2}));
    }

    @Test
    public void shouldNotRetainAllNonExistingElementsFromNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).retainAll(this.of((T[])new Integer[]{4, 5}))).isEqualTo(this.empty());
    }

    @Test
    public void shouldScanEmpty() {
        Traversable testee = this.empty();
        Traversable actual = testee.scan((Object)0, (s1, s2) -> s1 + s2);
        this.assertThat(actual).isEqualTo(this.of((T)0));
    }

    @Test
    public void shouldScanLeftEmpty() {
        Traversable testee = this.empty();
        Traversable actual = testee.scanLeft((Object)0, (s1, s2) -> s1 + s2);
        this.assertThat(actual).isEqualTo(this.of((T)0));
    }

    @Test
    public void shouldScanRightEmpty() {
        Traversable testee = this.empty();
        Traversable actual = testee.scanRight((Object)0, (s1, s2) -> s1 + s2);
        this.assertThat(actual).isEqualTo(this.of((T)0));
    }

    @Test
    public void shouldScanNonEmpty() {
        Traversable<Integer> testee = this.of((T[])new Integer[]{1, 2, 3});
        Traversable actual = testee.scan((Object)0, (acc, s) -> acc + s);
        this.assertThat(actual).isEqualTo(this.of((T[])new Integer[]{0, 1, 3, 6}));
    }

    @Test
    public void shouldScanLeftNonEmpty() {
        Traversable<Integer> testee = this.of((T[])new Integer[]{1, 2, 3});
        Traversable actual = testee.scanLeft((Object)"x", (acc, i) -> acc + i);
        this.assertThat(actual).isEqualTo(this.of((T[])new String[]{"x", "x1", "x12", "x123"}));
    }

    @Test
    public void shouldScanRightNonEmpty() {
        Traversable<Integer> testee = this.of((T[])new Integer[]{1, 2, 3});
        Traversable actual = testee.scanRight((Object)"x", (i, acc) -> acc + i);
        this.assertThat(actual).isEqualTo(this.of((T[])new String[]{"x", "x3", "x32", "x321"}));
    }

    @Test
    public void shouldScanWithNonComparable() {
        Traversable<NonComparable> testee = this.of((T)new NonComparable("a"));
        javaslang.collection.List actual = javaslang.collection.List.ofAll((Iterable)testee.scan((Object)new NonComparable("x"), (u1, u2) -> new NonComparable(u1.value + u2.value)));
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new String[]{"x", "xa"}).map(NonComparable::new);
        this.assertThat(actual).containsAll((Iterable)expected);
        this.assertThat(actual.length()).isEqualTo(expected.length());
    }

    @Test
    public void shouldScanLeftWithNonComparable() {
        Traversable<NonComparable> testee = this.of((T)new NonComparable("a"));
        javaslang.collection.List actual = javaslang.collection.List.ofAll((Iterable)testee.scanLeft((Object)new NonComparable("x"), (u1, u2) -> new NonComparable(u1.value + u2.value)));
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new String[]{"x", "xa"}).map(NonComparable::new);
        this.assertThat(actual).containsAll((Iterable)expected);
        this.assertThat(actual.length()).isEqualTo(expected.length());
    }

    @Test
    public void shouldScanRightWithNonComparable() {
        Traversable<NonComparable> testee = this.of((T)new NonComparable("a"));
        javaslang.collection.List actual = javaslang.collection.List.ofAll((Iterable)testee.scanRight((Object)new NonComparable("x"), (u1, u2) -> new NonComparable(u1.value + u2.value)));
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new String[]{"ax", "x"}).map(NonComparable::new);
        this.assertThat(actual).containsAll((Iterable)expected);
        this.assertThat(actual.length()).isEqualTo(expected.length());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenSlidingNilByZeroSize() {
        this.empty().sliding(0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenSlidingNilByNegativeSize() {
        this.empty().sliding(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenSlidingNonNilByZeroSize() {
        this.of((T)1).sliding(0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenSlidingNonNilByNegativeSize() {
        this.of((T)1).sliding(-1L);
    }

    @Test
    public void shouldSlideNilBySize() {
        this.assertThat(this.empty().sliding(1L)).isEmpty();
    }

    @Test
    public void shouldSlideNonNilBySize1() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3}).sliding(1L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new Traversable[]{Vector.of((Object)1), Vector.of((Object)2), Vector.of((Object)3)});
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSlideNonNilBySize2() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).sliding(2L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new Traversable[]{Vector.of((Object[])new Integer[]{1, 2}), Vector.of((Object[])new Integer[]{2, 3}), Vector.of((Object[])new Integer[]{3, 4}), Vector.of((Object[])new Integer[]{4, 5})});
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSlideNilBySizeAndStep() {
        this.assertThat(this.empty().sliding(1L, 1L).isEmpty()).isTrue();
    }

    @Test
    public void shouldSlide5ElementsBySize2AndStep3() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).sliding(2L, 3L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new Traversable[]{Vector.of((Object[])new Integer[]{1, 2}), Vector.of((Object[])new Integer[]{4, 5})});
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSlide5ElementsBySize2AndStep4() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).sliding(2L, 4L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object[])new Traversable[]{Vector.of((Object[])new Integer[]{1, 2}), Vector.of((Object)5)});
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSlide5ElementsBySize2AndStep5() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).sliding(2L, 5L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object)Vector.of((Object[])new Integer[]{1, 2}));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSlide4ElementsBySize5AndStep3() {
        javaslang.collection.List actual = this.of((T[])new Integer[]{1, 2, 3, 4}).sliding(5L, 3L).toList().map(Vector::ofAll);
        javaslang.collection.List expected = javaslang.collection.List.of((Object)Vector.of((Object[])new Integer[]{1, 2, 3, 4}));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldSpanNil() {
        this.assertThat(this.empty().span(i -> i < 2)).isEqualTo((Object)Tuple.of(this.empty(), this.empty()));
    }

    @Test
    public void shouldSpanNonNil() {
        this.assertThat(this.of((T[])new Integer[]{0, 1, 2, 3}).span(i -> i < 2)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{0, 1}), this.of((T[])new Integer[]{2, 3})));
    }

    @Test
    public void shouldSplitNil() {
        ArrayList actual = new ArrayList();
        this.empty().spliterator().forEachRemaining(actual::add);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldSplitNonNil() {
        ArrayList actual = new ArrayList();
        this.of((T[])new Integer[]{1, 2, 3}).spliterator().forEachRemaining(actual::add);
        this.assertThat(actual).isEqualTo(Arrays.asList(1, 2, 3));
    }

    @Test
    @Ignore
    public void shouldHaveImmutableSpliterator() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).spliterator().characteristics() & 0x400).isNotZero();
    }

    @Test
    public void shouldHaveOrderedSpliterator() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).spliterator().characteristics() & 0x10).isNotZero();
    }

    @Test
    public void shouldReturnSizeWhenSpliterator() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).spliterator().getExactSizeIfKnown()).isEqualTo(-1L);
    }

    @Test
    public void shouldWriteToStderr() {
        this.of((T[])new Integer[]{1, 2, 3}).stderr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldHandleStderrIOException() {
        PrintStream originalErr = System.err;
        try (PrintStream failingPrintStream = AbstractTraversableTest.failingPrintStream();){
            System.setErr(failingPrintStream);
            this.of((T)0).stderr();
        }
        finally {
            System.setErr(originalErr);
        }
    }

    @Test
    public void shouldWriteToStdout() {
        this.of((T[])new Integer[]{1, 2, 3}).stdout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void shouldHandleStdoutIOException() {
        PrintStream originalOut = System.out;
        try (PrintStream failingPrintStream = AbstractTraversableTest.failingPrintStream();){
            System.setOut(failingPrintStream);
            this.of((T)0).stdout();
        }
        finally {
            System.setOut(originalOut);
        }
    }

    @Test
    public void shouldWriteToPrintStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        PrintStream out = new PrintStream(baos);
        this.of((T[])new Integer[]{1, 2, 3}).out(out);
        this.assertThat(baos.toString()).isEqualTo((Object)this.of((T[])new Integer[]{1, 2, 3}).mkString((CharSequence)"", (CharSequence)System.lineSeparator(), (CharSequence)System.lineSeparator()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldHandlePrintStreamIOException() {
        try (PrintStream failingPrintStream = AbstractTraversableTest.failingPrintStream();){
            this.of((T)0).out(failingPrintStream);
        }
    }

    @Test
    public void shouldWriteToPrintWriter() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.of((T[])new Integer[]{1, 2, 3}).out(out);
        this.assertThat(sw.toString()).isEqualTo((Object)this.of((T[])new Integer[]{1, 2, 3}).mkString((CharSequence)"", (CharSequence)System.lineSeparator(), (CharSequence)System.lineSeparator()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldHandlePrintWriterIOException() {
        try (PrintWriter failingPrintWriter = AbstractTraversableTest.failingPrintWriter();){
            this.of((T)0).out(failingPrintWriter);
        }
    }

    @Test
    public void shouldComputeSumOfNil() {
        this.assertThat(this.empty().sum()).isEqualTo((Object)0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowWhenComputingSumOfStrings() {
        this.of((T[])new String[]{"1", "2", "3"}).sum();
    }

    @Test
    public void shouldComputeSumOfByte() {
        this.assertThat(this.of((T[])new Byte[]{(byte)1, (byte)2}).sum()).isEqualTo((Object)3);
    }

    @Test
    public void shouldComputeSumOfDouble() {
        this.assertThat(this.of((T[])new Double[]{0.1, 0.2, 0.3}).sum().doubleValue()).isEqualTo(0.6, Assertions.within((Double)1.0E-15));
    }

    @Test
    public void shouldComputeSumOfFloat() {
        this.assertThat(this.of((T[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f)}).sum().doubleValue()).isEqualTo(0.6, Assertions.within((Double)1.0E-7));
    }

    @Test
    public void shouldComputeSumOfInt() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).sum()).isEqualTo((Object)6);
    }

    @Test
    public void shouldComputeSumOfLong() {
        this.assertThat(this.of((T[])new Long[]{1L, 2L, 3L}).sum()).isEqualTo((Object)6L);
    }

    @Test
    public void shouldComputeSumOfShort() {
        this.assertThat(this.of((T[])new Short[]{(short)1, (short)2, (short)3}).sum()).isEqualTo((Object)6);
    }

    @Test
    public void shouldComputeSumOfBigInteger() {
        this.assertThat(this.of((T[])new BigInteger[]{BigInteger.ZERO, BigInteger.ONE}).sum()).isEqualTo((Object)1L);
    }

    @Test
    public void shouldComputeSumOfBigDecimal() {
        this.assertThat(this.of((T[])new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ONE}).sum()).isEqualTo((Object)1.0);
    }

    @Test
    public void shouldTakeNoneOnNil() {
        this.assertThat(this.empty().take(1L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeNoneIfCountIsNegative() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).take(-1L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeAsExpectedIfCountIsLessThanSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).take(2L)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldTakeAllIfCountExceedsSize() {
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).take(4L)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        } else {
            Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
            this.assertThat(t.take(4L)).isSameAs(t);
        }
    }

    @Test
    public void shouldTakeRightNoneOnNil() {
        this.assertThat(this.empty().takeRight(1L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeRightNoneIfCountIsNegative() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeRight(-1L)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeRightAsExpectedIfCountIsLessThanSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeRight(2L)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldTakeRightAllIfCountExceedsSize() {
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeRight(4L)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        } else {
            Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
            this.assertThat(t.takeRight(4L)).isSameAs(t);
        }
    }

    @Test
    public void shouldTakeUntilNoneOnNil() {
        this.assertThat(this.empty().takeUntil(x -> true)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeUntilAllOnFalseCondition() {
        Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeUntil(x -> false)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        } else {
            this.assertThat(t.takeUntil(x -> false)).isSameAs(t);
        }
    }

    @Test
    public void shouldTakeUntilAllOnTrueCondition() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeUntil(x -> true)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeUntilAsExpected() {
        this.assertThat(this.of((T[])new Integer[]{2, 4, 5, 6}).takeUntil(x -> x % 2 != 0)).isEqualTo(this.of((T[])new Integer[]{2, 4}));
    }

    @Test
    public void shouldTakeWhileNoneOnNil() {
        this.assertThat(this.empty().takeWhile(x -> true)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeWhileAllOnFalseCondition() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeWhile(x -> false)).isEqualTo(this.empty());
    }

    @Test
    public void shouldTakeWhileAllOnTrueCondition() {
        Traversable<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).takeWhile(x -> true)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        } else {
            this.assertThat(t.takeWhile(x -> true)).isSameAs(t);
        }
    }

    @Test
    public void shouldTakeWhileAsExpected() {
        this.assertThat(this.of((T[])new Integer[]{2, 4, 5, 6}).takeWhile(x -> x % 2 == 0)).isEqualTo(this.of((T[])new Integer[]{2, 4}));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowWhenTailOnNil() {
        this.empty().tail();
    }

    @Test
    public void shouldReturnTailOfNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).tail()).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldReturnNoneWhenCallingTailOptionOnNil() {
        this.assertThat(this.empty().tailOption().isEmpty()).isTrue();
    }

    @Test
    public void shouldReturnSomeTailWhenCallingTailOptionOnNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).tailOption()).isEqualTo((Object)Option.some(this.of((T[])new Integer[]{2, 3})));
    }

    @Test
    public void shouldConvertNilToJavaArray() {
        Integer[] actual = (Integer[])javaslang.collection.List.empty().toJavaArray(Integer.class);
        Integer[] expected = new Integer[]{};
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldConvertNonNilToJavaArray() {
        Integer[] array = (Integer[])this.of((T[])new Integer[]{1, 2}).toJavaArray(Integer.class);
        Integer[] expected = new Integer[]{1, 2};
        this.assertThat(array).isEqualTo((Object)expected);
    }

    @Test
    public void shouldConvertNilToArrayList() {
        this.assertThat(this.empty().toJavaList()).isEqualTo(new ArrayList());
    }

    @Test
    public void shouldConvertNonNilToArrayList() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).toJavaList()).isEqualTo(Arrays.asList(1, 2, 3));
    }

    @Test
    public void shouldConvertNilToHashMap() {
        this.assertThat(this.empty().toJavaMap(x -> Tuple.of((Object)x, (Object)x))).isEqualTo(new HashMap());
    }

    @Test
    public void shouldConvertNonNilToHashMap() {
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(1, 1);
        expected.put(2, 2);
        this.assertThat(this.of((T[])new Integer[]{1, 2}).toJavaMap(x -> Tuple.of((Object)x, (Object)x))).isEqualTo(expected);
    }

    @Test
    public void shouldConvertNilToHashSet() {
        this.assertThat(this.empty().toJavaSet()).isEqualTo(new HashSet());
    }

    @Test
    public void shouldConvertNonNilToHashSet() {
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(2);
        expected.add(1);
        expected.add(3);
        this.assertThat(this.of((T[])new Integer[]{1, 2, 2, 3}).toJavaSet()).isEqualTo(expected);
    }

    @Test
    public void shouldEqualSameTraversableInstance() {
        Traversable traversable = this.empty();
        this.assertThat(traversable).isEqualTo(traversable);
    }

    @Test
    public void shouldNilNotEqualsNull() {
        this.assertThat(this.empty()).isNotNull();
    }

    @Test
    public void shouldNonNilNotEqualsNull() {
        this.assertThat(this.of((T)1)).isNotNull();
    }

    @Test
    public void shouldEmptyNotEqualsDifferentType() {
        this.assertThat(this.empty()).isNotEqualTo((Object)"");
    }

    @Test
    public void shouldNonEmptyNotEqualsDifferentType() {
        this.assertThat(this.of((T)1)).isNotEqualTo((Object)"");
    }

    @Test
    public void shouldRecognizeEqualityOfNils() {
        this.assertThat(this.empty()).isEqualTo(this.empty());
    }

    @Test
    public void shouldRecognizeEqualityOfNonNils() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).equals(this.of((T[])new Integer[]{1, 2, 3}))).isTrue();
    }

    @Test
    public void shouldRecognizeNonEqualityOfTraversablesOfSameSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).equals(this.of((T[])new Integer[]{1, 2, 4}))).isFalse();
    }

    @Test
    public void shouldRecognizeNonEqualityOfTraversablesOfDifferentSize() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).equals(this.of((T[])new Integer[]{1, 2}))).isFalse();
    }

    @Test
    public void shouldCalculateHashCodeOfNil() {
        this.assertThat(this.empty().hashCode() == this.empty().hashCode()).isTrue();
    }

    @Test
    public void shouldCalculateHashCodeOfNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2}).hashCode() == this.of((T[])new Integer[]{1, 2}).hashCode()).isTrue();
    }

    @Test
    public void shouldCalculateDifferentHashCodesForDifferentTraversables() {
        this.assertThat(this.of((T[])new Integer[]{1, 2}).hashCode() != this.of((T[])new Integer[]{2, 3}).hashCode()).isTrue();
    }

    @Test
    public void shouldStreamAndCollectNil() {
        this.testCollector(() -> {
            Traversable actual = Stream.empty().collect(this.collector());
            this.assertThat(actual).isEmpty();
        });
    }

    @Test
    public void shouldStreamAndCollectNonNil() {
        this.testCollector(() -> {
            Traversable actual = Stream.of(1, 2, 3).collect(this.collector());
            this.assertThat(actual).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        });
    }

    @Test
    public void shouldParallelStreamAndCollectNil() {
        this.testCollector(() -> {
            Traversable actual = ((Stream)Stream.empty().parallel()).collect(this.collector());
            this.assertThat(actual).isEmpty();
        });
    }

    @Test
    public void shouldParallelStreamAndCollectNonNil() {
        this.testCollector(() -> {
            Traversable actual = ((Stream)Stream.of(1, 2, 3).parallel()).collect(this.collector());
            this.assertThat(actual).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        });
    }

    private void testCollector(Runnable test) {
        if (this.isTraversableAgain()) {
            test.run();
        } else {
            try {
                this.collector();
                Assertions.fail((String)"Collections which are not traversable again should not define a Collector.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Throwable x) {
                Assertions.fail((String)"Unexpected exception", (Throwable)x);
            }
        }
    }

    static PrintStream failingPrintStream() {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new IOException();
            }
        });
    }

    static PrintWriter failingPrintWriter() {
        return new PrintWriter(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new IOException();
            }
        });
    }

    static final class NonComparable {
        final String value;

        NonComparable(String value) {
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NonComparable) {
                NonComparable that = (NonComparable)obj;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public String toString() {
            return this.value;
        }
    }
}

