/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream;

import com.aol.cyclops.javaslang.reactivestreams.reactivestream.AbstractTraversableTest;
import javaslang.collection.Traversable;
import org.junit.Test;

public abstract class AbstractTraversableRangeTest
extends AbstractTraversableTest {
    protected abstract Traversable<Character> range(char var1, char var2);

    protected abstract Traversable<Character> rangeBy(char var1, char var2, int var3);

    protected abstract Traversable<Double> rangeBy(double var1, double var3, double var5);

    protected abstract Traversable<Integer> range(int var1, int var2);

    protected abstract Traversable<Integer> rangeBy(int var1, int var2, int var3);

    protected abstract Traversable<Long> range(long var1, long var3);

    protected abstract Traversable<Long> rangeBy(long var1, long var3, long var5);

    protected abstract Traversable<Character> rangeClosed(char var1, char var2);

    protected abstract Traversable<Character> rangeClosedBy(char var1, char var2, int var3);

    protected abstract Traversable<Double> rangeClosedBy(double var1, double var3, double var5);

    protected abstract Traversable<Integer> rangeClosed(int var1, int var2);

    protected abstract Traversable<Integer> rangeClosedBy(int var1, int var2, int var3);

    protected abstract Traversable<Long> rangeClosed(long var1, long var3);

    protected abstract Traversable<Long> rangeClosedBy(long var1, long var3, long var5);

    @Test
    public void shouldCreateRangeClosedWhereFromIsGreaterThanTo() {
        this.assertThat(this.rangeClosed('b', 'a')).isEmpty();
        this.assertThat(this.rangeClosed(1, 0)).isEmpty();
        this.assertThat(this.rangeClosed(1L, 0L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeClosedWhereFromEqualsTo() {
        this.assertThat(this.rangeClosed('a', 'a')).isEqualTo(this.of(Character.valueOf('a')));
        this.assertThat(this.rangeClosed(0, 0)).isEqualTo(this.of(Integer.valueOf(0)));
        this.assertThat(this.rangeClosed(0L, 0L)).isEqualTo(this.of(Long.valueOf(0L)));
    }

    @Test
    public void shouldCreateRangeClosedWhereFromIsLessThanTo() {
        this.assertThat(this.rangeClosed('a', 'c')).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}));
        this.assertThat(this.rangeClosed(1, 3)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(this.rangeClosed(1L, 3L)).isEqualTo(this.of((T[])new Long[]{1L, 2L, 3L}));
    }

    @Test
    public void shouldCreateRangeClosedWhereFromAndToEqualMIN_VALUE() {
        this.assertThat(this.rangeClosed('\u0000', '\u0000')).isEqualTo(this.of(Character.valueOf('\u0000')));
        this.assertThat(this.rangeClosed(Integer.MIN_VALUE, Integer.MIN_VALUE)).isEqualTo(this.of(Integer.valueOf(Integer.MIN_VALUE)));
        this.assertThat(this.rangeClosed(Long.MIN_VALUE, Long.MIN_VALUE)).isEqualTo(this.of(Long.valueOf(Long.MIN_VALUE)));
    }

    @Test
    public void shouldCreateRangeClosedWhereFromAndToEqualMAX_VALUE() {
        this.assertThat(this.rangeClosed('\uffff', '\uffff')).isEqualTo(this.of(Character.valueOf('\uffff')));
        this.assertThat(this.rangeClosed(Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo(this.of(Integer.valueOf(Integer.MAX_VALUE)));
        this.assertThat(this.rangeClosed(Long.MAX_VALUE, Long.MAX_VALUE)).isEqualTo(this.of(Long.valueOf(Long.MAX_VALUE)));
    }

    @Test
    public void shouldCreateRangeClosedByWhereFromIsGreaterThanToAndStepWrongDirection() {
        this.assertThat(this.rangeClosedBy('b', 'a', 1)).isEmpty();
        this.assertThat(this.rangeClosedBy('b', 'a', 3)).isEmpty();
        this.assertThat(this.rangeClosedBy('a', 'b', -1)).isEmpty();
        this.assertThat(this.rangeClosedBy('a', 'b', -3)).isEmpty();
        this.assertThat(this.rangeClosedBy(1.0, 0.0, 1.0)).isEmpty();
        this.assertThat(this.rangeClosedBy(1.0, 0.0, 3.0)).isEmpty();
        this.assertThat(this.rangeClosedBy(0.0, 1.0, -1.0)).isEmpty();
        this.assertThat(this.rangeClosedBy(0.0, 1.0, -3.0)).isEmpty();
        this.assertThat(this.rangeClosedBy(1, 0, 1)).isEmpty();
        this.assertThat(this.rangeClosedBy(1, 0, 3)).isEmpty();
        this.assertThat(this.rangeClosedBy(0, 1, -1)).isEmpty();
        this.assertThat(this.rangeClosedBy(0, 1, -3)).isEmpty();
        this.assertThat(this.rangeClosedBy(1L, 0L, 1L)).isEmpty();
        this.assertThat(this.rangeClosedBy(1L, 0L, 3L)).isEmpty();
        this.assertThat(this.rangeClosedBy(0L, 1L, -1L)).isEmpty();
        this.assertThat(this.rangeClosedBy(0L, 1L, -3L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeClosedByWhereFromEqualsTo() {
        this.assertThat(this.rangeClosedBy('a', 'a', 1)).isEqualTo(this.of(Character.valueOf('a')));
        this.assertThat(this.rangeClosedBy('a', 'a', 3)).isEqualTo(this.of(Character.valueOf('a')));
        this.assertThat(this.rangeClosedBy('a', 'a', -1)).isEqualTo(this.of(Character.valueOf('a')));
        this.assertThat(this.rangeClosedBy('a', 'a', -3)).isEqualTo(this.of(Character.valueOf('a')));
        this.assertThat(this.rangeClosedBy(0.0, 0.0, 1.0)).isEqualTo(this.of(Double.valueOf(0.0)));
        this.assertThat(this.rangeClosedBy(0.0, 0.0, 3.0)).isEqualTo(this.of(Double.valueOf(0.0)));
        this.assertThat(this.rangeClosedBy(0.0, 0.0, -1.0)).isEqualTo(this.of(Double.valueOf(0.0)));
        this.assertThat(this.rangeClosedBy(0.0, 0.0, -3.0)).isEqualTo(this.of(Double.valueOf(0.0)));
        this.assertThat(this.rangeClosedBy(0, 0, 1)).isEqualTo(this.of(Integer.valueOf(0)));
        this.assertThat(this.rangeClosedBy(0, 0, 3)).isEqualTo(this.of(Integer.valueOf(0)));
        this.assertThat(this.rangeClosedBy(0, 0, -1)).isEqualTo(this.of(Integer.valueOf(0)));
        this.assertThat(this.rangeClosedBy(0, 0, -3)).isEqualTo(this.of(Integer.valueOf(0)));
        this.assertThat(this.rangeClosedBy(0L, 0L, 1L)).isEqualTo(this.of(Long.valueOf(0L)));
        this.assertThat(this.rangeClosedBy(0L, 0L, 3L)).isEqualTo(this.of(Long.valueOf(0L)));
        this.assertThat(this.rangeClosedBy(0L, 0L, -1L)).isEqualTo(this.of(Long.valueOf(0L)));
        this.assertThat(this.rangeClosedBy(0L, 0L, -3L)).isEqualTo(this.of(Long.valueOf(0L)));
    }

    @Test
    public void shouldCreateRangeClosedByWhereFromIsLessThanToAndStepCorrectDirection() {
        this.assertThat(this.rangeClosedBy('a', 'c', 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}));
        this.assertThat(this.rangeClosedBy('a', 'e', 2)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('c'), Character.valueOf('e')}));
        this.assertThat(this.rangeClosedBy('a', 'f', 2)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('c'), Character.valueOf('e')}));
        this.assertThat(this.rangeClosedBy('\ufffd', '\uffff', 3)).isEqualTo(this.of(Character.valueOf('\ufffd')));
        this.assertThat(this.rangeClosedBy('\ufffc', '\uffff', 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('\ufffc'), Character.valueOf('\uffff')}));
        this.assertThat(this.rangeClosedBy('c', 'a', -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('c'), Character.valueOf('b'), Character.valueOf('a')}));
        this.assertThat(this.rangeClosedBy('e', 'a', -2)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('e'), Character.valueOf('c'), Character.valueOf('a')}));
        this.assertThat(this.rangeClosedBy('e', '`', -2)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('e'), Character.valueOf('c'), Character.valueOf('a')}));
        this.assertThat(this.rangeClosedBy('\u0002', '\u0000', -3)).isEqualTo(this.of(Character.valueOf('\u0002')));
        this.assertThat(this.rangeClosedBy('\u0003', '\u0000', -3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('\u0003'), Character.valueOf('\u0000')}));
        this.assertThat(this.rangeClosedBy(1.0, 3.0, 1.0)).isEqualTo(this.of((T[])new Double[]{1.0, 2.0, 3.0}));
        this.assertThat(this.rangeClosedBy(1.0, 5.0, 2.0)).isEqualTo(this.of((T[])new Double[]{1.0, 3.0, 5.0}));
        this.assertThat(this.rangeClosedBy(1.0, 6.0, 2.0)).isEqualTo(this.of((T[])new Double[]{1.0, 3.0, 5.0}));
        this.assertThat(this.rangeClosedBy(1.5976931348623158E308, Double.MAX_VALUE, 3.0E307)).isEqualTo(this.of(Double.valueOf(1.5976931348623158E308)));
        this.assertThat(this.rangeClosedBy(3.0, 1.0, -1.0)).isEqualTo(this.of((T[])new Double[]{3.0, 2.0, 1.0}));
        this.assertThat(this.rangeClosedBy(5.0, 1.0, -2.0)).isEqualTo(this.of((T[])new Double[]{5.0, 3.0, 1.0}));
        this.assertThat(this.rangeClosedBy(5.0, 0.0, -2.0)).isEqualTo(this.of((T[])new Double[]{5.0, 3.0, 1.0}));
        this.assertThat(this.rangeClosedBy(2.0E307, Double.MIN_VALUE, -3.0E307)).isEqualTo(this.of(Double.valueOf(2.0E307)));
        this.assertThat(this.rangeClosedBy(1, 3, 1)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(this.rangeClosedBy(1, 5, 2)).isEqualTo(this.of((T[])new Integer[]{1, 3, 5}));
        this.assertThat(this.rangeClosedBy(1, 6, 2)).isEqualTo(this.of((T[])new Integer[]{1, 3, 5}));
        this.assertThat(this.rangeClosedBy(0x7FFFFFFD, Integer.MAX_VALUE, 3)).isEqualTo(this.of(Integer.valueOf(0x7FFFFFFD)));
        this.assertThat(this.rangeClosedBy(0x7FFFFFFC, Integer.MAX_VALUE, 3)).isEqualTo(this.of((T[])new Integer[]{0x7FFFFFFC, Integer.MAX_VALUE}));
        this.assertThat(this.rangeClosedBy(3, 1, -1)).isEqualTo(this.of((T[])new Integer[]{3, 2, 1}));
        this.assertThat(this.rangeClosedBy(5, 1, -2)).isEqualTo(this.of((T[])new Integer[]{5, 3, 1}));
        this.assertThat(this.rangeClosedBy(5, 0, -2)).isEqualTo(this.of((T[])new Integer[]{5, 3, 1}));
        this.assertThat(this.rangeClosedBy(-2147483646, Integer.MIN_VALUE, -3)).isEqualTo(this.of(Integer.valueOf(-2147483646)));
        this.assertThat(this.rangeClosedBy(-2147483645, Integer.MIN_VALUE, -3)).isEqualTo(this.of((T[])new Integer[]{-2147483645, Integer.MIN_VALUE}));
        this.assertThat(this.rangeClosedBy(1L, 3L, 1L)).isEqualTo(this.of((T[])new Long[]{1L, 2L, 3L}));
        this.assertThat(this.rangeClosedBy(1L, 5L, 2L)).isEqualTo(this.of((T[])new Long[]{1L, 3L, 5L}));
        this.assertThat(this.rangeClosedBy(1L, 6L, 2L)).isEqualTo(this.of((T[])new Long[]{1L, 3L, 5L}));
        this.assertThat(this.rangeClosedBy(0x7FFFFFFFFFFFFFFDL, Long.MAX_VALUE, 3L)).isEqualTo(this.of(Long.valueOf(0x7FFFFFFFFFFFFFFDL)));
        this.assertThat(this.rangeClosedBy(0x7FFFFFFFFFFFFFFCL, Long.MAX_VALUE, 3L)).isEqualTo(this.of((T[])new Long[]{0x7FFFFFFFFFFFFFFCL, Long.MAX_VALUE}));
        this.assertThat(this.rangeClosedBy(3L, 1L, -1L)).isEqualTo(this.of((T[])new Long[]{3L, 2L, 1L}));
        this.assertThat(this.rangeClosedBy(5L, 1L, -2L)).isEqualTo(this.of((T[])new Long[]{5L, 3L, 1L}));
        this.assertThat(this.rangeClosedBy(5L, 0L, -2L)).isEqualTo(this.of((T[])new Long[]{5L, 3L, 1L}));
        this.assertThat(this.rangeClosedBy(-9223372036854775806L, Long.MIN_VALUE, -3L)).isEqualTo(this.of(Long.valueOf(-9223372036854775806L)));
        this.assertThat(this.rangeClosedBy(-9223372036854775805L, Long.MIN_VALUE, -3L)).isEqualTo(this.of((T[])new Long[]{-9223372036854775805L, Long.MIN_VALUE}));
    }

    @Test
    public void shouldCreateRangeClosedByWhereFromAndToEqualMIN_VALUE() {
        this.assertThat(this.rangeClosedBy('\u0000', '\u0000', 1)).isEqualTo(this.of(Character.valueOf('\u0000')));
        this.assertThat(this.rangeClosedBy('\u0000', '\u0000', 3)).isEqualTo(this.of(Character.valueOf('\u0000')));
        this.assertThat(this.rangeClosedBy('\u0000', '\u0000', -1)).isEqualTo(this.of(Character.valueOf('\u0000')));
        this.assertThat(this.rangeClosedBy('\u0000', '\u0000', -3)).isEqualTo(this.of(Character.valueOf('\u0000')));
        this.assertThat(this.rangeClosedBy(Double.MIN_VALUE, Double.MIN_VALUE, 1.0)).isEqualTo(this.of(Double.valueOf(Double.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Double.MIN_VALUE, Double.MIN_VALUE, 3.0)).isEqualTo(this.of(Double.valueOf(Double.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Double.MIN_VALUE, Double.MIN_VALUE, -1.0)).isEqualTo(this.of(Double.valueOf(Double.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Double.MIN_VALUE, Double.MIN_VALUE, -3.0)).isEqualTo(this.of(Double.valueOf(Double.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MIN_VALUE, Integer.MIN_VALUE, 1)).isEqualTo(this.of(Integer.valueOf(Integer.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MIN_VALUE, Integer.MIN_VALUE, 3)).isEqualTo(this.of(Integer.valueOf(Integer.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MIN_VALUE, Integer.MIN_VALUE, -1)).isEqualTo(this.of(Integer.valueOf(Integer.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MIN_VALUE, Integer.MIN_VALUE, -3)).isEqualTo(this.of(Integer.valueOf(Integer.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MIN_VALUE, Long.MIN_VALUE, 1L)).isEqualTo(this.of(Long.valueOf(Long.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MIN_VALUE, Long.MIN_VALUE, 3L)).isEqualTo(this.of(Long.valueOf(Long.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MIN_VALUE, Long.MIN_VALUE, -1L)).isEqualTo(this.of(Long.valueOf(Long.MIN_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MIN_VALUE, Long.MIN_VALUE, -3L)).isEqualTo(this.of(Long.valueOf(Long.MIN_VALUE)));
    }

    @Test
    public void shouldCreateRangeClosedByWhereFromAndToEqualMAX_VALUE() {
        this.assertThat(this.rangeClosedBy('\uffff', '\uffff', 1)).isEqualTo(this.of(Character.valueOf('\uffff')));
        this.assertThat(this.rangeClosedBy('\uffff', '\uffff', 3)).isEqualTo(this.of(Character.valueOf('\uffff')));
        this.assertThat(this.rangeClosedBy('\uffff', '\uffff', -1)).isEqualTo(this.of(Character.valueOf('\uffff')));
        this.assertThat(this.rangeClosedBy('\uffff', '\uffff', -3)).isEqualTo(this.of(Character.valueOf('\uffff')));
        this.assertThat(this.rangeClosedBy(Double.MAX_VALUE, Double.MAX_VALUE, 1.0)).isEqualTo(this.of(Double.valueOf(Double.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Double.MAX_VALUE, Double.MAX_VALUE, 3.0)).isEqualTo(this.of(Double.valueOf(Double.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Double.MAX_VALUE, Double.MAX_VALUE, -1.0)).isEqualTo(this.of(Double.valueOf(Double.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Double.MAX_VALUE, Double.MAX_VALUE, -3.0)).isEqualTo(this.of(Double.valueOf(Double.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MAX_VALUE, Integer.MAX_VALUE, 1)).isEqualTo(this.of(Integer.valueOf(Integer.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MAX_VALUE, Integer.MAX_VALUE, 3)).isEqualTo(this.of(Integer.valueOf(Integer.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MAX_VALUE, Integer.MAX_VALUE, -1)).isEqualTo(this.of(Integer.valueOf(Integer.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Integer.MAX_VALUE, Integer.MAX_VALUE, -3)).isEqualTo(this.of(Integer.valueOf(Integer.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MAX_VALUE, Long.MAX_VALUE, 1L)).isEqualTo(this.of(Long.valueOf(Long.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MAX_VALUE, Long.MAX_VALUE, 3L)).isEqualTo(this.of(Long.valueOf(Long.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MAX_VALUE, Long.MAX_VALUE, -1L)).isEqualTo(this.of(Long.valueOf(Long.MAX_VALUE)));
        this.assertThat(this.rangeClosedBy(Long.MAX_VALUE, Long.MAX_VALUE, -3L)).isEqualTo(this.of(Long.valueOf(Long.MAX_VALUE)));
    }

    @Test
    public void shouldCreateRangeWhereFromIsGreaterThanTo() {
        this.assertThat(this.range('b', 'a').isEmpty());
        this.assertThat(this.range(1, 0)).isEmpty();
        this.assertThat(this.range(1L, 0L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeWhereFromEqualsTo() {
        this.assertThat(this.range('a', 'a')).isEmpty();
        this.assertThat(this.range(0, 0)).isEmpty();
        this.assertThat(this.range(0L, 0L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeWhereFromIsLessThanTo() {
        this.assertThat(this.range('a', 'c')).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}));
        this.assertThat(this.range(1, 3)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
        this.assertThat(this.range(1L, 3L)).isEqualTo(this.of((T[])new Long[]{1L, 2L}));
    }

    @Test
    public void shouldCreateRangeWhereFromAndToEqualMIN_VALUE() {
        this.assertThat(this.range('\u0000', '\u0000')).isEmpty();
        this.assertThat(this.range(Integer.MIN_VALUE, Integer.MIN_VALUE)).isEmpty();
        this.assertThat(this.range(Long.MIN_VALUE, Long.MIN_VALUE)).isEmpty();
    }

    @Test
    public void shouldCreateRangeWhereFromAndToEqualMAX_VALUE() {
        this.assertThat(this.range('\uffff', '\uffff')).isEmpty();
        this.assertThat(this.range(Integer.MAX_VALUE, Integer.MAX_VALUE)).isEmpty();
        this.assertThat(this.range(Long.MAX_VALUE, Long.MAX_VALUE)).isEmpty();
    }

    @Test
    public void shouldCreateRangeByWhereFromIsGreaterThanToAndStepWrongDirection() {
        this.assertThat(this.rangeBy('b', 'a', 1)).isEmpty();
        this.assertThat(this.rangeBy('b', 'a', 3)).isEmpty();
        this.assertThat(this.rangeBy('a', 'b', -1)).isEmpty();
        this.assertThat(this.rangeBy('a', 'b', -3)).isEmpty();
        this.assertThat(this.rangeBy(1.0, 0.0, 1.0)).isEmpty();
        this.assertThat(this.rangeBy(1.0, 0.0, 3.0)).isEmpty();
        this.assertThat(this.rangeBy(0.0, 1.0, -1.0)).isEmpty();
        this.assertThat(this.rangeBy(0.0, 1.0, -3.0)).isEmpty();
        this.assertThat(this.rangeBy(1, 0, 1)).isEmpty();
        this.assertThat(this.rangeBy(1, 0, 3)).isEmpty();
        this.assertThat(this.rangeBy(0, 1, -1)).isEmpty();
        this.assertThat(this.rangeBy(0, 1, -3)).isEmpty();
        this.assertThat(this.rangeBy(1L, 0L, 1L)).isEmpty();
        this.assertThat(this.rangeBy(1L, 0L, 3L)).isEmpty();
        this.assertThat(this.rangeBy(0L, 1L, -1L)).isEmpty();
        this.assertThat(this.rangeBy(0L, 1L, -3L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeByWithBigStep() {
        this.assertThat(this.rangeBy(3721, 2000000, 3721)).isNotEmpty();
        this.assertThat(this.rangeBy(3221000L, 200000000000L, 154221000L)).isNotEmpty();
    }

    @Test
    public void shouldCreateRangeByWhereFromEqualsTo() {
        this.assertThat(this.rangeBy('a', 'a', 1)).isEmpty();
        this.assertThat(this.rangeBy('a', 'a', 3)).isEmpty();
        this.assertThat(this.rangeBy('a', 'a', -1)).isEmpty();
        this.assertThat(this.rangeBy('a', 'a', -3)).isEmpty();
        this.assertThat(this.rangeBy(0.0, 0.0, 1.0)).isEmpty();
        this.assertThat(this.rangeBy(0.0, 0.0, 3.0)).isEmpty();
        this.assertThat(this.rangeBy(0.0, 0.0, -1.0)).isEmpty();
        this.assertThat(this.rangeBy(0.0, 0.0, -3.0)).isEmpty();
        this.assertThat(this.rangeBy(0, 0, 1)).isEmpty();
        this.assertThat(this.rangeBy(0, 0, 3)).isEmpty();
        this.assertThat(this.rangeBy(0, 0, -1)).isEmpty();
        this.assertThat(this.rangeBy(0, 0, -3)).isEmpty();
        this.assertThat(this.rangeBy(0L, 0L, 1L)).isEmpty();
        this.assertThat(this.rangeBy(0L, 0L, 3L)).isEmpty();
        this.assertThat(this.rangeBy(0L, 0L, -1L)).isEmpty();
        this.assertThat(this.rangeBy(0L, 0L, -3L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeByWhereFromIsLessThanToAndStepCorrectDirection() {
        this.assertThat(this.rangeBy('a', 'c', 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}));
        this.assertThat(this.rangeBy('a', 'd', 2)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('c')}));
        this.assertThat(this.rangeBy('c', 'a', -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('c'), Character.valueOf('b')}));
        this.assertThat(this.rangeBy('d', 'a', -2)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('d'), Character.valueOf('b')}));
        this.assertThat(this.rangeBy('\ufffc', '\uffff', 3)).isEqualTo(this.of(Character.valueOf('\ufffc')));
        this.assertThat(this.rangeBy('\ufffb', '\uffff', 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('\ufffb'), Character.valueOf('\ufffe')}));
        this.assertThat(this.rangeBy('\u0003', '\u0000', -3)).isEqualTo(this.of(Character.valueOf('\u0003')));
        this.assertThat(this.rangeBy('\u0004', '\u0000', -3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('\u0004'), Character.valueOf('\u0001')}));
        this.assertThat(this.rangeBy(1.0, 3.0, 1.0)).isEqualTo(this.of((T[])new Double[]{1.0, 2.0}));
        this.assertThat(this.rangeBy(1.0, 4.0, 2.0)).isEqualTo(this.of((T[])new Double[]{1.0, 3.0}));
        this.assertThat(this.rangeBy(3.0, 1.0, -1.0)).isEqualTo(this.of((T[])new Double[]{3.0, 2.0}));
        this.assertThat(this.rangeBy(4.0, 1.0, -2.0)).isEqualTo(this.of((T[])new Double[]{4.0, 2.0}));
        this.assertThat(this.rangeBy(1.4976931348623158E308, Double.MAX_VALUE, 3.0E307)).isEqualTo(this.of(Double.valueOf(1.4976931348623158E308)));
        this.assertThat(this.rangeBy(3.0E307, Double.MIN_VALUE, -3.0E307)).isEqualTo(this.of(Double.valueOf(3.0E307)));
        this.assertThat(this.rangeBy(1, 3, 1)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
        this.assertThat(this.rangeBy(1, 4, 2)).isEqualTo(this.of((T[])new Integer[]{1, 3}));
        this.assertThat(this.rangeBy(3, 1, -1)).isEqualTo(this.of((T[])new Integer[]{3, 2}));
        this.assertThat(this.rangeBy(4, 1, -2)).isEqualTo(this.of((T[])new Integer[]{4, 2}));
        this.assertThat(this.rangeBy(0x7FFFFFFC, Integer.MAX_VALUE, 3)).isEqualTo(this.of(Integer.valueOf(0x7FFFFFFC)));
        this.assertThat(this.rangeBy(0x7FFFFFFB, Integer.MAX_VALUE, 3)).isEqualTo(this.of((T[])new Integer[]{0x7FFFFFFB, 0x7FFFFFFE}));
        this.assertThat(this.rangeBy(-2147483645, Integer.MIN_VALUE, -3)).isEqualTo(this.of(Integer.valueOf(-2147483645)));
        this.assertThat(this.rangeBy(-2147483644, Integer.MIN_VALUE, -3)).isEqualTo(this.of((T[])new Integer[]{-2147483644, -2147483647}));
        this.assertThat(this.rangeBy(1L, 3L, 1L)).isEqualTo(this.of((T[])new Long[]{1L, 2L}));
        this.assertThat(this.rangeBy(1L, 4L, 2L)).isEqualTo(this.of((T[])new Long[]{1L, 3L}));
        this.assertThat(this.rangeBy(3L, 1L, -1L)).isEqualTo(this.of((T[])new Long[]{3L, 2L}));
        this.assertThat(this.rangeBy(4L, 1L, -2L)).isEqualTo(this.of((T[])new Long[]{4L, 2L}));
        this.assertThat(this.rangeBy(0x7FFFFFFFFFFFFFFCL, Long.MAX_VALUE, 3L)).isEqualTo(this.of(Long.valueOf(0x7FFFFFFFFFFFFFFCL)));
        this.assertThat(this.rangeBy(0x7FFFFFFFFFFFFFFBL, Long.MAX_VALUE, 3L)).isEqualTo(this.of((T[])new Long[]{0x7FFFFFFFFFFFFFFBL, 0x7FFFFFFFFFFFFFFEL}));
        this.assertThat(this.rangeBy(-9223372036854775805L, Long.MIN_VALUE, -3L)).isEqualTo(this.of(Long.valueOf(-9223372036854775805L)));
        this.assertThat(this.rangeBy(-9223372036854775804L, Long.MIN_VALUE, -3L)).isEqualTo(this.of((T[])new Long[]{-9223372036854775804L, -9223372036854775807L}));
    }

    @Test
    public void shouldCreateRangeByWhereFromAndToEqualMIN_VALUE() {
        this.assertThat(this.rangeBy('\u0000', '\u0000', 1)).isEmpty();
        this.assertThat(this.rangeBy('\u0000', '\u0000', 3)).isEmpty();
        this.assertThat(this.rangeBy('\u0000', '\u0000', -1)).isEmpty();
        this.assertThat(this.rangeBy('\u0000', '\u0000', -3)).isEmpty();
        this.assertThat(this.rangeBy(Double.MIN_VALUE, Double.MIN_VALUE, 1.0)).isEmpty();
        this.assertThat(this.rangeBy(Double.MIN_VALUE, Double.MIN_VALUE, 3.0)).isEmpty();
        this.assertThat(this.rangeBy(Double.MIN_VALUE, Double.MIN_VALUE, -1.0)).isEmpty();
        this.assertThat(this.rangeBy(Double.MIN_VALUE, Double.MIN_VALUE, -3.0)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MIN_VALUE, Integer.MIN_VALUE, 1)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MIN_VALUE, Integer.MIN_VALUE, 3)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MIN_VALUE, Integer.MIN_VALUE, -1)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MIN_VALUE, Integer.MIN_VALUE, -3)).isEmpty();
        this.assertThat(this.rangeBy(Long.MIN_VALUE, Long.MIN_VALUE, 1L)).isEmpty();
        this.assertThat(this.rangeBy(Long.MIN_VALUE, Long.MIN_VALUE, 3L)).isEmpty();
        this.assertThat(this.rangeBy(Long.MIN_VALUE, Long.MIN_VALUE, -1L)).isEmpty();
        this.assertThat(this.rangeBy(Long.MIN_VALUE, Long.MIN_VALUE, -3L)).isEmpty();
    }

    @Test
    public void shouldCreateRangeByWhereFromAndToEqualMAX_VALUE() {
        this.assertThat(this.rangeBy('\uffff', '\uffff', 1)).isEmpty();
        this.assertThat(this.rangeBy('\uffff', '\uffff', 3)).isEmpty();
        this.assertThat(this.rangeBy('\uffff', '\uffff', -1)).isEmpty();
        this.assertThat(this.rangeBy('\uffff', '\uffff', -3)).isEmpty();
        this.assertThat(this.rangeBy(Double.MAX_VALUE, Double.MAX_VALUE, 1.0)).isEmpty();
        this.assertThat(this.rangeBy(Double.MAX_VALUE, Double.MAX_VALUE, 3.0)).isEmpty();
        this.assertThat(this.rangeBy(Double.MAX_VALUE, Double.MAX_VALUE, -1.0)).isEmpty();
        this.assertThat(this.rangeBy(Double.MAX_VALUE, Double.MAX_VALUE, -3.0)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MAX_VALUE, Integer.MAX_VALUE, 1)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MAX_VALUE, Integer.MAX_VALUE, 3)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MAX_VALUE, Integer.MAX_VALUE, -1)).isEmpty();
        this.assertThat(this.rangeBy(Integer.MAX_VALUE, Integer.MAX_VALUE, -3)).isEmpty();
        this.assertThat(this.rangeBy(Long.MAX_VALUE, Long.MAX_VALUE, 1L)).isEmpty();
        this.assertThat(this.rangeBy(Long.MAX_VALUE, Long.MAX_VALUE, 3L)).isEmpty();
        this.assertThat(this.rangeBy(Long.MAX_VALUE, Long.MAX_VALUE, -1L)).isEmpty();
        this.assertThat(this.rangeBy(Long.MAX_VALUE, Long.MAX_VALUE, -3L)).isEmpty();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitCharRangeByStepZero() {
        this.rangeBy('a', 'b', 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeByStepZero() {
        this.rangeBy(0.0, 1.0, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitIntRangeByStepZero() {
        this.rangeBy(0, 1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitLongRangeByStepZero() {
        this.rangeBy(0L, 1L, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitCharRangeClosedByStepZero() {
        this.rangeClosedBy('a', 'b', 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeClosedByStepZero() {
        this.rangeClosedBy(0.0, 1.0, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitIntRangeClosedByStepZero() {
        this.rangeClosedBy(0, 1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitLongRangeClosedByStepZero() {
        this.rangeClosedBy(0L, 1L, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeByAndFromEqualsNaN() {
        this.rangeBy(Double.NaN, 0.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeByAndToEqualsNaN() {
        this.rangeBy(0.0, Double.NaN, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeByFromAndToEqualNaN() {
        this.rangeBy(Double.NaN, Double.NaN, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeClosedByAndFromEqualsNaN() {
        this.rangeClosedBy(Double.NaN, 0.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeClosedByAndToEqualsNaN() {
        this.rangeClosedBy(0.0, Double.NaN, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldProhibitDoubleRangeClosedByFromAndToEqualNaN() {
        this.rangeClosedBy(Double.NaN, Double.NaN, 1.0);
    }
}

