/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams.reactivestream;

import com.aol.cyclops.javaslang.reactivestreams.reactivestream.AbstractTraversableRangeTest;
import java.util.ArrayList;
import java.util.stream.Collector;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Seq;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSeqTest
extends AbstractTraversableRangeTest {
    protected abstract <T> Collector<T, ArrayList<T>, ? extends Seq<T>> collector();

    protected abstract <T> Seq<T> empty();

    protected abstract <T> Seq<T> of(T var1);

    protected abstract <T> Seq<T> of(T ... var1);

    protected abstract <T> Seq<T> ofAll(Iterable<? extends T> var1);

    protected abstract Seq<Boolean> ofAll(boolean[] var1);

    protected abstract Seq<Byte> ofAll(byte[] var1);

    protected abstract Seq<Character> ofAll(char[] var1);

    protected abstract Seq<Double> ofAll(double[] var1);

    protected abstract Seq<Float> ofAll(float[] var1);

    protected abstract Seq<Integer> ofAll(int[] var1);

    protected abstract Seq<Long> ofAll(long[] var1);

    protected abstract Seq<Short> ofAll(short[] var1);

    protected abstract Seq<Character> range(char var1, char var2);

    protected abstract Seq<Character> rangeBy(char var1, char var2, int var3);

    protected abstract Seq<Double> rangeBy(double var1, double var3, double var5);

    protected abstract Seq<Integer> range(int var1, int var2);

    protected abstract Seq<Integer> rangeBy(int var1, int var2, int var3);

    protected abstract Seq<Long> range(long var1, long var3);

    protected abstract Seq<Long> rangeBy(long var1, long var3, long var5);

    protected abstract Seq<Character> rangeClosed(char var1, char var2);

    protected abstract Seq<Character> rangeClosedBy(char var1, char var2, int var3);

    protected abstract Seq<Double> rangeClosedBy(double var1, double var3, double var5);

    protected abstract Seq<Integer> rangeClosed(int var1, int var2);

    protected abstract Seq<Integer> rangeClosedBy(int var1, int var2, int var3);

    protected abstract Seq<Long> rangeClosed(long var1, long var3);

    protected abstract Seq<Long> rangeClosedBy(long var1, long var3, long var5);

    @Test
    public void shouldAppendElementToNil() {
        Seq actual = this.empty().append((Object)1);
        Seq<Integer> expected = this.of((T)1);
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldAppendNullElementToNil() {
        Seq actual = this.empty().append(null);
        Seq<Integer> expected = this.of((T)null);
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldAppendElementToNonNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2}).append((Object)3);
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowOnAppendAllOfNull() {
        this.empty().appendAll(null);
    }

    @Test
    public void shouldAppendAllNilToNil() {
        Seq actual = this.empty().appendAll(this.empty());
        Seq expected = this.empty();
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldAppendAllNonNilToNil() {
        Seq actual = this.empty().appendAll(this.of((T[])new Integer[]{1, 2, 3}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldAppendAllNilToNonNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).appendAll(this.empty());
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldAppendAllNonNilToNonNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).appendAll(this.of((T[])new Integer[]{4, 5, 6}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3, 4, 5, 6});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldUseSeqAsPartialFunction() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).apply(Integer.valueOf(1))).isEqualTo(2);
    }

    @Test
    public void shouldComputeCombinationsOfEmptyList() {
        this.assertThat((Iterable)this.of((T)this.empty()).get(0)).isEqualTo(this.empty().combinations().get(0));
    }

    @Test
    public void shouldComputeCombinationsOfNonEmptyList() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).combinations().map(r -> r.toList())).isEqualTo(this.of((T[])new List[]{List.empty(), List.of((Object)1), List.of((Object)2), List.of((Object)3), List.of((Object[])new Integer[]{1, 2}), List.of((Object[])new Integer[]{1, 3}), List.of((Object[])new Integer[]{2, 3}), List.of((Object[])new Integer[]{1, 2, 3})}));
    }

    @Test
    public void shouldComputeKCombinationsOfEmptyList() {
        this.assertThat(this.empty().combinations(1)).isEmpty();
    }

    @Test
    public void shouldComputeKCombinationsOfNonEmptyList() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).combinations(2)).isEqualTo(this.of((T[])new Seq[]{this.of((T[])new Integer[]{1, 2}), this.of((T[])new Integer[]{1, 3}), this.of((T[])new Integer[]{2, 3})}));
    }

    @Test
    public void shouldComputeKCombinationsOfNegativeK() {
        Assert.assertTrue((boolean)((Seq)this.of((T)1).combinations(-1).get()).isEmpty());
    }

    @Test
    public void shouldRecognizeNilNotContainsSlice() {
        boolean actual = this.empty().containsSlice(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(actual).isFalse();
    }

    @Test
    public void shouldRecognizeNonNilDoesContainSlice() {
        boolean actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).containsSlice(this.of((T[])new Integer[]{2, 3}));
        this.assertThat(actual).isTrue();
    }

    @Test
    public void shouldRecognizeNonNilDoesNotContainSlice() {
        boolean actual = this.of((T[])new Integer[]{1, 2, 3, 4, 5}).containsSlice(this.of((T[])new Integer[]{2, 1, 4}));
        this.assertThat(actual).isFalse();
    }

    @Test
    public void shouldCalculateCrossProductOfNil() {
        Seq actual = this.empty().crossProduct();
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldCalculateCrossProductOfNonNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).crossProduct();
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)1), Tuple.of((Object)1, (Object)2), Tuple.of((Object)1, (Object)3), Tuple.of((Object)2, (Object)1), Tuple.of((Object)2, (Object)2), Tuple.of((Object)2, (Object)3), Tuple.of((Object)3, (Object)1), Tuple.of((Object)3, (Object)2), Tuple.of((Object)3, (Object)3)});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldCalculateCrossProductPower() {
        Seq<Seq> expected = this.of((T[])new Seq[]{this.of((T[])new Integer[]{1, 1}), this.of((T[])new Integer[]{1, 2}), this.of((T[])new Integer[]{2, 1}), this.of((T[])new Integer[]{2, 2})});
        this.assertThat(this.of((T[])new Integer[]{1, 2}).crossProduct(2)).isEqualTo(expected);
    }

    @Test
    public void shouldCalculateCrossProductOfNilAndNil() {
        Seq actual = this.empty().crossProduct(this.empty());
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldCalculateCrossProductOfNilAndNonNil() {
        Seq actual = this.empty().crossProduct(this.of((T[])new Integer[]{1, 2, 3}));
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldCalculateCrossProductOfNonNilAndNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).crossProduct(this.empty());
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldCalculateCrossProductOfNonNilAndNonNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).crossProduct(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}));
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)Character.valueOf('a')), Tuple.of((Object)1, (Object)Character.valueOf('b')), Tuple.of((Object)2, (Object)Character.valueOf('a')), Tuple.of((Object)2, (Object)Character.valueOf('b')), Tuple.of((Object)3, (Object)Character.valueOf('a')), Tuple.of((Object)3, (Object)Character.valueOf('b'))});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowWhenCalculatingCrossProductAndThatIsNull() {
        this.empty().crossProduct(null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenGetWithNegativeIndexOnNil() {
        this.empty().get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenGetWithNegativeIndexOnNonNil() {
        this.of((T)1).get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenGetOnNil() {
        this.empty().get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenGetWithTooBigIndexOnNonNil() {
        this.of((T)1).get(1);
    }

    @Test
    public void shouldGetFirstElement() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).get(0)).isEqualTo(1);
    }

    @Test
    public void shouldGetLastElement() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).get(2)).isEqualTo(3);
    }

    @Test
    public void shouldNotFindIndexOfElementWhenSeqIsEmpty() {
        this.assertThat(this.empty().indexOf((Object)1)).isEqualTo(-1);
    }

    @Test
    public void shouldNotFindIndexOfElementWhenStartIsGreater() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).indexOf((Object)2, 2)).isEqualTo(-1);
    }

    @Test
    public void shouldFindIndexOfFirstElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).indexOf((Object)1)).isEqualTo(0);
    }

    @Test
    public void shouldFindIndexOfInnerElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).indexOf((Object)2)).isEqualTo(1);
    }

    @Test
    public void shouldFindIndexOfLastElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).indexOf((Object)3)).isEqualTo(2);
    }

    @Test
    public void shouldNotFindIndexOfSliceWhenSeqIsEmpty() {
        this.assertThat(this.empty().indexOfSlice(this.of((T[])new Integer[]{2, 3}))).isEqualTo(-1);
    }

    @Test
    public void shouldNotFindIndexOfSliceWhenStartIsGreater() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).indexOfSlice(this.of((T[])new Integer[]{2, 3}), 2)).isEqualTo(-1);
    }

    @Test
    public void shouldFindIndexOfFirstSlice() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).indexOfSlice(this.of((T[])new Integer[]{1, 2}))).isEqualTo(0);
    }

    @Test
    public void shouldFindIndexOfInnerSlice() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).indexOfSlice(this.of((T[])new Integer[]{2, 3}))).isEqualTo(1);
    }

    @Test
    public void shouldFindIndexOfLastSlice() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).indexOfSlice(this.of((T[])new Integer[]{2, 3}))).isEqualTo(1);
    }

    @Test
    public void shouldNotFindLastIndexOfElementWhenSeqIsEmpty() {
        this.assertThat(this.empty().lastIndexOf((Object)1)).isEqualTo(-1);
    }

    @Test
    public void shouldNotFindLastIndexOfElementWhenEndIdLess() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4}).lastIndexOf((Object)3, 1)).isEqualTo(-1);
    }

    @Test
    public void shouldFindLastIndexOfElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).lastIndexOf((Object)1)).isEqualTo(3);
    }

    @Test
    public void shouldFindLastIndexOfElementWithEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).lastIndexOf((Object)1, 1)).isEqualTo(0);
    }

    @Test
    public void shouldNotFindLastIndexOfSliceWhenSeqIsEmpty() {
        this.assertThat(this.empty().lastIndexOfSlice(this.of((T[])new Integer[]{2, 3}))).isEqualTo(-1);
    }

    @Test
    public void shouldNotFindLastIndexOfSliceWhenEndIdLess() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4, 5}).lastIndexOfSlice(this.of((T[])new Integer[]{3, 4}), 1)).isEqualTo(-1);
    }

    @Test
    public void shouldFindLastIndexOfSlice() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2}).lastIndexOfSlice(this.empty())).isEqualTo(5);
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2}).lastIndexOfSlice(this.of((T)2))).isEqualTo(4);
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3, 4}).lastIndexOfSlice(this.of((T[])new Integer[]{2, 3}))).isEqualTo(4);
    }

    @Test
    public void shouldFindLastIndexOfSliceWithEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).lastIndexOfSlice(this.empty(), 2)).isEqualTo(2);
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).lastIndexOfSlice(this.of((T)2), 2)).isEqualTo(1);
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).lastIndexOfSlice(this.of((T[])new Integer[]{2, 3}), 2)).isEqualTo(1);
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3, 4}).lastIndexOfSlice(this.of((T[])new Integer[]{2, 3}), 2)).isEqualTo(1);
    }

    @Test
    public void shouldInsertIntoNil() {
        Seq actual = this.empty().insert(0, (Object)1);
        Seq<Integer> expected = this.of((T)1);
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldInsertInFrontOfElement() {
        Seq actual = this.of((T)4).insert(0, (Object)1);
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 4});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldInsertBehindOfElement() {
        Seq actual = this.of((T)4).insert(1, (Object)1);
        Seq<Integer> expected = this.of((T[])new Integer[]{4, 1});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldInsertIntoSeq() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).insert(2, (Object)4);
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 4, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenInsertOnNonNilWithNegativeIndex() {
        this.of((T)1).insert(-1, null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenInsertOnNilWithNegativeIndex() {
        this.empty().insert(-1, null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnInsertWhenExceedingUpperBound() {
        this.empty().insert(1, null);
    }

    @Test
    public void shouldInserAlltIntoNil() {
        Seq actual = this.empty().insertAll(0, this.of((T[])new Integer[]{1, 2, 3}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldInsertAllInFrontOfElement() {
        Seq actual = this.of((T)4).insertAll(0, this.of((T[])new Integer[]{1, 2, 3}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3, 4});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldInsertAllBehindOfElement() {
        Seq actual = this.of((T)4).insertAll(1, this.of((T[])new Integer[]{1, 2, 3}));
        Seq<Integer> expected = this.of((T[])new Integer[]{4, 1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldInsertAllIntoSeq() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).insertAll(2, this.of((T[])new Integer[]{4, 5}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 4, 5, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowOnInsertAllWithNil() {
        this.empty().insertAll(0, null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenInsertOnNonNilAllWithNegativeIndex() {
        this.of((T)1).insertAll(-1, this.empty());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenInsertOnNilAllWithNegativeIndex() {
        this.empty().insertAll(-1, this.empty());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnInsertAllWhenExceedingUpperBound() {
        this.empty().insertAll(1, this.empty());
    }

    @Test
    public void shouldIntersperseNil() {
        this.assertThat(this.empty().intersperse((Object)Character.valueOf(','))).isEmpty();
    }

    @Test
    public void shouldIntersperseSingleton() {
        this.assertThat(this.of((T)Character.valueOf('a')).intersperse((Object)Character.valueOf(','))).isEqualTo(this.of((T)Character.valueOf('a')));
    }

    @Test
    public void shouldIntersperseMultipleElements() {
        this.assertThat(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}).intersperse((Object)Character.valueOf(','))).isEqualTo(this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf(','), Character.valueOf('b')}));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenNilIteratorStartingAtIndex() {
        this.empty().iterator(1);
    }

    @Test
    public void shouldIterateFirstElementOfNonNilStartingAtIndex() {
        this.assertThat((Integer)this.of((T[])new Integer[]{1, 2, 3}).iterator(1).next()).isEqualTo(2);
    }

    @Test
    public void shouldFullyIterateNonNilStartingAtIndex() {
        int actual = -1;
        Iterator iter = this.of((T[])new Integer[]{1, 2, 3}).iterator(1);
        while (iter.hasNext()) {
            actual = (Integer)iter.next();
        }
        this.assertThat(actual).isEqualTo(3);
    }

    @Test
    public void shouldPadEmptyToEmpty() {
        Assert.assertTrue((boolean)this.empty().padTo(0, (Object)1).isEmpty());
    }

    @Test
    public void shouldPadEmptyToNonEmpty() {
        this.assertThat(this.empty().padTo(2, (Object)1)).isEqualTo(this.of((T[])new Integer[]{1, 1}));
    }

    @Test
    public void shouldPadNonEmptyZeroLen() {
        Seq<Integer> seq = this.of((T)1);
        this.assertThat(seq.padTo(0, (Object)2)).isEqualTo(seq);
    }

    @Test
    public void shouldPadNonEmpty() {
        this.assertThat(this.of((T)1).padTo(2, (Object)1)).isEqualTo(this.of((T[])new Integer[]{1, 1}));
        this.assertThat(this.of((T)1).padTo(2, (Object)2)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
        this.assertThat(this.of((T)1).padTo(3, (Object)2)).isEqualTo(this.of((T[])new Integer[]{1, 2, 2}));
    }

    @Test
    public void shouldPatchEmptyByEmpty() {
        this.assertThat(this.empty().patch(0, this.empty(), 0)).isEmpty();
        this.assertThat(this.empty().patch(-1, this.empty(), -1)).isEmpty();
        this.assertThat(this.empty().patch(-1, this.empty(), 1)).isEmpty();
        this.assertThat(this.empty().patch(1, this.empty(), -1)).isEmpty();
        this.assertThat(this.empty().patch(1, this.empty(), 1)).isEmpty();
    }

    @Test
    public void shouldPatchEmptyByNonEmpty() {
        Seq<Character> s = this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')});
        this.assertThat(this.empty().patch(0, s, 0)).isEqualTo(s);
        this.assertThat(this.empty().patch(-1, s, -1)).isEqualTo(s);
        this.assertThat(this.empty().patch(-1, s, 1)).isEqualTo(s);
        this.assertThat(this.empty().patch(1, s, -1)).isEqualTo(s);
        this.assertThat(this.empty().patch(1, s, 1)).isEqualTo(s);
    }

    @Test
    public void shouldPatchNonEmptyByEmpty() {
        Seq<Character> s = this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')});
        this.assertThat(s.patch(-1, this.empty(), -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(-1, this.empty(), 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(-1, this.empty(), 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(-1, this.empty(), 3)).isEmpty();
        this.assertThat(s.patch(0, this.empty(), -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(0, this.empty(), 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(0, this.empty(), 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(0, this.empty(), 3)).isEmpty();
        this.assertThat(s.patch(1, this.empty(), -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(1, this.empty(), 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(1, this.empty(), 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('3')}));
        this.assertThat(s.patch(1, this.empty(), 3)).isEqualTo(this.of((T)Character.valueOf('1')));
        this.assertThat(s.patch(4, this.empty(), -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(4, this.empty(), 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(4, this.empty(), 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(4, this.empty(), 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
    }

    @Test
    public void shouldPatchNonEmptyByNonEmpty() {
        Seq<Character> s = this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')});
        Seq<Character> d = this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')});
        this.assertThat(s.patch(-1, d, -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(-1, d, 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(-1, d, 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(-1, d, 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
        this.assertThat(s.patch(0, d, -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(0, d, 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(0, d, 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(0, d, 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
        this.assertThat(s.patch(1, d, -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(1, d, 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('2'), Character.valueOf('3')}));
        this.assertThat(s.patch(1, d, 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('3')}));
        this.assertThat(s.patch(1, d, 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
        this.assertThat(s.patch(4, d, -1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
        this.assertThat(s.patch(4, d, 0)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
        this.assertThat(s.patch(4, d, 1)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
        this.assertThat(s.patch(4, d, 3)).isEqualTo(this.of((T[])new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6')}));
    }

    @Test
    public void shouldComputePermutationsOfEmptyList() {
        this.assertThat(this.empty().permutations()).isEmpty();
    }

    @Test
    public void shouldComputePermutationsOfNonEmptyList() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).permutations()).isEqualTo(this.ofAll((Iterable)this.of((T[])new Seq[]{this.of((T[])new Integer[]{1, 2, 3}), this.of((T[])new Integer[]{1, 3, 2}), this.of((T[])new Integer[]{2, 1, 3}), this.of((T[])new Integer[]{2, 3, 1}), this.of((T[])new Integer[]{3, 1, 2}), this.of((T[])new Integer[]{3, 2, 1})})));
    }

    @Test
    public void shouldPrependElementToNil() {
        Seq actual = this.empty().prepend((Object)1);
        Seq<Integer> expected = this.of((T)1);
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldPrependElementToNonNil() {
        Seq actual = this.of((T[])new Integer[]{2, 3}).prepend((Object)1);
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowOnPrependAllOfNull() {
        this.empty().prependAll(null);
    }

    @Test
    public void shouldPrependAllNilToNil() {
        Seq actual = this.empty().prependAll(this.empty());
        Seq expected = this.empty();
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldPrependAllNilToNonNil() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).prependAll(this.empty());
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldPrependAllNonNilToNil() {
        Seq actual = this.empty().prependAll(this.of((T[])new Integer[]{1, 2, 3}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldPrependAllNonNilToNonNil() {
        Seq actual = this.of((T[])new Integer[]{4, 5, 6}).prependAll(this.of((T[])new Integer[]{1, 2, 3}));
        Seq<Integer> expected = this.of((T[])new Integer[]{1, 2, 3, 4, 5, 6});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldRemoveElementFromNil() {
        this.assertThat(this.empty().remove(null)).isEmpty();
    }

    @Test
    public void shouldRemoveFirstElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).remove((Object)1)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldRemoveLastElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).remove((Object)3)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldRemoveInnerElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).remove((Object)2)).isEqualTo(this.of((T[])new Integer[]{1, 3}));
    }

    @Test
    public void shouldRemoveNonExistingElement() {
        Seq<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(t.remove((Object)4)).isEqualTo(t);
        } else {
            this.assertThat(t.remove((Object)4)).isSameAs(t);
        }
    }

    @Test
    public void shouldRemoveFirstElementByPredicateFromNil() {
        this.assertThat(this.empty().removeFirst(v -> true)).isEmpty();
    }

    @Test
    public void shouldRemoveFirstElementByPredicateBegin() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeFirst(v -> v == 1)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldRemoveFirstElementByPredicateBeginM() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 1, 3}).removeFirst(v -> v == 1)).isEqualTo(this.of((T[])new Integer[]{2, 1, 3}));
    }

    @Test
    public void shouldRemoveFirstElementByPredicateEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeFirst(v -> v == 3)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldRemoveFirstElementByPredicateInner() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4, 5}).removeFirst(v -> v == 3)).isEqualTo(this.of((T[])new Integer[]{1, 2, 4, 5}));
    }

    @Test
    public void shouldRemoveFirstElementByPredicateInnerM() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 2, 5}).removeFirst(v -> v == 2)).isEqualTo(this.of((T[])new Integer[]{1, 3, 2, 5}));
    }

    @Test
    public void shouldRemoveFirstElementByPredicateNonExisting() {
        Seq<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(t.removeFirst(v -> v == 4)).isEqualTo(t);
        } else {
            this.assertThat(t.removeFirst(v -> v == 4)).isSameAs(t);
        }
    }

    @Test
    public void shouldRemoveLastElementByPredicateFromNil() {
        this.assertThat(this.empty().removeLast(v -> true)).isEmpty();
    }

    @Test
    public void shouldRemoveLastElementByPredicateBegin() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeLast(v -> v == 1)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldRemoveLastElementByPredicateEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeLast(v -> v == 3)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldRemoveLastElementByPredicateEndM() {
        this.assertThat(this.of((T[])new Integer[]{1, 3, 2, 3}).removeLast(v -> v == 3)).isEqualTo(this.of((T[])new Integer[]{1, 3, 2}));
    }

    @Test
    public void shouldRemoveLastElementByPredicateInner() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 4, 5}).removeLast(v -> v == 3)).isEqualTo(this.of((T[])new Integer[]{1, 2, 4, 5}));
    }

    @Test
    public void shouldRemoveLastElementByPredicateInnerM() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 2, 5}).removeLast(v -> v == 2)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3, 5}));
    }

    @Test
    public void shouldRemoveLastElementByPredicateNonExisting() {
        Seq<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(t.removeLast(v -> v == 4)).isEqualTo(t);
        } else {
            this.assertThat(t.removeLast(v -> v == 4)).isSameAs(t);
        }
    }

    @Test
    public void shouldRemoveAllElementsFromNil() {
        this.assertThat(this.empty().removeAll(this.of((T[])new Integer[]{1, 2, 3}))).isEmpty();
    }

    @Test
    public void shouldRemoveAllExistingElementsFromNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).removeAll(this.of((T[])new Integer[]{1, 2}))).isEqualTo(this.of((T[])new Integer[]{3, 3}));
    }

    @Test
    public void shouldNotRemoveAllNonExistingElementsFromNonNil() {
        Seq<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(t.removeAll(this.of((T[])new Integer[]{4, 5}))).isEqualTo(t);
        } else {
            this.assertThat(t.removeAll(this.of((T[])new Integer[]{4, 5}))).isSameAs(t);
        }
    }

    @Test
    public void shouldRemoveAllObjectsFromNil() {
        this.assertThat(this.empty().removeAll((Object)1)).isEmpty();
    }

    @Test
    public void shouldRemoveAllExistingObjectsFromNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3, 1, 2, 3}).removeAll((Object)1)).isEqualTo(this.of((T[])new Integer[]{2, 3, 2, 3}));
    }

    @Test
    public void shouldNotRemoveAllNonObjectsElementsFromNonNil() {
        Seq<Integer> t = this.of((T[])new Integer[]{1, 2, 3});
        if (this.useIsEqualToInsteadOfIsSameAs()) {
            this.assertThat(t.removeAll((Object)4)).isEqualTo(t);
        } else {
            this.assertThat(t.removeAll((Object)4)).isSameAs(t);
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldRemoveIndxAtNil() {
        this.assertThat(this.empty().removeAt(1)).isEmpty();
    }

    @Test
    public void shouldRemoveIndxAtNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeAt(1)).isEqualTo(this.of((T[])new Integer[]{1, 3}));
    }

    @Test
    public void shouldRemoveIndxAtBegin() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeAt(0)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldRemoveIndxAtEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeAt(2)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldRemoveIndxOutOfBoundsLeft() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeAt(-1)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldRemoveIndxOutOfBoundsRight() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).removeAt(5)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void shouldReverseNil() {
        this.assertThat(this.empty().reverse()).isEmpty();
    }

    @Test
    public void shouldReverseNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).reverse()).isEqualTo(this.of((T[])new Integer[]{3, 2, 1}));
    }

    @Test
    public void shouldCreateReverseIteratorOfEmpty() {
        this.assertThat(Seq.ofAll(this.empty()).reverseIterator()).isEmpty();
    }

    @Test
    public void shouldCreateReverseIteratorOfSingle() {
        this.assertThat(Seq.ofAll(this.of((T)"a")).reverseIterator().toList()).isEqualTo((Object)Iterator.of((Object)"a").toList());
    }

    @Test
    public void shouldCreateReverseIteratorOfNonEmpty() {
        this.assertThat(Seq.ofAll(this.of((T[])new String[]{"a", "b", "c"})).reverseIterator().toList()).isEqualTo((Object)Iterator.of((Object[])new String[]{"c", "b", "a"}).toList());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSetWithNegativeIndexOnNil() {
        this.empty().update(-1, null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSetWithNegativeIndexOnNonNil() {
        this.of((T)1).update(-1, (Object)2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSetOnNil() {
        this.empty().update(0, null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSetWithIndexExceedingByOneOnNonNil() {
        this.of((T)1).update(1, (Object)2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSetWithIndexExceedingByTwoOnNonNil() {
        this.of((T)1).update(2, (Object)2);
    }

    @Test
    public void shouldSetFirstElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).update(0, (Object)4)).isEqualTo(this.of((T[])new Integer[]{4, 2, 3}));
    }

    @Test
    public void shouldSetLastElement() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).update(2, (Object)4)).isEqualTo(this.of((T[])new Integer[]{1, 2, 4}));
    }

    @Test
    public void shouldReturnNilWhenSliceFrom0To0OnNil() {
        Seq actual = this.empty().slice(0L, 0L);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnNilWhenSliceFrom0To0OnNonNil() {
        Seq actual = this.of((T)1).slice(0L, 0L);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnSeqWithFirstElementWhenSliceFrom0To1OnNonNil() {
        Seq actual = this.of((T)1).slice(0L, 1L);
        this.assertThat(actual).isEqualTo(this.of((T)1));
    }

    @Test
    public void shouldReturnNilWhenSliceFrom1To1OnNonNil() {
        Seq actual = this.of((T)1).slice(1L, 1L);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnSliceWhenIndicesAreWithinRange() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).slice(1L, 3L);
        this.assertThat(actual).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldReturnNilOnSliceWhenIndicesBothAreUpperBound() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).slice(3L, 3L);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldComputeSliceOnNonNilWhenBeginIndexIsGreaterThanEndIndex() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).slice(1L, 0L)).isEmpty();
    }

    @Test
    public void shouldComputeSliceOnNilWhenBeginIndexIsGreaterThanEndIndex() {
        this.assertThat(this.empty().slice(1L, 0L)).isEmpty();
    }

    @Test
    public void shouldComputeSliceOnNonNilWhenBeginIndexExceedsLowerBound() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).slice(-1L, 2L)).isEqualTo(this.of((T[])new Integer[]{1, 2}));
    }

    @Test
    public void shouldComputeSliceOnNilWhenBeginIndexExceedsLowerBound() {
        this.assertThat(this.empty().slice(-1L, 2L)).isEmpty();
    }

    @Test
    public void shouldThrowWhenSlice2OnNil() {
        this.assertThat(this.empty().slice(0L, 1L)).isEmpty();
    }

    @Test
    public void shouldComputeSliceWhenEndIndexExceedsUpperBound() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).slice(1L, 4L)).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldComputeSliceWhenBeginIndexIsGreaterThanEndIndex() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).slice(2L, 1L)).isEmpty();
    }

    @Test
    public void shouldComputeSliceWhenBeginIndexAndEndIndexAreBothOutOfBounds() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).slice(-10L, 10L)).isEqualTo(this.of((T[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void shouldSortNil() {
        this.assertThat(this.empty().sort()).isEmpty();
    }

    @Test
    public void shouldSortNonNil() {
        this.assertThat(this.of((T[])new Integer[]{3, 4, 1, 2}).sort()).isEqualTo(this.of((T[])new Integer[]{1, 2, 3, 4}));
    }

    @Test
    public void shouldSortNilUsingComparator() {
        this.assertThat(this.empty().sort((i, j) -> j - i)).isEmpty();
    }

    @Test
    public void shouldSortNonNilUsingComparator() {
        this.assertThat(this.of((T[])new Integer[]{3, 4, 1, 2}).sort((i, j) -> j - i)).isEqualTo(this.of((T[])new Integer[]{4, 3, 2, 1}));
    }

    @Test
    public void shouldSortByNilUsingFunction() {
        this.assertThat(this.empty().sortBy(String::length)).isEmpty();
    }

    @Test
    public void shouldSortByNonNilUsingFunction() {
        Seq<String> testee = this.of((T[])new String[]{"aaa", "b", "cc"});
        Seq actual = testee.sortBy(String::length);
        Seq<String> expected = this.of((T[])new String[]{"b", "cc", "aaa"});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldSortByNilUsingComparatorAndFunction() {
        this.assertThat(this.empty().sortBy(String::length)).isEmpty();
    }

    @Test
    public void shouldSortByNonNilUsingComparatorAndFunction() {
        Seq<String> testee = this.of((T[])new String[]{"aaa", "b", "cc"});
        Seq actual = testee.sortBy((i1, i2) -> i2 - i1, String::length);
        Seq<String> expected = this.of((T[])new String[]{"aaa", "cc", "b"});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldSplitAtNil() {
        this.assertThat(this.empty().splitAt(1L)).isEqualTo((Object)Tuple.of(this.empty(), this.empty()));
    }

    @Test
    public void shouldSplitAtNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(1L)).isEqualTo((Object)Tuple.of(this.of((T)1), this.of((T[])new Integer[]{2, 3})));
    }

    @Test
    public void shouldSplitAtBegin() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(0L)).isEqualTo((Object)Tuple.of(this.empty(), this.of((T[])new Integer[]{1, 2, 3})));
    }

    @Test
    public void shouldSplitAtEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(3L)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2, 3}), this.empty()));
    }

    @Test
    public void shouldSplitAtOutOfBounds() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(5L)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2, 3}), this.empty()));
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(-1L)).isEqualTo((Object)Tuple.of(this.empty(), this.of((T[])new Integer[]{1, 2, 3})));
    }

    @Test
    public void shouldSplitPredicateAtNil() {
        this.assertThat(this.empty().splitAt(e -> true)).isEqualTo((Object)Tuple.of(this.empty(), this.empty()));
    }

    @Test
    public void shouldSplitPredicateAtNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(e -> e == 2)).isEqualTo((Object)Tuple.of(this.of((T)1), this.of((T[])new Integer[]{2, 3})));
    }

    @Test
    public void shouldSplitAtPredicateBegin() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(e -> e == 1)).isEqualTo((Object)Tuple.of(this.empty(), this.of((T[])new Integer[]{1, 2, 3})));
    }

    @Test
    public void shouldSplitAtPredicateEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(e -> e == 3)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2}), this.of((T)3)));
    }

    @Test
    public void shouldSplitAtPredicateNotFound() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAt(e -> e == 5)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2, 3}), this.empty()));
    }

    @Test
    public void shouldSplitInclusivePredicateAtNil() {
        this.assertThat(this.empty().splitAtInclusive(e -> true)).isEqualTo((Object)Tuple.of(this.empty(), this.empty()));
    }

    @Test
    public void shouldSplitInclusivePredicateAtNonNil() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAtInclusive(e -> e == 2)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2}), this.of((T)3)));
    }

    @Test
    public void shouldSplitAtInclusivePredicateBegin() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAtInclusive(e -> e == 1)).isEqualTo((Object)Tuple.of(this.of((T)1), this.of((T[])new Integer[]{2, 3})));
    }

    @Test
    public void shouldSplitAtInclusivePredicateEnd() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAtInclusive(e -> e == 3)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2, 3}), this.empty()));
    }

    @Test
    public void shouldSplitAtInclusivePredicateNotFound() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).splitAtInclusive(e -> e == 5)).isEqualTo((Object)Tuple.of(this.of((T[])new Integer[]{1, 2, 3}), this.empty()));
    }

    @Test
    public void shouldStartsNilOfNilCalculate() {
        this.assertThat(this.empty().startsWith(this.empty())).isTrue();
    }

    @Test
    public void shouldStartsNilOfNonNilCalculate() {
        this.assertThat(this.empty().startsWith(this.of((T)1))).isFalse();
    }

    @Test
    public void shouldStartsNilOfNilWithOffsetCalculate() {
        this.assertThat(this.empty().startsWith(this.empty(), 1)).isTrue();
    }

    @Test
    public void shouldStartsNilOfNonNilWithOffsetCalculate() {
        this.assertThat(this.empty().startsWith(this.of((T)1), 1)).isFalse();
    }

    @Test
    public void shouldStartsNonNilOfNilCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.empty())).isTrue();
    }

    @Test
    public void shouldStartsNonNilOfNonNilCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{1, 2}))).isTrue();
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{1, 2, 3}))).isTrue();
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{1, 2, 3, 4}))).isFalse();
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{1, 3}))).isFalse();
    }

    @Test
    public void shouldStartsNonNilOfNilWithOffsetCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.empty(), 1)).isTrue();
    }

    @Test
    public void shouldNotStartsNonNilOfNonNilWithNegativeOffsetCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T)1), -1)).isFalse();
    }

    @Test
    public void shouldNotStartsNonNilOfNonNilWithOffsetEqualLengthCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T)3), 3)).isFalse();
    }

    @Test
    public void shouldNotStartsNonNilOfNonNilWithOffsetEndCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T)3), 2)).isTrue();
    }

    @Test
    public void shouldStartsNonNilOfNonNilWithOffsetAtStartCalculate() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T)1), 0)).isTrue();
    }

    @Test
    public void shouldStartsNonNilOfNonNilWithOffsetCalculate1() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{2, 3}), 1)).isTrue();
    }

    @Test
    public void shouldStartsNonNilOfNonNilWithOffsetCalculate2() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{2, 3, 4}), 1)).isFalse();
    }

    @Test
    public void shouldStartsNonNilOfNonNilWithOffsetCalculate3() {
        this.assertThat(this.of((T[])new Integer[]{1, 2, 3}).startsWith(this.of((T[])new Integer[]{2, 4}), 1)).isFalse();
    }

    @Test
    public void shouldReturnNilWhenSubSequenceFrom0OnNil() {
        Seq actual = this.empty().subSequence(0);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnIdentityWhenSubSequenceFrom0OnNonNil() {
        Seq actual = this.of((T)1).subSequence(0);
        this.assertThat(actual).isEqualTo(this.of((T)1));
    }

    @Test
    public void shouldReturnNilWhenSubSequenceFrom1OnSeqOf1() {
        Seq actual = this.of((T)1).subSequence(1);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnSubSequenceWhenIndexIsWithinRange() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).subSequence(1);
        this.assertThat(actual).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldReturnNilWhenSubSequenceBeginningWithSize() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).subSequence(3);
        this.assertThat(actual).isEmpty();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSubSequenceOnNil() {
        this.empty().subSequence(1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSubSequenceWithOutOfLowerBound() {
        this.of((T[])new Integer[]{1, 2, 3}).subSequence(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSubSequenceWithOutOfUpperBound() {
        this.of((T[])new Integer[]{1, 2, 3}).subSequence(4);
    }

    @Test
    public void shouldReturnNilWhenSubSequenceFrom0To0OnNil() {
        Seq actual = this.empty().subSequence(0, 0);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnNilWhenSubSequenceFrom0To0OnNonNil() {
        Seq actual = this.of((T)1).subSequence(0, 0);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnSeqWithFirstElementWhenSubSequenceFrom0To1OnNonNil() {
        Seq actual = this.of((T)1).subSequence(0, 1);
        this.assertThat(actual).isEqualTo(this.of((T)1));
    }

    @Test
    public void shouldReturnNilWhenSubSequenceFrom1To1OnNonNil() {
        Seq actual = this.of((T)1).subSequence(1, 1);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldReturnSubSequenceWhenIndicesAreWithinRange() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).subSequence(1, 3);
        this.assertThat(actual).isEqualTo(this.of((T[])new Integer[]{2, 3}));
    }

    @Test
    public void shouldReturnNilWhenOnSubSequenceIndicesBothAreUpperBound() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).subSequence(3, 3);
        this.assertThat(actual).isEmpty();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnSubSequenceOnNonNilWhenBeginIndexIsGreaterThanEndIndex() {
        this.of((T[])new Integer[]{1, 2, 3}).subSequence(1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnSubSequenceOnNilWhenBeginIndexIsGreaterThanEndIndex() {
        this.empty().subSequence(1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnSubSequenceOnNonNilWhenBeginIndexExceedsLowerBound() {
        this.of((T[])new Integer[]{1, 2, 3}).subSequence(-1, 2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnSubSequenceOnNilWhenBeginIndexExceedsLowerBound() {
        this.empty().subSequence(-1, 2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowWhenSubSequence2OnNil() {
        this.empty().subSequence(0, 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnSubSequenceWhenEndIndexExceedsUpperBound() {
        this.of((T[])new Integer[]{1, 2, 3}).subSequence(1, 4).mkString();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldThrowOnSubSequenceWhenBeginIndexIsGreaterThanEndIndex() {
        this.of((T[])new Integer[]{1, 2, 3}).subSequence(2, 1).mkString();
    }

    @Test
    public void shouldUnzipNil() {
        this.assertThat(this.empty().unzip(x -> Tuple.of((Object)x, (Object)x))).isEqualTo((Object)Tuple.of(this.empty(), this.empty()));
    }

    @Test
    public void shouldUnzipNonNil() {
        Tuple2 actual = this.of((T[])new Integer[]{0, 1}).unzip(i -> Tuple.of((Object)i, (Object)Character.valueOf((char)(97 + i))));
        Tuple2 expected = Tuple.of(this.of((T[])new Integer[]{0, 1}), this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldUnzip3Nil() {
        this.assertThat(this.empty().unzip3(x -> Tuple.of((Object)x, (Object)x, (Object)x))).isEqualTo((Object)Tuple.of(this.empty(), this.empty(), this.empty()));
    }

    @Test
    public void shouldUnzip3NonNil() {
        Tuple3 actual = this.of((T[])new Integer[]{0, 1}).unzip3(i -> Tuple.of((Object)i, (Object)Character.valueOf((char)(97 + i)), (Object)Character.valueOf((char)(97 + i + 1))));
        Tuple3 expected = Tuple.of(this.of((T[])new Integer[]{0, 1}), this.of((T[])new Character[]{Character.valueOf('a'), Character.valueOf('b')}), this.of((T[])new Character[]{Character.valueOf('b'), Character.valueOf('c')}));
        this.assertThat(actual).isEqualTo((Object)expected);
    }

    @Test
    public void shouldZipNils() {
        Seq actual = this.empty().zip(this.empty());
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldZipEmptyAndNonNil() {
        Seq actual = this.empty().zip(this.of((T)1));
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldZipNonEmptyAndNil() {
        Seq actual = this.of((T)1).zip(this.empty());
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldZipNonNilsIfThisIsSmaller() {
        Seq actual = this.of((T[])new Integer[]{1, 2}).zip(this.of((T[])new String[]{"a", "b", "c"}));
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)"a"), Tuple.of((Object)2, (Object)"b")});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldZipNonNilsIfThatIsSmaller() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).zip(this.of((T[])new String[]{"a", "b"}));
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)"a"), Tuple.of((Object)2, (Object)"b")});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldZipNonNilsOfSameSize() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).zip(this.of((T[])new String[]{"a", "b", "c"}));
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)"a"), Tuple.of((Object)2, (Object)"b"), Tuple.of((Object)3, (Object)"c")});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfZipWithThatIsNull() {
        this.empty().zip(null);
    }

    @Test
    public void shouldZipAllNils() {
        Seq actual = this.empty().zipAll(this.empty(), null, null);
        this.assertThat(actual).isEmpty();
    }

    @Test
    public void shouldZipAllEmptyAndNonNil() {
        Seq actual = this.empty().zipAll(this.of((T)1), null, null);
        Seq<Tuple2> expected = this.of((T)Tuple.of(null, (Object)1));
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldZipAllNonEmptyAndNil() {
        Seq actual = this.of((T)1).zipAll(this.empty(), null, null);
        Seq<Tuple2> expected = this.of((T)Tuple.of((Object)1, null));
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldZipAllNonNilsIfThisIsSmaller() {
        Seq actual = this.of((T[])new Integer[]{1, 2}).zipAll(this.of((T[])new String[]{"a", "b", "c"}), (Object)9, (Object)"z");
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)"a"), Tuple.of((Object)2, (Object)"b"), Tuple.of((Object)9, (Object)"c")});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldZipAllNonNilsIfThatIsSmaller() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).zipAll(this.of((T[])new String[]{"a", "b"}), (Object)9, (Object)"z");
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)"a"), Tuple.of((Object)2, (Object)"b"), Tuple.of((Object)3, (Object)"z")});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void shouldZipAllNonNilsOfSameSize() {
        Seq actual = this.of((T[])new Integer[]{1, 2, 3}).zipAll(this.of((T[])new String[]{"a", "b", "c"}), (Object)9, (Object)"z");
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)1, (Object)"a"), Tuple.of((Object)2, (Object)"b"), Tuple.of((Object)3, (Object)"c")});
        this.assertThat(actual).isEqualTo(expected);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfZipAllWithThatIsNull() {
        this.empty().zipAll(null, null, null);
    }

    @Test
    public void shouldZipNilWithIndex() {
        this.assertThat(this.empty().zipWithIndex()).isEqualTo(this.empty());
    }

    @Test
    public void shouldZipNonNilWithIndex() {
        Seq actual = this.of((T[])new String[]{"a", "b", "c"}).zipWithIndex();
        Seq<Tuple2> expected = this.of((T[])new Tuple2[]{Tuple.of((Object)"a", (Object)0L), Tuple.of((Object)"b", (Object)1L), Tuple.of((Object)"c", (Object)2L)});
        this.assertThat(actual).isEqualTo(expected);
    }
}

