/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.streams;

import com.aol.cyclops.javaslang.ToStream;
import com.aol.cyclops.javaslang.streams.StreamUtils;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.HeadAndTail;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.Reducers;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.streamable.AsStreamable;
import com.aol.cyclops.sequence.streamable.Streamable;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javaslang.collection.HashMap;
import javaslang.collection.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StreamUtilsTest {
    int count;

    @Test
    public void headTailReplay() {
        javaslang.collection.Stream helloWorld = javaslang.collection.Stream.ofAll((Object[])new String[]{"hello", "world", "last"});
        HeadAndTail headAndTail = StreamUtils.headAndTail((javaslang.collection.Stream)helloWorld);
        String head = (String)headAndTail.head();
        Assert.assertThat((Object)head, (Matcher)Matchers.equalTo((Object)"hello"));
        SequenceM tail = headAndTail.tail();
        Assert.assertThat((Object)tail.headAndTail().head(), (Matcher)Matchers.equalTo((Object)"world"));
    }

    @Test
    public void headTailReplayOptional() {
        javaslang.collection.Stream helloWorld = javaslang.collection.Stream.ofAll((Object[])new String[]{"hello", "world", "last"});
        HeadAndTail headAndTail = (HeadAndTail)StreamUtils.headAndTailOptional((javaslang.collection.Stream)helloWorld).get();
        String head = (String)headAndTail.head();
        Assert.assertThat((Object)head, (Matcher)Matchers.equalTo((Object)"hello"));
        SequenceM tail = headAndTail.tail();
        Assert.assertThat((Object)tail.headAndTail().head(), (Matcher)Matchers.equalTo((Object)"world"));
    }

    @Test
    public void headTailReplayOptionalEmpty() {
        javaslang.collection.Stream helloWorld = javaslang.collection.Stream.ofAll((Object[])new String[0]);
        Optional headAndTail = StreamUtils.headAndTailOptional((javaslang.collection.Stream)helloWorld);
        Assert.assertTrue((!headAndTail.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testToLazyCollection() {
        System.out.println(StreamUtils.toLazyCollection((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 4})).size());
    }

    @Test
    public void testOfType() {
        Assert.assertThat((Object)StreamUtils.ofType((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}), Integer.class).toJavaList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Integer.class).toList(), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{"a", "b", null})));
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Serializable.class).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3)}));
    }

    @Test
    public void testCastPast() {
        SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).cast(Date.class).map(d -> d.getTime());
    }

    @Test
    public void testIntersperse() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[]{1, 2, 3}).intersperse((Object)0).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 0, 2, 0, 3)));
    }

    @Test
    public void testReverse() {
        Assert.assertThat((Object)StreamUtils.reverse((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3})).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testReversedStream() {
        StreamUtils.reversedStream((javaslang.collection.List)javaslang.collection.List.ofAll(Arrays.asList(1, 2, 3))).map(i -> i * 100).forEach(System.out::println);
        Assert.assertThat((Object)StreamUtils.reversedStream((javaslang.collection.List)javaslang.collection.List.ofAll((Object[])new Integer[]{1, 2, 3})).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testCycleStreamOfU() {
        Assert.assertThat((Object)StreamUtils.cycle((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3})).take(6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testCycleStreamableOfU() {
        Assert.assertThat((Object)StreamUtils.cycle((Streamable)AsStreamable.fromStream((Stream)ToStream.toSequenceM((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3})))).take(6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testStreamIterableOfU() {
        Assert.assertThat((Object)StreamUtils.stream(Arrays.asList(1, 2, 3)).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testStreamIteratorOfU() {
        Assert.assertThat((Object)StreamUtils.stream(Arrays.asList(1, 2, 3).iterator()).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testStreamMapOfKV() {
        java.util.HashMap<String, String> map = new java.util.HashMap<String, String>();
        map.put("hello", "world");
        Assert.assertThat((Object)StreamUtils.stream(map).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(new AbstractMap.SimpleEntry<String, String>("hello", "world"))));
    }

    @Test
    public void testStreamMapOfKVJavaslang() {
        HashMap map = HashMap.empty().put((Object)"hello", (Object)"world");
        Assert.assertThat((Object)StreamUtils.stream((Map)map).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(new AbstractMap.SimpleEntry<String, String>("hello", "world"))));
    }

    @Test
    public void testCollectorsStreamable() {
        List result = StreamUtils.collect((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), (Streamable)Streamable.of((Object[])new Collector[]{Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)})).toJavaList();
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testCollectors2() {
        List result = StreamUtils.collect((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), (javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Collector[]{Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)})).toJavaList();
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testCollectorsIterables() {
        List result = StreamUtils.collect((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), Arrays.asList(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue))).toJavaList();
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void reducer() {
        Monoid concat = Monoid.of((Object)"", (a, b) -> a + b);
        Monoid join = Monoid.of((Object)"", (a, b) -> a + "," + b);
        Assert.assertThat((Object)StreamUtils.reduce((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new String[]{"hello", "world", "woo!"}), (javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Monoid[]{concat, join})), (Matcher)Matchers.equalTo((Object)javaslang.collection.List.ofAll((Object[])new String[]{"helloworldwoo!", ",hello,world,woo!"})));
    }

    @Test
    public void reducer2() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        javaslang.collection.List result = StreamUtils.reduce((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 4}), Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)javaslang.collection.List.ofAll((Object[])new Integer[]{10, 24})));
    }

    @Test
    public void testCollectors() {
        List result = StreamUtils.collect((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), Arrays.asList(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue))).toJavaList();
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testCycleWhile() {
        this.count = 0;
        Assert.assertThat((Object)StreamUtils.cycleWhile((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 2}), next -> this.count++ < 6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleUntil() {
        this.count = 0;
        Assert.assertThat((Object)StreamUtils.cycleUntil((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 2, 3}), next -> this.count++ > 10).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 3, 1, 2, 2, 3, 1, 2, 2)));
    }

    @Test
    public void testCycle() {
        Assert.assertThat((Object)StreamUtils.cycle((int)3, (Streamable)Streamable.of((Object[])new Integer[]{1, 2, 2})).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleReduce() {
        Assert.assertThat((Object)StreamUtils.cycle((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 2}), (Monoid)Reducers.toCountInt(), (int)3).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 3, 3)));
    }

    @Test
    public void testSkipUntil() {
        Assert.assertThat((Object)StreamUtils.skipUntil((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{4, 3, 6, 7}), i -> i == 6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipWhile() {
        Assert.assertThat((Object)StreamUtils.skipWhile((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{4, 3, 6, 7}).sort(), i -> i < 6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testLimitWhile() {
        Assert.assertThat((Object)StreamUtils.limitWhile((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{4, 3, 6, 7}).sort(), i -> i < 6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4)));
    }

    @Test
    public void testLimitUntil() {
        Assert.assertThat((Object)StreamUtils.limitUntil((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{4, 3, 6, 7}), i -> i == 6).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void zipOptional() {
        javaslang.collection.Stream zipped = StreamUtils.zipAnyM((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), (AnyM)AnyM.fromOptional(Optional.of(2)), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.toJavaList().get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipOptionalSequence() {
        javaslang.collection.Stream zipped = StreamUtils.zipAnyM((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), (AnyM)AnyM.fromOptional(Optional.of(2)), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.toJavaList().get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipStream() {
        javaslang.collection.Stream zipped = StreamUtils.zipStream((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), Stream.of(2, 3, 4), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.toJavaList().get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void zipSequence() {
        javaslang.collection.Stream zipped = StreamUtils.zipSequence((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), (javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{2, 3, 4}), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.toJavaList().get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void sliding() {
        List list = StreamUtils.sliding((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 4, 5, 6}), (int)2).map(l -> l.toJavaList()).toJavaList();
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{2, 3}));
    }

    @Test
    public void grouped() {
        List list = StreamUtils.batchBySize((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 4, 5, 6}), (int)3).map(l -> l.toJavaList()).toJavaList();
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void startsWith() {
        Assert.assertTrue((boolean)StreamUtils.startsWith((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 4}), Arrays.asList(1, 2, 3)));
    }

    @Test
    public void startsWithIterator() {
        Assert.assertTrue((boolean)StreamUtils.startsWith((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 4}), Arrays.asList(1, 2, 3).iterator()));
    }

    @Test
    public void scanLeft() {
        Assert.assertEquals(Arrays.asList("", "a", "ab", "abc"), (Object)StreamUtils.scanLeft((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new String[]{"a", "b", "c"}), (Monoid)Reducers.toString((String)"")).toJavaList());
    }

    @Test
    public void xMatch() {
        Assert.assertTrue((boolean)StreamUtils.xMatch((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3, 5, 6, 7}), (int)3, i -> i > 4));
    }

    @Test
    public void testIntersperse2() {
        Assert.assertThat((Object)StreamUtils.intersperse((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), (Object)0).toJavaList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 0, 2, 0, 3)));
    }

    @Test(expected=ClassCastException.class)
    public void cast() {
        StreamUtils.cast((javaslang.collection.Stream)javaslang.collection.Stream.ofAll((Object[])new Integer[]{1, 2, 3}), String.class).toJavaList();
    }
}

