/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.caching;

import com.aol.cyclops.functions.TriFunction;
import com.aol.cyclops.functions.caching.Cacheable;
import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.javaslang.caching.Memoize;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Function0;
import javaslang.Function1;
import javaslang.Function2;
import javaslang.Function4;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoiseTest {
    int called = 0;

    @Before
    public void setup() {
        this.called = 0;
    }

    @Test
    public void testMemoiseSupplier() {
        Function0 s = Memoize.memoizeFunction0((Function0 & Serializable)() -> ++this.called);
        Assert.assertThat((Object)s.get(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.get(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.get(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.get(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testMemoiseCallable() throws Exception {
        Callable s = Memoize.memoizeCallable(() -> ++this.called);
        Assert.assertThat(s.call(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(s.call(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(s.call(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(s.call(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testMemoiseFunction() {
        Function s = Memoize.memoizeFunction((Function1 & Serializable)a -> a + ++this.called);
        Assert.assertThat(s.apply(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(s.apply(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(s.apply(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(s.apply(1), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat(s.apply(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testMemoiseBiFunction() {
        Function2 s = Memoize.memoizeBiFunction((Function2 & Serializable)(a, b) -> a + ++this.called);
        Assert.assertThat((Object)s.apply((Object)0, (Object)1), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.apply((Object)0, (Object)1), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.apply((Object)0, (Object)1), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.apply((Object)1, (Object)1), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)s.apply((Object)1, (Object)1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testMemoiseBiFunctionWithCache() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        Cacheable cacheable = (key, fn) -> {
            try {
                return (Integer)cache.get(key, () -> (Integer)fn.apply(key));
            }
            catch (ExecutionException e) {
                throw ExceptionSoftener.throwSoftenedException((Throwable)e);
            }
        };
        Function2 s = Memoize.memoizeBiFunction((Function2 & Serializable)(a, b) -> a + ++this.called, (Cacheable)cacheable);
        Assert.assertThat((Object)s.apply((Object)0, (Object)1), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.apply((Object)0, (Object)1), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.apply((Object)0, (Object)1), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)s.apply((Object)1, (Object)1), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)s.apply((Object)1, (Object)1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testMemoisePredicate() {
        Predicate s = Memoize.memoizePredicate(a -> a == ++this.called);
        Assert.assertThat((Object)s.test(0), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)s.test(0), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)s.test(2), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)s.test(2), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testMemoiseTriFunction() {
        TriFunction cached = com.aol.cyclops.functions.caching.Memoize.memoizeTriFunction(this::mult);
        Assert.assertThat((Object)cached.apply((Object)1, (Object)2, (Object)3), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)cached.apply((Object)1, (Object)2, (Object)3), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)cached.apply((Object)1, (Object)2, (Object)3), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)this.called, (Matcher)Matchers.equalTo((Object)1));
    }

    private int mult(int a, int b, int c) {
        ++this.called;
        return a * b * c;
    }

    @Test
    public void testMemoiseQuadFunction() {
        Function4 cached = Memoize.memoizeQuadFunction(this::addAll);
        Assert.assertThat((Object)cached.apply((Object)1, (Object)2, (Object)3, (Object)4), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)cached.apply((Object)1, (Object)2, (Object)3, (Object)4), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)cached.apply((Object)1, (Object)2, (Object)3, (Object)4), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)this.called, (Matcher)Matchers.equalTo((Object)1));
    }

    private int addAll(int a, int b, int c, int d) {
        ++this.called;
        return a + b + c + d;
    }
}

