/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.streams;

import com.aol.cyclops.javaslang.FromJDK;
import com.aol.cyclops.javaslang.streams.JavaslangHotStream;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.streams.spliterators.ClosingSpliterator;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javaslang.collection.Stream;
import uk.co.real_logic.agrona.concurrent.OneToOneConcurrentArrayQueue;

public class HotStreamImpl<T>
implements JavaslangHotStream<T> {
    private final Stream<T> stream;
    private final AtomicReferenceArray<Queue<T>> connections = new AtomicReferenceArray(10);
    private final AtomicBoolean open = new AtomicBoolean(true);
    private volatile int connected = 0;

    public HotStreamImpl(Stream<T> stream) {
        this.stream = stream;
    }

    public JavaslangHotStream<T> init(Executor exec) {
        CompletableFuture.runAsync(() -> {
            this.stream.forEach(a -> {
                int local = this.connected;
                for (int i = 0; i < local; ++i) {
                    this.connections.get(i).offer(a);
                }
            });
            this.open.set(false);
            System.out.println("finished!");
        }, exec);
        return this;
    }

    @Override
    public Stream<T> connect() {
        return this.connect((Queue<T>)new OneToOneConcurrentArrayQueue(256));
    }

    @Override
    public Stream<T> connect(Queue<T> queue) {
        this.connections.getAndSet(this.connected, queue);
        ++this.connected;
        return FromJDK.stream(SequenceM.fromStream(StreamSupport.stream(new ClosingSpliterator(Long.MAX_VALUE, queue, this.open), false)));
    }

    @Override
    public <R extends Stream<T>> R connectTo(Queue<T> queue, Function<Stream<T>, R> to) {
        return (R)((Stream)to.apply(this.connect(queue)));
    }
}

