/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.forcomprehensions;

import com.aol.cyclops.javaslang.forcomprehensions.Do;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MixedDoTest {
    @Test
    public void mixedCompletableFutureStream() {
        CompletableFuture<String> future = CompletableFuture.supplyAsync(this::loadData);
        CompletableFuture results1 = (CompletableFuture)Do.add(future).addStream(() -> Stream.of("first", "second")).yield(loadedData -> local -> loadedData + ":" + local).unwrap();
        CompletionStage results2 = CompletableFuture.supplyAsync(this::loadData).thenApply(loadedData -> Stream.of("first", "second").map(local -> loadedData + ":" + local).collect(Collectors.toList()));
        Assert.assertThat(results1.join(), (Matcher)Matchers.equalTo(((CompletableFuture)results2).join()));
    }

    @Test
    public void mixedStreamCompletableFuture() {
        Stream results1 = (Stream)Do.addStream(Stream.of("first", "second")).add(CompletableFuture.supplyAsync(this::loadData)).yield(local -> loadedData -> loadedData + ":" + local).unwrap();
        Stream<String> results2 = Stream.of("first", "second").map(local -> CompletableFuture.supplyAsync(this::loadData).join() + ":" + local);
        Assert.assertThat(results1.collect(Collectors.toList()), (Matcher)Matchers.equalTo(results2.collect(Collectors.toList())));
    }

    private String loadData() {
        return "loaded";
    }

    @Test
    public void mixedOptionalEither() {
    }
}

