/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.streams;

import com.aol.cyclops.javaslang.streams.StreamUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import javaslang.collection.Stream;
import org.junit.Assert;
import org.junit.Test;

public class HotStreamTest {
    static final Executor exec = Executors.newFixedThreadPool(1);
    volatile Object value;

    @Test
    public void hotStream() throws InterruptedException {
        this.value = null;
        CountDownLatch latch = new CountDownLatch(1);
        StreamUtils.hotStream((Stream)Stream.ofAll((Object[])new Integer[]{1, 2, 3}).peek(v -> {
            this.value = v;
        }).peek(v -> latch.countDown()), (Executor)exec);
        latch.await();
        Assert.assertTrue((this.value != null ? 1 : 0) != 0);
    }

    @Test
    public void hotStreamConnect() throws InterruptedException {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(i);
            this.value = null;
            CountDownLatch latch = new CountDownLatch(1);
            StreamUtils.futureOperations((Stream)StreamUtils.hotStream((Stream)Stream.range((int)0, (int)Integer.MAX_VALUE).take(100).peek(v -> {
                this.value = v;
            }).peek(v -> latch.countDown()).peek(System.out::println), (Executor)exec).connect().take(100), (Executor)ForkJoinPool.commonPool()).forEach(System.out::println);
            latch.await();
            Assert.assertTrue((this.value != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void hotStreamConnectBlockingQueue() throws InterruptedException {
        this.value = null;
        CountDownLatch latch = new CountDownLatch(1);
        StreamUtils.futureOperations((Stream)StreamUtils.hotStream((Stream)Stream.range((int)0, (int)Integer.MAX_VALUE).take(1000).peek(v -> {
            this.value = v;
        }).peek(v -> latch.countDown()), (Executor)exec).connect(new LinkedBlockingQueue()).take(100), (Executor)ForkJoinPool.commonPool()).forEach(System.out::println);
        latch.await();
        Assert.assertTrue((this.value != null ? 1 : 0) != 0);
    }
}

