/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.streams;

import com.aol.cyclops.closures.mutable.Mutable;
import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.javaslang.FromJDK;
import com.aol.cyclops.javaslang.ToStream;
import com.aol.cyclops.javaslang.streams.HotStreamImpl;
import com.aol.cyclops.javaslang.streams.JavaslangHotStream;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.HeadAndTail;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SeqUtils;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.future.FutureOperations;
import com.aol.cyclops.sequence.streamable.AsStreamable;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.streams.future.FutureOperationsImpl;
import com.aol.cyclops.streams.operators.MultiCollectOperator;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Tuple4;
import javaslang.collection.Map;
import javaslang.collection.Set;
import javaslang.collection.Stream;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public final class StreamUtils {
    private static final Object UNSET = new Object();

    public static final <T> Optional<javaslang.collection.List<T>> streamToOptional(Stream<T> stream) {
        javaslang.collection.List collected = stream.toList();
        if (collected.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(collected);
    }

    public static final <T> Stream<T> optionalToStream(Optional<T> optional) {
        if (optional.isPresent()) {
            return Stream.ofAll((Object[])new Object[]{optional.get()});
        }
        return Stream.empty();
    }

    public static final <T> CompletableFuture<javaslang.collection.List<T>> streamToCompletableFuture(Stream<T> stream) {
        return CompletableFuture.completedFuture(stream.toList());
    }

    public static final <T> Stream<T> completableFutureToStream(CompletableFuture<T> future) {
        return Stream.ofAll((Object[])new Object[]{future.join()});
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> splitAt(Stream<T> stream, int where) {
        Tuple2<Stream<T>, Stream<T>> tuple2 = StreamUtils.duplicate(stream);
        return new Tuple2((Object)((Stream)tuple2._1).take(where), (Object)((Stream)tuple2._2).drop(where));
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> splitBy(Stream<T> stream, Predicate<T> splitter) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicate(stream);
        return new Tuple2(StreamUtils.limitWhile((Stream)Tuple22._1, splitter), StreamUtils.skipWhile((Stream)Tuple22._2, splitter));
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> partition(Stream<T> stream, Predicate<T> splitter) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicate(stream);
        return new Tuple2((Object)((Stream)Tuple22._1).filter(splitter), (Object)((Stream)Tuple22._2).filter(splitter.negate()));
    }

    public static final <T> Tuple2<Stream<T>, Stream<T>> duplicate(Stream<T> stream) {
        Tuple2 Tuple22 = StreamUtils.toBufferingDuplicator(stream.iterator());
        return new Tuple2(StreamUtils.stream((Iterator)Tuple22._1()), StreamUtils.stream((Iterator)Tuple22._2()));
    }

    private static final <T> Tuple2<Stream<T>, Stream<T>> duplicatePos(Stream<T> stream, int pos) {
        Tuple2 Tuple22 = StreamUtils.toBufferingDuplicator(stream.iterator(), pos);
        return new Tuple2(StreamUtils.stream((Iterator)Tuple22._1()), StreamUtils.stream((Iterator)Tuple22._2()));
    }

    public static final <T> Tuple3<Stream<T>, Stream<T>, Stream<T>> triplicate(Stream<T> stream) {
        Stream its = Stream.ofAll((Iterable)StreamUtils.toBufferingCopier(stream.iterator(), 3).map(it -> StreamUtils.stream(it)));
        javaslang.collection.Iterator it2 = its.iterator();
        return new Tuple3(it2.next(), it2.next(), it2.next());
    }

    public static final <T> Tuple4<Stream<T>, Stream<T>, Stream<T>, Stream<T>> quadruplicate(Stream<T> stream) {
        Stream its = Stream.ofAll((Iterable)StreamUtils.toBufferingCopier(stream.iterator(), 4).map(it -> StreamUtils.stream(it)));
        javaslang.collection.Iterator it2 = its.iterator();
        return new Tuple4(it2.next(), it2.next(), it2.next(), it2.next());
    }

    public static final <T> Stream<T> appendStream(Stream<T> stream1, Stream<T> append) {
        return stream1.appendAll(append);
    }

    public static final <T> Stream<T> prependStream(Stream<T> stream1, Stream<T> prepend) {
        return stream1.prependAll(prepend);
    }

    public static final <T> Stream<T> append(Stream<T> stream, T ... values) {
        return StreamUtils.appendStream(stream, Stream.ofAll((Object[])values));
    }

    public static final <T> Stream<T> prepend(Stream<T> stream, T ... values) {
        return StreamUtils.appendStream(Stream.ofAll((Object[])values), stream);
    }

    public static final <T> Stream<T> insertAt(Stream<T> stream, int pos, T ... values) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicatePos(stream, pos);
        return StreamUtils.appendStream(StreamUtils.append(((Stream)Tuple22._1).take(pos), values), ((Stream)Tuple22._2).drop(pos));
    }

    public static final <T> Stream<T> deleteBetween(Stream<T> stream, int start, int end) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicatePos(stream, start);
        return StreamUtils.appendStream(((Stream)Tuple22._1).take(start), ((Stream)Tuple22._2).drop(end));
    }

    public static final <T> Stream<T> insertStreamAt(Stream<T> stream1, int pos, Stream<T> insert) {
        Tuple2<Stream<T>, Stream<T>> Tuple22 = StreamUtils.duplicatePos(stream1, pos);
        return StreamUtils.appendStream(StreamUtils.appendStream(((Stream)Tuple22._1).take(pos), insert), ((Stream)Tuple22._2).drop(pos));
    }

    public static final <T> Stream<T> cycle(Stream<T> stream, Monoid<T> m, int times) {
        return StreamUtils.cycle(times, AsStreamable.fromObject((Object)m.reduce(ToStream.toSequenceM(stream))));
    }

    public static final <T> HeadAndTail<T> headAndTail(Stream<T> stream) {
        javaslang.collection.Iterator it = stream.iterator();
        return new HeadAndTail(it.next(), SequenceM.fromIterable(() -> StreamUtils.lambda$headAndTail$92((Iterator)it)));
    }

    public static final <T> Optional<HeadAndTail<T>> headAndTailOptional(Stream<T> stream) {
        javaslang.collection.Iterator it = stream.iterator();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(new HeadAndTail(it.next(), SequenceM.fromIterable(() -> StreamUtils.lambda$headAndTailOptional$93((Iterator)it))));
    }

    public static <U> Stream<U> skipUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return StreamUtils.skipWhile(stream, predicate.negate());
    }

    public static <U> Stream<U> skipLast(Stream<U> stream, int num) {
        return FromJDK.stream(ToStream.toSequenceM(stream).skipLast(num));
    }

    public static <U> Stream<U> limitLast(Stream<U> stream, int num) {
        return FromJDK.stream(ToStream.toSequenceM(stream).limitLast(num));
    }

    public static <T> Stream<T> recover(Stream<T> stream, Function<Throwable, T> fn) {
        return FromJDK.stream(ToStream.toSequenceM(stream).recover(fn));
    }

    public static <T, EX extends Throwable> Stream<T> recover(Stream<T> stream, Class<EX> type, Function<EX, T> fn) {
        return FromJDK.stream(ToStream.toSequenceM(stream).recover(type, fn));
    }

    public static <U> Stream<U> skipWhile(Stream<U> stream, Predicate<? super U> predicate) {
        return FromJDK.stream(ToStream.toSequenceM(stream).skipWhile(predicate));
    }

    public static <U> Stream<U> limit(Stream<U> stream, long time, TimeUnit unit) {
        return FromJDK.stream(ToStream.toSequenceM(stream).limit(time, unit));
    }

    public static <U> Stream<U> skip(Stream<U> stream, long time, TimeUnit unit) {
        return FromJDK.stream(ToStream.toSequenceM(stream).skip(time, unit));
    }

    public static <U> Stream<U> limitWhile(Stream<U> stream, Predicate<? super U> predicate) {
        return FromJDK.stream(ToStream.toSequenceM(stream).limitWhile(predicate));
    }

    public static <U> Stream<U> limitUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return StreamUtils.limitWhile(stream, predicate.negate());
    }

    public static <U> Stream<U> reverse(Stream<U> stream) {
        return stream.reverse();
    }

    public static <U> Stream<U> reversedStream(javaslang.collection.List<U> list) {
        return Stream.ofAll(list).reverse();
    }

    public static <U> Stream<U> cycle(Stream<U> s) {
        return StreamUtils.cycle(AsStreamable.fromStream(ToStream.toSequenceM(s)));
    }

    public static <U> Stream<U> cycle(Streamable<U> s) {
        return Stream.gen(FromJDK.stream(s.stream()), s1 -> FromJDK.stream(s.stream())).flatten();
    }

    public static <U> Stream<U> cycle(int times, Streamable<U> s) {
        return Stream.gen(FromJDK.stream(s.stream()), s1 -> FromJDK.stream(s.stream())).take(times).flatten();
    }

    public static <U> Stream<U> stream(Iterable<U> it) {
        return Stream.ofAll(it);
    }

    public static <U> Stream<U> stream(Spliterator<U> it) {
        return FromJDK.stream(StreamSupport.stream(it, false));
    }

    public static <U> Stream<U> stream(Iterator<U> it) {
        return Stream.ofAll(() -> it);
    }

    public static <U> Stream<U> concat(Object o, Stream<U> stream) {
        Object first = null;
        first = o instanceof Stream ? (Stream<U>)o : (o instanceof Iterable ? StreamUtils.stream((Iterable)o) : (o instanceof Streamable ? FromJDK.stream(((Streamable)o).stream()) : Stream.ofAll((Object[])new Object[]{o})));
        return first.appendAll(stream);
    }

    public static final <K, V> Stream<Map.Entry<K, V>> stream(java.util.Map<K, V> it) {
        return FromJDK.stream(it.entrySet().stream());
    }

    public static final <K, V> Stream<Map.Entry<K, V>> stream(Map<K, V> it) {
        return it.toStream().map(t -> new AbstractMap.SimpleEntry<Object, Object>(t._1, t._2));
    }

    public static final <T> FutureOperations<T> futureOperations(Stream<T> stream, Executor exec) {
        return new FutureOperationsImpl(exec, ToStream.toSequenceM(stream));
    }

    public static final <T> T firstValue(Stream<T> stream) {
        return ToStream.toSequenceM(stream).findAny().get();
    }

    public static <R> javaslang.collection.List<R> reduce(Stream<R> stream, Iterable<Monoid<R>> reducers) {
        return javaslang.collection.List.ofAll((Iterable)ToStream.toSequenceM(stream).reduce(reducers));
    }

    public static <R> javaslang.collection.List<R> reduce(Stream<R> stream, Stream<Monoid<R>> reducers) {
        return javaslang.collection.List.ofAll((Iterable)ToStream.toSequenceM(stream).reduce(reducers));
    }

    public static <T, A, R> javaslang.collection.List<R> collect(Stream<T> stream, Stream<Collector> collectors) {
        return StreamUtils.collect(stream, (Streamable<Collector>)AsStreamable.fromStream(ToStream.toSequenceM(collectors)));
    }

    public static <T, A, R> javaslang.collection.List<R> collect(Stream<T> stream, Iterable<Collector> collectors) {
        return StreamUtils.collect(stream, (Streamable<Collector>)AsStreamable.fromIterable(collectors));
    }

    public static <T> javaslang.collection.List collect(Stream<T> stream, Streamable<Collector> collectors) {
        return javaslang.collection.List.ofAll((Iterable)new MultiCollectOperator(ToStream.toSequenceM(stream)).collect(collectors));
    }

    public static final <T> Stream<T> cycleWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamUtils.limitWhile(StreamUtils.cycle(stream), predicate);
    }

    public static final <T> Stream<T> cycleUntil(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamUtils.limitUntil(StreamUtils.cycle(stream), predicate);
    }

    public static final <T, S, R> Stream<R> zipSequence(Stream<T> stream, Stream<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        javaslang.collection.Iterator left = stream.iterator();
        javaslang.collection.Iterator right = second.iterator();
        return StreamUtils.stream(new Iterator<R>((Iterator)left, (Iterator)right, zipper){
            final /* synthetic */ Iterator val$left;
            final /* synthetic */ Iterator val$right;
            final /* synthetic */ BiFunction val$zipper;
            {
                this.val$left = iterator;
                this.val$right = iterator2;
                this.val$zipper = biFunction;
            }

            @Override
            public boolean hasNext() {
                return this.val$left.hasNext() && this.val$right.hasNext();
            }

            @Override
            public R next() {
                return this.val$zipper.apply(this.val$left.next(), this.val$right.next());
            }
        });
    }

    public static final <T, S, R> Stream<R> zipAnyM(Stream<T> stream, AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.zipSequence(stream, FromJDK.stream(second.toSequence()), zipper);
    }

    public static final <T, S, R> Stream<R> zipStream(Stream<T> stream, BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        javaslang.collection.Iterator left = stream.iterator();
        Iterator<? extends S> right = second.iterator();
        return StreamUtils.stream(new Iterator<R>((Iterator)left, right, zipper){
            final /* synthetic */ Iterator val$left;
            final /* synthetic */ Iterator val$right;
            final /* synthetic */ BiFunction val$zipper;
            {
                this.val$left = iterator;
                this.val$right = iterator2;
                this.val$zipper = biFunction;
            }

            @Override
            public boolean hasNext() {
                return this.val$left.hasNext() && this.val$right.hasNext();
            }

            @Override
            public R next() {
                return this.val$zipper.apply(this.val$left.next(), this.val$right.next());
            }
        });
    }

    public static final <T> Stream<javaslang.collection.List<T>> sliding(Stream<T> stream, int windowSize, int increment) {
        javaslang.collection.Iterator it = stream.iterator();
        Mutable list = Mutable.of((Object)javaslang.collection.List.empty());
        return StreamUtils.stream(new Iterator<javaslang.collection.List<T>>((Iterator)it, increment, list, windowSize){
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ int val$increment;
            final /* synthetic */ Mutable val$list;
            final /* synthetic */ int val$windowSize;
            {
                this.val$it = iterator;
                this.val$increment = n;
                this.val$list = mutable;
                this.val$windowSize = n2;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public javaslang.collection.List<T> next() {
                int i;
                for (i = 0; i < this.val$increment && ((javaslang.collection.List)this.val$list.get()).length() > 0; ++i) {
                    this.val$list.mutate(var -> var.removeAt(0));
                }
                i = 0;
                while (((javaslang.collection.List)this.val$list.get()).length() < this.val$windowSize && this.val$it.hasNext()) {
                    if (this.val$it.hasNext()) {
                        this.val$list.mutate(var -> var.append(this.val$it.next()));
                    }
                    ++i;
                }
                return (javaslang.collection.List)this.val$list.get();
            }
        });
    }

    public static final <T> Stream<Streamable<T>> window(Stream<T> stream, int windowSize, int increment) {
        javaslang.collection.Iterator it = stream.iterator();
        Mutable list = Mutable.of((Object)ConsPStack.empty());
        return StreamUtils.stream(new Iterator<Streamable<T>>((Iterator)it, increment, list, windowSize){
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ int val$increment;
            final /* synthetic */ Mutable val$list;
            final /* synthetic */ int val$windowSize;
            {
                this.val$it = iterator;
                this.val$increment = n;
                this.val$list = mutable;
                this.val$windowSize = n2;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public Streamable<T> next() {
                int i;
                for (i = 0; i < this.val$increment && ((PStack)this.val$list.get()).size() > 0; ++i) {
                    this.val$list.mutate(var -> var.minus(0));
                }
                i = 0;
                while (((PStack)this.val$list.get()).size() < this.val$windowSize && this.val$it.hasNext()) {
                    if (this.val$it.hasNext()) {
                        this.val$list.mutate(var -> var.plus(Math.max(0, var.size()), this.val$it.next()));
                    }
                    ++i;
                }
                return Streamable.fromIterable((Iterable)((Iterable)this.val$list.get()));
            }
        });
    }

    public static final <T> Stream<javaslang.collection.List<T>> sliding(Stream<T> stream, int windowSize) {
        return StreamUtils.sliding(stream, windowSize, 1);
    }

    public static final <T> Stream<javaslang.collection.List<T>> batchBySize(Stream<T> stream, int groupSize) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchBySize(groupSize).map(list -> javaslang.collection.List.ofAll((Iterable)list)));
    }

    public static final <T, C extends Collection<T>> Stream<C> batchBySize(Stream<T> stream, int groupSize, Supplier<C> factory) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchBySize(groupSize, factory));
    }

    public static final <T> Streamable<T> shuffle(Stream<T> stream) {
        List list = stream.toJavaList();
        Collections.shuffle(list);
        return Streamable.fromIterable((Iterable)list);
    }

    public static final <T> Streamable<T> toLazyStreamable(Stream<T> stream) {
        return AsStreamable.fromStream(ToStream.toSequenceM(stream));
    }

    public static final <T> Streamable<T> toConcurrentLazyStreamable(Stream<T> stream) {
        return AsStreamable.synchronizedFromStream(ToStream.toSequenceM(stream));
    }

    public static final <U, T> Stream<U> scanRight(Stream<T> stream, U identity, BiFunction<? super T, U, U> combiner) {
        return FromJDK.stream(ToStream.toSequenceM(stream).scanRight(identity, combiner));
    }

    public static final <T> Stream<T> scanLeft(Stream<T> stream, final Monoid<T> monoid) {
        javaslang.collection.Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<T>((Iterator)it){
            boolean init = false;
            T next = monoid.zero();
            final /* synthetic */ Iterator val$it;
            {
                this.val$it = iterator;
            }

            @Override
            public boolean hasNext() {
                if (!this.init) {
                    return true;
                }
                return this.val$it.hasNext();
            }

            @Override
            public T next() {
                if (!this.init) {
                    this.init = true;
                    return monoid.zero();
                }
                this.next = monoid.combiner().apply(this.next, this.val$it.next());
                return this.next;
            }
        });
    }

    public static <T> boolean xMatch(Stream<T> stream, int num, Predicate<? super T> c) {
        return (Long)ToStream.toSequenceM(stream.filter(t -> c.test(t))).collect(Collectors.counting()) == (long)num;
    }

    public static final <T> boolean noneMatch(Stream<T> stream, Predicate<? super T> c) {
        return ToStream.toSequenceM(stream).allMatch(c.negate());
    }

    public static final <T> String join(Stream<T> stream) {
        return (String)ToStream.toSequenceM(stream).map(t -> t.toString()).collect(Collectors.joining());
    }

    public static final <T> String join(Stream<T> stream, String sep) {
        return (String)ToStream.toSequenceM(stream).map(t -> t.toString()).collect(Collectors.joining(sep));
    }

    public static final <T> String join(Stream<T> stream, String sep, String start, String end) {
        return (String)ToStream.toSequenceM(stream).map(t -> t.toString()).collect(Collectors.joining(sep, start, end));
    }

    public static final <T, C extends Comparable<C>> Optional<T> minBy(Stream<T> stream, Function<T, C> f) {
        Optional o = ToStream.toSequenceM(stream).map(in -> new Tuple2(f.apply(in), in)).min(Comparator.comparing(n -> (Comparable)n._1(), Comparator.naturalOrder()));
        return o.map(p -> p._2);
    }

    public static final <T> Optional<T> min(Stream<T> stream, Comparator<? super T> comparator) {
        return (Optional)ToStream.toSequenceM(stream).collect(Collectors.minBy(comparator));
    }

    public static final <T, C extends Comparable<? super C>> Optional<T> maxBy(Stream<T> stream, Function<T, C> f) {
        Optional o = ToStream.toSequenceM(stream).map(in -> new Tuple2(f.apply(in), in)).max(Comparator.comparing(n -> (Comparable)n._1(), Comparator.naturalOrder()));
        return o.map(p -> p._2);
    }

    public static final <T> Optional<T> max(Stream<T> stream, Comparator<? super T> comparator) {
        return (Optional)ToStream.toSequenceM(stream).collect(Collectors.maxBy(comparator));
    }

    public static final <T, R> R mapReduce(Stream<T> stream, Monoid<R> reducer) {
        return (R)reducer.mapReduce(ToStream.toSequenceM(stream));
    }

    public static final <T, R> R mapReduce(Stream<T> stream, Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return (R)ToStream.toSequenceM(stream).mapReduce(mapper, reducer);
    }

    public static final <T> T foldLeft(Stream<T> stream, Monoid<T> reducer) {
        return (T)ToStream.toSequenceM(stream).foldLeft(reducer);
    }

    public static final <T> T foldLeftMapToType(Stream<T> stream, Monoid<T> reducer) {
        return (T)ToStream.toSequenceM(stream).foldLeftMapToType(reducer);
    }

    public static final <T> T foldRight(Stream<T> stream, Monoid<T> reducer) {
        return (T)ToStream.toSequenceM(stream).foldRight(reducer);
    }

    public static final <T> T foldRightMapToType(Stream<T> stream, Monoid<T> reducer) {
        return (T)ToStream.toSequenceM(stream).foldRightMapToType(reducer);
    }

    public static final <T> Streamable<T> toStreamable(Stream<T> stream) {
        return AsStreamable.fromIterable(stream);
    }

    public static final <T> Set<T> toSet(Stream<T> stream) {
        return stream.toSet();
    }

    public static final <T> javaslang.collection.List<T> toList(Stream<T> stream) {
        return (javaslang.collection.List)stream.toJavaList();
    }

    public static final <T> boolean startsWith(Stream<T> stream, Iterable<T> iterable) {
        return StreamUtils.startsWith(stream, iterable.iterator());
    }

    public static final <T> boolean endsWith(Stream<T> stream, Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        ArrayList compare1 = new ArrayList();
        while (it.hasNext()) {
            compare1.add(it.next());
        }
        LinkedList list = new LinkedList();
        stream.forEach(v -> {
            list.add(v);
            if (list.size() > compare1.size()) {
                list.remove();
            }
        });
        return StreamUtils.startsWith(FromJDK.stream(list.stream()), compare1.iterator());
    }

    public static final <T> boolean startsWith(Stream<T> stream, Iterator<T> iterator) {
        javaslang.collection.Iterator it = stream.iterator();
        while (iterator.hasNext()) {
            if (!it.hasNext()) {
                return false;
            }
            if (Objects.equals(it.next(), iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> Stream<T> intersperse(Stream<T> stream, T value) {
        return stream.flatMap(t -> Stream.ofAll((Object[])new Object[]{value, t})).drop(1);
    }

    public static <T, U> Stream<U> ofType(Stream<T> stream, Class<U> type) {
        return stream.filter(type::isInstance).map(t -> t);
    }

    public static <T, U> Stream<U> cast(Stream<T> stream, Class<U> type) {
        return stream.map(type::cast);
    }

    public static final <T, R> Stream<R> flatMapSequenceM(Stream<T> stream, Function<? super T, SequenceM<? extends R>> fn) {
        return stream.flatMap(fn);
    }

    public static final <T, R> Stream<R> flatMapAnyM(Stream<T> stream, Function<? super T, AnyM<? extends R>> fn) {
        return FromJDK.stream(AsGenericMonad.asMonad(stream).bind(in -> ((AnyM)fn.apply(in)).unwrap()).sequence());
    }

    public static final <T, R> Stream<R> flatMapCollection(Stream<T> stream, Function<? super T, Collection<? extends R>> fn) {
        return stream.map(fn).map(c -> Stream.ofAll((Iterable)c)).flatten();
    }

    public static final <T, R> Stream<R> flatMapStream(Stream<T> stream, Function<? super T, BaseStream<? extends R, ?>> fn) {
        return stream.flatMap(i -> (Iterable)fn.andThen(bs -> {
            if (bs instanceof java.util.stream.Stream) {
                return FromJDK.stream((java.util.stream.Stream)bs);
            }
            return Stream.ofAll((Object[])new Iterator[]{bs.iterator()});
        }).apply(i));
    }

    public static final <T, R> Stream<R> flatMapOptional(Stream<T> stream, Function<? super T, Optional<? extends R>> fn) {
        return stream.flatMap(in -> StreamUtils.optionalToStream((Optional)fn.apply(in)));
    }

    public static final <T, R> Stream<R> flatten(Stream<T> stream) {
        return stream.flatten();
    }

    public static final <T, R> Stream<R> flatMapCompletableFuture(Stream<T> stream, Function<? super T, CompletableFuture<? extends R>> fn) {
        return stream.flatMap(in -> StreamUtils.completableFutureToStream((CompletableFuture)fn.apply(in)));
    }

    public static final <T> Stream<Character> flatMapCharSequence(Stream<T> stream, Function<? super T, CharSequence> fn) {
        return FromJDK.stream(AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence());
    }

    public static final <T> Stream<String> flatMapFile(Stream<T> stream, Function<? super T, File> fn) {
        return FromJDK.stream(AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence());
    }

    public static final <T> Stream<String> flatMapURL(Stream<T> stream, Function<? super T, URL> fn) {
        return FromJDK.stream(AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence());
    }

    public static final <T> Stream<String> flatMapBufferedReader(Stream<T> stream, Function<? super T, BufferedReader> fn) {
        return FromJDK.stream(AsGenericMonad.asMonad(stream).liftAndBind(fn).sequence());
    }

    public static final <A> Tuple2<Iterator<A>, Iterator<A>> toBufferingDuplicator(Iterator<A> iterator) {
        return StreamUtils.toBufferingDuplicator(iterator, Long.MAX_VALUE);
    }

    public static final <A> Tuple2<Iterator<A>, Iterator<A>> toBufferingDuplicator(Iterator<A> iterator, long pos) {
        LinkedList bufferTo = new LinkedList();
        LinkedList bufferFrom = new LinkedList();
        return new Tuple2(new DuplicatingIterator(bufferTo, bufferFrom, iterator, Long.MAX_VALUE, 0L), new DuplicatingIterator(bufferFrom, bufferTo, iterator, pos, 0L));
    }

    public static final <A> javaslang.collection.List<Iterator<A>> toBufferingCopier(Iterator<A> iterator, int copies) {
        ArrayList<CopyingIterator<A>> result = new ArrayList<CopyingIterator<A>>();
        LinkedList leaderboard = new LinkedList();
        LinkedList buffer = new LinkedList();
        for (int i = 0; i < copies; ++i) {
            result.add(new CopyingIterator<A>(iterator, leaderboard, buffer, copies));
        }
        return javaslang.collection.List.ofAll(result);
    }

    public static final <A> Collection<A> toLazyCollection(Stream<A> stream) {
        return SeqUtils.toLazyCollection((Iterator)stream.iterator());
    }

    public static final <A> Collection<A> toLazyCollection(Iterator<A> iterator) {
        return SeqUtils.toLazyCollection(iterator);
    }

    public static final <A> Collection<A> toConcurrentLazyCollection(Stream<A> stream) {
        return SeqUtils.toConcurrentLazyCollection((Iterator)stream.iterator());
    }

    public static final <A> Collection<A> toConcurrentLazyCollection(Iterator<A> iterator) {
        return SeqUtils.toConcurrentLazyCollection(iterator);
    }

    public static final <T> Stream<Streamable<T>> windowByTime(Stream<T> stream, long time, TimeUnit t) {
        javaslang.collection.Iterator it = stream.iterator();
        long toRun = t.toNanos(time);
        return StreamUtils.stream(new Iterator<Streamable<T>>((Iterator)it, toRun){
            long start = System.nanoTime();
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ long val$toRun;
            {
                this.val$it = iterator;
                this.val$toRun = l;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public Streamable<T> next() {
                ArrayList list = new ArrayList();
                while (System.nanoTime() - this.start < this.val$toRun && this.val$it.hasNext()) {
                    list.add(this.val$it.next());
                }
                if (list.size() == 0 && this.val$it.hasNext()) {
                    list.add(this.val$it.next());
                }
                this.start = System.nanoTime();
                return Streamable.fromIterable(list);
            }
        });
    }

    public static final <T> Stream<javaslang.collection.List<T>> batchByTime(Stream<T> stream, long time, TimeUnit t) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchByTime(time, t).map(list -> javaslang.collection.List.ofAll((Iterable)list)));
    }

    public static final <T, C extends Collection<T>> Stream<C> batchByTime(Stream<T> stream, long time, TimeUnit t, Supplier<C> factory) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchByTime(time, t, factory));
    }

    public static final <T> Stream<Streamable<T>> windowStatefullyWhile(Stream<T> stream, BiPredicate<Streamable<T>, T> predicate) {
        return FromJDK.stream(ToStream.toSequenceM(stream).windowStatefullyWhile(predicate));
    }

    public static final <T> Stream<Streamable<T>> windowWhile(Stream<T> stream, Predicate<T> predicate) {
        return FromJDK.stream(ToStream.toSequenceM(stream).windowWhile(predicate));
    }

    public static final <T> Stream<javaslang.collection.List<T>> batchWhile(Stream<T> stream, Predicate<T> predicate) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchWhile(predicate).map(list -> javaslang.collection.List.ofAll((Iterable)list)));
    }

    public static final <T, C extends Collection<T>> Stream<C> batchWhile(Stream<T> stream, Predicate<T> predicate, Supplier<C> factory) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchWhile(predicate, factory));
    }

    public static final <T> Stream<javaslang.collection.List<T>> batchUntil(Stream<T> stream, Predicate<T> predicate) {
        return StreamUtils.batchWhile(stream, predicate.negate());
    }

    public static final <T> Stream<javaslang.collection.List<T>> batchBySizeAndTime(Stream<T> stream, int size, long time, TimeUnit t) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchBySizeAndTime(size, time, t).map(list -> javaslang.collection.List.ofAll((Iterable)list)));
    }

    public static final <T, C extends Collection<T>> Stream<C> batchBySizeAndTime(Stream<T> stream, int size, long time, TimeUnit t, Supplier<C> factory) {
        return FromJDK.stream(ToStream.toSequenceM(stream).batchBySizeAndTime(size, time, t, factory));
    }

    public static final <T> Stream<Streamable<T>> windowBySizeAndTime(Stream<T> stream, int size, long time, TimeUnit t) {
        return FromJDK.stream(ToStream.toSequenceM(stream).windowBySizeAndTime(size, time, t));
    }

    public static final <T> Stream<T> debounce(Stream<T> stream, long time, TimeUnit t) {
        return FromJDK.stream(ToStream.toSequenceM(stream).debounce(time, t));
    }

    public static final <T> Stream<T> onePer(Stream<T> stream, long time, TimeUnit t) {
        return FromJDK.stream(ToStream.toSequenceM(stream).onePer(time, t));
    }

    public static final <T> Stream<T> jitter(Stream<T> stream, long jitterInNanos) {
        javaslang.collection.Iterator it = stream.iterator();
        Random r = new Random();
        return StreamUtils.stream(new Iterator<T>((Iterator)it, jitterInNanos, r){
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ long val$jitterInNanos;
            final /* synthetic */ Random val$r;
            {
                this.val$it = iterator;
                this.val$jitterInNanos = l;
                this.val$r = random;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = this.val$it.next();
                try {
                    long elapsedNanos = (long)((double)this.val$jitterInNanos * this.val$r.nextDouble());
                    long millis = elapsedNanos / 1000000L;
                    int nanos = (int)(elapsedNanos - millis * 1000000L);
                    Thread.sleep(Math.max(0L, millis), Math.max(0, nanos));
                }
                catch (InterruptedException e) {
                    ExceptionSoftener.throwSoftenedException((Throwable)e);
                    return null;
                }
                return nextValue;
            }
        });
    }

    public static final <T> Stream<T> fixedDelay(Stream<T> stream, long time, TimeUnit unit) {
        javaslang.collection.Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<T>((Iterator)it, unit, time){
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ TimeUnit val$unit;
            final /* synthetic */ long val$time;
            {
                this.val$it = iterator;
                this.val$unit = timeUnit;
                this.val$time = l;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = this.val$it.next();
                try {
                    long elapsedNanos = this.val$unit.toNanos(this.val$time);
                    long millis = elapsedNanos / 1000000L;
                    int nanos = (int)(elapsedNanos - millis * 1000000L);
                    Thread.sleep(Math.max(0L, millis), Math.max(0, nanos));
                }
                catch (InterruptedException e) {
                    ExceptionSoftener.throwSoftenedException((Throwable)e);
                    return null;
                }
                return nextValue;
            }
        });
    }

    public static final <T> Stream<T> xPer(Stream<T> stream, int x, long time, TimeUnit t) {
        javaslang.collection.Iterator it = stream.iterator();
        long next = t.toNanos(time);
        return StreamUtils.stream(new Iterator<T>((Iterator)it, x, next){
            volatile long last = -1L;
            volatile int count = 0;
            final /* synthetic */ Iterator val$it;
            final /* synthetic */ int val$x;
            final /* synthetic */ long val$next;
            {
                this.val$it = iterator;
                this.val$x = n;
                this.val$next = l;
            }

            @Override
            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            @Override
            public T next() {
                Object nextValue = this.val$it.next();
                if (this.count++ < this.val$x) {
                    return nextValue;
                }
                this.count = 0;
                LockSupport.parkNanos(this.val$next - System.nanoTime() - this.last);
                this.last = System.nanoTime();
                return nextValue;
            }
        });
    }

    public static final <T> JavaslangHotStream<T> hotStream(Stream<T> stream, Executor exec) {
        return new HotStreamImpl<T>(stream).init(exec);
    }

    private StreamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ Iterator lambda$headAndTailOptional$93(Iterator iterator) {
        return iterator;
    }

    private static /* synthetic */ Iterator lambda$headAndTail$92(Iterator iterator) {
        return iterator;
    }

    static class CopyingIterator<T>
    implements Iterator<T> {
        LinkedList<T> buffer;
        Iterator<T> it;
        List<CopyingIterator<T>> leaderboard = new LinkedList<CopyingIterator<T>>();
        boolean added = false;
        int total = 0;
        int counter = 0;

        @Override
        public boolean hasNext() {
            if (this.isLeader()) {
                return this.it.hasNext();
            }
            if (this.isLast()) {
                return this.buffer.size() > 0 || this.it.hasNext();
            }
            if (this.it.hasNext()) {
                return true;
            }
            return this.counter < this.buffer.size();
        }

        private boolean isLeader() {
            return this.leaderboard.size() == 0 || this == this.leaderboard.get(0);
        }

        private boolean isLast() {
            return this.leaderboard.size() == this.total && this == this.leaderboard.get(this.leaderboard.size() - 1);
        }

        @Override
        public T next() {
            if (!this.added) {
                this.leaderboard.add(this);
                this.added = true;
            }
            if (this.isLeader()) {
                return this.handleLeader();
            }
            if (this.isLast()) {
                if (this.buffer.size() > 0) {
                    return this.buffer.poll();
                }
                return this.it.next();
            }
            if (this.counter < this.buffer.size()) {
                return this.buffer.get(this.counter++);
            }
            return this.handleLeader();
        }

        private T handleLeader() {
            T next = this.it.next();
            this.buffer.offer(next);
            return next;
        }

        public CopyingIterator(Iterator<T> it, List<CopyingIterator<T>> leaderboard, LinkedList<T> buffer, int total) {
            this.it = it;
            this.leaderboard = leaderboard;
            this.buffer = buffer;
            this.total = total;
        }
    }

    static class DuplicatingIterator<T>
    implements Iterator<T> {
        LinkedList<T> bufferTo;
        LinkedList<T> bufferFrom;
        Iterator<T> it;
        long otherLimit = Long.MAX_VALUE;
        long counter = 0L;

        @Override
        public boolean hasNext() {
            return this.bufferFrom.size() > 0 || this.it.hasNext();
        }

        @Override
        public T next() {
            try {
                if (this.bufferFrom.size() > 0) {
                    T t = this.bufferFrom.remove(0);
                    return t;
                }
                T next = this.it.next();
                if (this.counter < this.otherLimit) {
                    this.bufferTo.add(next);
                }
                T t = next;
                return t;
            }
            finally {
                ++this.counter;
            }
        }

        @ConstructorProperties(value={"bufferTo", "bufferFrom", "it", "otherLimit", "counter"})
        public DuplicatingIterator(LinkedList<T> bufferTo, LinkedList<T> bufferFrom, Iterator<T> it, long otherLimit, long counter) {
            this.bufferTo = bufferTo;
            this.bufferFrom = bufferFrom;
            this.it = it;
            this.otherLimit = otherLimit;
            this.counter = counter;
        }
    }
}

