/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.reactivestreams;

import com.aol.cyclops.javaslang.ToStream;
import com.aol.simple.react.stream.ThreadPools;
import com.aol.simple.react.stream.lazy.LazyReact;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javaslang.collection.Traversable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class JavaslangReactiveStreamsPublisher<T>
implements Publisher<T> {
    private final boolean synchronous;
    private final Traversable<T> wrappedStream;
    private final Executor exec;

    public static <T> JavaslangReactiveStreamsPublisher<T> ofSync(Traversable<T> stream) {
        return new JavaslangReactiveStreamsPublisher<T>(true, stream, null);
    }

    public static <T> JavaslangReactiveStreamsPublisher<T> ofAsync(Traversable<T> stream, Executor exec) {
        return new JavaslangReactiveStreamsPublisher<T>(false, stream, exec);
    }

    public void subscribe(Subscriber<? super T> s) {
        if (this.synchronous) {
            ToStream.toFutureStreamFromTraversable(this.wrappedStream).sync().subscribe(s);
        } else {
            new LazyReact(ThreadPools.getCurrentThreadExecutor()).withPublisherExecutor(this.exec).from((Iterator)this.wrappedStream.iterator()).async().subscribe(s);
        }
    }

    @ConstructorProperties(value={"synchronous", "wrappedStream", "exec"})
    public JavaslangReactiveStreamsPublisher(boolean synchronous, Traversable<T> wrappedStream, Executor exec) {
        this.synchronous = synchronous;
        this.wrappedStream = wrappedStream;
        this.exec = exec;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public Traversable<T> getWrappedStream() {
        return this.wrappedStream;
    }

    public Executor getExec() {
        return this.exec;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaslangReactiveStreamsPublisher)) {
            return false;
        }
        JavaslangReactiveStreamsPublisher other = (JavaslangReactiveStreamsPublisher)o;
        if (this.isSynchronous() != other.isSynchronous()) {
            return false;
        }
        Traversable<T> this$wrappedStream = this.getWrappedStream();
        Traversable<T> other$wrappedStream = other.getWrappedStream();
        if (this$wrappedStream == null ? other$wrappedStream != null : !this$wrappedStream.equals(other$wrappedStream)) {
            return false;
        }
        Executor this$exec = this.getExec();
        Executor other$exec = other.getExec();
        return !(this$exec == null ? other$exec != null : !this$exec.equals(other$exec));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSynchronous() ? 79 : 97);
        Traversable<T> $wrappedStream = this.getWrappedStream();
        result = result * 59 + ($wrappedStream == null ? 0 : $wrappedStream.hashCode());
        Executor $exec = this.getExec();
        result = result * 59 + ($exec == null ? 0 : $exec.hashCode());
        return result;
    }

    public String toString() {
        return "JavaslangReactiveStreamsPublisher(synchronous=" + this.isSynchronous() + ", wrappedStream=" + this.getWrappedStream() + ", exec=" + this.getExec() + ")";
    }
}

