/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang.caching;

import com.aol.cyclops.functions.caching.Cacheable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Function0;
import javaslang.Function1;
import javaslang.Function2;
import javaslang.Function3;
import javaslang.Function4;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Tuple4;

public class Memoize {
    public static <T> Function0<T> memoizeFunction0(Function0<T> s) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return (Function0 & Serializable)() -> lazy.computeIfAbsent("k", a -> s.get());
    }

    public static <T> Function0<T> memoizeFunction0(Function0<T> s, Cacheable<T> cache) {
        return (Function0 & Serializable)() -> cache.computeIfAbsent((Object)"k", a -> s.get());
    }

    public static <T> Callable<T> memoizeCallable(Callable<T> s, Cacheable<T> cache) {
        return () -> cache.computeIfAbsent((Object)"k", a -> {
            try {
                return s.call();
            }
            catch (Exception e) {
                Memoize.throwSoftenedException(e);
                return null;
            }
        });
    }

    public static <T> Callable<T> memoizeCallable(Callable<T> s) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return () -> lazy.computeIfAbsent("k", a -> {
            try {
                return s.call();
            }
            catch (Exception e) {
                Memoize.throwSoftenedException(e);
                return null;
            }
        });
    }

    public static <T, R> Function<T, R> memoizeFunction(Function1<T, R> fn) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return t -> lazy.computeIfAbsent(t, fn);
    }

    public static <T, R> Function<T, R> memoizeFunction(Function1<T, R> fn, Cacheable<R> cache) {
        return t -> cache.computeIfAbsent(t, (Function)fn);
    }

    public static <T1, T2, R> Function2<T1, T2, R> memoizeBiFunction(Function2<T1, T2, R> fn) {
        Function memoise2 = Memoize.memoizeFunction((Function1 & Serializable)pair -> fn.apply(pair._1, pair._2));
        return (Function2 & Serializable)(t1, t2) -> memoise2.apply(new Tuple2(t1, t2));
    }

    public static <T1, T2, R> Function2<T1, T2, R> memoizeBiFunction(Function2<T1, T2, R> fn, Cacheable<R> cache) {
        Function memoise2 = Memoize.memoizeFunction((Function1 & Serializable)pair -> fn.apply(pair._1, pair._2), cache);
        return (Function2 & Serializable)(t1, t2) -> memoise2.apply(new Tuple2(t1, t2));
    }

    public static <T1, T2, T3, R> Function3<T1, T2, T3, R> memoizeTriFunction(Function3<T1, T2, T3, R> fn) {
        Function memoise2 = Memoize.memoizeFunction((Function1 & Serializable)triple -> fn.apply(triple._1, triple._2, triple._3));
        return (Function3 & Serializable)(t1, t2, t3) -> memoise2.apply(new Tuple3(t1, t2, t3));
    }

    public static <T1, T2, T3, R> Function3<T1, T2, T3, R> memoizeTriFunction(Function3<T1, T2, T3, R> fn, Cacheable<R> cache) {
        Function memoise2 = Memoize.memoizeFunction((Function1 & Serializable)triple -> fn.apply(triple._1, triple._2, triple._3), cache);
        return (Function3 & Serializable)(t1, t2, t3) -> memoise2.apply(new Tuple3(t1, t2, t3));
    }

    public static <T1, T2, T3, T4, R> Function4<T1, T2, T3, T4, R> memoizeQuadFunction(Function4<T1, T2, T3, T4, R> fn) {
        Function memoise2 = Memoize.memoizeFunction((Function1 & Serializable)quad -> fn.apply(quad._1, quad._2, quad._3, quad._4));
        return (Function4 & Serializable)(t1, t2, t3, t4) -> memoise2.apply(new Tuple4(t1, t2, t3, t4));
    }

    public static <T1, T2, T3, T4, R> Function4<T1, T2, T3, T4, R> memoizeQuadFunction(Function4<T1, T2, T3, T4, R> fn, Cacheable<R> cache) {
        Function memoise2 = Memoize.memoizeFunction((Function1 & Serializable)quad -> fn.apply(quad._1, quad._2, quad._3, quad._4), cache);
        return (Function4 & Serializable)(t1, t2, t3, t4) -> memoise2.apply(new Tuple4(t1, t2, t3, t4));
    }

    public static <T> Predicate<T> memoizePredicate(Predicate<T> p) {
        Function memoised = Memoize.memoizeFunction((Function1 & Serializable)t -> p.test(t));
        return t -> (Boolean)memoised.apply(t);
    }

    public static <T> Predicate<T> memoizePredicate(Predicate<T> p, Cacheable<Boolean> cache) {
        Function memoised = Memoize.memoizeFunction((Function1 & Serializable)t -> p.test(t), cache);
        return t -> (Boolean)memoised.apply(t);
    }

    private static void throwSoftenedException(Throwable e) {
        new Thrower().uncheck(e);
    }

    static class Thrower<T extends Throwable> {
        Thrower() {
        }

        private void uncheck(Throwable throwable) throws T {
            throw throwable;
        }
    }
}

