/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.javaslang;

import com.aol.cyclops.javaslang.Javaslang;
import com.aol.cyclops.lambda.monads.AnyMonads;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javaslang.collection.List;
import javaslang.control.Either;
import javaslang.control.Failure;
import javaslang.control.Left;
import javaslang.control.Option;
import javaslang.control.Right;
import javaslang.control.Success;
import javaslang.control.Try;
import javaslang.test.Arbitrary;
import javaslang.test.Gen;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AnyJavaslangMTest {
    @Test
    public void tryTest() {
        Assert.assertThat((Object)Javaslang.anyM((Try)Try.of(this::success)).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void tryTestFailure() {
        Javaslang.anyM((Try)new Failure((Throwable)new RuntimeException())).toSequence().forEach(System.out::println);
    }

    @Test
    public void tryTestFailureProcess() {
        RuntimeException e = new RuntimeException();
        Assert.assertThat((Object)Javaslang.anyMFailure((Try)new Failure((Throwable)e)).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(e)));
    }

    @Test
    public void whenSuccessFailureProcessDoesNothing() {
        Assert.assertThat((Object)Javaslang.anyMFailure((Try)new Success((Object)"hello world")).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void tryFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Try)Try.of(this::success)).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    private String success() {
        return "hello world";
    }

    private String exceptional() {
        throw new RuntimeException();
    }

    @Test
    public void eitherTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either)new Right((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void eitherLeftTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either)new Left((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void eitherFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either)new Right((Object)"hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)new Right((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionLeftTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)new Left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void rightProjectionFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)new Right((Object)"hello world").right()).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.RightProjection)new Left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void leftProjectionLeftTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.LeftProjection)new Left((Object)"hello world").left()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionLeftFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Either.LeftProjection)new Left((Object)"hello world").left()).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionTest() {
        Assert.assertThat((Object)Javaslang.anyM((Option)Option.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((Option)Option.of((Object)"hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionEmptyTest() {
        Assert.assertThat((Object)Javaslang.anyM((Option)Option.none()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void streamTest() {
        Assert.assertThat((Object)Javaslang.anyM((javaslang.collection.Stream)javaslang.collection.Stream.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    @Ignore
    public void arbritrayTest() {
        Assert.assertThat((Object)Javaslang.anyM((Arbitrary)Arbitrary.list((Arbitrary)Gen.of((Object)"hello world").arbitrary())).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void listTest() {
        Assert.assertThat((Object)Javaslang.anyM((List)List.of((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTest() {
        Assert.assertThat((Object)Javaslang.anyM((javaslang.collection.Stream)javaslang.collection.Stream.of((Object)"hello world")).map(String::toUpperCase).flatMap(i -> Javaslang.anyM((List)List.of((Object)i))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTestJDK() {
        Assert.assertThat((Object)Javaslang.anyM((javaslang.collection.Stream)javaslang.collection.Stream.of((Object)"hello world")).map(String::toUpperCase).flatMap(i -> AnyMonads.anyM(Stream.of(i))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }
}

