/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.api;

import com.aol.cyclops.lambda.api.AsDecomposable;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.InvokeDynamic;
import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.StreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Streamable<T>
extends Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Object getStreamable() {
        return this;
    }

    default public SequenceM<T> sequenceM() {
        return SequenceM.fromStream(this.stream());
    }

    default public Stream<T> stream() {
        Object streamable = this.getStreamable();
        if (streamable instanceof Stream) {
            return (Stream)streamable;
        }
        if (streamable instanceof Iterable) {
            return StreamSupport.stream(((Iterable)streamable).spliterator(), false);
        }
        return new InvokeDynamic().stream(streamable).orElseGet(() -> StreamSupport.stream(AsDecomposable.asDecomposable(streamable).unapply().spliterator(), false));
    }

    public static <T> Streamable<T> fromStream(Stream<T> stream) {
        return AsStreamable.asStreamable(stream);
    }

    public static <T> Streamable<T> fromIterable(Iterable<T> iterable) {
        return AsStreamable.asStreamable(iterable);
    }

    public static <T> Streamable<T> reveresedOf(final T ... values) {
        return new Streamable<T>(){

            @Override
            public Stream<T> stream() {
                return StreamUtils.reversedStream(Arrays.asList(values));
            }
        };
    }

    public static <T> Streamable<T> reveresedOfList(final ArrayList<T> values) {
        return new Streamable<T>(){

            @Override
            public Stream<T> stream() {
                return StreamUtils.reversedStream(values);
            }
        };
    }

    public static <T> Streamable<T> of(final T ... values) {
        return new Streamable<T>(){

            @Override
            public Stream<T> stream() {
                return Stream.of(values);
            }
        };
    }
}

