/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.StreamUtils;
import com.nurkiewicz.lazyseq.LazySeq;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jooq.lambda.Seq;
import org.junit.Assert;
import org.junit.Test;

public class FlatMapStreamUtilsTest {
    @Test
    public void flatMap() {
        Assert.assertThat(StreamUtils.flatMapStream(Stream.of(1, 2, 3), i -> Stream.of(i)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void flatMapCrossType() {
        Assert.assertThat(StreamUtils.flatMapOptional(Stream.of(1, 2, 3, null), Optional::ofNullable).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void flatMapCollection() {
        Assert.assertThat(StreamUtils.flatMapCollection(Stream.of(Integer.valueOf(20)), i -> Arrays.asList(1, 2, i)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 20)));
    }

    @Test
    public void flatMap2() {
        Assert.assertThat(StreamUtils.flatMapStream(Stream.of(1, 2, 3), i -> Stream.of(Integer.valueOf(i + 2))).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapToLazySeq() {
        Assert.assertThat(StreamUtils.flatMapLazySeq(Stream.of(1, 2, 3), i -> LazySeq.of((Object)(i + 2))).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapToSeq() {
        Assert.assertThat(StreamUtils.flatMapStream(Stream.of(1, 2, 3), i -> Seq.of((Object)(i + 2))).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapSeqToStream() {
        Assert.assertThat(StreamUtils.flatMapStream((Stream)Seq.of((Object[])new Integer[]{1, 2, 3}), i -> Stream.of(Integer.valueOf(i + 2))).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapSeqToCompletableFuture() {
        Assert.assertThat(StreamUtils.flatMapCompletableFuture((Stream)Seq.of((Object[])new Integer[]{1, 2, 3}), i -> CompletableFuture.completedFuture(i + 2)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapSeqToSequenceM() {
        Assert.assertThat(StreamUtils.flatMapSequenceM((Stream)Seq.of((Object[])new Integer[]{1, 2, 3}), i -> SequenceM.of((Object[])new Integer[]{i + 2})).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }
}

