/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.internal.Monad;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.api.Unwrapable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.streams.HeadAndTail;
import com.aol.cyclops.streams.Pair;
import com.aol.cyclops.streams.Quadruple;
import com.aol.cyclops.streams.StreamUtils;
import com.aol.cyclops.streams.Triple;
import com.nurkiewicz.lazyseq.LazySeq;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class SequenceM<T>
implements Unwrapable,
Stream<T>,
Iterable<T> {
    private final Stream<T> monad;

    SequenceM(Stream<T> stream) {
        this.monad = stream;
    }

    static <T> SequenceM<T> monad(Stream<T> stream) {
        return new SequenceM<T>(stream);
    }

    @Override
    public final <R> R unwrap() {
        return (R)this.monad;
    }

    public final <T1> SequenceM<T1> flatten() {
        return AsGenericMonad.monad(this.monad).flatten().sequence();
    }

    public final Stream<T> unwrapStream() {
        Stream<Integer> unwrapper = Stream.of(Integer.valueOf(1));
        return (Stream)new ComprehenderSelector().selectComprehender(unwrapper).executeflatMap(unwrapper, i -> this.unwrap());
    }

    public final Optional<List<T>> unwrapOptional() {
        Optional<Integer> unwrapper = Optional.of(1);
        return (Optional)new ComprehenderSelector().selectComprehender(unwrapper).executeflatMap(unwrapper, i -> this.unwrap());
    }

    public final CompletableFuture<List<T>> unwrapCompletableFuture() {
        CompletableFuture<Integer> unwrapper = CompletableFuture.completedFuture(1);
        return (CompletableFuture)new ComprehenderSelector().selectComprehender(unwrapper).executeflatMap(unwrapper, i -> this.unwrap());
    }

    public final SequenceM<T> cycle(int times) {
        return new SequenceM<T>(StreamUtils.cycle(times, AsStreamable.asStreamable(this.monad)));
    }

    public final SequenceM<T> cycle() {
        return new SequenceM<T>(StreamUtils.cycle(this.monad));
    }

    public final Pair<SequenceM<T>, SequenceM<T>> duplicate() {
        Pair pair = StreamUtils.toBufferingDuplicator(this.monad.iterator());
        return new Pair(new SequenceM(StreamUtils.stream(pair._1())), new SequenceM(StreamUtils.stream(pair._2())));
    }

    private final Pair<SequenceM<T>, SequenceM<T>> duplicatePos(int pos) {
        Pair pair = StreamUtils.toBufferingDuplicator(this.monad.iterator(), pos);
        return new Pair(new SequenceM(StreamUtils.stream(pair._1())), new SequenceM(StreamUtils.stream(pair._2())));
    }

    public final Triple<SequenceM<T>, SequenceM<T>, SequenceM<T>> triplicate() {
        Stream<SequenceM> its = StreamUtils.toBufferingCopier(this.monad.iterator(), 3).stream().map((? super T it) -> StreamUtils.stream(it)).map((? super T stream) -> new SequenceM(stream));
        return new Triple<SequenceM<T>, SequenceM<T>, SequenceM<T>>(its.collect(Collectors.toList()));
    }

    public final Quadruple<SequenceM<T>, SequenceM<T>, SequenceM<T>, SequenceM<T>> quadruplicate() {
        Stream<SequenceM> its = StreamUtils.toBufferingCopier(this.monad.iterator(), 4).stream().map((? super T it) -> StreamUtils.stream(it)).map((? super T stream) -> new SequenceM(stream));
        return new Quadruple<SequenceM<T>, SequenceM<T>, SequenceM<T>, SequenceM<T>>(its.collect(Collectors.toList()));
    }

    public final Pair<Optional<T>, SequenceM<T>> splitAtHead() {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.splitAt(1);
        return new Pair<Optional<T>, SequenceM<T>>(((SequenceM)pair.v1).unwrapOptional().flatMap((? super T l) -> l.size() > 0 ? Optional.of(l.get(0)) : Optional.empty()), pair.v2);
    }

    public final Pair<SequenceM<T>, SequenceM<T>> splitAt(int where) {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.duplicate();
        return new Pair<Stream, Stream>(((SequenceM)pair.v1).limit(where), ((SequenceM)pair.v2).skip(where));
    }

    public final Pair<SequenceM<T>, SequenceM<T>> splitBy(Predicate<T> splitter) {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.duplicate();
        return new Pair<SequenceM<T>, SequenceM<T>>(((SequenceM)pair.v1).limitWhile(splitter), ((SequenceM)pair.v2).skipWhile(splitter));
    }

    public final Pair<SequenceM<T>, SequenceM<T>> partition(Predicate<T> splitter) {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.duplicate();
        return new Pair<Stream, Stream>(((SequenceM)pair.v1).filter(splitter), ((SequenceM)pair.v2).filter(splitter.negate()));
    }

    public static final <T, U> Pair<SequenceM<T>, SequenceM<U>> unzip(SequenceM<Pair<T, U>> sequence) {
        Pair<SequenceM<Pair<T, U>>, SequenceM<Pair<T, U>>> pair = sequence.duplicate();
        return new Pair<Stream, Stream>(((SequenceM)pair.v1).map(Pair::_1), ((SequenceM)pair.v2).map(Pair::_2));
    }

    public static final <T1, T2, T3> Triple<SequenceM<T1>, SequenceM<T2>, SequenceM<T3>> unzip3(SequenceM<Triple<T1, T2, T3>> sequence) {
        Triple<SequenceM<Triple<T1, T2, T3>>, SequenceM<Triple<T1, T2, T3>>, SequenceM<Triple<T1, T2, T3>>> triple = sequence.triplicate();
        return new Triple<Stream, Stream, Stream>(((SequenceM)triple.v1).map(Triple::_1), ((SequenceM)triple.v2).map(Triple::_2), ((SequenceM)triple.v3).map(Triple::_3));
    }

    public static final <T1, T2, T3, T4> Quadruple<SequenceM<T1>, SequenceM<T2>, SequenceM<T3>, SequenceM<T4>> unzip4(SequenceM<Quadruple<T1, T2, T3, T4>> sequence) {
        Quadruple<SequenceM<Quadruple<T1, T2, T3, T4>>, SequenceM<Quadruple<T1, T2, T3, T4>>, SequenceM<Quadruple<T1, T2, T3, T4>>, SequenceM<Quadruple<T1, T2, T3, T4>>> quad = sequence.quadruplicate();
        return new Quadruple<Stream, Stream, Stream, Stream>(((SequenceM)quad.v1).map(Quadruple::_1), ((SequenceM)quad.v2).map(Quadruple::_2), ((SequenceM)quad.v3).map(Quadruple::_3), ((SequenceM)quad.v4).map(Quadruple::_4));
    }

    public final SequenceM<T> cycle(Monoid<T> m, int times) {
        return SequenceM.monad(StreamUtils.cycle(times, AsStreamable.asStreamable(m.reduce(this.monad))));
    }

    public final <R> SequenceM<R> cycle(Class<R> monadC, int times) {
        return this.cycle(times).map(r -> new ComprehenderSelector().selectComprehender(monadC).of(r));
    }

    public final SequenceM<T> cycleWhile(Predicate<? super T> predicate) {
        return SequenceM.monad(StreamUtils.cycle(this.monad)).limitWhile(predicate);
    }

    public final SequenceM<T> cycleUntil(Predicate<? super T> predicate) {
        return SequenceM.monad(StreamUtils.cycle(this.monad)).limitWhile(predicate.negate());
    }

    public final <S> SequenceM<Pair<T, S>> zip(Stream<? extends S> second) {
        return this.zipStream(second, (a, b) -> new Pair<Object, Object>(a, b));
    }

    public final <S, U> SequenceM<Triple<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return this.zip(second).zip(third).map((T p) -> new Triple(((Pair)p._1())._1(), ((Pair)p._1())._2(), p._2()));
    }

    public final <T2, T3, T4> SequenceM<Quadruple<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.zip3(second, third).zip(fourth).map((T t) -> new Quadruple(((Triple)t._1())._1(), ((Triple)t._1())._2(), ((Triple)t._1())._3(), t._2()));
    }

    public final SequenceM<Pair<T, Long>> zipWithIndex() {
        return this.zipStream(LongStream.iterate(0L, (long i) -> i + 1L), (a, b) -> new Pair<Object, Long>(a, (Long)b));
    }

    public final <S, R> SequenceM<R> zip(SequenceM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return SequenceM.monad(StreamUtils.zip(this.monad, second, zipper));
    }

    public final <S, R> SequenceM<R> zip(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return this.zip(second.toSequence(), zipper);
    }

    public final <S, R> SequenceM<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return SequenceM.monad(StreamUtils.zipStream(this.monad, second, zipper));
    }

    public final SequenceM<List<T>> sliding(int windowSize) {
        return SequenceM.monad(StreamUtils.sliding(this.monad, windowSize));
    }

    public final SequenceM<List<T>> sliding(int windowSize, int increment) {
        return SequenceM.monad(StreamUtils.sliding(this.monad, windowSize, increment));
    }

    public final SequenceM<List<T>> grouped(int groupSize) {
        return SequenceM.monad(StreamUtils.grouped(this.monad, groupSize));
    }

    public final <K> Map<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.collect(Collectors.groupingBy(classifier));
    }

    @Override
    public final SequenceM<T> distinct() {
        return SequenceM.monad(this.monad.distinct());
    }

    public final SequenceM<T> scanLeft(Monoid<T> monoid) {
        return SequenceM.monad(StreamUtils.scanLeft(this.monad, monoid));
    }

    public final SequenceM<T> scanLeft(T identity, BiFunction<T, T, T> combiner) {
        return this.scanLeft(Monoid.of(identity, combiner));
    }

    public final SequenceM<T> scanRight(Monoid<T> monoid) {
        return SequenceM.monad(this.reverse().scanLeft(monoid.zero(), (u, t) -> monoid.combiner().apply(t, u)));
    }

    public final <U> SequenceM<T> scanRight(T identity, BiFunction<T, T, T> combiner) {
        return this.scanRight(Monoid.of(identity, combiner));
    }

    @Override
    public final SequenceM<T> sorted() {
        return SequenceM.monad(this.monad.sorted());
    }

    @Override
    public final SequenceM<T> sorted(Comparator<? super T> c) {
        return SequenceM.monad(this.monad.sorted(c));
    }

    @Override
    public final SequenceM<T> skip(long num) {
        return new SequenceM<T>(this.monad.skip(num));
    }

    public final SequenceM<T> skipWhile(Predicate<? super T> p) {
        return SequenceM.monad(StreamUtils.skipWhile(this.monad, p));
    }

    public final SequenceM<T> skipUntil(Predicate<? super T> p) {
        return SequenceM.monad(StreamUtils.skipUntil(this.monad, p));
    }

    @Override
    public final SequenceM<T> limit(long num) {
        return SequenceM.monad(this.monad.limit(num));
    }

    public final SequenceM<T> limitWhile(Predicate<? super T> p) {
        return SequenceM.monad(StreamUtils.limitWhile(this.monad, p));
    }

    public final SequenceM<T> limitUntil(Predicate<? super T> p) {
        return SequenceM.monad(StreamUtils.limitUntil(this.monad, p));
    }

    @Override
    public final SequenceM<T> parallel() {
        return SequenceM.monad((Stream)this.monad.parallel());
    }

    @Override
    public final boolean allMatch(Predicate<? super T> c) {
        return this.monad.allMatch(c);
    }

    @Override
    public final boolean anyMatch(Predicate<? super T> c) {
        return this.monad.anyMatch(c);
    }

    public boolean xMatch(int num, Predicate<? super T> c) {
        return this.monad.filter((? super T t) -> c.test(t)).collect(Collectors.counting()) == (long)num;
    }

    @Override
    public final boolean noneMatch(Predicate<? super T> c) {
        return this.monad.allMatch(c.negate());
    }

    public final String join() {
        return StreamUtils.join(this.monad, "");
    }

    public final String join(String sep) {
        return StreamUtils.join(this.monad, sep);
    }

    public final String join(String sep, String start, String end) {
        return StreamUtils.join(this.monad, sep, start, end);
    }

    public final <C extends Comparable<? super C>> Optional<T> minBy(Function<T, C> f) {
        return StreamUtils.minBy(this.monad, f);
    }

    @Override
    public final Optional<T> min(Comparator<? super T> comparator) {
        return StreamUtils.min(this.monad, comparator);
    }

    public final <C extends Comparable<? super C>> Optional<T> maxBy(Function<T, C> f) {
        return StreamUtils.maxBy(this.monad, f);
    }

    @Override
    public final Optional<T> max(Comparator<? super T> comparator) {
        return StreamUtils.max(this.monad, comparator);
    }

    public final HeadAndTail<T> headAndTail() {
        return StreamUtils.headAndTail(this.monad);
    }

    public final Optional<HeadAndTail<T>> headAndTailOptional() {
        return StreamUtils.headAndTailOptional(this.monad);
    }

    @Override
    public final Optional<T> findFirst() {
        return this.monad.findFirst();
    }

    @Override
    public final Optional<T> findAny() {
        return this.monad.findAny();
    }

    public final <R> R mapReduce(Monoid<R> reducer) {
        return reducer.mapReduce(this.monad);
    }

    public final <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return reducer.reduce(this.monad.map(mapper));
    }

    @Override
    public final <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.monad.collect(collector);
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.monad.collect(supplier, accumulator, combiner);
    }

    public final List collect(Stream<Collector> collectors) {
        return StreamUtils.collect(this.monad, collectors);
    }

    public <R> List<R> collectIterable(Iterable<Collector> collectors) {
        return StreamUtils.collect(this.monad, collectors);
    }

    public final T reduce(Monoid<T> reducer) {
        return reducer.reduce(this.monad);
    }

    @Override
    public final Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.monad.reduce(accumulator);
    }

    @Override
    public final T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.monad.reduce(identity, accumulator);
    }

    @Override
    public final <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.monad.reduce(identity, accumulator, combiner);
    }

    @Override
    public final List<T> reduce(Stream<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.monad, reducers);
    }

    @Override
    public final List<T> reduce(Iterable<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.monad, reducers);
    }

    public final T foldLeft(Monoid<T> reducer) {
        return this.reduce(reducer);
    }

    public final T foldLeft(T identity, BinaryOperator<T> accumulator) {
        return this.monad.reduce(identity, accumulator);
    }

    public final <T> T foldLeftMapToType(Monoid<T> reducer) {
        return reducer.mapReduce(this.monad);
    }

    public final T foldRight(Monoid<T> reducer) {
        return reducer.reduce(StreamUtils.reverse(this.monad));
    }

    public final T foldRight(T identity, BinaryOperator<T> accumulator) {
        return this.foldRight(Monoid.of(identity, accumulator));
    }

    public final <T> T foldRightMapToType(Monoid<T> reducer) {
        return reducer.mapReduce(StreamUtils.reverse(this.monad));
    }

    public final Streamable<T> toStreamable() {
        return AsStreamable.asStreamable(this.stream());
    }

    public final Set<T> toSet() {
        return this.monad.collect(Collectors.toSet());
    }

    @Override
    public final List<T> toList() {
        return this.monad.collect(Collectors.toList());
    }

    public final <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.monad.collect(Collectors.toCollection(collectionFactory)));
    }

    public final <T> Stream<T> toStream() {
        return this.monad;
    }

    public final Stream<T> stream() {
        return this.monad;
    }

    public final boolean startsWith(Iterable<T> iterable) {
        return StreamUtils.startsWith(this.monad, iterable);
    }

    public final boolean startsWith(Iterator<T> iterator) {
        return StreamUtils.startsWith(this.monad, iterator);
    }

    public AnyM<T> anyM() {
        return new AnyM(AsGenericMonad.asMonad(this.monad));
    }

    @Override
    public final <R> SequenceM<R> map(Function<? super T, ? extends R> fn) {
        return new SequenceM<R>(this.monad.map(fn));
    }

    @Override
    public final SequenceM<T> peek(Consumer<? super T> c) {
        return new SequenceM<T>(this.monad.peek(c));
    }

    @Override
    public final <R> SequenceM<R> flatMap(Function<? super T, ? extends Stream<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (Stream)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> ((AnyM)fn.apply(in)).unwrap()).sequence();
    }

    public final <R> SequenceM<R> flatMapCollection(Function<? super T, Collection<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (Collection)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        Monad m = AsGenericMonad.asMonad(this.monad);
        return m.flatMap((? super T in) -> (BaseStream)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapOptional(Function<? super T, Optional<? extends R>> fn) {
        Monad m = AsGenericMonad.asMonad(this.monad);
        return m.flatMap((? super T in) -> (Optional)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (CompletableFuture)fn.apply(in)).sequence();
    }

    public final <R> SequenceM<R> flatMapLazySeq(Function<? super T, LazySeq<? extends R>> fn) {
        return AsGenericMonad.asMonad(this.monad).bind(in -> (LazySeq)fn.apply(in)).sequence();
    }

    public final SequenceM<Character> liftAndBindCharSequence(Function<? super T, CharSequence> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<String> liftAndBindFile(Function<? super T, File> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<String> liftAndBindURL(Function<? super T, URL> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    public final SequenceM<String> liftAndBindBufferedReader(Function<? super T, BufferedReader> fn) {
        return AsGenericMonad.asMonad(this.monad).liftAndBind(fn).sequence();
    }

    @Override
    public final SequenceM<T> filter(Predicate<? super T> fn) {
        return AsGenericMonad.asMonad(this.monad).filter((Predicate)fn).sequence();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.monad.forEach(action);
    }

    @Override
    public Iterator<T> iterator() {
        return this.monad.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.monad.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.monad.isParallel();
    }

    @Override
    public SequenceM<T> sequential() {
        return SequenceM.monad((Stream)this.monad.sequential());
    }

    @Override
    public SequenceM<T> unordered() {
        return SequenceM.monad((Stream)this.monad.unordered());
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.monad.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.monad.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.monad.mapToDouble(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.monad.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.monad.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.monad.flatMapToDouble(mapper);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.monad.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.monad.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.monad.toArray(generator);
    }

    @Override
    public long count() {
        return this.monad.count();
    }

    public SequenceM<T> intersperse(T value) {
        return new SequenceM(this.monad.flatMap((? super T t) -> Stream.of(value, t)).skip(1L));
    }

    public <U> SequenceM<U> ofType(Class<U> type) {
        return SequenceM.fromStream(this.monad.filter(type::isInstance).map((? super T t) -> t));
    }

    public <U> SequenceM<U> cast(Class<U> type) {
        return SequenceM.fromStream(this.monad.map(type::cast));
    }

    public Collection<T> toLazyCollection() {
        return StreamUtils.toLazyCollection(this.monad);
    }

    public Collection<T> toConcurrentLazyCollection() {
        return StreamUtils.toConcurrentLazyCollection(this.monad);
    }

    public Streamable<T> toLazyStreamable() {
        return AsStreamable.asStreamable(this.monad);
    }

    public Streamable<T> toConcurrentLazyStreamable() {
        return AsStreamable.asConcurrentStreamable(this.monad);
    }

    public SequenceM<T> reverse() {
        return new SequenceM<T>(StreamUtils.reverse(this.monad));
    }

    public static <T> SequenceM<T> of(T ... elements) {
        return new SequenceM<T>(Stream.of(elements));
    }

    public static <T> SequenceM<T> reversedOf(T ... elements) {
        return new SequenceM<T>(StreamUtils.reversedStream(Arrays.asList(elements)));
    }

    public static <T> SequenceM<T> reversedListOf(List<T> elements) {
        return new SequenceM<T>(StreamUtils.reversedStream(elements));
    }

    public static <T> SequenceM<T> fromStream(Stream<T> stream) {
        if (stream instanceof SequenceM) {
            return (SequenceM)stream;
        }
        return new SequenceM<T>(stream);
    }

    public static <T> SequenceM<T> fromIterable(Iterable<T> iterable) {
        return new SequenceM<T>(StreamUtils.stream(iterable));
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return this;
    }

    @Override
    public void close() {
    }

    public static <T> SequenceM<T> empty() {
        return SequenceM.of(new Object[0]);
    }

    public SequenceM<T> shuffle() {
        List<T> list = this.toList();
        Collections.shuffle(list);
        return new SequenceM(list.stream());
    }

    public SequenceM<T> appendStream(Stream<T> stream) {
        return new SequenceM<T>(Stream.concat(this.monad, stream));
    }

    public SequenceM<T> prependStream(Stream<T> stream) {
        return new SequenceM<T>(Stream.concat(stream, this.monad));
    }

    public SequenceM<T> append(T ... values) {
        return this.appendStream(Stream.of(values));
    }

    public SequenceM<T> prepend(T ... values) {
        return new SequenceM<T>(Stream.of(values)).appendStream(this.monad);
    }

    public SequenceM<T> insertAt(int pos, T ... values) {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.duplicatePos(pos);
        return ((SequenceM)((SequenceM)pair.v1).limit(pos)).append(values).appendStream(((SequenceM)pair.v2).skip(pos));
    }

    public SequenceM<T> deleteBetween(int start, int end) {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.duplicatePos(start);
        return ((SequenceM)((SequenceM)pair.v1).limit(start)).appendStream(((SequenceM)pair.v2).skip(end));
    }

    public SequenceM<T> insertStreamAt(int pos, SequenceM<T> stream) {
        Pair<SequenceM<T>, SequenceM<T>> pair = this.duplicatePos(pos);
        return ((SequenceM)((SequenceM)pair.v1).limit(pos)).appendStream(stream).appendStream(((SequenceM)pair.v2).skip(pos));
    }
}

