/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Reducers;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.HeadAndTail;
import com.aol.cyclops.streams.StreamUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StreamUtilsTest {
    int count;

    @Test
    public void headTailReplay() {
        Stream<String> helloWorld = Stream.of("hello", "world", "last");
        HeadAndTail headAndTail = StreamUtils.headAndTail(helloWorld);
        String head = (String)headAndTail.head();
        Assert.assertThat((Object)head, (Matcher)Matchers.equalTo((Object)"hello"));
        SequenceM tail = headAndTail.tail();
        Assert.assertThat((Object)tail.headAndTail().head(), (Matcher)Matchers.equalTo((Object)"world"));
    }

    @Test
    public void headTailReplayOptional() {
        Stream<String> helloWorld = Stream.of("hello", "world", "last");
        HeadAndTail headAndTail = (HeadAndTail)StreamUtils.headAndTailOptional(helloWorld).get();
        String head = (String)headAndTail.head();
        Assert.assertThat((Object)head, (Matcher)Matchers.equalTo((Object)"hello"));
        SequenceM tail = headAndTail.tail();
        Assert.assertThat((Object)tail.headAndTail().head(), (Matcher)Matchers.equalTo((Object)"world"));
    }

    @Test
    public void headTailReplayOptionalEmpty() {
        Stream<String> helloWorld = Stream.of(new String[0]);
        Optional headAndTail = StreamUtils.headAndTailOptional(helloWorld);
        Assert.assertTrue((!headAndTail.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testToLazyCollection() {
        System.out.println(StreamUtils.toLazyCollection(Stream.of(1, 2, 3, 4)).size());
    }

    @Test
    public void testOfType() {
        Assert.assertThat(StreamUtils.ofType(Stream.of(Integer.valueOf(1), "a", 2, "b", 3, null), Integer.class).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Integer.class).collect(Collectors.toList()), (Matcher)Matchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{"a", "b", null})));
        Assert.assertThat((Object)SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).ofType(Serializable.class).toList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3)}));
    }

    @Test
    public void testCastPast() {
        SequenceM.of((Object[])new Serializable[]{Integer.valueOf(1), "a", Integer.valueOf(2), "b", Integer.valueOf(3), null}).cast(Date.class).map(d -> d.getTime());
    }

    @Test
    public void testIntersperse() {
        Assert.assertThat((Object)SequenceM.of((Object[])new Integer[]{1, 2, 3}).intersperse((Object)0).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 0, 2, 0, 3)));
    }

    @Test
    public void testReverse() {
        Assert.assertThat(StreamUtils.reverse(Stream.of(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testReversedStream() {
        StreamUtils.reversedStream(Arrays.asList(1, 2, 3)).map(i -> i * 100).forEach(System.out::println);
        Assert.assertThat(StreamUtils.reversedStream(Arrays.asList(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testCycleStreamOfU() {
        Assert.assertThat(StreamUtils.cycle(Stream.of(1, 2, 3)).limit(6L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testCycleStreamableOfU() {
        Assert.assertThat(StreamUtils.cycle((Streamable)AsStreamable.asStreamable(Stream.of(1, 2, 3))).limit(6L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testStreamIterableOfU() {
        Assert.assertThat(StreamUtils.stream(Arrays.asList(1, 2, 3)).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testStreamIteratorOfU() {
        Assert.assertThat(StreamUtils.stream(Arrays.asList(1, 2, 3).iterator()).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testStreamMapOfKV() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hello", "world");
        Assert.assertThat(StreamUtils.stream(map).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(new AbstractMap.SimpleEntry<String, String>("hello", "world"))));
    }

    @Test
    public void testCollectorsStreamable() {
        List result = StreamUtils.collect(Stream.of(1, 2, 3), (Streamable)Streamable.of((Object[])new Collector[]{Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)}));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testCollectors2() {
        List result = StreamUtils.collect(Stream.of(1, 2, 3), Stream.of(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testCollectorsIterables() {
        List result = StreamUtils.collect(Stream.of(1, 2, 3), Arrays.asList(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void reducer() {
        Monoid concat = Monoid.of((Object)"", (a, b) -> a + b);
        Monoid join = Monoid.of((Object)"", (a, b) -> a + "," + b);
        Assert.assertThat((Object)StreamUtils.reduce(Stream.of("hello", "world", "woo!"), Stream.of(concat, join)), (Matcher)Matchers.equalTo(Arrays.asList("helloworldwoo!", ",hello,world,woo!")));
    }

    @Test
    public void reducer2() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = StreamUtils.reduce(Stream.of(1, 2, 3, 4), Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(10, 24)));
    }

    @Test
    public void testCollectors() {
        List result = StreamUtils.collect(Stream.of(1, 2, 3), Arrays.asList(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void testCycleWhile() {
        this.count = 0;
        Assert.assertThat(StreamUtils.cycleWhile(Stream.of(1, 2, 2), next -> this.count++ < 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleUntil() {
        this.count = 0;
        Assert.assertThat(StreamUtils.cycleUntil(Stream.of(1, 2, 2, 3), next -> this.count++ > 10).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 3, 1, 2, 2, 3, 1, 2, 2)));
    }

    @Test
    public void testCycle() {
        Assert.assertThat(StreamUtils.cycle((int)3, (Streamable)Streamable.of((Object[])new Integer[]{1, 2, 2})).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleReduce() {
        Assert.assertThat(StreamUtils.cycle(Stream.of(1, 2, 2), (Monoid)Reducers.toCountInt(), (int)3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 3, 3)));
    }

    @Test
    public void testSkipUntil() {
        Assert.assertThat(StreamUtils.skipUntil(Stream.of(4, 3, 6, 7), i -> i == 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipWhile() {
        Assert.assertThat(StreamUtils.skipWhile(Stream.of(4, 3, 6, 7).sorted(), i -> i < 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testLimitWhile() {
        Assert.assertThat(StreamUtils.limitWhile(Stream.of(4, 3, 6, 7).sorted(), i -> i < 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 4)));
    }

    @Test
    public void testLimitUntil() {
        Assert.assertThat(StreamUtils.limitUntil(Stream.of(4, 3, 6, 7), i -> i == 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void zipOptional() {
        Stream zipped = StreamUtils.zip(Stream.of(1, 2, 3), (AnyM)AsAnyM.anyM(Optional.of(2)), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.collect(Collectors.toList()).get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipOptionalSequence() {
        Stream zipped = StreamUtils.zip(Stream.of(1, 2, 3), (AnyM)AsAnyM.anyM(Optional.of(2)), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.collect(Collectors.toList()).get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipStream() {
        Stream zipped = StreamUtils.zipStream(Stream.of(1, 2, 3), Stream.of(2, 3, 4), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.collect(Collectors.toList()).get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void zipSequence() {
        Stream zipped = StreamUtils.zip(Stream.of(1, 2, 3), (SequenceM)SequenceM.of((Object[])new Integer[]{2, 3, 4}), (a, b) -> Arrays.asList(a, b));
        List zip = (List)zipped.collect(Collectors.toList()).get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void sliding() {
        List list = StreamUtils.sliding(Stream.of(1, 2, 3, 4, 5, 6), (int)2).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{2, 3}));
    }

    @Test
    public void grouped() {
        List list = StreamUtils.grouped(Stream.of(1, 2, 3, 4, 5, 6), (int)3).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void startsWith() {
        Assert.assertTrue((boolean)StreamUtils.startsWith(Stream.of(1, 2, 3, 4), Arrays.asList(1, 2, 3)));
    }

    @Test
    public void startsWithIterator() {
        Assert.assertTrue((boolean)StreamUtils.startsWith(Stream.of(1, 2, 3, 4), Arrays.asList(1, 2, 3).iterator()));
    }

    @Test
    public void scanLeft() {
        Assert.assertEquals(Arrays.asList("", "a", "ab", "abc"), StreamUtils.scanLeft(Stream.of("a", "b", "c"), (Monoid)Reducers.toString((String)"")).collect(Collectors.toList()));
    }

    @Test
    public void convertStreamToLazySeq() {
        Assert.assertThat(Arrays.asList(1, 2, 3), (Matcher)Matchers.equalTo((Object)StreamUtils.steamToLazySeq(Stream.of(1, 2, 3)).toList()));
    }

    @Test
    public void xMatch() {
        Assert.assertTrue((boolean)StreamUtils.xMatch(Stream.of(1, 2, 3, 5, 6, 7), (int)3, i -> i > 4));
    }

    @Test
    public void testIntersperse2() {
        Assert.assertThat(StreamUtils.intersperse(Stream.of(1, 2, 3), (Object)0).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 0, 2, 0, 3)));
    }

    @Test(expected=ClassCastException.class)
    public void cast() {
        StreamUtils.cast(Stream.of(1, 2, 3), String.class).collect(Collectors.toList());
    }
}

