/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.streams.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LiftAndBindStreamUtilsTest {
    @Test
    public void testLiftAndBindFile() {
        List result = StreamUtils.liftAndBindFile(Stream.of("input.file").map(this.getClass().getClassLoader()::getResource).peek(System.out::println).map(URL::getFile), File::new).collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void testLiftAndBindURL() {
        List result = StreamUtils.liftAndBindURL(Stream.of("input.file"), this.getClass().getClassLoader()::getResource).collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void testLiftAndBindString() {
        List result = StreamUtils.liftAndBindCharSequence(Stream.of("input.file"), i -> "hello world").collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList(Character.valueOf('h'), Character.valueOf('e'), Character.valueOf('l'), Character.valueOf('l'), Character.valueOf('o'), Character.valueOf(' '), Character.valueOf('w'), Character.valueOf('o'), Character.valueOf('r'), Character.valueOf('l'), Character.valueOf('d'))));
    }

    @Test
    public void testLiftAndBindBufferedReader() {
        List result = StreamUtils.liftAndBindBufferedReader(Stream.of("input.file").map(this.getClass().getClassLoader()::getResourceAsStream).map(InputStreamReader::new), in -> new BufferedReader((Reader)in)).collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }
}

