/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.AsAnyM;
import com.nurkiewicz.lazyseq.LazySeq;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jooq.lambda.Seq;
import org.junit.Assert;
import org.junit.Test;

public class FlatMapTest {
    @Test
    public void flatMap() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 3)).flatMapStream(i -> Stream.of(i)).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void flatMapCrossType() {
        Assert.assertThat((Object)AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 3))).flatMapStream(i -> Stream.of(Integer.valueOf(i.size()))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3)));
    }

    @Test
    public void flatMapCrossTypeNotCollection() {
        Assert.assertThat((Object)AsAnyM.anyM(Optional.of(1)).flatMapStream(i -> Stream.of(Integer.valueOf(i + 2))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3)));
    }

    @Test
    public void flatMapCrossTypeNotCollectionUnwrap() {
        Assert.assertThat((Object)AsAnyM.anyM(Optional.of(1)).flatMapStream(i -> Stream.of(Integer.valueOf(i + 2))).unwrap(), (Matcher)Matchers.equalTo(Optional.of(Arrays.asList(3))));
    }

    @Test
    public void flatMapCollection() {
        Assert.assertThat((Object)AsAnyM.anyM(Optional.of(20)).flatMapCollection(i -> Arrays.asList(1, 2, i)).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 20)));
    }

    @Test
    public void flatMap2() {
        Assert.assertThat((Object)AsAnyM.anyM((LazySeq)LazySeq.of((Object)1, (Object)2, (Object)3)).flatMapStream(i -> Stream.of(Integer.valueOf(i + 2))).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapToLazySeq() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 3)).flatMapLazySeq(i -> LazySeq.of((Object)(i + 2))).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapToSeq() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 3)).flatMapStream(i -> Seq.of((Object)(i + 2))).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapSeqToStream() {
        Assert.assertThat((Object)AsAnyM.anyM((Stream)Seq.of((Object[])new Integer[]{1, 2, 3})).flatMapStream(i -> Stream.of(Integer.valueOf(i + 2))).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapSeqToCompletableFuture() {
        Assert.assertThat((Object)AsAnyM.anyM((Stream)Seq.of((Object[])new Integer[]{1, 2, 3})).flatMapCompletableFuture(i -> CompletableFuture.completedFuture(i + 2)).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }

    @Test
    public void flatMapSeqToSequenceM() {
        Assert.assertThat((Object)AsAnyM.anyM((Stream)Seq.of((Object[])new Integer[]{1, 2, 3})).flatMapSequenceM(i -> AsAnyM.anyM(CompletableFuture.completedFuture(i + 2)).asSequence()).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 5)));
    }
}

