/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.AsAnyM;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class UnwrapTest {
    @Test
    public void unwrap() {
        Stream stream = AsAnyM.anyM((Object[])new String[]{"hello", "world"}).asSequence().unwrapStream();
        Assert.assertThat(stream.collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void unwrapOptional() {
        Optional stream = AsAnyM.anyM((Object[])new String[]{"hello", "world"}).asSequence().unwrapOptional();
        Assert.assertThat(stream.get(), (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void unwrapOptionalList() {
        Optional stream = AsAnyM.anyM(Optional.of(Arrays.asList("hello", "world"))).toSequence().unwrapOptional();
        Assert.assertThat(stream.get(), (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void unwrapCompletableFuture() {
        CompletableFuture cf = AsAnyM.anyM((Object[])new String[]{"hello", "world"}).asSequence().unwrapCompletableFuture();
        Assert.assertThat(cf.join(), (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void unwrapCompletableFutureList() {
        CompletableFuture cf = AsAnyM.anyM(CompletableFuture.completedFuture(Arrays.asList("hello", "world"))).toSequence().unwrapCompletableFuture();
        Assert.assertThat(cf.join(), (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }
}

