/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.lambda.monads.SequenceM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StreamTest {
    Object val;

    public static <U> SequenceM<U> of(U ... array) {
        return AsAnyM.anyM((Object[])array).asSequence();
    }

    @Test
    public void testAnyMatch() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).anyMatch(it -> it.equals(3)), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testAllMatch() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).allMatch(it -> it > 0 && it < 6), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testNoneMatch() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).noneMatch(it -> it == 5000), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testAnyMatchFalse() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).anyMatch(it -> it.equals(8)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testAllMatchFalse() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).allMatch(it -> it < 0 && it > 6), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testFlatMap() {
        Assert.assertThat((Object)StreamTest.of(Arrays.asList("1", "10"), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("4")).flatMapStream(list -> list.stream()).collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)"10"));
    }

    @Test
    public void testMapReduce() {
        Assert.assertThat(StreamTest.of(1, 2, 3, 4, 5).map(it -> it * 100).reduce((acc, next) -> acc + next).get(), (Matcher)Matchers.equalTo((Object)1500));
    }

    @Test
    public void testMapReduceSeed() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).map(it -> it * 100).reduce((Object)50, (acc, next) -> acc + next), (Matcher)Matchers.equalTo((Object)1550));
    }

    @Test
    public void testMapReduceCombiner() {
        Assert.assertThat((Object)StreamTest.of(1, 2, 3, 4, 5).map(it -> it * 100).reduce((Object)0, (acc, next) -> acc + next, Integer::sum), (Matcher)Matchers.equalTo((Object)1500));
    }

    @Test
    public void testFindFirst() {
        Assert.assertThat(Arrays.asList(1, 2, 3), (Matcher)Matchers.hasItem(StreamTest.of(1, 2, 3, 4, 5).filter(it -> it < 3).findFirst().get()));
    }

    @Test
    public void testFindAny() {
        Assert.assertThat(Arrays.asList(1, 2, 3), (Matcher)Matchers.hasItem(StreamTest.of(1, 2, 3, 4, 5).filter(it -> it < 3).findAny().get()));
    }

    @Test
    public void testDistinct() {
        Assert.assertThat((Object)((List)StreamTest.of(1, 1, 1, 2, 1).distinct().collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)StreamTest.of(1, 1, 1, 2, 1).distinct().collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat((Object)StreamTest.of(1, 1, 1, 2, 1).distinct().collect(Collectors.toList()), (Matcher)Matchers.hasItem((Object)2));
    }

    @Test
    public void testLimit() {
        Assert.assertThat((Object)((List)StreamTest.of(1, 2, 3, 4, 5).limit(2).collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testSkip() {
        Assert.assertThat((Object)((List)StreamTest.of(1, 2, 3, 4, 5).skip(2).collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testMax() {
        Assert.assertThat(StreamTest.of(1, 2, 3, 4, 5).max((t1, t2) -> t1 - t2).get(), (Matcher)Matchers.equalTo((Object)5));
    }

    @Test
    public void testMin() {
        Assert.assertThat(StreamTest.of(1, 2, 3, 4, 5).min((t1, t2) -> t1 - t2).get(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testMapToInt() {
        Assert.assertThat((Object)StreamTest.of("1", "2", "3", "4").mapToInt(it -> Integer.valueOf(it)).max().getAsInt(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void mapToLong() {
        Assert.assertThat((Object)StreamTest.of("1", "2", "3", "4").mapToLong(it -> Long.valueOf(it)).max().getAsLong(), (Matcher)Matchers.equalTo((Object)4L));
    }

    @Test
    public void mapToDouble() {
        Assert.assertThat((Object)StreamTest.of("1", "2", "3", "4").mapToDouble(it -> Double.valueOf(it)).max().getAsDouble(), (Matcher)Matchers.equalTo((Object)4.0));
    }

    @Test
    public void flatMapToInt() {
        Assert.assertThat((Object)StreamTest.of(Arrays.asList("1", "10"), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("4")).flatMapToInt(list -> list.stream().mapToInt(Integer::valueOf)).max().getAsInt(), (Matcher)Matchers.equalTo((Object)10));
    }

    @Test
    public void flatMapToLong() {
        Assert.assertThat((Object)StreamTest.of(Arrays.asList("1", "10"), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("4")).flatMapToLong(list -> list.stream().mapToLong(Long::valueOf)).max().getAsLong(), (Matcher)Matchers.equalTo((Object)10L));
    }

    @Test
    public void flatMapToDouble() {
        Assert.assertThat((Object)StreamTest.of(Arrays.asList("1", "10"), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("4")).flatMapToDouble(list -> list.stream().mapToDouble(Double::valueOf)).max().getAsDouble(), (Matcher)Matchers.equalTo((Object)10.0));
    }

    @Test
    public void sorted() {
        Assert.assertThat((Object)StreamTest.of(1, 5, 3, 4, 2).sorted().collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void sortedComparator() {
        Assert.assertThat((Object)StreamTest.of(1, 5, 3, 4, 2).sorted((t1, t2) -> t2 - t1).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(5, 4, 3, 2, 1)));
    }

    @Test
    public void forEach() {
        ArrayList list = new ArrayList();
        StreamTest.of(1, 5, 3, 4, 2).forEach(it -> list.add(it));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)2));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)3));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)4));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)5));
    }

    @Test
    public void forEachOrderedx() {
        ArrayList list = new ArrayList();
        StreamTest.of(1, 5, 3, 4, 2).forEachOrdered(it -> list.add(it));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)2));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)3));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)4));
        Assert.assertThat(list, (Matcher)Matchers.hasItem((Object)5));
    }

    @Test
    public void testToArray() {
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5), (Matcher)Matchers.hasItem((Object)StreamTest.of(1, 5, 3, 4, 2).toArray()[0]));
    }

    @Test
    public void testToArrayGenerator() {
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5), (Matcher)Matchers.hasItem((Object)((Integer[])StreamTest.of(1, 5, 3, 4, 2).toArray(Integer[]::new))[0]));
    }

    @Test
    public void testCount() {
        Assert.assertThat((Object)StreamTest.of(1, 5, 3, 4, 2).count(), (Matcher)Matchers.equalTo((Object)5L));
    }

    @Test
    public void collectSBB() {
        List list = (List)StreamTest.of(1, 2, 3, 4, 5).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)5));
    }

    @Test
    public void collect() {
        Assert.assertThat((Object)((List)StreamTest.of(1, 2, 3, 4, 5).collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)5));
        Assert.assertThat((Object)((Set)StreamTest.of(1, 1, 1, 2).collect(Collectors.toSet())).size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testFilter() {
        Assert.assertThat((Object)((List)StreamTest.of(1, 1, 1, 2).filter(it -> it == 1).collect(Collectors.toList())).size(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testMap() {
        Assert.assertThat(((List)StreamTest.of(1).map(it -> it + 100).collect(Collectors.toList())).get(0), (Matcher)Matchers.equalTo((Object)101));
    }

    @Test
    public void testPeek() {
        this.val = null;
        StreamTest.of(1).map(it -> it + 100).peek(it -> {
            this.val = it;
        }).collect(Collectors.toList());
        Assert.assertThat((Object)this.val, (Matcher)Matchers.equalTo((Object)101));
    }
}

