/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.lambda.api.AsAnyMList;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Reducers;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.AnyMonads;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AnyMTest {
    int count;

    @Test
    public void test() {
        List list = (List)AsAnyM.anyM(Stream.of(Arrays.asList(1, 3))).flatMap(c -> AsAnyM.anyM(c.stream())).asSequence().map(i -> i * 2).peek(System.out::println).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(2, 6), (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void testMixed() {
        List list = AsAnyM.anyM(Stream.of(Arrays.asList(1, 3), null)).flatMap(d -> AsAnyM.anyM(Optional.ofNullable(d))).map(i -> i.size()).peek(System.out::println).asSequence().toList();
        Assert.assertThat(Arrays.asList(2), (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void testCycleWhile() {
        this.count = 0;
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 2)).asSequence().cycleWhile(next -> this.count++ < 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycle() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 2)).asSequence().cycle(3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleReduce() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 2)).asSequence().cycle(Reducers.toCountInt(), 3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 3, 3)));
    }

    @Test
    public void testCycleMonad() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2)).asSequence().cycle(Optional.class, 2).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(Optional.of(1), Optional.of(2), Optional.of(1), Optional.of(2))));
    }

    @Test
    public void testJoin() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 2)).map(b -> Stream.of(b)).flatten().asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2)));
    }

    @Test
    public void testJoin2() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(Arrays.asList(1, 2), Arrays.asList(2))).flatten().asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2)));
    }

    @Test
    public void testToSet() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 2)).asSequence().toSet().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testToList() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 3)).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testCollect() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 3)).asSequence().collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testToListFlatten() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(1, 2, 3, null)).bind(Optional::ofNullable).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testToListOptional() {
        Assert.assertThat((Object)AsAnyM.anyM(Optional.of(1)).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1)));
    }

    @Test
    public void testFold() {
        Supplier<AnyM> s = () -> AsAnyM.anyM(Stream.of("a", "b", "c"));
        Assert.assertThat((Object)"cba", (Matcher)Matchers.equalTo((Object)s.get().asSequence().foldRight(Reducers.toString((String)""))));
        Assert.assertThat((Object)"abc", (Matcher)Matchers.equalTo((Object)s.get().asSequence().foldLeft(Reducers.toString((String)""))));
        Assert.assertThat((Object)3, (Matcher)Matchers.equalTo((Object)s.get().map(i -> "" + i.length()).asSequence().foldRightMapToType(Reducers.toCountInt())));
        Assert.assertThat((Object)3, (Matcher)Matchers.equalTo((Object)s.get().map(i -> "" + i.length()).asSequence().foldLeftMapToType(Reducers.toCountInt())));
    }

    @Test
    public void testLift() {
        List result = AsAnyM.anyM(Stream.of("input.file")).map(this.getClass().getClassLoader()::getResource).peek(System.out::println).map(URL::getFile).liftAndBind(File::new).asSequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void testSequence() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        AnyM futureList = AnyMonads.sequence((Collection)AsAnyMList.completableFutureToAnyMList(futures));
        List collected = (List)((CompletableFuture)futureList.unwrap()).join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat(list.get(next), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void testSequenceList() {
        AnyM futureList = AnyMonads.sequence((Collection)AsAnyMList.collectionToAnyMList(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4))));
        Assert.assertThat((Object)futureList.toSequence(c -> c).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    public void testSequenceStream() {
        AnyM result = AnyMonads.sequence((Collection)AsAnyMList.streamToAnyMList(Arrays.asList(Stream.of(1, 2), Stream.of(3, 4))));
        Assert.assertThat((Object)result.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    public void testSequenceOptional() {
        AnyM futureList = AnyMonads.sequence((Collection)AsAnyMList.optionalToAnyMList(Arrays.asList(Optional.of(7), Optional.of(8), Optional.of(9))));
        Assert.assertThat((Object)futureList.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(7, 8, 9)));
    }

    @Test
    public void traversableTestToList() {
        List list = AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 3, 4, 5, 6))).toSequence(i -> i.stream()).toList();
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void traversableTest() {
        List list = (List)AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 3, 4, 5, 6))).toSequence(i -> i.stream()).collect(Collectors.toList());
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void traversableTestStream() {
        List list = (List)AsAnyM.anyM(Stream.of(Arrays.asList(1, 2, 3, 4, 5, 6))).toSequence(i -> i.stream()).collect(Collectors.toList());
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void traversableTestStreamNested() {
        List list = (List)AsAnyM.anyM(Stream.of(Stream.of(1, 2, 3, 4, 5, 6))).toSequence(i -> i).collect(Collectors.toList());
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void testTraverse() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        AnyM futureList = AnyMonads.traverse((Collection)AsAnyMList.completableFutureToAnyMList(futures), i -> "hello" + i);
        List collected = (List)((CompletableFuture)futureList.unwrap()).join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat((Object)("hello" + list.get(next)), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void testFlatMap() {
        AnyM m = AsAnyM.anyM(Stream.of(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3)));
        AnyM intM = m.flatMap(c -> AsAnyM.anyM(c.stream()));
        List list = intM.asSequence().toList();
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void testBind() {
        AnyM m = AsAnyM.anyM(Stream.of(Arrays.asList(1, 2, 3), Arrays.asList(1, 2, 3)));
        AnyM intM = m.bind(Collection::stream);
        List list = intM.asSequence().toList();
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 1, 2, 3)));
    }

    @Test
    public void zipOptional() {
        Stream zipped = AsAnyM.anyM(Stream.of(1, 2, 3)).asSequence().zip(AsAnyM.anyM(Optional.of(2)), (a, b) -> Arrays.asList(a, b)).toStream();
        List zip = (List)zipped.collect(Collectors.toList()).get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipOptionalSequence() {
        Stream zipped = AsAnyM.anyM(Stream.of(1, 2, 3)).asSequence().zip(AsAnyM.anyM(Optional.of(2)).asSequence(), (a, b) -> Arrays.asList(a, b)).toStream();
        List zip = (List)zipped.collect(Collectors.toList()).get(0);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void zipStream() {
        Stream zipped = AsAnyM.anyM(Stream.of(1, 2, 3)).asSequence().zip(Stream.of(2, 3, 4), (a, b) -> Arrays.asList(a, b)).toStream();
        List zip = (List)zipped.collect(Collectors.toList()).get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void sliding() {
        List list = (List)AsAnyM.anyM(Stream.of(1, 2, 3, 4, 5, 6)).asSequence().sliding(2).collect(Collectors.toList());
        System.out.println(list);
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{2, 3}));
    }

    @Test
    public void grouped() {
        List list = (List)AsAnyM.anyM(Stream.of(1, 2, 3, 4, 5, 6)).asSequence().grouped(3).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void groupedOptional() {
        List list = (List)AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 3, 4, 5, 6))).toSequence().grouped(3).collect(Collectors.toList());
        Assert.assertThat(list.get(0), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat(list.get(1), (Matcher)Matchers.hasItems((Object[])new Integer[]{4, 5, 6}));
    }

    @Test
    public void startsWith() {
        Assert.assertTrue((boolean)AsAnyM.anyM(Stream.of(1, 2, 3, 4)).asSequence().startsWith(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void startsWithIterator() {
        Assert.assertTrue((boolean)AsAnyM.anyM(Stream.of(1, 2, 3, 4)).asSequence().startsWith(Arrays.asList(1, 2, 3).iterator()));
    }

    @Test
    public void distinctOptional() {
        List list = (List)AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 2, 2, 5, 6))).toSequence().distinct().collect(Collectors.toList());
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void scanLeft() {
        Assert.assertEquals(Arrays.asList("", "a", "ab", "abc"), (Object)AsAnyM.anyM(Stream.of("a", "b", "c")).asSequence().scanLeft(Reducers.toString((String)"")).toList());
    }

    @Test
    public void testCollectors() {
        List result = AsAnyM.anyM(Stream.of(1, 2, 3)).asSequence().collect(Stream.of(Collectors.toList(), Collectors.summingInt(Integer::intValue), Collectors.averagingInt(Integer::intValue)));
        Assert.assertThat(result.get(0), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat(result.get(1), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat(result.get(2), (Matcher)Matchers.equalTo((Object)2.0));
    }

    @Test
    public void reducer1() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsAnyM.anyM(Stream.of(1, 2, 3, 4)).asSequence().reduce(Arrays.asList(sum, mult).stream());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(10, 24)));
    }

    @Test
    public void reducer2() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsAnyM.anyM(Optional.of(Stream.of(1, 2, 3, 4))).toSequence().reduce(Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(10, 24)));
    }

    @Test
    public void reducer3() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsAnyM.anyM(Optional.of(Stream.of(new Object[0]))).toSequence().reduce(Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(0, 1)));
    }

    @Test
    public void reducer4() {
        Monoid sum = Monoid.of((Object)0, (a, b) -> a + b);
        Monoid mult = Monoid.of((Object)1, (a, b) -> a * b);
        List result = AsAnyM.anyM(Optional.empty()).toSequence().reduce(Arrays.asList(sum, mult));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(0, 1)));
    }

    @Test
    public void aggregate() {
        List result = AsAnyM.anyM(Stream.of(1, 2, 3, 4)).aggregate(AsAnyM.anyM(Optional.of(5))).asSequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void aggregate2() {
        List result = AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 3, 4))).aggregateUntyped(AsAnyM.anyM(CompletableFuture.completedFuture(5))).toSequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void aggregate3() {
        List result = AsAnyM.anyM(Optional.of(Arrays.asList(1, 2, 3, 4))).aggregateUntyped(AsAnyM.anyM(CompletableFuture.supplyAsync(() -> Arrays.asList(5, 6)))).toSequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testApplyM() {
        AnyM applied = AsAnyM.anyM(Stream.of(1, 2, 3)).applyM(AsAnyM.anyM((Streamable)Streamable.of((Object[])new Function[]{a -> a + 1, a -> a * 2})));
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 2, 3, 4, 4, 6)));
    }

    @Test
    public void testApplyMOptional() {
        AnyM applied = AsAnyM.anyM(Optional.of(2)).applyM(AsAnyM.anyM(Optional.of(a -> a + 1)));
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3)));
    }

    @Test
    public void testApplyMOptionalEmpty() {
        AnyM applied = AsAnyM.anyM(Optional.of(2)).applyM(AsAnyM.anyM(Optional.empty()));
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testApplyMEmptyOptional() {
        AnyM empty = AsAnyM.anyM(Optional.empty());
        AnyM applied = empty.applyM(AsAnyM.anyM(Optional.of(a -> a + 1)));
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testSimpleFilter() {
        AnyM applied = AsAnyM.anyM(Stream.of(1, 2, 3)).simpleFilter(AsAnyM.anyM((Streamable)Streamable.of((Object[])new Predicate[]{a -> a > 5, a -> a < 3})));
        Assert.assertThat((Object)applied.map(s -> s.collect(Collectors.toList())).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(new Object[0]))));
    }

    @Test
    public void testSimpleFilterOptional() {
        AnyM applied = AsAnyM.anyM(Optional.of(2)).simpleFilter(AsAnyM.anyM((Streamable)Streamable.of((Object[])new Predicate[]{a -> a > 5, a -> a < 3})));
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2)));
    }

    @Test
    public void testReplicateM() {
        AnyM applied = AsAnyM.anyM(Optional.of(2)).replicateM(5);
        Assert.assertThat((Object)applied.unwrap(), (Matcher)Matchers.equalTo(Optional.of(Arrays.asList(2, 2, 2, 2, 2))));
    }

    @Test
    public void testReplicateMStream() {
        AnyM applied = AsAnyM.anyM(Stream.of(2, 3, 4)).replicateM(5);
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4)));
    }

    @Test
    public void testSorted() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().sorted().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 6, 7)));
    }

    @Test
    public void testSortedCompartor() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().sorted((a, b) -> b - a).toList(), (Matcher)Matchers.equalTo(Arrays.asList(7, 6, 4, 3)));
    }

    @Test
    public void testSkip() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().skip(2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipUntil() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().skipUntil(i -> i == 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipWhile() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().sorted().skipWhile(i -> i < 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testLimit() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().limit(2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void testLimitUntil() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().limitUntil(i -> i == 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void testLimitWhile() {
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(4, 3, 6, 7)).asSequence().sorted().limitWhile(i -> i < 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4)));
    }

    @Test
    public void testLiftMSimplex() {
        Function lifted = AnyMonads.liftM(a -> a + 3);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testReduceM() {
        Monoid optionalAdd = Monoid.of(Optional.of(0), (a, b) -> Optional.of((Integer)a.get() + (Integer)b.get()));
        Assert.assertThat((Object)AsAnyM.anyM(Stream.of(2, 8, 3, 1)).reduceM(optionalAdd).unwrap(), (Matcher)Matchers.equalTo(Optional.of(14)));
    }

    @Test
    public void testLiftM2Simplex() {
        BiFunction lifted = AnyMonads.liftM2((a, b) -> a + b);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)), AsAnyM.anyM(Optional.of(4)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo((Object)7));
    }

    @Test
    public void testLiftM2SimplexNull() {
        BiFunction lifted = AnyMonads.liftM2((a, b) -> a + b);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)), AsAnyM.anyM(Optional.ofNullable(null)));
        Assert.assertThat((Object)((Optional)result.unwrap()).isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    private Integer add(Integer a, Integer b) {
        return a + b;
    }

    @Test
    public void testLiftM2Mixed() {
        BiFunction lifted = AnyMonads.liftM2(this::add);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)), AsAnyM.anyM(Stream.of(4, 6, 7)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo(Arrays.asList(7, 9, 10)));
    }
}

