/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.lambda.api.Streamable;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ReversedIterator<U>
implements Streamable<U> {
    private final List<U> list;

    public List<U> getValue() {
        return this.list;
    }

    @Override
    public Stream<U> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.reversedIterator(), 16), false);
    }

    public Iterator<U> reversedIterator() {
        final ListIterator<U> iterator = this.list.listIterator(this.list.size());
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasPrevious();
            }

            @Override
            public U next() {
                return iterator.previous();
            }
        };
    }

    @ConstructorProperties(value={"list"})
    public ReversedIterator(List<U> list) {
        this.list = list;
    }
}

