/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.utils;

import com.aol.cyclops.lambda.utils.LazyImmutableSetMoreThanOnceException;
import java.util.function.Function;
import java.util.function.Supplier;

public class LazyImmutable<T>
implements Supplier<T> {
    private T value;
    private boolean set = false;

    @Override
    public T get() {
        return this.value;
    }

    public static <T> LazyImmutable<T> unbound() {
        return new LazyImmutable<T>();
    }

    public static <T> LazyImmutable<T> of(T value) {
        LazyImmutable<T> v = new LazyImmutable<T>();
        v.setOnce(value);
        return v;
    }

    public static <T> LazyImmutable<T> def() {
        return new LazyImmutable<T>();
    }

    public <R> LazyImmutable<R> map(Function<T, R> fn) {
        if (!this.set) {
            return this;
        }
        return LazyImmutable.of(fn.apply(this.value));
    }

    public <R> LazyImmutable<R> flatMap(Function<T, LazyImmutable<R>> fn) {
        if (!this.set) {
            return this;
        }
        return fn.apply(this.value);
    }

    public synchronized LazyImmutable<T> setOnce(T val) throws LazyImmutableSetMoreThanOnceException {
        if (!this.set) {
            this.value = val;
            this.set = true;
            return this;
        }
        throw new LazyImmutableSetMoreThanOnceException("Current value " + this.value + " attempt to reset to " + val);
    }

    private synchronized T setOnceFromSupplier(Supplier<T> lazy) {
        if (!this.set) {
            this.value = lazy.get();
            this.set = true;
            return this.value;
        }
        return this.value;
    }

    public T computeIfAbsent(Supplier<T> lazy) {
        if (this.set) {
            return this.value;
        }
        return this.setOnceFromSupplier(lazy);
    }

    public String toString() {
        return "LazyImmutable(value=" + this.value + ", set=" + this.set + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyImmutable)) {
            return false;
        }
        LazyImmutable other = (LazyImmutable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.set == other.set;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LazyImmutable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 0 : $value.hashCode());
        result = result * 59 + (this.set ? 79 : 97);
        return result;
    }
}

