/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.api.AsGenericMonad;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.lambda.monads.Filterable;
import com.aol.cyclops.lambda.monads.Functor;
import com.aol.cyclops.lambda.monads.Simplex;
import com.aol.cyclops.lambda.monads.SimplexImpl;
import com.aol.cyclops.streams.Pair;
import com.aol.cyclops.streams.StreamUtils;
import com.nurkiewicz.lazyseq.LazySeq;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Monad<MONAD, T>
extends Functor<T>,
Filterable<T>,
Streamable<T>,
AsGenericMonad {
    public <MONAD, T> Monad<MONAD, T> withMonad(Object var1);

    public Object getMonad();

    default public <T> Monad<MONAD, T> withFunctor(T functor) {
        return this.withMonad(functor);
    }

    @Override
    default public Object getFunctor() {
        return this.getMonad();
    }

    @Override
    default public Filterable<T> withFilterable(T filter) {
        return this.withMonad(filter);
    }

    @Override
    default public Object getFilterable() {
        return this.getMonad();
    }

    default public Monad<MONAD, T> filter(Predicate<T> fn) {
        return (Monad)Filterable.super.filter(fn);
    }

    default public <R> Monad<MONAD, R> map(Function<T, R> fn) {
        return (Monad)Functor.super.map(fn);
    }

    default public Monad<MONAD, T> peek(Consumer<T> c) {
        return (Monad)Functor.super.peek(c);
    }

    default public void allMatch(Predicate<T> c) {
        this.stream().allMatch(c);
    }

    default public void anyMatch(Predicate<T> c) {
        this.stream().anyMatch(c);
    }

    default public Optional<T> findFirst() {
        return this.stream().findFirst();
    }

    default public Optional<T> findAny() {
        return this.stream().findAny();
    }

    default public <R> Monad<MONAD, T> bind(Function<T, R> fn) {
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.getMonad()).executeflatMap(this.getMonad(), fn));
    }

    default public <MONAD1, R> Monad<MONAD1, R> liftAndBind(Function<T, ?> fn) {
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.getMonad()).liftAndFlatMap(this.getMonad(), fn));
    }

    default public <T1> Monad<T, T1> flatten() {
        return this.flatMap(t -> t);
    }

    default public <R> R mapReduce(Monoid<R> reducer) {
        return reducer.mapReduce(this.stream());
    }

    default public <R> R mapReduce(Function<T, R> mapper, Monoid<R> reducer) {
        return reducer.reduce(this.stream().map(mapper));
    }

    default public <R, A> R collect(Collector<T, A, R> collector) {
        return this.stream().collect(collector);
    }

    default public List collect(Stream<Collector> collectors) {
        return StreamUtils.collect(this.stream(), collectors);
    }

    default public T reduce(Monoid<T> reducer) {
        return reducer.reduce(this.stream());
    }

    default public List<T> reduce(Stream<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.stream(), reducers);
    }

    default public List<T> reduce(Iterable<Monoid<T>> reducers) {
        return StreamUtils.reduce(this.stream(), reducers);
    }

    default public T foldLeft(Monoid<T> reducer) {
        return this.reduce(reducer);
    }

    default public <T> T foldLeftMapToType(Monoid<T> reducer) {
        return reducer.mapReduce(this.stream());
    }

    default public T foldRight(Monoid<T> reducer) {
        return reducer.reduce(StreamUtils.reverse(this.stream()));
    }

    default public <T> T foldRightMapToType(Monoid<T> reducer) {
        return reducer.mapReduce(StreamUtils.reverse(this.stream()));
    }

    default public Streamable<T> toStreamable() {
        return AsStreamable.asStreamable(this.stream());
    }

    default public Set<T> toSet() {
        return this.stream().collect(Collectors.toSet());
    }

    default public List<T> toList() {
        return this.stream().collect(Collectors.toList());
    }

    default public <T> Stream<T> toStream() {
        return this.stream();
    }

    @Override
    default public Stream<T> stream() {
        if (this.unwrap() instanceof Stream) {
            return (Stream)this.unwrap();
        }
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        return (Stream)this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.getMonad())).flatMap(Function.identity()).unwrap();
    }

    default public <T> Optional<T> toOptional() {
        Optional<Integer> stream = Optional.of(1);
        return (Optional)this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.getMonad())).unwrap();
    }

    default public <R> Monad<Optional<R>, R> flatMapToOptional(Function<MONAD, Optional<R>> fn) {
        Optional<Integer> opt = Optional.of(1);
        return AsGenericMonad.monad(opt.flatMap((? super T i) -> (Optional)fn.apply(this.unwrap())));
    }

    default public <R> Monad<Stream<R>, R> flatMapToStream(Function<MONAD, Stream<R>> fn) {
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        return AsGenericMonad.monad(stream.flatMap((? super T i) -> (Stream)fn.apply(this.unwrap())));
    }

    default public <R> Monad<CompletableFuture<R>, R> flatMapToCompletableFuture(Function<MONAD, CompletableFuture<R>> fn) {
        CompletableFuture<Integer> future = CompletableFuture.completedFuture(1);
        return AsGenericMonad.monad(future.thenCompose(i -> (CompletableFuture)fn.apply(this.unwrap())));
    }

    default public Monad<Stream<T>, T> cycle(int times) {
        return AsGenericMonad.monad(StreamUtils.cycle(times, AsStreamable.asStreamable(this.stream())));
    }

    default public Monad<Stream<T>, T> cycle(Monoid<T> m, int times) {
        return AsGenericMonad.monad(StreamUtils.cycle(times, AsStreamable.asStreamable(m.reduce(this.stream()))));
    }

    default public <R> Monad<Stream<R>, R> cycle(Class<R> monad, int times) {
        return this.cycle(times).map(r -> new ComprehenderSelector().selectComprehender(monad).of(r));
    }

    default public Monad<Stream<T>, T> cycleWhile(Predicate<T> predicate) {
        return AsGenericMonad.monad(LazySeq.of(StreamUtils.cycle(this.stream()).iterator()).takeWhile(predicate).stream());
    }

    default public Monad<Stream<T>, T> cycleUntil(Predicate<T> predicate) {
        return AsGenericMonad.monad(LazySeq.of(StreamUtils.cycle(this.stream()).iterator()).takeWhile(predicate.negate()).stream());
    }

    default public <MONAD2, S, R> Monad<Stream<R>, R> zip(Monad<MONAD2, ? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).zip(LazySeq.of(second.stream().iterator()), zipper).stream());
    }

    default public <S, R> Monad<Stream<R>, R> zip(Stream<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).zip(LazySeq.of(second.iterator()), zipper).stream());
    }

    default public Monad<Stream<List<T>>, List<T>> sliding(int windowSize) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).sliding(windowSize).stream());
    }

    default public Monad<Stream<List<T>>, List<T>> grouped(int groupSize) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).grouped(groupSize).stream());
    }

    default public boolean startsWith(Iterable<T> iterable) {
        return LazySeq.of(this.stream().iterator()).startsWith(iterable);
    }

    default public boolean startsWith(Iterator<T> iterator) {
        return LazySeq.of(this.stream().iterator()).startsWith(iterator);
    }

    default public Monad<Stream<T>, T> distinct() {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).distinct().stream());
    }

    default public Monad<Stream<T>, T> scanLeft(Monoid<T> monoid) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).scan(monoid.zero(), monoid.reducer()).stream());
    }

    default public Monad<Stream<T>, T> sorted() {
        return AsGenericMonad.monad(this.stream().sorted());
    }

    default public Monad<Stream<T>, T> sorted(Comparator<T> c) {
        return AsGenericMonad.monad(this.stream().sorted(c));
    }

    default public Monad<Stream<T>, T> skip(int num) {
        return AsGenericMonad.monad(this.stream().skip(num));
    }

    default public Monad<Stream<T>, T> skipWhile(Predicate<T> p) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).dropWhile(p).stream());
    }

    default public Monad<Stream<T>, T> skipUntil(Predicate<T> p) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).dropWhile(p.negate()).stream());
    }

    default public Monad<Stream<T>, T> limit(int num) {
        return AsGenericMonad.monad(this.stream().limit(num));
    }

    default public Monad<Stream<T>, T> limitWhile(Predicate<T> p) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).takeWhile(p).stream());
    }

    default public Monad<Stream<T>, T> limitUntil(Predicate<T> p) {
        return AsGenericMonad.monad(LazySeq.of(this.stream().iterator()).takeWhile(p.negate()).stream());
    }

    default public <NT, R> Monad<NT, R> applyM(Monad<?, Function<T, R>> fn) {
        return this.bind(v -> fn.map(innerFn -> innerFn.apply(v)).unwrap());
    }

    default public <NT, R> Monad<NT, R> filterM(Monad<?, Predicate<T>> fn) {
        return this.bind(v -> fn.map(innerFn -> new Pair<Object, Boolean>(v, innerFn.test(v))).filter((T p) -> (Boolean)p._2()).map(Pair::_1)).map((T m) -> ((Monad)m).unwrap());
    }

    default public <NT, R> Monad<NT, R> replicateM(int times) {
        return AsGenericMonad.asMonad(this.unit(1)).flatten().bind(v -> this.cycle(times).unwrap());
    }

    default public <MONAD, T> MONAD unit(T value) {
        return (MONAD)new ComprehenderSelector().selectComprehender(this.getMonad()).of(value);
    }

    public static <MONAD, MONAD_LIST> MONAD_LIST sequenceNative(Class c, List<MONAD> seq) {
        return (MONAD_LIST)AsGenericMonad.asMonad(new ComprehenderSelector().selectComprehender(c).of(1)).flatMap(in -> AsGenericMonad.asMonad(seq.stream()).flatMap(m -> m).unwrap()).unwrap();
    }

    public static <MONAD, MONAD_LIST, R> MONAD_LIST traverseNative(Class c, List<MONAD> seq, Function<?, R> fn) {
        return (MONAD_LIST)AsGenericMonad.asMonad(new ComprehenderSelector().selectComprehender(c).of(1)).flatMap(in -> AsGenericMonad.asMonad(seq.stream()).flatMap(m -> m).flatMap(fn).unwrap()).unwrap();
    }

    public static <MONAD, R> Monad<MONAD, List<R>> traverse(Class c, List<?> seq, Function<?, R> fn) {
        return AsGenericMonad.asMonad(new ComprehenderSelector().selectComprehender(c).of(1)).flatMap(in -> AsGenericMonad.asMonad(seq.stream()).flatMap(m -> m).flatMap(fn).unwrap());
    }

    public static <MONAD, T> Monad<MONAD, T> sequence(Class c, List<?> seq) {
        return AsGenericMonad.asMonad(new ComprehenderSelector().selectComprehender(c).of(1)).flatMap(in -> AsGenericMonad.asMonad(seq.stream()).flatMap(m -> m).unwrap());
    }

    default public <R> Monad<MONAD, R> aggregate(Monad<?, ?> next) {
        Stream<?> concat = StreamUtils.concat(this.stream(), next.stream());
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.unwrap()).of(AsGenericMonad.monad(concat).flatMap(Function.identity()).toList())).bind(Function.identity());
    }

    default public <R extends MONAD, NT> Monad<R, NT> flatMap(Function<T, R> fn) {
        return this.bind(fn);
    }

    @Override
    default public MONAD unwrap() {
        return (MONAD)this.getMonad();
    }

    default public <R, NT> Monad<R, NT> parallel() {
        return this.streamedMonad().parallel();
    }

    default public <R, NT> Monad<R, NT> streamedMonad() {
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        Monad<MONAD, Object> r = this.withMonad(new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.getMonad()));
        return r.flatMap(e -> e);
    }

    default public <X> Simplex<X> simplex() {
        return new SimplexImpl(this);
    }
}

