/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.comprehensions.converters;

import com.aol.cyclops.comprehensions.converters.IteratorToStreamConverter;
import com.aol.cyclops.lambda.api.MonadicConverter;
import com.aol.cyclops.lambda.utils.ExceptionSoftener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.stream.Stream;

public class ResultsetToStreamConverter
implements MonadicConverter<Stream> {
    public static int priority = 5;

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public boolean accept(Object o) {
        return o instanceof ResultSet;
    }

    @Override
    public Stream convertToMonadicForm(Object f) {
        final ResultSet resultset = (ResultSet)f;
        return this.toStream(new Iterator(){
            Boolean hasNext;

            @Override
            public boolean hasNext() {
                if (this.hasNext == null) {
                    try {
                        this.hasNext = resultset.next();
                    }
                    catch (SQLException e) {
                        ExceptionSoftener.singleton.factory.getInstance().throwSoftenedException(e);
                    }
                }
                return this.hasNext;
            }

            public Object next() {
                this.hasNext = null;
                return resultset;
            }
        });
    }

    private Stream toStream(Iterator iterator) {
        return new IteratorToStreamConverter().convertToMonadicForm(iterator);
    }
}

