/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.ws;

import com.aoindustries.util.StringUtility;

public class WsEncoder {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private WsEncoder() {
    }

    public static String encode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encoded = null;
        int len = value.length();
        for (int c = 0; c < len; ++c) {
            char ch = value.charAt(c);
            if (ch < ' ' && ch != '\n' && ch != '\r' || ch == '\\') {
                if (encoded == null) {
                    encoded = new StringBuilder();
                    if (c > 0) {
                        encoded.append(value, 0, c);
                    }
                }
                if (ch == '\\') {
                    encoded.append("\\\\");
                    continue;
                }
                if (ch == '\b') {
                    encoded.append("\\b");
                    continue;
                }
                if (ch == '\f') {
                    encoded.append("\\f");
                    continue;
                }
                if (ch == '\t') {
                    encoded.append("\\t");
                    continue;
                }
                char ich = ch;
                encoded.append("\\u").append(hexChars[ich >>> 12 & 0xF]).append(hexChars[ich >>> 8 & 0xF]).append(hexChars[ich >>> 4 & 0xF]).append(hexChars[ich & 0xF]);
                continue;
            }
            if (encoded == null) continue;
            encoded.append(ch);
        }
        return encoded == null ? value : encoded.toString();
    }

    public static String decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        StringBuilder value = null;
        int len = encoded.length();
        for (int c = 0; c < len; ++c) {
            char ch = encoded.charAt(c);
            if (ch == '\\') {
                if (value == null) {
                    value = new StringBuilder();
                    if (c > 0) {
                        value.append(encoded, 0, c);
                    }
                }
                if (++c < len) {
                    ch = encoded.charAt(c);
                    if (ch == '\\') {
                        value.append('\\');
                        continue;
                    }
                    if (ch == 'b' || ch == 'B') {
                        value.append('\b');
                        continue;
                    }
                    if (ch == 'f' || ch == 'F') {
                        value.append('\f');
                        continue;
                    }
                    if (ch == 't' || ch == 'T') {
                        value.append('\t');
                        continue;
                    }
                    if (ch == 'u' || ch == 'U') {
                        if (++c < len) {
                            char ch1 = encoded.charAt(c);
                            if (ch1 >= '0' && ch1 <= '9' || ch1 >= 'a' && ch1 <= 'f' || ch1 >= 'A' && ch1 <= 'F') {
                                if (++c < len) {
                                    char ch2 = encoded.charAt(c);
                                    if (ch2 >= '0' && ch2 <= '9' || ch2 >= 'a' && ch2 <= 'f' || ch2 >= 'A' && ch2 <= 'F') {
                                        if (++c < len) {
                                            char ch3 = encoded.charAt(c);
                                            if (ch3 >= '0' && ch3 <= '9' || ch3 >= 'a' && ch3 <= 'f' || ch3 >= 'A' && ch3 <= 'F') {
                                                if (++c < len) {
                                                    char ch4 = encoded.charAt(c);
                                                    if (ch4 >= '0' && ch4 <= '9' || ch4 >= 'a' && ch4 <= 'f' || ch4 >= 'A' && ch4 <= 'F') {
                                                        value.append((char)(StringUtility.getHex(ch1) << 12 | StringUtility.getHex(ch2) << 8 | StringUtility.getHex(ch3) << 4 | StringUtility.getHex(ch4)));
                                                        continue;
                                                    }
                                                    value.append('\\').append(ch).append(ch1).append(ch2).append(ch3).append(ch4);
                                                    continue;
                                                }
                                                value.append('\\').append(ch).append(ch1).append(ch2).append(ch3);
                                                continue;
                                            }
                                            value.append('\\').append(ch).append(ch1).append(ch2).append(ch3);
                                            continue;
                                        }
                                        value.append('\\').append(ch).append(ch1).append(ch2);
                                        continue;
                                    }
                                    value.append('\\').append(ch).append(ch1).append(ch2);
                                    continue;
                                }
                                value.append('\\').append(ch).append(ch1);
                                continue;
                            }
                            value.append('\\').append(ch).append(ch1);
                            continue;
                        }
                        value.append('\\').append(ch);
                        continue;
                    }
                    value.append('\\').append(ch);
                    continue;
                }
                value.append('\\');
                continue;
            }
            if (value == null) continue;
            value.append(ch);
        }
        return value == null ? encoded : value.toString();
    }
}

