/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.tree;

import com.aoindustries.util.tree.Node;
import com.aoindustries.util.tree.NodeCopy;
import com.aoindustries.util.tree.NodeFilter;
import com.aoindustries.util.tree.Tree;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeCopy<E>
implements Tree<E> {
    private final List<Node<E>> rootNodes;

    public TreeCopy(Tree<E> source) throws IOException, SQLException {
        List<Node<E>> sourceRootNodes = source.getRootNodes();
        int size = sourceRootNodes.size();
        if (size == 0) {
            this.rootNodes = Collections.emptyList();
        } else if (size == 1) {
            NodeCopy<E> nodeCopy = new NodeCopy<E>(sourceRootNodes.get(0));
            this.rootNodes = Collections.singletonList(nodeCopy);
        } else {
            ArrayList<NodeCopy<E>> newRootNodes = new ArrayList<NodeCopy<E>>(size);
            for (Node<E> rootNode : sourceRootNodes) {
                newRootNodes.add(new NodeCopy<E>(rootNode));
            }
            this.rootNodes = Collections.unmodifiableList(newRootNodes);
        }
    }

    public TreeCopy(Tree<E> source, NodeFilter<E> nodeFilter) throws IOException, SQLException {
        List<Node<E>> sourceRootNodes = source.getRootNodes();
        ArrayList<Node<E>> filteredRootNodes = new ArrayList<Node<E>>(sourceRootNodes.size());
        for (Node<E> sourceRootNode : sourceRootNodes) {
            if (nodeFilter.isNodeFiltered(sourceRootNode)) continue;
            filteredRootNodes.add(sourceRootNode);
        }
        int size = filteredRootNodes.size();
        if (size == 0) {
            this.rootNodes = Collections.emptyList();
        } else if (size == 1) {
            NodeCopy<E> nodeCopy = new NodeCopy<E>((Node)filteredRootNodes.get(0), nodeFilter);
            this.rootNodes = Collections.singletonList(nodeCopy);
        } else {
            ArrayList<NodeCopy<E>> newRootNodes = new ArrayList<NodeCopy<E>>(size);
            for (Node node : filteredRootNodes) {
                newRootNodes.add(new NodeCopy<E>(node, nodeFilter));
            }
            this.rootNodes = Collections.unmodifiableList(newRootNodes);
        }
    }

    @Override
    public List<Node<E>> getRootNodes() {
        return this.rootNodes;
    }
}

