/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.tree;

import com.aoindustries.util.tree.Node;
import com.aoindustries.util.tree.NodeFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeCopy<E>
implements Node<E> {
    private final E value;
    private final List<Node<E>> children;

    public NodeCopy(Node<E> node) throws IOException, SQLException {
        this.value = node.getValue();
        List<Node<E>> nodeChildren = node.getChildren();
        if (nodeChildren == null) {
            this.children = null;
        } else {
            int size = nodeChildren.size();
            if (size == 0) {
                this.children = Collections.emptyList();
            } else if (size == 1) {
                NodeCopy<E> nodeCopy = new NodeCopy<E>(nodeChildren.get(0));
                this.children = Collections.singletonList(nodeCopy);
            } else {
                ArrayList<NodeCopy<E>> childrenCopy = new ArrayList<NodeCopy<E>>(size);
                for (Node<E> child : nodeChildren) {
                    childrenCopy.add(new NodeCopy<E>(child));
                }
                this.children = Collections.unmodifiableList(childrenCopy);
            }
        }
    }

    public NodeCopy(Node<E> node, NodeFilter<E> nodeFilter) throws IOException, SQLException {
        this.value = node.getValue();
        List<Node<E>> nodeChildren = node.getChildren();
        if (nodeChildren == null) {
            this.children = null;
        } else {
            ArrayList<Node<E>> filteredChildren = new ArrayList<Node<E>>(nodeChildren.size());
            for (Node<E> child : nodeChildren) {
                if (nodeFilter.isNodeFiltered(child)) continue;
                filteredChildren.add(child);
            }
            int size = filteredChildren.size();
            if (size == 0) {
                this.children = Collections.emptyList();
            } else if (size == 1) {
                NodeCopy<E> nodeCopy = new NodeCopy<E>((Node)filteredChildren.get(0), nodeFilter);
                this.children = Collections.singletonList(nodeCopy);
            } else {
                ArrayList<NodeCopy<E>> childrenCopy = new ArrayList<NodeCopy<E>>(size);
                for (Node node2 : filteredChildren) {
                    childrenCopy.add(new NodeCopy<E>(node2, nodeFilter));
                }
                this.children = Collections.unmodifiableList(childrenCopy);
            }
        }
    }

    @Override
    public List<Node<E>> getChildren() {
        return this.children;
    }

    @Override
    public E getValue() {
        return this.value;
    }
}

